/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imagelibrary.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.imagelibrary.exception.GroupDuplicateNameException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageDuplicateNameException;
import com.kingdee.bos.qing.imagelibrary.model.ImageModel;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageLibraryDao {
    private static final String FCATEGORYNAME = "FNAME";
    private static final String FUSERID = "FUSERID";
    private static final String FCATEGORYID = "FCATEGORYID";
    private static final String FIMAGEFILENAME = "FIMAGEFILENAME";
    private static final String FIMAGENAME = "FIMAGENAME";
    private static final String FTHUMBNAILFILENAME = "FTHUMBNAILFILENAME";
    private static final String FIMAGEWIDTH = "FIMAGEWIDTH";
    private static final String FIMAGEHEIGHT = "FIMAGEHEIGHT";
    private IDBExcuter dbExcuter;

    public ImageLibraryDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public String saveOrUpdateCategory(String userId, String categoryId, String categoryName) throws SQLException, GroupDuplicateNameException, AbstractQingIntegratedException {
        String fId = categoryId;
        if (this.getCategoryIdByName(categoryName, userId) != null) {
            throw new GroupDuplicateNameException("Category Name Exist");
        }
        if (fId == null || "".equals(fId)) {
            Object[] params = new Object[5];
            fId = this.dbExcuter.genStringId("T_QING_IMGLIB_CATEGORY");
            params[0] = fId;
            params[1] = userId;
            params[2] = categoryName;
            params[3] = new Date();
            params[4] = new Date();
            this.dbExcuter.execute("INSERT INTO T_QING_IMGLIB_CATEGORY (FID,FUSERID,FNAME,FCREATEDATE,FUPDATEDATE) VALUES(?,?,?,?,?)", params);
        } else {
            this.updateCategory(categoryName, categoryId, userId);
        }
        return fId;
    }

    public void updateCategory(String newCategoryName, String categoryId, String userId) throws SQLException, AbstractQingIntegratedException {
        Object[] params = new Object[]{newCategoryName, new Date(), categoryId, userId};
        this.dbExcuter.execute("UPDATE T_QING_IMGLIB_CATEGORY SET FNAME = ?, FUPDATEDATE = ? WHERE FID = ? AND FUSERID = ?", params);
    }

    public void deleteCategory(String categoryId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.dbExcuter.execute("DELETE FROM T_QING_IMGLIB_CATEGORY WHERE FID = ? AND FUSERID = ?", new Object[]{categoryId, userId});
    }

    public boolean deleteAllImageInfo(String categoryId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.dbExcuter.execute("DELETE FROM T_QING_IMGLIB_IMG_INFO WHERE FCATEGORYID = ? AND FUSERID = ?", new Object[]{categoryId, userId});
        return true;
    }

    public void saveImageInfo(ImageModel imageModel) throws SQLException, AbstractQingIntegratedException {
        Object[] params = new Object[]{imageModel.getId(), imageModel.getThumbnailFileName(), imageModel.getCategoryId(), imageModel.getImageFileName(), imageModel.getImageName(), imageModel.getUserId(), new Date(), imageModel.getImageWidth(), imageModel.getImageHeight()};
        this.dbExcuter.execute("INSERT INTO T_QING_IMGLIB_IMG_INFO (FID,FTHUMBNAILFILENAME,FCATEGORYID,FIMAGEFILENAME,FIMAGENAME,FUSERID,FUPLOADDATE,FIMAGEWIDTH,FIMAGEHEIGHT) VALUES(?,?,?,?,?,?,?,?,?)", params);
    }

    public List<Map<String, String>> getAllCategory(String userId) throws SQLException, AbstractQingIntegratedException {
        return (List)this.dbExcuter.query("SELECT FID, FNAME, FUSERID FROM T_QING_IMGLIB_CATEGORY WHERE FUSERID=? ORDER BY FCREATEDATE ASC", new Object[]{userId}, (ResultHandler)new ResultHandler<List<Map<String, String>>>(){

            public List<Map<String, String>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, String>> categorys = new ArrayList<Map<String, String>>(10);
                while (rs.next()) {
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("categoryId", rs.getString("FID"));
                    item.put("categoryName", rs.getString(ImageLibraryDao.FCATEGORYNAME));
                    item.put("isPreset", "" + IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                    categorys.add(item);
                }
                return categorys;
            }
        });
    }

    public List<Map<String, String>> getAllPresetCategory() throws SQLException, AbstractQingIntegratedException {
        return (List)this.dbExcuter.query("SELECT FID, FNAME FROM T_QING_IMGLIB_CATEGORY WHERE FUSERID=? ORDER BY FNAME ASC", new Object[]{IntegratedHelper.getPresetUserId()}, (ResultHandler)new ResultHandler<List<Map<String, String>>>(){

            public List<Map<String, String>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, String>> categorys = new ArrayList<Map<String, String>>(10);
                while (rs.next()) {
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("categoryId", rs.getString("FID"));
                    item.put("categoryName", rs.getString(ImageLibraryDao.FCATEGORYNAME));
                    item.put("isPreset", "true");
                    categorys.add(item);
                }
                return categorys;
            }
        });
    }

    public String getCategoryNameByFid(String fid) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT FNAME FROM T_QING_IMGLIB_CATEGORY WHERE FID = ?", new Object[]{fid}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String categoryName = null;
                while (rs.next()) {
                    categoryName = rs.getString(ImageLibraryDao.FCATEGORYNAME);
                }
                return categoryName;
            }
        });
    }

    public List<ImageModel> getAllImageOfCategory(String categoryId, String userId) throws SQLException, AbstractQingIntegratedException {
        return (List)this.dbExcuter.query("SELECT FID, FTHUMBNAILFILENAME, FCATEGORYID, FIMAGEFILENAME, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT, FUSERID FROM T_QING_IMGLIB_IMG_INFO WHERE FCATEGORYID=? AND FUSERID=? ORDER BY FUPLOADDATE DESC", new Object[]{categoryId, userId}, (ResultHandler)new ResultHandler<List<ImageModel>>(){

            public List<ImageModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ImageModel> imageInfos = new ArrayList<ImageModel>(10);
                while (rs.next()) {
                    ImageModel imageInfo = new ImageModel();
                    imageInfo.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageInfo.setId(rs.getString("FID"));
                    imageInfo.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageInfo.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageInfo.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageInfo.setImageWidth(rs.getInt(ImageLibraryDao.FIMAGEWIDTH));
                    imageInfo.setImageHeight(rs.getInt(ImageLibraryDao.FIMAGEHEIGHT));
                    imageInfo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                    imageInfos.add(imageInfo);
                }
                return imageInfos;
            }
        });
    }

    public List<ImageModel> getAllImageOfCategoryLikeImageName(String categoryId, String userId, String imageName) throws SQLException, AbstractQingIntegratedException {
        return (List)this.dbExcuter.query("SELECT FID, FTHUMBNAILFILENAME, FCATEGORYID, FIMAGEFILENAME, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT, FUSERID FROM T_QING_IMGLIB_IMG_INFO WHERE FCATEGORYID=? AND FUSERID=? AND FIMAGENAME LIKE ? ORDER BY FUPLOADDATE DESC", new Object[]{categoryId, userId, imageName + "%"}, (ResultHandler)new ResultHandler<List<ImageModel>>(){

            public List<ImageModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ImageModel> imageInfos = new ArrayList<ImageModel>(10);
                while (rs.next()) {
                    ImageModel imageInfo = new ImageModel();
                    imageInfo.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageInfo.setId(rs.getString("FID"));
                    imageInfo.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageInfo.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageInfo.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageInfo.setImageWidth(rs.getInt(ImageLibraryDao.FIMAGEWIDTH));
                    imageInfo.setImageHeight(rs.getInt(ImageLibraryDao.FIMAGEHEIGHT));
                    imageInfo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                    imageInfos.add(imageInfo);
                }
                return imageInfos;
            }
        });
    }

    public List<ImageModel> getAllPresetImageOfCategory(String categoryId) throws SQLException, AbstractQingIntegratedException {
        return (List)this.dbExcuter.query("SELECT FID, FTHUMBNAILFILENAME, FCATEGORYID, FIMAGEFILENAME, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT, FUSERID FROM T_QING_IMGLIB_IMG_INFO WHERE FCATEGORYID=? AND FUSERID=? ORDER BY FIMAGENAME", new Object[]{categoryId, IntegratedHelper.getPresetUserId()}, (ResultHandler)new ResultHandler<List<ImageModel>>(){

            public List<ImageModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ImageModel> imageInfos = new ArrayList<ImageModel>(10);
                while (rs.next()) {
                    ImageModel imageInfo = new ImageModel();
                    imageInfo.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageInfo.setId(rs.getString("FID"));
                    imageInfo.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageInfo.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageInfo.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageInfo.setImageWidth(rs.getInt(ImageLibraryDao.FIMAGEWIDTH));
                    imageInfo.setImageHeight(rs.getInt(ImageLibraryDao.FIMAGEHEIGHT));
                    imageInfo.setPreset(true);
                    imageInfos.add(imageInfo);
                }
                return imageInfos;
            }
        });
    }

    public void deleteImage(String imageId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.dbExcuter.execute("DELETE FROM T_QING_IMGLIB_IMG_INFO WHERE FID=? AND FUSERID=?", new Object[]{imageId, userId});
    }

    public void updateImageName(String imageName, String imageId, String userId, String categoryId) throws AbstractQingIntegratedException, SQLException, ImageDuplicateNameException {
        boolean iamgeNameduplicate = this.checkImageNameDuplicate(userId, imageName, categoryId);
        if (iamgeNameduplicate) {
            throw new ImageDuplicateNameException("image Name Exist");
        }
        Object[] params = new Object[]{imageName, imageId, userId};
        this.dbExcuter.execute("UPDATE T_QING_IMGLIB_IMG_INFO SET FIMAGENAME = ? WHERE FID = ? AND FUSERID = ?", params);
    }

    public boolean checkImageNameDuplicate(String userId, String imageName, String categoryId) throws AbstractQingIntegratedException, SQLException {
        return (Boolean)this.dbExcuter.query("SELECT FID FROM T_QING_IMGLIB_IMG_INFO WHERE FUSERID = ? AND FIMAGENAME = ? AND FCATEGORYID = ?", new Object[]{userId, imageName, categoryId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public String getCategoryName(String imageFileName, String userId) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT IMGINFO.FIMAGENAME, CATEGORY.FNAME FROM T_QING_IMGLIB_IMG_INFO IMGINFO LEFT JOIN T_QING_IMGLIB_CATEGORY CATEGORY ON IMGINFO.FCATEGORYID = CATEGORY.FID WHERE IMGINFO.FIMAGEFILENAME = ? AND IMGINFO.FUSERID = ?", new Object[]{imageFileName, userId}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String categoryName = null;
                if (rs.next()) {
                    categoryName = rs.getString(ImageLibraryDao.FCATEGORYNAME);
                }
                return categoryName;
            }
        });
    }

    public String getCategoryName(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT IMGINFO.FIMAGENAME, CATEGORY.FNAME FROM T_QING_IMGLIB_IMG_INFO IMGINFO LEFT JOIN T_QING_IMGLIB_CATEGORY CATEGORY ON IMGINFO.FCATEGORYID = CATEGORY.FID WHERE IMGINFO.FIMAGEFILENAME = ?", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String categoryName = null;
                if (rs.next()) {
                    categoryName = rs.getString(ImageLibraryDao.FCATEGORYNAME);
                }
                return categoryName;
            }
        });
    }

    public String getImageFullPath(String imageFileName, String userId) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT IMGINFO.FIMAGENAME, CATEGORY.FNAME FROM T_QING_IMGLIB_IMG_INFO IMGINFO LEFT JOIN T_QING_IMGLIB_CATEGORY CATEGORY ON IMGINFO.FCATEGORYID = CATEGORY.FID WHERE IMGINFO.FIMAGEFILENAME = ? AND IMGINFO.FUSERID = ?", new Object[]{imageFileName, userId}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String fullPath = null;
                if (rs.next()) {
                    fullPath = rs.getString(ImageLibraryDao.FCATEGORYNAME) + "/" + rs.getString(ImageLibraryDao.FIMAGENAME);
                }
                return fullPath;
            }
        });
    }

    public String getImageName(String userId, String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT FIMAGENAME FROM T_QING_IMGLIB_IMG_INFO WHERE FUSERID = ? AND FIMAGEFILENAME = ?", new Object[]{userId, imageFileName}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String imageName = null;
                if (rs.next()) {
                    imageName = rs.getString(ImageLibraryDao.FIMAGENAME);
                }
                return imageName;
            }
        });
    }

    public ImageModel loadImageModel(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (ImageModel)this.dbExcuter.query("SELECT FIMAGENAME, FUSERID FROM T_QING_IMGLIB_IMG_INFO WHERE FIMAGEFILENAME = ?", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<ImageModel>(){

            public ImageModel handle(ResultSet rs) throws SQLException {
                ImageModel imageModel = null;
                if (rs.next()) {
                    imageModel = new ImageModel();
                    imageModel.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageModel.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                }
                return imageModel;
            }
        });
    }

    public ImageModel loadImageModel(String imageFileName, String userId) throws AbstractQingIntegratedException, SQLException {
        return (ImageModel)this.dbExcuter.query("SELECT FID, FTHUMBNAILFILENAME, FCATEGORYID, FIMAGEFILENAME, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT, FUSERID FROM T_QING_IMGLIB_IMG_INFO WHERE FIMAGEFILENAME = ? AND FUSERID = ?", new Object[]{imageFileName, userId}, (ResultHandler)new ResultHandler<ImageModel>(){

            public ImageModel handle(ResultSet rs) throws SQLException {
                ImageModel imageModel = null;
                if (rs.next()) {
                    imageModel = new ImageModel();
                    imageModel.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageModel.setId(rs.getString("FID"));
                    imageModel.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageModel.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageModel.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageModel.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                }
                return imageModel;
            }
        });
    }

    public boolean checkImageNameDuplicateByCategory(String userId, String imageName, String categoryName) throws AbstractQingIntegratedException, SQLException {
        return (Boolean)this.dbExcuter.query("SELECT INFO.FID FROM T_QING_IMGLIB_IMG_INFO INFO LEFT JOIN T_QING_IMGLIB_CATEGORY CATEGORY ON INFO.FCATEGORYID = CATEGORY.FID  WHERE INFO.FUSERID = ? AND INFO.FIMAGENAME = ? AND CATEGORY.FNAME = ?", new Object[]{userId, imageName, categoryName}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public String getCategoryIdByName(String categoryName, String userId) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT FID FROM T_QING_IMGLIB_CATEGORY WHERE FNAME = ? AND FUSERID = ?", new Object[]{categoryName, userId}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String categoryId = null;
                if (rs.next()) {
                    categoryId = rs.getString("FID");
                }
                return categoryId;
            }
        });
    }

    public String getImageFileName(String categoryId, String imageName, String userId) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT FIMAGEFILENAME FROM T_QING_IMGLIB_IMG_INFO WHERE FCATEGORYID = ? AND FIMAGENAME = ? AND FUSERID = ?", new Object[]{categoryId, imageName, userId}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String imageFileName = null;
                if (rs.next()) {
                    imageFileName = rs.getString(ImageLibraryDao.FIMAGEFILENAME);
                }
                return imageFileName;
            }
        });
    }

    public Map<String, Object> getImageSize(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (Map)this.dbExcuter.query("SELECT FIMAGEWIDTH, FIMAGEHEIGHT, FIMAGENAME FROM T_QING_IMGLIB_IMG_INFO WHERE FIMAGEFILENAME = ?", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws SQLException {
                HashMap<String, Object> imageSize = new HashMap<String, Object>();
                if (rs.next()) {
                    imageSize.put("imageWidth", rs.getInt(ImageLibraryDao.FIMAGEWIDTH));
                    imageSize.put("imageHeight", rs.getInt(ImageLibraryDao.FIMAGEHEIGHT));
                    imageSize.put("imageName", rs.getString(ImageLibraryDao.FIMAGENAME));
                }
                return imageSize;
            }
        });
    }

    public List<ImageModel> getAllImage(String userId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID, FTHUMBNAILFILENAME, FCATEGORYID, FIMAGEFILENAME, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT FROM T_QING_IMGLIB_IMG_INFO WHERE FUSERID = ?", new Object[]{userId}, (ResultHandler)new ResultHandler<List<ImageModel>>(){

            public List<ImageModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ImageModel> imageInfos = new ArrayList<ImageModel>(10);
                while (rs.next()) {
                    ImageModel imageInfo = new ImageModel();
                    imageInfo.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageInfo.setId(rs.getString("FID"));
                    imageInfo.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageInfo.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageInfo.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageInfo.setImageWidth(rs.getInt(ImageLibraryDao.FIMAGEWIDTH));
                    imageInfo.setImageHeight(rs.getInt(ImageLibraryDao.FIMAGEHEIGHT));
                    imageInfos.add(imageInfo);
                }
                return imageInfos;
            }
        });
    }

    public ImageModel getImageModelByImageFileName(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (ImageModel)this.dbExcuter.query("SELECT FID, FUSERID, FCATEGORYID, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT, FIMAGEFILENAME, FTHUMBNAILFILENAME FROM T_QING_IMGLIB_IMG_INFO WHERE FIMAGEFILENAME = ?", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<ImageModel>(){

            public ImageModel handle(ResultSet rs) throws SQLException {
                ImageModel imageModel = null;
                if (rs.next()) {
                    imageModel = new ImageModel();
                    imageModel.setId(rs.getString("FID"));
                    imageModel.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageModel.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageModel.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageModel.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageModel.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                }
                return imageModel;
            }
        });
    }

    public ImageModel loadModelByImageNameAndCategoryName(String categoryName, String imageName, String userId) throws AbstractQingIntegratedException, SQLException {
        return (ImageModel)this.dbExcuter.query("SELECT IMGINFO.FID, IMGINFO.FCATEGORYID, IMGINFO.FIMAGENAME, IMGINFO.FIMAGEWIDTH, IMGINFO.FIMAGEHEIGHT, IMGINFO.FIMAGEFILENAME, IMGINFO.FTHUMBNAILFILENAME FROM T_QING_IMGLIB_IMG_INFO IMGINFO LEFT JOIN T_QING_IMGLIB_CATEGORY CATEGORY ON IMGINFO.FCATEGORYID = CATEGORY.FID WHERE CATEGORY.FNAME = ? AND IMGINFO.FIMAGENAME = ? AND IMGINFO.FUSERID = ?", new Object[]{categoryName, imageName, userId}, (ResultHandler)new ResultHandler<ImageModel>(){

            public ImageModel handle(ResultSet rs) throws SQLException {
                ImageModel imageModel = null;
                if (rs.next()) {
                    imageModel = new ImageModel();
                    imageModel.setId(rs.getString("FID"));
                    imageModel.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageModel.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageModel.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageModel.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                }
                return imageModel;
            }
        });
    }

    public PathModel getPathModel(String imageFileName, String userId) throws AbstractQingIntegratedException, SQLException {
        return (PathModel)this.dbExcuter.query("SELECT IMGINFO.FIMAGENAME, CATEGORY.FNAME FROM T_QING_IMGLIB_IMG_INFO IMGINFO LEFT JOIN T_QING_IMGLIB_CATEGORY CATEGORY ON IMGINFO.FCATEGORYID = CATEGORY.FID WHERE IMGINFO.FIMAGEFILENAME = ? AND IMGINFO.FUSERID = ?", new Object[]{imageFileName, userId}, (ResultHandler)new ResultHandler<PathModel>(){

            public PathModel handle(ResultSet rs) throws SQLException {
                PathModel pathModel = null;
                if (rs.next()) {
                    pathModel = new PathModel();
                    pathModel.setName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    pathModel.setGroupName(rs.getString(ImageLibraryDao.FCATEGORYNAME));
                }
                return pathModel;
            }
        });
    }

    public List<FileResourceVO> findResourceFileListByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FR.FFROMID, FR.FUSERID, FR.FDISPLAYNAME, FR.FFROMTYPE, FR.FCREATEDATE, FR.FFILESIZE, II.FID AS IMGID,  IC.FNAME AS IMGGROUPNAME, IC.FID AS IMGCATEGORYID  FROM      (SELECT FR.FFROMID, FR.FUSERID, FR.FDISPLAYNAME, FR.FFROMTYPE, FR.FCREATEDATE, FR.FFILESIZE FROM T_QING_FILE_RESOURCE FR       WHERE FR.FUSERID = ? AND FR.FFROMTYPE='IMAGELIBRARY' ) FR  LEFT JOIN T_QING_IMGLIB_IMG_INFO II ON FR.FFROMID=II.FID  LEFT JOIN T_QING_IMGLIB_CATEGORY IC ON II.FCATEGORYID=IC.FID ";
        return (List)this.dbExcuter.query(sql, new Object[]{userId}, (ResultHandler)new ResultHandler<List<FileResourceVO>>(){

            public List<FileResourceVO> handle(ResultSet rs) throws SQLException {
                ArrayList<FileResourceVO> list = new ArrayList<FileResourceVO>(10);
                while (rs.next()) {
                    FileResourceVO resourceFile = new FileResourceVO();
                    resourceFile.setFromId(rs.getString("FFROMID"));
                    resourceFile.setDisplayName(rs.getString("FDISPLAYNAME"));
                    resourceFile.setFileSizeNoFormat(rs.getString("FFILESIZE"));
                    resourceFile.setCreateDate(Long.valueOf(rs.getTimestamp("FCREATEDATE").getTime()));
                    String fromType = rs.getString("FFROMTYPE");
                    resourceFile.setFromType(fromType);
                    String imgGroupName = rs.getString("IMGGROUPNAME");
                    String imgCategoryId = rs.getString("IMGCATEGORYID");
                    resourceFile.setFromPathName(imgGroupName);
                    resourceFile.setFromPath(imgCategoryId);
                    resourceFile.setSourceExist(StringUtils.isNotBlank((CharSequence)rs.getString("IMGID")));
                    list.add(resourceFile);
                }
                return list;
            }
        });
    }
}

