/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imagelibrary.domian;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.reference.TimedPushLappUpdateRefPathAndIdHandle;
import com.kingdee.bos.qing.dashboard.reference.impl.PictureSwitchPathAndIdHandler;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageLimitException;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imagelibrary.dao.ImageLibraryDao;
import com.kingdee.bos.qing.imagelibrary.exception.ImageAccessException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageFileSizeLimitException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageNotFoundException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageTypeException;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.imagelibrary.model.ImageModel;
import com.kingdee.bos.qing.imagelibrary.model.ImageType;
import com.kingdee.bos.qing.imagelibrary.oplog.ImageLibOpLog;
import com.kingdee.bos.qing.imagelibrary.util.ImageTypeUtil;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageLibraryDomain {
    private static final int THUNBNAIL_MAX_WIDTH = 180;
    private static final String IMAGE_TYPE = "png";
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private QingContext context;
    private ImageLibraryDao imageLibraryDao;
    private DashboardDao dashboardDao;
    private DashboardPublishDao dashboardPublishDao;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setQingContext(QingContext qingContext) {
        this.context = qingContext;
    }

    private ImageLibraryDao getImageLibraryDao() {
        if (this.imageLibraryDao == null) {
            this.imageLibraryDao = new ImageLibraryDao(this.dbExcuter);
        }
        return this.imageLibraryDao;
    }

    private DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new PictureSwitchPathAndIdHandler(this.context, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    public byte[] loadImage(String fileName) throws ImageAccessException {
        try {
            return FileFactory.getFileContent((AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)fileName);
        }
        catch (FileNotFoundException e) {
            throw new ImageNotFoundException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ImageAccessException(e.getMessage(), e);
        }
    }

    public String saveOrUpdateCategory(String userId, String categoryId, String categoryName) throws QingImglibException, AbstractQingIntegratedException {
        String fId;
        String oldName = null;
        try {
            this.tx.beginRequired();
            if (categoryId != null) {
                oldName = this.getImageLibraryDao().getCategoryNameByFid(categoryId);
            }
            fId = this.getImageLibraryDao().saveOrUpdateCategory(userId, categoryId, categoryName);
            if (categoryId != null || !"".equals(fId)) {
                List<ImageModel> imageInfos = this.getImageLibraryDao().getAllImageOfCategory(categoryId, userId);
                for (int i = 0; i < imageInfos.size(); ++i) {
                    ImageModel imageInfo = imageInfos.get(i);
                    this.updateRefToId(categoryName, imageInfo.getImageName(), imageInfo.getImageFileName());
                }
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new QingImglibException((Throwable)e, "fail to save category.");
        }
        finally {
            this.tx.end();
        }
        OpLogActionType opLogActionType = categoryId != null ? OpLogActionType.EDIT : OpLogActionType.NEW;
        ArrayList<String> params = new ArrayList<String>(2);
        ImageLibOpLog emptyDir = ImageLibOpLog.EMPTY_DIR;
        emptyDir.setParamsDesc("\u201c$param\u201d");
        if (opLogActionType.equals((Object)OpLogActionType.EDIT) && oldName != null && !oldName.equals(categoryName)) {
            emptyDir.setParamsDesc("\u201c$param\u201d\u540d\u79f0\u4e3a\u201c$param\u201d");
            params.add(oldName);
        }
        emptyDir.setLogScene("\u56fe\u7247\u76ee\u5f55");
        params.add(categoryName);
        OpLogUtil.addLog((OpLogBO)new OpLogBO(opLogActionType, (IOpLogConstant)emptyDir, params));
        return fId;
    }

    public void deleteCategory(String categoryId, String categoryName) throws AbstractQingIntegratedException, QingImglibException {
        try {
            this.tx.beginRequired();
            String userId = this.context.getUserId();
            List<ImageModel> images = this.getAllImageOfCategory(categoryId, IntegratedHelper.getPresetUserId().equals(userId));
            this.getImageLibraryDao().deleteCategory(categoryId, userId);
            this.getImageLibraryDao().deleteAllImageInfo(categoryId, userId);
            for (ImageModel imageInfo : images) {
                String imagePath = imageInfo.getImageFileName();
                String thumbnailFileName = imageInfo.getThumbnailFileName();
                this.updateRefFullPath(categoryName, imageInfo.getImageName(), imagePath);
                this.deleteImageFile(imagePath);
                this.deleteImageFile(thumbnailFileName);
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new QingImglibException((Throwable)e, "fail to delete category.");
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(categoryName);
        ImageLibOpLog emptyDir = ImageLibOpLog.EMPTY_DIR;
        emptyDir.setLogScene("\u56fe\u7247\u76ee\u5f55");
        emptyDir.setParamsDesc("\u201c$param\u201d");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)emptyDir, params));
    }

    public void saveImageInfoWithNoTX(ImageModel imageModel, IQingFile thumbnailFileNameP, IQingFile imageFileNameP) throws AbstractQingIntegratedException, SQLException, IOException, ImageTypeException, ImageFileSizeLimitException {
        String userId = this.context.getUserId();
        String imageName = imageModel.getImageName();
        int idx = imageName.lastIndexOf(46);
        String imageSubName = imageName.substring(0, idx);
        String imagePrefixName = imageName.substring(idx);
        boolean imageNameDuplicate = this.getImageLibraryDao().checkImageNameDuplicate(userId, imageName, imageModel.getCategoryId());
        while (imageNameDuplicate) {
            if (imageSubName.lastIndexOf(95) > 0) {
                String indexStr = imageSubName.substring(imageSubName.lastIndexOf(95) + 1, imageSubName.length());
                imageSubName = imageSubName.substring(0, imageSubName.lastIndexOf(95));
                try {
                    Integer index = Integer.parseInt(indexStr);
                    index = index + 1;
                    imageSubName = imageSubName + "_" + index;
                }
                catch (NumberFormatException e) {
                    imageSubName = imageSubName + "_1";
                }
            } else {
                imageSubName = imageSubName + "_1";
            }
            imageNameDuplicate = this.getImageLibraryDao().checkImageNameDuplicate(userId, imageSubName + imagePrefixName, imageModel.getCategoryId());
        }
        imageModel.setImageName(imageSubName + imagePrefixName);
        String imageFileName = imageModel.getImageFileName();
        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)imageFileName);
        QingInputStream sis = null;
        try {
            sis = file.getInputStream();
            ImageType imageType = ImageTypeUtil.getPicType((InputStream)sis);
            if (imageType == null) {
                throw new ImageTypeException();
            }
            CloseUtil.close((Closeable[])new Closeable[]{sis});
            sis = file.getInputStream();
            BufferedImage bufImg = ImageIO.read((InputStream)sis);
            imageModel.setImageWidth(bufImg.getWidth());
            imageModel.setImageHeight(bufImg.getHeight());
            byte[] thumbnail = ImageLibraryDomain.zoomImage(bufImg);
            thumbnailFileNameP.write((IWriteCall)new CopyWriteCall((InputStream)new ByteArrayInputStream(thumbnail), false), true);
            imageModel.setThumbnailFileName(thumbnailFileNameP.getName());
            CloseUtil.close((Closeable[])new Closeable[]{sis});
            sis = file.getInputStream();
            imageFileNameP.write((IWriteCall)new CopyWriteCall((InputStream)sis, false), true);
            imageModel.setImageFileName(imageFileNameP.getName());
        }
        catch (QingFileStorageLimitException e) {
            try {
                throw new ImageFileSizeLimitException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{sis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{sis});
        this.getImageLibraryDao().saveImageInfo(imageModel);
        String categoryName = this.getImageLibraryDao().getCategoryName(imageFileNameP.getName(), userId);
        this.updateRefToId(categoryName, imageModel.getImageName(), imageFileNameP.getName());
    }

    public void saveImageInfo(ImageModel imageModel) throws AbstractQingIntegratedException, ImageFileSizeLimitException, QingImglibException {
        String fId = this.dbExcuter.genStringId("T_QING_IMGLIB_IMG_INFO");
        imageModel.setId(fId);
        IQingFile thumbnailFileNameP = this.createImageFile(imageModel.getImageName() + "_thumbnail", fId, true);
        IQingFile imageFileNameP = this.createImageFile(imageModel.getImageName(), fId, false);
        try {
            this.tx.beginRequired();
            this.saveImageInfoWithNoTX(imageModel, thumbnailFileNameP, imageFileNameP);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            this.clearFiles(new IQingFileUpdater[]{thumbnailFileNameP, imageFileNameP});
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            this.clearFiles(new IQingFileUpdater[]{thumbnailFileNameP, imageFileNameP});
            throw new QingImglibException((Throwable)e, "fail to save Image Info.");
        }
        catch (IOException e) {
            this.tx.markRollback();
            this.clearFiles(new IQingFileUpdater[]{thumbnailFileNameP, imageFileNameP});
            throw new QingImglibException((Throwable)e, "fail to save Image Info.");
        }
        finally {
            this.tx.end();
        }
        try {
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(imageModel.getImageName());
            ImageLibOpLog imageDir = ImageLibOpLog.IMAGE_DIR;
            imageDir.setLogScene("\u56fe\u7247");
            imageDir.setParamsDesc("\u201c$param\u201d");
            params.add(this.getImageLibraryDao().getCategoryNameByFid(imageModel.getCategoryId()));
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.NEW, (IOpLogConstant)imageDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearFiles(IQingFileUpdater ... files) {
        for (IQingFileUpdater file : files) {
            if (file == null) continue;
            file.delete();
        }
    }

    public List<Map<String, String>> getAllCategory(String userId) throws QingImglibException, AbstractQingIntegratedException {
        try {
            boolean isInRole;
            List<Map<String, String>> ret = this.getImageLibraryDao().getAllCategory(userId);
            if (ret.isEmpty()) {
                this.saveOrUpdateCategory(userId, "", Messages.getMLS((QingContext)this.context, (String)"defaultGroupName", (String)"\u9ed8\u8ba4\u5206\u7c7b", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                ret = this.getImageLibraryDao().getAllCategory(userId);
            }
            if (isInRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.context, (IDBExcuter)this.dbExcuter)) {
                List<Map<String, String>> presetCategorys = this.getImageLibraryDao().getAllPresetCategory();
                ret.addAll(0, presetCategorys);
            }
            return ret;
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to get category.");
        }
    }

    public List<ImageModel> getAllImageOfCategory(String categoryId, boolean isPreset) throws QingImglibException, AbstractQingIntegratedException {
        try {
            if (isPreset) {
                return this.getImageLibraryDao().getAllPresetImageOfCategory(categoryId);
            }
            return this.getImageLibraryDao().getAllImageOfCategory(categoryId, this.context.getUserId());
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to get image of category.");
        }
    }

    public void updateImageName(String imageName, ImageModel imageModel, String userId) throws AbstractQingIntegratedException, QingImglibException {
        try {
            this.tx.beginRequired();
            String imageId = imageModel.getId();
            String categoryId = imageModel.getCategoryId();
            this.getImageLibraryDao().updateImageName(imageName, imageId, userId, categoryId);
            String imageFileName = imageModel.getImageFileName();
            String categoryName = this.getImageLibraryDao().getCategoryName(imageFileName, userId);
            this.updateRefToId(categoryName, imageName, imageFileName);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new QingImglibException((Throwable)e, "fail to update image name.");
        }
        finally {
            this.tx.end();
        }
        try {
            ArrayList<String> params = new ArrayList<String>(3);
            params.add(imageModel.getImageName());
            params.add(imageName);
            params.add(this.getImageLibraryDao().getCategoryNameByFid(imageModel.getCategoryId()));
            ImageLibOpLog imageDir = ImageLibOpLog.IMAGE_DIR;
            imageDir.setLogScene("\u56fe\u7247");
            imageDir.setParamsDesc("\u201c$param\u201d\u540d\u79f0\u4e3a\u201c$param\u201d");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)imageDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteImage(ImageModel imageModel) throws QingImglibException, AbstractQingIntegratedException {
        String categoryName = null;
        try {
            this.tx.beginRequired();
            String imageFileName = imageModel.getImageFileName();
            String imageId = imageModel.getId();
            String userId = imageModel.getUserId();
            String thumbnailFileName = imageModel.getThumbnailFileName();
            categoryName = this.getImageLibraryDao().getCategoryName(imageFileName, userId);
            this.getImageLibraryDao().deleteImage(imageId, userId);
            this.deleteImageFile(thumbnailFileName);
            this.deleteImageFile(imageFileName);
            this.updateRefFullPath(categoryName, imageModel.getImageName(), imageFileName);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new QingImglibException((Throwable)e, "fail to delete image of category.");
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(imageModel.getImageName());
        params.add(categoryName);
        ImageLibOpLog imageDir = ImageLibOpLog.IMAGE_DIR;
        imageDir.setLogScene("\u56fe\u7247");
        imageDir.setParamsDesc("\u201c$param\u201d");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)imageDir, params));
    }

    public void deleteImageFile(String imageFileName) {
        IQingFileUpdater file = FileFactory.newFileUpdater((QingContext)this.context, (AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)imageFileName);
        file.delete();
    }

    public IQingFile createImageFile(String imageName, String imageId, boolean thumbnail) {
        IQingFile file = null;
        if (thumbnail) {
            file = FileFactory.newPersistentFile((QingContext)this.context, null, (QingPersistentFileType)QingPersistentFileType.IMAGE_LIBRARY);
        } else {
            QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
            resourceInfo.setDisplayName(imageName);
            resourceInfo.setFromId(imageId);
            resourceInfo.setFromType(ResourceFromType.IMAGELIBRARY);
            file = FileFactory.newPersistentFile((QingContext)this.context, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.IMAGE_LIBRARY);
        }
        return file;
    }

    public static byte[] zoomImage(BufferedImage bufImg) throws IOException {
        int imageWidth = bufImg.getWidth();
        int imageHeight = bufImg.getHeight();
        Image Itemp = bufImg.getScaledInstance(imageWidth, imageHeight, 4);
        int imageLongerSide = imageWidth >= imageHeight ? imageWidth : imageHeight;
        double zoomMultiple = 180.0 / (double)imageLongerSide;
        zoomMultiple = zoomMultiple > 1.0 ? 1.0 : zoomMultiple;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AffineTransformOp ato = new AffineTransformOp(AffineTransform.getScaleInstance(zoomMultiple, zoomMultiple), null);
        Itemp = ato.filter(bufImg, null);
        ImageIO.write((RenderedImage)((BufferedImage)Itemp), IMAGE_TYPE, out);
        return out.toByteArray();
    }

    public int getRefTimeOfImage(String imageFileName) throws AbstractQingIntegratedException, QingImglibException {
        try {
            int pubDsbRefTimes = this.getDashboardPublishDao().getRefTimeOfImage(imageFileName);
            int dsbRefTimes = this.getDashboardDao().getRefTimeOfImage(imageFileName);
            TimedPushLappUpdateRefPathAndIdHandle timedPushLappHandle = new TimedPushLappUpdateRefPathAndIdHandle(this.context, this.tx, this.dbExcuter);
            int timedPublishTimes = timedPushLappHandle.getTimedPublishRefTime(imageFileName);
            int total = pubDsbRefTimes + dsbRefTimes + timedPublishTimes;
            return total;
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to load image ref times.");
        }
    }

    public String getCategoryName(String imageFileName, String userId) throws AbstractQingIntegratedException, QingImglibException {
        try {
            return this.getImageLibraryDao().getCategoryName(imageFileName, userId);
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to load category");
        }
    }

    public String getCategoryName(String imageFileName) throws AbstractQingIntegratedException, QingImglibException {
        try {
            return this.getImageLibraryDao().getCategoryName(imageFileName);
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to load category");
        }
    }

    public String getImageName(String imageFileName, String userId) throws AbstractQingIntegratedException, QingImglibException {
        try {
            return this.getImageLibraryDao().getImageName(userId, imageFileName);
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to load image name.");
        }
    }

    public ImageModel loadImageModel(String imageFileName) throws AbstractQingIntegratedException, QingImglibException {
        try {
            return this.getImageLibraryDao().loadImageModel(imageFileName);
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to load image name.");
        }
    }

    public Map<String, Object> getImageSize(String imageFileName) throws QingImglibException, AbstractQingIntegratedException {
        try {
            return this.getImageLibraryDao().getImageSize(imageFileName);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to load image size.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNoRefImage(String userId) {
        try {
            this.tx.beginRequired();
            List<ImageModel> images = this.getImageLibraryDao().getAllImage(userId);
            ArrayList<String> deleteImageFiles = new ArrayList<String>();
            for (int i = 0; i < images.size(); ++i) {
                ImageModel image = images.get(i);
                String imageFileName = image.getImageFileName();
                int refTime = this.getRefTimeOfImage(imageFileName);
                if (refTime != 0) continue;
                String imageId = image.getId();
                String thumbnailFileName = image.getThumbnailFileName();
                this.getImageLibraryDao().deleteImage(imageId, userId);
                deleteImageFiles.add(thumbnailFileName);
                deleteImageFiles.add(imageFileName);
            }
            for (String deleteImageFileName : deleteImageFiles) {
                this.deleteImageFile(deleteImageFileName);
            }
        }
        catch (Exception e) {
            this.tx.markRollback();
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        finally {
            this.tx.end();
        }
    }

    public ImageModel getImageModelByImageFileName(String imageFileName) throws AbstractQingIntegratedException, QingImglibException {
        try {
            return this.getImageLibraryDao().getImageModelByImageFileName(imageFileName);
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to load image model.");
        }
    }

    public ImageModel loadImageModelByImagePath(String imagePath) throws AbstractQingIntegratedException, QingImglibException {
        try {
            String userId = this.context.getUserId();
            if (StringUtils.isNotBlank((CharSequence)imagePath)) {
                String[] path = imagePath.split("/");
                String categoryName = path[0];
                String imageName = path[1];
                return this.getImageLibraryDao().loadModelByImageNameAndCategoryName(categoryName, imageName, userId);
            }
            return null;
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to load image model.");
        }
    }

    public String getImagePath(String imageFileName) throws AbstractQingIntegratedException, QingImglibException {
        try {
            String userId = this.context.getUserId();
            return this.getImageLibraryDao().getImageFullPath(imageFileName, userId);
        }
        catch (SQLException e) {
            throw new QingImglibException((Throwable)e, "fail to load image fullpath.");
        }
    }

    private void updateRefFullPath(String categoryName, String imageName, String imageFileName) throws AbstractQingIntegratedException, SQLException {
        String userId = this.context.getUserId();
        PathModel pathModel = new PathModel();
        pathModel.setNameSpace(NameSpace.user.toPersistance());
        pathModel.setGroupName(categoryName);
        pathModel.setName(imageName);
        ISwitchPathAndIdHandler switchPathAndIdHandler = this.getSwitchPathAndIdHandler();
        switchPathAndIdHandler.replacePersistentIdToPath(JsonUtil.encodeToString((Object)pathModel), imageFileName, userId);
    }

    private void updateRefToId(String categoryName, String imageName, String imageFileName) throws AbstractQingIntegratedException, SQLException {
        String userId = this.context.getUserId();
        String fullPath = categoryName + "/" + imageName;
        String fullPathWithNameSpace = NameSpace.user.toPersistance() + "/" + fullPath;
        PathModel pathModel = new PathModel();
        pathModel.setNameSpace(NameSpace.user.toPersistance());
        pathModel.setGroupName(categoryName);
        pathModel.setName(imageName);
        ISwitchPathAndIdHandler switchPathAndIdHandler = this.getSwitchPathAndIdHandler();
        switchPathAndIdHandler.replacePersistentPathToId(fullPath, imageFileName, userId);
        switchPathAndIdHandler.replacePersistentPathToId(fullPathWithNameSpace, imageFileName, userId);
        switchPathAndIdHandler.replacePersistentPathToId(JsonUtil.encodeToString((Object)pathModel), imageFileName, userId);
    }
}

