/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.AbstractQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.DsbDesignerQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.SubjectLongerQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.SubjectSquareQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.PublishDsbQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.PublishLongerSquareQHFExporter;
import com.kingdee.bos.qing.imexport.model.QHFSceneTypeEnum;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class QHFExporterFactory {
    private static Map<QHFSceneTypeEnum, Constructor<? extends AbstractQHFExporter>> EXPORTER_MAP = new HashMap<QHFSceneTypeEnum, Constructor<? extends AbstractQHFExporter>>();

    public static void regist(QHFSceneTypeEnum qhfSceneTypeEnum, Class<? extends AbstractQHFExporter> clazz) {
        try {
            Constructor<? extends AbstractQHFExporter> constructor = clazz.getConstructor(QingContext.class, IDBExcuter.class, ITransactionManagement.class);
            EXPORTER_MAP.put(qhfSceneTypeEnum, constructor);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static AbstractQHFExporter getQHFExporter(QHFSceneTypeEnum sceneTypeEnum, QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        Constructor<? extends AbstractQHFExporter> constructor = EXPORTER_MAP.get((Object)sceneTypeEnum);
        try {
            if (constructor != null) {
                return constructor.newInstance(qingContext, dbExcuter, tx);
            }
            throw new RuntimeException("can't confirm sceneTypeEnum");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        QHFExporterFactory.regist(QHFSceneTypeEnum.subjectLonger, SubjectLongerQHFExporter.class);
        QHFExporterFactory.regist(QHFSceneTypeEnum.subjectSquare, SubjectSquareQHFExporter.class);
        QHFExporterFactory.regist(QHFSceneTypeEnum.publishSubjectLonger, PublishLongerSquareQHFExporter.class);
        QHFExporterFactory.regist(QHFSceneTypeEnum.publishSubjectSquare, PublishLongerSquareQHFExporter.class);
        QHFExporterFactory.regist(QHFSceneTypeEnum.publishEmbeddedLonger, PublishLongerSquareQHFExporter.class);
        QHFExporterFactory.regist(QHFSceneTypeEnum.publishEmbeddedSquare, PublishLongerSquareQHFExporter.class);
        QHFExporterFactory.regist(QHFSceneTypeEnum.dsbDesigner, DsbDesignerQHFExporter.class);
        QHFExporterFactory.regist(QHFSceneTypeEnum.publishDsb, PublishDsbQHFExporter.class);
    }
}

