/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.imexport.exporter.common.publishtarget.AbstractPublishExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.AbstractPublishQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.source.AbstractPublishSourceQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.source.PublishSourceQHFExporterFactory;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetDomainFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jdom2.JDOMException;

public class PublishLongerSquareQHFExporter
extends AbstractPublishQHFExporter {
    public PublishLongerSquareQHFExporter(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    @Override
    public void exportPublishSource(PublishPO publishPO, Map<String, String> params, String tag, AbstractPublishObject publishObj, PackageMeta meta) throws SQLException, IOException, AbstractQingException, JDOMException {
        List<SchemaObject> extraSchemaObjects = this.getExtraSchemaObjects(params, tag, meta);
        String dbSchemaId = this.getDBSchemaId(publishPO.getId(), params);
        List<SchemaObject> schemaObjs = this.getDBSchema(dbSchemaId, meta);
        schemaObjs.addAll(extraSchemaObjects);
        LongerSquarePublishObject longerSquarePublishObj = (LongerSquarePublishObject)publishObj;
        longerSquarePublishObj.setSchemaObjs(schemaObjs);
        meta.getPublishObjs().add(longerSquarePublishObj);
        AbstractPublishSourceQHFExporter publishSourceQHFExporter = PublishSourceQHFExporterFactory.getQHFExporter(publishPO.getPublishSourceType(), this.qingContext, this.dbExcuter, this.tx);
        publishSourceQHFExporter.export(tag, longerSquarePublishObj, meta);
    }

    @Override
    public AbstractPublishObject getPublishObj(PublishPO publishPO) {
        AbstractPublishSourceQHFExporter publishSourceQHFExporter = PublishSourceQHFExporterFactory.getQHFExporter(publishPO.getPublishSourceType(), this.qingContext, this.dbExcuter, this.tx);
        return publishSourceQHFExporter.getPublishObj(publishPO);
    }

    public void exportPublishInfo(String publishId, PackageMeta packageMeta) throws SQLException, AbstractQingException, IOException {
        PublishPO publishPO = this.getCommonPublishDomain().loadPublishInfo(publishId);
        if (publishPO == null) {
            return;
        }
        AbstractPublishObject publishObj = this.getPublishObj(publishPO);
        publishObj.setPublishPO(publishPO);
        List permissionInfos = this.getPublishPermissionDao().loadPublishPermissionInfo(publishId);
        publishObj.setPermissionObjs(ImExportUtil.getPermissionObjs(permissionInfos));
        AbstractPublishTargetDomain publishTargetDomain = PublishTargetDomainFactory.createPublishTargetDomain((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null, (Integer)publishPO.getPublishTargetType());
        if (publishTargetDomain != null) {
            AbstractPublishExporter publishExporter = this.getPublishExporter(publishPO.getPublishTargetType());
            publishExporter.exportTarget(publishObj, publishPO, packageMeta);
        }
        packageMeta.getPublishObjs().add(publishObj);
    }

    private String getDBSchemaId(String publishId, Map<String, String> params) {
        return params.containsKey("schemaId") ? params.get("schemaId") : publishId;
    }
}

