/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.source;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.ModelPersistenceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.source.IFileSavable;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.AbstractQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.PublishSubjectQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.source.AbstractPublishSourceQHFExporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.publish.subject.SubjectCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.subject.DataModelingObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectQsInfo;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.publish.dao.PublishSubjectFileDao;
import com.kingdee.bos.qing.publish.dao.PublishSubjectModelDao;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSubjectFilePO;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jdom2.JDOMException;

public class PublishSourceSubjectQHFExporter
extends AbstractPublishSourceQHFExporter {
    private PublishSubjectFileDao publishSubjectFileDao;
    private PublishSubjectModelDao publishSubjectModelDao;
    private IThemeDao iThemeDao;
    private IThemeGroupDao themeGroupDao;

    public PublishSourceSubjectQHFExporter(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    private PublishSubjectFileDao getPublishSubjectFileDao() {
        if (this.publishSubjectFileDao == null) {
            this.publishSubjectFileDao = new PublishSubjectFileDao(this.dbExcuter);
        }
        return this.publishSubjectFileDao;
    }

    private PublishSubjectModelDao getPublishSubjectModelDao() {
        if (this.publishSubjectModelDao == null) {
            this.publishSubjectModelDao = new PublishSubjectModelDao(this.dbExcuter);
        }
        return this.publishSubjectModelDao;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private IThemeGroupDao getThemeGroupDao() {
        if (this.themeGroupDao == null) {
            this.themeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.themeGroupDao;
    }

    @Override
    public void export(String tag, AbstractPublishObject publishObj, PackageMeta meta) throws AbstractQingException, SQLException, IOException, JDOMException {
        PublishPO publishPO = publishObj.getPublishPO();
        if (publishPO.isCarryData()) {
            this.exportCarryDataInfo(publishObj, meta);
        } else {
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("tag", tag);
            params.put("themeId", publishPO.getTagId());
            PublishSubjectQHFExporter exporter = new PublishSubjectQHFExporter(this.qingContext, this.dbExcuter, this.tx);
            ((AbstractQHFExporter)exporter).export(params, meta);
        }
    }

    @Override
    public AbstractPublishObject getPublishObj(PublishPO publishPO) {
        return new LongerSquarePublishObject();
    }

    private void exportCarryDataInfo(AbstractPublishObject publishObj, PackageMeta meta) throws AbstractQingIntegratedException, SQLException, ModelParseException, IOException, ThemeManagementException, ModelPersistenceException {
        ThemePO themePO;
        List<PublishSubjectFilePO> publishSubjectFilePOs;
        PublishPO publishPO = publishObj.getPublishPO();
        SubjectCarryDataInfo subjectCarryDataInfo = new SubjectCarryDataInfo();
        Box box = this.getPublishSubjectModelDao().loadBoxByPublishId(publishPO.getId());
        if (box != null) {
            DataModelingObject dataModelingObj = new DataModelingObject();
            InputStream dbStream = this.getPublishSubjectModelDao().loadBoxStreamByPublishId(publishPO.getId());
            byte[] boxBytes = BoxSerializationUtil.toBytes(box, null, dbStream);
            String boxTempFileName = ImExportUtil.writeBytesToExportTempFile(boxBytes);
            dataModelingObj.setBoxFileName(boxTempFileName);
            if (box.getSources() != null && !box.getSources().isEmpty()) {
                HashSet<String> dsFileNames = new HashSet<String>(16);
                for (AbstractSource source : box.getSources()) {
                    if (!(source instanceof IFileSavable)) continue;
                    IFileSavable iFileSavable = (IFileSavable)source;
                    String fileUrl = ((IFileSavable)source).getFileUrl();
                    String fileName = iFileSavable.getFileName();
                    String fileExtension = "";
                    if (fileName.indexOf(".") > -1) {
                        fileExtension = fileName.substring(fileName.lastIndexOf("."));
                    }
                    dsFileNames.add(fileUrl + fileExtension);
                }
                dataModelingObj.setDsFileNames(dsFileNames);
            }
            subjectCarryDataInfo.setDataModelingObj(dataModelingObj);
        }
        if ((publishSubjectFilePOs = this.getPublishSubjectFileDao().loadPublishSubjectFile(publishPO.getId())) != null) {
            SubjectQsInfo subjectQsInfo = new SubjectQsInfo();
            HashMap<String, String> dataPathMap = new HashMap<String, String>(publishSubjectFilePOs.size());
            long extractTimestamp = System.currentTimeMillis();
            for (int i = 0; i < publishSubjectFilePOs.size(); ++i) {
                PublishSubjectFilePO publishSubjectFilePO = publishSubjectFilePOs.get(i);
                String qsFileName = publishSubjectFilePO.getFilePath();
                String entityName = publishSubjectFilePO.getEntityName();
                dataPathMap.put(entityName, qsFileName);
                if (publishSubjectFilePO.getExtractDataTime() == null) continue;
                extractTimestamp = publishSubjectFilePO.getExtractDataTime().getTime();
            }
            subjectQsInfo.setQs(dataPathMap);
            subjectQsInfo.setExtractTimestamp(extractTimestamp);
            subjectQsInfo.setOriginalCreatorId(publishPO.getCreatorId());
            subjectQsInfo.setOriginalCreatorName(IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)publishPO.getCreatorId()));
            subjectCarryDataInfo.setSubjectQsInfo(subjectQsInfo);
        }
        if ((themePO = this.getThemeDao().getThemeByID(publishPO.getTagId())) != null) {
            subjectCarryDataInfo.setThemeVO(themePO.toVo());
            ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(themePO.getUserID(), themePO.getGroupID());
            subjectCarryDataInfo.setThemeGroupVO(themeGroupVO);
        }
        publishObj.setCarryDataInfo(subjectCarryDataInfo);
    }
}

