/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.pkg.publish;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.importer.pkg.source.MapImporter;
import com.kingdee.bos.qing.imexport.model.SchemaInfo;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.publish.embedded.EmbeddedPublishObject;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.domain.MapManageDomain;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PermissionObject;
import com.kingdee.bos.qing.publish.model.PermissionTypeEnum;
import com.kingdee.bos.qing.publish.model.PublishOperPermissionsObject;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSchemaModel;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetImexportDomainFactory;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdom2.JDOMException;

public class AbstractPublishInfoImporter {
    protected QingContext qingContext;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    private MapImporter mapImporter;
    private MapManageDomain mapManageDomain;

    public QingContext getQingContext() {
        return this.qingContext;
    }

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public ITransactionManagement getTx() {
        return this.tx;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public IDBExcuter getDbExcuter() {
        return this.dbExcuter;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private MapImporter getMapImporter() {
        if (this.mapImporter == null) {
            this.mapImporter = new MapImporter();
            this.mapImporter.setDbExcuter(this.dbExcuter);
            this.mapImporter.setQingContext(this.qingContext);
            this.mapImporter.setTx(this.tx);
        }
        return this.mapImporter;
    }

    private MapManageDomain getMapManageDomain() {
        if (this.mapManageDomain == null) {
            this.mapManageDomain = new MapManageDomain();
            this.mapManageDomain.setDbExcuter(this.dbExcuter);
            this.mapManageDomain.setQingContext(this.qingContext);
            this.mapManageDomain.setTx(this.tx);
        }
        return this.mapManageDomain;
    }

    public void savePublishWithoutTx(AbstractPublishObject publishObj, ThemeVO subjectVO, ImportParamModel importParamModel) throws IOException, AbstractQingIntegratedException, SQLException, MapException, PublishException, PersistentModelParseException, PersistentModelTooModernException, JDOMException, ImportThemeException, EncryptedLicenseCheckException {
        PublishPO newPublishPO;
        Map<String, String> importIds = importParamModel.getImportIds();
        Map<String, String> tempFile = importParamModel.getTempFile();
        List<PermissionObject> permissionObjs = publishObj.getPermissionObjs();
        List<PublishOperPermissionsObject> publishOperPermissionsObjects = publishObj.getPublishOperPermissionsObjects();
        PublishTarget publishTarget = publishObj.getPublishTarget();
        ArrayList<SchemaObject> publishSchemaObjs = new ArrayList(10);
        if (publishObj instanceof LongerSquarePublishObject) {
            publishSchemaObjs = ((LongerSquarePublishObject)publishObj).getSchemaObjs();
        } else if (publishObj instanceof EmbeddedPublishObject) {
            publishSchemaObjs = ((EmbeddedPublishObject)publishObj).getSchemaObjs();
        }
        PublishPO publishPO = publishObj.getPublishPO();
        String exportPublishId = publishPO.getId();
        String newPublishId = importParamModel.getNewPublishIdMap().get(exportPublishId);
        publishPO.setId(newPublishId);
        List<PermissionInfo> permInfos = this.getPermInfos(permissionObjs, newPublishId);
        HashMap<String, Integer> noOperValueMap = new HashMap<String, Integer>(16);
        if (publishOperPermissionsObjects != null) {
            for (PublishOperPermissionsObject publishOperPermissionsObject : publishOperPermissionsObjects) {
                noOperValueMap.put(publishOperPermissionsObject.getPublishOperPermissionsPO().getType(), publishOperPermissionsObject.getPublishOperPermissionsPO().getNoOperAuthValue());
            }
        }
        if (CollectionUtils.isEmpty(publishSchemaObjs)) {
            return;
        }
        List<AbstractPublishSourceModel> publishSchemaModelList = this.getSchemaModels(publishSchemaObjs, tempFile, importIds, importParamModel);
        AbstractPublishTargetImexportDomain publishTargetImexportDomain = PublishTargetImexportDomainFactory.createPublishTargetImexportDomain(this.qingContext, this.tx, this.dbExcuter, null, publishTarget.getTargetType());
        if (IntegratedHelper.getPresetUserId().equals(this.qingContext.getUserId())) {
            newPublishPO = this.getNewPublishPO(publishTargetImexportDomain, publishTarget, tempFile, publishPO, exportPublishId, noOperValueMap);
            for (PermissionInfo permissionInfo : permInfos) {
                permissionInfo.setPublishId(exportPublishId);
            }
        } else {
            newPublishPO = this.getNewPublishPO(publishTargetImexportDomain, publishTarget, tempFile, publishPO, newPublishId, noOperValueMap);
        }
        this.modifyParentFullPath(publishPO, importParamModel, newPublishPO);
        this.doSavePublishInfo(publishObj, subjectVO, importParamModel, exportPublishId, permInfos, publishSchemaModelList, publishPO, newPublishPO);
    }

    public void doSavePublishInfo(AbstractPublishObject publishObj, ThemeVO subjectVO, ImportParamModel importParamModel, String exportPublishId, List<PermissionInfo> permInfos, List<AbstractPublishSourceModel> publishSchemaModelList, PublishPO publishPO, PublishPO newPublishPO) throws IOException, PublishException, SQLException, AbstractQingIntegratedException, ImportThemeException, EncryptedLicenseCheckException, PersistentModelParseException, PersistentModelTooModernException, JDOMException {
    }

    public void sortPublishObjs(List<AbstractPublishObject> publishObjects) {
        Collections.sort(publishObjects, new Comparator<AbstractPublishObject>(){

            @Override
            public int compare(AbstractPublishObject object1, AbstractPublishObject object2) {
                int object1Size = 0;
                int object2Size = 0;
                if (object1.getPublishPO() != null && object1.getPublishPO().getParentPublishIdFullPath() != null) {
                    object1Size = object1.getPublishPO().getParentPublishIdFullPath().length();
                }
                if (object2.getPublishPO() != null && object2.getPublishPO().getParentPublishIdFullPath() != null) {
                    object2Size = object2.getPublishPO().getParentPublishIdFullPath().length();
                }
                return object1Size - object2Size;
            }
        });
    }

    private List<PermissionInfo> getPermInfos(List<PermissionObject> permissionObjs, String newPublishId) throws IntegratedRuntimeException {
        ArrayList<PermissionInfo> permInfos = new ArrayList<PermissionInfo>(10);
        if (permissionObjs != null) {
            for (PermissionObject permissionObj : permissionObjs) {
                PermissionInfo permissionInfo = permissionObj.getPermissionInfo();
                String viewId = permissionInfo.getViewerId();
                if (permissionInfo.getType() == PermissionTypeEnum.role.getType() && IntegratedHelper.getRoleName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)viewId) != null) {
                    PermissionInfo rolePermissionInfo = new PermissionInfo();
                    String roleUuid = UUID.randomUUID().toString();
                    rolePermissionInfo.setCreateTime(new Date());
                    rolePermissionInfo.setId(roleUuid);
                    rolePermissionInfo.setPublishId(newPublishId);
                    rolePermissionInfo.setType(1);
                    rolePermissionInfo.setViewerId(viewId);
                    permInfos.add(rolePermissionInfo);
                    continue;
                }
                if (permissionInfo.getType() != PermissionTypeEnum.user.getType() || IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)viewId) == null) continue;
                PermissionInfo userPermissionInfo = new PermissionInfo();
                String userUuid = UUID.randomUUID().toString();
                userPermissionInfo.setCreateTime(new Date());
                userPermissionInfo.setId(userUuid);
                userPermissionInfo.setPublishId(newPublishId);
                userPermissionInfo.setType(0);
                userPermissionInfo.setViewerId(viewId);
                permInfos.add(userPermissionInfo);
            }
        }
        return permInfos;
    }

    private List<AbstractPublishSourceModel> getSchemaModels(List<SchemaObject> publishSchemaObjs, Map<String, String> tempFile, Map<String, String> importIds, ImportParamModel importParamModel) throws AbstractQingIntegratedException, SQLException, MapException, JDOMException, IOException, PersistentModelParseException, PersistentModelTooModernException {
        ArrayList<AbstractPublishSourceModel> publishSchemaModelList = new ArrayList<AbstractPublishSourceModel>(publishSchemaObjs.size());
        for (int i = 0; i < publishSchemaObjs.size(); ++i) {
            SchemaObject schemaObj = publishSchemaObjs.get(i);
            SchemaInfo schemaInfo = schemaObj.getSchemaInfo();
            SchemaBO schemaBO = schemaInfo.getSchemaBO();
            List<OutsideReference> outSideRefs = schemaObj.getOutSideRefs();
            if (CollectionUtils.isNotEmpty(outSideRefs)) {
                for (OutsideReference outsideReference : outSideRefs) {
                    outsideReference.setRefType("Map");
                    String oldMapId = outsideReference.getRefToId();
                    String newMapId = null;
                    if (importIds.get(oldMapId) != null) {
                        newMapId = importIds.get(oldMapId);
                    } else if (oldMapId != null && (newMapId = this.getMapImporter().doImportWithoutTx(importParamModel, oldMapId)) != null) {
                        importIds.put(oldMapId, newMapId);
                    }
                    if (newMapId != null) {
                        outsideReference.setRefToFullPath(null);
                        outsideReference.setRefToId(newMapId);
                        importIds.put(oldMapId, newMapId);
                        continue;
                    }
                    String mapFullPath = outsideReference.getRefToFullPath();
                    if (StringUtils.isNotEmpty((CharSequence)mapFullPath)) {
                        PathModel pathModel = (PathModel)JsonUtil.decodeFromString((String)mapFullPath, PathModel.class);
                        if (pathModel != null) {
                            String nameSpace = NameSpace.valueOf((String)pathModel.getNameSpace()).getCode();
                            ExportMapModel exportMapModel = this.getMapManageDomain().loadMapByNameAndGroupName(pathModel.getGroupName(), pathModel.getName(), nameSpace);
                            if (exportMapModel != null) {
                                outsideReference.setRefToFullPath(null);
                                outsideReference.setRefToId(exportMapModel.getMapId());
                                continue;
                            }
                            outsideReference.setRefToId(null);
                            continue;
                        }
                        outsideReference.setRefToId(null);
                        continue;
                    }
                    outsideReference.setRefToId(null);
                }
            }
            ModelBook modelBook = ModelBookUtil.fromFile((AbstractQingFileType)QingTempFileType.UPLOAD, tempFile.get(schemaInfo.getSchemaContentFile()));
            PublishSchemaModel publishSchemaModel = this.getImportSource(modelBook, schemaBO, outSideRefs);
            publishSchemaModelList.add(publishSchemaModel);
        }
        return publishSchemaModelList;
    }

    private PublishSchemaModel getImportSource(ModelBook modelBook, SchemaBO schemaBO, List<OutsideReference> outSideRefist) {
        PublishSchemaModel importSubjectSource = new PublishSchemaModel();
        SchemaAttrVO schemaAttrVO = new SchemaAttrVO();
        schemaAttrVO.setfId(schemaBO.getfId());
        schemaAttrVO.setSchemaName(schemaBO.getSchemaName());
        schemaAttrVO.setIsDefault(schemaBO.IsDefault());
        schemaAttrVO.setSource(schemaBO.getSource());
        schemaAttrVO.setSeq(schemaBO.getSeq());
        schemaAttrVO.setSchemaType(schemaBO.getSchemaType());
        importSubjectSource.setSchemaAttr(schemaAttrVO);
        if (CollectionUtils.isNotEmpty(outSideRefist)) {
            modelBook.fixReferences(outSideRefist);
        }
        importSubjectSource.setSchemaContent(modelBook);
        return importSubjectSource;
    }

    private PublishPO getNewPublishPO(AbstractPublishTargetImexportDomain publishTargetImexportDomain, PublishTarget publishTarget, Map<String, String> tempFile, PublishPO publishPO, String newPublishId, Map<String, Integer> noOperValueMap) throws AbstractQingIntegratedException, SQLException {
        PublishPO newPublishPO = new PublishPO();
        if (publishTargetImexportDomain != null) {
            newPublishPO = publishTargetImexportDomain.loadNewPublishPO(publishTarget, tempFile);
        }
        newPublishPO.setCreatorId(this.qingContext.getUserId());
        newPublishPO.setCreateTime(new Date());
        newPublishPO.setUpdateTime(new Date());
        newPublishPO.setSchemaId("currentAnalysisState");
        newPublishPO.setImport(true);
        newPublishPO.setTagId(publishPO.getTagId());
        newPublishPO.setTimingPush(false);
        newPublishPO.setId(newPublishId);
        newPublishPO.setOverwrite(publishPO.isOverwrite());
        newPublishPO.setAddOldPermission(false);
        newPublishPO.setPublishTargetType(publishTarget.getTargetType());
        newPublishPO.setCanAnalysis(publishPO.isCanAnalysis());
        newPublishPO.setCarryData(publishPO.isCarryData());
        newPublishPO.setName(publishPO.getName());
        newPublishPO.setPublishSourceType(publishPO.getPublishSourceType());
        newPublishPO.setFailedUserIds(publishPO.getFailedUserIds());
        newPublishPO.setNoOperValueMap(noOperValueMap);
        return newPublishPO;
    }

    private void modifyParentFullPath(PublishPO publishPO, ImportParamModel importParamModel, PublishPO newPublishPO) {
        if (publishPO.getParentPublishIdFullPath() != null) {
            String[] oldParentPublishIds = publishPO.getParentPublishIdFullPath().split(",");
            ArrayList<String> newParentPublishIdFullPath = new ArrayList<String>(oldParentPublishIds.length);
            for (String oldParentPublishId : oldParentPublishIds) {
                if (importParamModel.getOverwriteFinalPublishIdMap().get(oldParentPublishId) == null) continue;
                newParentPublishIdFullPath.add(importParamModel.getOverwriteFinalPublishIdMap().get(oldParentPublishId));
            }
            newPublishPO.setParentPublishIdFullPath(StringUtils.join((Object[])newParentPublishIdFullPath.toArray(), (char)','));
        }
    }
}

