/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.pkg.source;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dbmanage.export.DBExportModelConvertor;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.model.resource.DBConnInfo;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.macro.domain.AbstractMacroDomain;
import com.kingdee.bos.qing.macro.domain.MacroDomainFactory;
import com.kingdee.bos.qing.macro.exception.MacroDuplicateNameException;
import com.kingdee.bos.qing.macro.exception.MacroDuplicateUidException;
import com.kingdee.bos.qing.macro.exception.QingMacroException;
import com.kingdee.bos.qing.macro.export.ExportModelConvertor;
import com.kingdee.bos.qing.macro.model.MacroType;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.macro.model.vo.SQLMacro;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class MacroImporter {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;

    public MacroImporter(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    public void doImportWithoutTx(ImportParamModel importParamModel, com.kingdee.bos.qing.imexport.model.resource.Macro macro, List<DBConnInfo> dbConnInfos) throws QingMacroException, AbstractQingIntegratedException, SQLException {
        String oldMacroId;
        String sourceStrategy = importParamModel.getSourceStrategy();
        ExportThemeVO.StrategyType sourceStrategyEnum = ExportThemeVO.StrategyType.valueOf(sourceStrategy);
        Map<String, String> importIds = importParamModel.getImportIds();
        if (importIds.get(oldMacroId = macro.getId()) != null) {
            return;
        }
        String newMacroId = null;
        Macro macroVO = ExportModelConvertor.convertExportModelToMacro(macro);
        AbstractMacroDomain macroDomain = MacroDomainFactory.getDomain((MacroType)macro.getType(), (IDBExcuter)this.dbExcuter, (ITransactionManagement)this.tx, (QingContext)this.qingContext);
        if (macroVO instanceof SQLMacro) {
            String refDBHashcode = ((com.kingdee.bos.qing.imexport.model.resource.SQLMacro)macro).getRefDBHashcode();
            ((SQLMacro)macroVO).setRefDBHashCode(refDBHashcode);
            for (DBConnInfo dbConn : dbConnInfos) {
                if (!dbConn.getDbSource().getSourceHashCode().equals(refDBHashcode)) continue;
                DBConnection dbConnection = DBExportModelConvertor.convertExportModelToDBConn((DBConnInfo)dbConn);
                ((SQLMacro)macroVO).setDBInfo(dbConnection);
            }
        }
        try {
            macroDomain.saveMacroWithoutTx(macroVO, false);
            newMacroId = macroVO.getFid();
        }
        catch (MacroDuplicateUidException e) {
            if (ExportThemeVO.StrategyType.overwrite == sourceStrategyEnum) {
                macroDomain.deleteMacroByUidWithoutTx(macro.getUid());
                macroDomain.saveMacroWithoutTx(macroVO, false);
                newMacroId = macroVO.getFid();
            }
        }
        catch (MacroDuplicateNameException e) {
            String name = macroVO.getName();
            name = ImExportUtil.rename(name);
            while (macroDomain.isMacroNameExist(name)) {
                name = ImExportUtil.rename(name);
            }
            macroVO.setName(name);
            macroDomain.saveMacroWithoutTx(macroVO, false);
            newMacroId = macroVO.getFid();
        }
        importIds.put(oldMacroId, newMacroId);
    }
}

