/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.pkg.source;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.imagelibrary.dao.ImageLibraryDao;
import com.kingdee.bos.qing.imagelibrary.domian.ImageLibraryDomain;
import com.kingdee.bos.qing.imagelibrary.exception.GroupDuplicateNameException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageFileSizeLimitException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageTypeException;
import com.kingdee.bos.qing.imagelibrary.model.ImageModel;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.resource.Picture;
import com.kingdee.bos.qing.imexport.model.resource.Resources;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.publish.target.dsbtimingpush.dao.DsbTimingPushDao;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class PictureImporter {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private ImageLibraryDomain imageLibraryDomain;
    private ImageLibraryDao imageLibraryDao;
    private DashboardPublishDao dashboardPublishDao;
    private DashboardDao dashboardDao;
    private DsbTimingPushDao dsbTimingPushDao;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private DsbTimingPushDao getDsbTimingPushDao() {
        if (this.dsbTimingPushDao == null) {
            this.dsbTimingPushDao = new DsbTimingPushDao(this.dbExcuter);
        }
        return this.dsbTimingPushDao;
    }

    private ImageLibraryDomain getImageLibraryDomain() {
        if (this.imageLibraryDomain == null) {
            this.imageLibraryDomain = new ImageLibraryDomain();
            this.imageLibraryDomain.setDbExcuter(this.dbExcuter);
            this.imageLibraryDomain.setQingContext(this.qingContext);
            this.imageLibraryDomain.setTx(this.tx);
        }
        return this.imageLibraryDomain;
    }

    private ImageLibraryDao getImageLibraryDao() {
        if (this.imageLibraryDao == null) {
            this.imageLibraryDao = new ImageLibraryDao(this.dbExcuter);
        }
        return this.imageLibraryDao;
    }

    protected DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    public String doImport(ImportParamModel importParamModel, String oldPictureId) throws AbstractQingIntegratedException, SQLException, GroupDuplicateNameException, ImageTypeException, ImageFileSizeLimitException, IOException {
        PackageMeta meta = importParamModel.getPackageMeta();
        String sourceStrategy = importParamModel.getSourceStrategy();
        Map<String, String> tempFile = importParamModel.getTempFile();
        List<IQingFile> successImportFiles = importParamModel.getSuccessImportFiles();
        Resources resources = meta.getResources();
        List<Picture> pictures = resources.getPictures();
        String userId = this.qingContext.getUserId();
        Picture importPicture = null;
        boolean insertCategory = false;
        String imageFileName = null;
        for (Picture picture : pictures) {
            if (!oldPictureId.equals(picture.getId())) continue;
            importPicture = picture;
            break;
        }
        if (importPicture != null) {
            String categoryName = importPicture.getCategoryName();
            String categoryId = this.getImageLibraryDao().getCategoryIdByName(categoryName, userId);
            if (categoryId == null) {
                categoryId = this.getImageLibraryDao().saveOrUpdateCategory(userId, null, categoryName);
                insertCategory = true;
            }
            String imageName = importPicture.getImageName();
            ImageModel imageModel = this.getImageLibraryDao().loadModelByImageNameAndCategoryName(categoryName, imageName, userId);
            String pictureFileKey = tempFile.get(importPicture.getId() + imageName.substring(imageName.lastIndexOf(".")));
            if (pictureFileKey == null) {
                return null;
            }
            if (imageModel != null) {
                ExportThemeVO.StrategyType strategyEnum = ExportThemeVO.StrategyType.valueOf(sourceStrategy);
                if (ExportThemeVO.StrategyType.ignore == strategyEnum) {
                    if (insertCategory) {
                        insertCategory = false;
                        this.getImageLibraryDao().deleteCategory(categoryId, userId);
                    }
                } else if (ExportThemeVO.StrategyType.rename == strategyEnum) {
                    String fId = this.dbExcuter.genStringId("T_QING_IMGLIB_IMG_INFO");
                    imageFileName = this.saveImage(successImportFiles, categoryId, pictureFileKey, imageName, fId);
                } else if (ExportThemeVO.StrategyType.overwrite == strategyEnum) {
                    String imageId = this.dbExcuter.genStringId("T_QING_IMGLIB_IMG_INFO");
                    String oldFileName = null;
                    if (imageModel != null) {
                        imageId = imageModel.getId();
                        oldFileName = imageModel.getImageFileName();
                        this.getImageLibraryDomain().deleteImageFile(imageModel.getImageFileName());
                        this.getImageLibraryDomain().deleteImageFile(imageModel.getThumbnailFileName());
                        this.getImageLibraryDao().deleteImage(imageId, userId);
                    }
                    imageFileName = this.saveImage(successImportFiles, categoryId, pictureFileKey, imageName, imageId);
                    if (oldFileName != null) {
                        List<ReferenceMap> oldFileNamePublishRef = this.getDashboardPublishDao().loadRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                        int len = oldFileNamePublishRef.size();
                        for (int j = 0; j < len; ++j) {
                            ReferenceMap ref = oldFileNamePublishRef.get(j);
                            this.getDashboardPublishDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                        }
                        List<ReferenceMap> oldFileNameRef = this.getDashboardDao().loadRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                        int len2 = oldFileNameRef.size();
                        for (int j = 0; j < len2; ++j) {
                            ReferenceMap ref = oldFileNameRef.get(j);
                            this.getDashboardDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                        }
                        List<ReferenceMap> oldFileNameEmailTimingPushRef = this.getDsbTimingPushDao().loadRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                        int len3 = oldFileNameEmailTimingPushRef.size();
                        for (int j = 0; j < len3; ++j) {
                            ReferenceMap ref = oldFileNameEmailTimingPushRef.get(j);
                            this.getDsbTimingPushDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                        }
                        List<ReferenceMap> oldFileNameRobotTimingPushRef = this.getDsbTimingPushDao().loadRobotPushRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                        int len4 = oldFileNameRobotTimingPushRef.size();
                        for (int j = 0; j < len4; ++j) {
                            ReferenceMap ref = oldFileNameRobotTimingPushRef.get(j);
                            this.getDsbTimingPushDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                        }
                    }
                }
            } else {
                String fId = this.dbExcuter.genStringId("T_QING_IMGLIB_IMG_INFO");
                imageFileName = this.saveImage(successImportFiles, categoryId, pictureFileKey, imageName, fId);
            }
        }
        return imageFileName;
    }

    private String saveImage(List<IQingFile> successImportFile, String categoryId, String pictureFileKey, String imageName, String imageId) throws ImageTypeException, ImageFileSizeLimitException, AbstractQingIntegratedException, SQLException, IOException {
        String userId = this.qingContext.getUserId();
        ImageModel imageModel = new ImageModel();
        imageModel.setId(imageId);
        imageModel.setCategoryId(categoryId);
        imageModel.setUserId(userId);
        imageModel.setImageName(imageName);
        imageModel.setImageFileName(pictureFileKey);
        IQingFile thumbnailFileNameP = this.getImageLibraryDomain().createImageFile(imageName + "_thumbnail", imageId, true);
        IQingFile imageFileNameP = this.getImageLibraryDomain().createImageFile(imageName, imageId, false);
        successImportFile.add(thumbnailFileNameP);
        successImportFile.add(imageFileNameP);
        this.getImageLibraryDomain().saveImageInfoWithNoTX(imageModel, thumbnailFileNameP, imageFileNameP);
        return imageModel.getImageFileName();
    }
}

