/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain;

import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.exception.ImportCacheNotFoundException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportEncryptedLicenseCheckException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.AbstractImportDsbQHFDomain;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.dashboard.DashboardObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.util.QHFDsbUtil;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.util.BoxUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class ImportDsbDesignQHFDomain
extends AbstractImportDsbQHFDomain {
    public DashboardModel loadDsbModel(String tag) throws ImportException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            try {
                Map<String, String> tempMap = importedModel.getTempFileMap();
                DashboardObject dashboardObj = importedModel.getPackageMeta().getDashboardObjs().get(0);
                String zipFileName = dashboardObj.getDsbModelFileName();
                String tempFileName = tempMap.get(zipFileName);
                List<DsbRefObject> dsbRefObjs = dashboardObj.getDsbRefObjs();
                List<ReferenceMap> referenceMaps = this.getReferenceMaps(dsbRefObjs);
                InputStream dsbOrignalStream = BoxUtil.getBoxStreamByFileName(tempFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
                DashboardModel dashboardModel = DashboardSerializationUtil.toModel(dsbOrignalStream);
                dashboardModel.fixReferences(referenceMaps);
                return dashboardModel;
            }
            catch (PersistentModelParseException e) {
                throw new ImportException(e);
            }
            catch (IOException e) {
                throw new ImportException(e);
            }
            catch (EncryptedLicenseCheckException e) {
                throw new ImportEncryptedLicenseCheckException(e.getMessage(), e.getErrorCode());
            }
        }
        throw new ImportCacheNotFoundException();
    }

    public String dsbRefRefreshData(String tag, String uid) throws ImportCacheNotFoundException, ImportNoInfoFoundException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            DashboardObject dashboardObj;
            List<DsbRefObject> dsbRefObjs;
            List<DashboardObject> dashboardObjs = importedModel.getPackageMeta().getDashboardObjs();
            if (dashboardObjs != null && !dashboardObjs.isEmpty() && (dsbRefObjs = (dashboardObj = dashboardObjs.get(0)).getDsbRefObjs()) != null) {
                for (DsbRefObject dsbRefObj : dsbRefObjs) {
                    if (!dsbRefObj.getReferenceMap().getUid().equals(uid)) continue;
                    String refTag = QHFDsbUtil.getRefUniqueKeyForImport(tag, dashboardObj.getThemeVO().getThemeID(), false, uid);
                    QingSessionUtil.set((String)refTag, (String)tag);
                    return refTag;
                }
            }
            throw new ImportNoInfoFoundException();
        }
        throw new ImportCacheNotFoundException();
    }

    public ModelBook loadSchema(String tag, ReferenceMap referenceMap) throws ImportException {
        String uid = referenceMap.getUid();
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            try {
                List<DashboardObject> dashboardObjs = importedModel.getPackageMeta().getDashboardObjs();
                if (dashboardObjs != null && !dashboardObjs.isEmpty()) {
                    Map<String, String> tempMap = importedModel.getTempFileMap();
                    DashboardObject dashboardObj = dashboardObjs.get(0);
                    List<DsbRefObject> dsbRefObjs = dashboardObj.getDsbRefObjs();
                    if (dsbRefObjs != null) {
                        for (DsbRefObject dsbRefObj : dsbRefObjs) {
                            String refSchemaContentFileName;
                            String tempFileName;
                            IQingFileVisitor qingFileVisitor;
                            if (!dsbRefObj.getReferenceMap().getUid().equals(uid) || !(qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)(tempFileName = tempMap.get(refSchemaContentFileName = dsbRefObj.getRefSchemaContentFileName())))).exists()) continue;
                            ModelBook modelBook = DashboardModelUtil.byteToSchemaModel((InputStream)qingFileVisitor.getInputStream());
                            List<OutsideReference> outsideRef = dsbRefObj.getOuterRefs();
                            if (modelBook != null && outsideRef != null && outsideRef.size() > 0) {
                                modelBook.fixReferences(outsideRef);
                            }
                            return modelBook;
                        }
                    }
                }
                throw new ImportNoInfoFoundException();
            }
            catch (IOException e) {
                throw new ImportException(e);
            }
            catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
                throw new ImportException(e);
            }
            catch (PersistentModelTooModernException e) {
                throw new ImportException(e);
            }
        }
        throw new ImportCacheNotFoundException();
    }
}

