/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain;

import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.exception.ImportCacheNotFoundException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportEncryptedLicenseCheckException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.AbstractImportDsbQHFDomain;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.SchemaInfo;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbPublishObject;
import com.kingdee.bos.qing.imexport.util.QHFDsbUtil;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaContentVO;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jdom2.JDOMException;

public class ImportRuntimeDsbQHFDomain
extends AbstractImportDsbQHFDomain {
    public DashboardModel loadPublishedDsb(String tag) throws ImportException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            try {
                List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
                if (publishObjs != null && !publishObjs.isEmpty()) {
                    for (AbstractPublishObject publishObj : publishObjs) {
                        if (PublishSourceEnum.dashboard != publishObj.getPublishPO().getPublishSourceType()) continue;
                        DsbPublishObject dsbPublishObj = (DsbPublishObject)publishObj;
                        String zipFileName = dsbPublishObj.getDsbModelFileName();
                        Map<String, String> tempMap = importedModel.getTempFileMap();
                        String tempFileName = tempMap.get(zipFileName);
                        List<DsbRefObject> dsbRefObjs = dsbPublishObj.getDsbRefObjs();
                        List<ReferenceMap> referenceMaps = this.getReferenceMaps(dsbRefObjs);
                        InputStream dsbOrignalStream = BoxUtil.getBoxStreamByFileName(tempFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
                        DashboardModel dashboardModel = new DashboardModel();
                        if (dsbOrignalStream != null) {
                            dashboardModel = DashboardSerializationUtil.toModel(dsbOrignalStream);
                        }
                        dashboardModel.fixReferences(referenceMaps);
                        return dashboardModel;
                    }
                }
                throw new ImportNoInfoFoundException();
            }
            catch (PersistentModelParseException e) {
                throw new ImportException(e);
            }
            catch (IOException e) {
                throw new ImportException(e);
            }
            catch (EncryptedLicenseCheckException e) {
                throw new ImportEncryptedLicenseCheckException(e.getMessage(), e.getErrorCode());
            }
        }
        throw new ImportCacheNotFoundException();
    }

    public String dsbRefRefreshData(String tag, String uid) throws ImportCacheNotFoundException, ImportNoInfoFoundException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
            if (publishObjs != null && !publishObjs.isEmpty()) {
                for (AbstractPublishObject publishObj : publishObjs) {
                    DsbPublishObject dsbPublishObj;
                    List<DsbRefObject> dsbRefObjs;
                    if (PublishSourceEnum.dashboard != publishObj.getPublishPO().getPublishSourceType() || (dsbRefObjs = (dsbPublishObj = (DsbPublishObject)publishObj).getDsbRefObjs()) == null) continue;
                    for (DsbRefObject dsbRefObj : dsbRefObjs) {
                        ReferenceMap referenceMap = dsbRefObj.getReferenceMap();
                        if (!referenceMap.getUid().equals(uid)) continue;
                        String refTag = QHFDsbUtil.getRefUniqueKeyForImport(tag, dsbPublishObj.getPublishPO().getId(), true, uid);
                        QingSessionUtil.set((String)refTag, (String)tag);
                        return refTag;
                    }
                }
            }
            throw new ImportNoInfoFoundException();
        }
        throw new ImportCacheNotFoundException();
    }

    public ModelBook loadSchema(String tag, ReferenceMap referenceMap) throws ImportException {
        String uid = referenceMap.getUid();
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            try {
                Map<String, String> tempMap = importedModel.getTempFileMap();
                List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
                if (publishObjs != null && !publishObjs.isEmpty()) {
                    for (AbstractPublishObject publishObj : publishObjs) {
                        if (PublishSourceEnum.dashboard != publishObj.getPublishPO().getPublishSourceType()) continue;
                        DsbPublishObject dsbPublishObj = (DsbPublishObject)publishObj;
                        List<DsbRefObject> dsbRefObjs = dsbPublishObj.getDsbRefObjs();
                        for (DsbRefObject dsbRefObj : dsbRefObjs) {
                            String refSchemaContentFileName;
                            String tempFileName;
                            IQingFileVisitor qingFileVisitor;
                            if (!dsbRefObj.getReferenceMap().getUid().equals(uid) || !(qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)(tempFileName = tempMap.get(refSchemaContentFileName = dsbRefObj.getRefSchemaContentFileName())))).exists()) continue;
                            ModelBook modelBook = DashboardModelUtil.byteToSchemaModel((InputStream)qingFileVisitor.getInputStream());
                            List<OutsideReference> outsideRef = dsbRefObj.getOuterRefs();
                            if (modelBook != null && outsideRef != null && outsideRef.size() > 0) {
                                modelBook.fixReferences(outsideRef);
                            }
                            return modelBook;
                        }
                    }
                }
                throw new ImportNoInfoFoundException();
            }
            catch (IOException e) {
                throw new ImportException(e);
            }
            catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
                throw new ImportException(e);
            }
            catch (PersistentModelTooModernException e) {
                throw new ImportException(e);
            }
        }
        throw new ImportCacheNotFoundException();
    }

    public ArrayList<SchemaAttrVO> loadRefAnalysisSchemaAttrs(String refTag) throws IOException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, ImportCacheNotFoundException {
        String tag = QingSessionUtil.get((String)refTag);
        ArrayList<SchemaAttrVO> listVO = new ArrayList<SchemaAttrVO>();
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
            if (publishObjs != null && !publishObjs.isEmpty()) {
                for (AbstractPublishObject publishObj : publishObjs) {
                    DsbPublishObject dsbPublishObj;
                    List<DsbRefObject> dsbRefObjs;
                    if (PublishSourceEnum.dashboard != publishObj.getPublishPO().getPublishSourceType() || (dsbRefObjs = (dsbPublishObj = (DsbPublishObject)publishObj).getDsbRefObjs()) == null) continue;
                    for (DsbRefObject dsbRefObj : dsbRefObjs) {
                        ReferenceMap referenceMap = dsbRefObj.getReferenceMap();
                        String refTagTemp = QHFDsbUtil.getRefUniqueKeyForImport(tag, dsbPublishObj.getPublishPO().getId(), true, referenceMap.getUid());
                        if (!refTagTemp.equals(refTag)) continue;
                        List<SchemaObject> schemaObjs = dsbRefObj.getAnalysisSchemaObjects();
                        if (schemaObjs != null && !schemaObjs.isEmpty()) {
                            for (SchemaObject schemaObj : schemaObjs) {
                                SchemaBO schemaBO;
                                SchemaInfo schemaInfo = schemaObj.getSchemaInfo();
                                if (schemaInfo == null || (schemaBO = schemaInfo.getSchemaBO()) == null) continue;
                                SchemaAttrVO schemaAttrVO = new SchemaAttrVO();
                                schemaAttrVO.setfId(schemaBO.getfId());
                                schemaAttrVO.setSchemaName(schemaBO.getSchemaName());
                                schemaAttrVO.setSchemaType(schemaBO.getSchemaType());
                                schemaAttrVO.setIsDefault(schemaBO.IsDefault());
                                schemaAttrVO.setSource(schemaBO.getSource());
                                schemaAttrVO.setSeq(schemaBO.getSeq());
                                listVO.add(schemaAttrVO);
                            }
                        }
                        Collections.sort(listVO, new Comparator<SchemaAttrVO>(){

                            @Override
                            public int compare(SchemaAttrVO v1, SchemaAttrVO v2) {
                                int seqDiff = v1.getSeq() - v2.getSeq();
                                if (seqDiff < 0) {
                                    return 1;
                                }
                                if (seqDiff > 0) {
                                    return -1;
                                }
                                return 0;
                            }
                        });
                        return listVO;
                    }
                }
            }
            return listVO;
        }
        throw new ImportCacheNotFoundException();
    }

    public SchemaContentVO loadRefAnalysisSchemaContent(String refTag, String schemaId) throws ImportException {
        String tag = QingSessionUtil.get((String)refTag);
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
            for (AbstractPublishObject publishObj : publishObjs) {
                DsbPublishObject dsbPublishObj;
                List<DsbRefObject> dsbRefObjs;
                if (PublishSourceEnum.dashboard != publishObj.getPublishPO().getPublishSourceType() || (dsbRefObjs = (dsbPublishObj = (DsbPublishObject)publishObj).getDsbRefObjs()) == null) continue;
                for (DsbRefObject dsbRefObj : dsbRefObjs) {
                    List<SchemaObject> schemaObjs;
                    ReferenceMap referenceMap = dsbRefObj.getReferenceMap();
                    String refTagTemp = QHFDsbUtil.getRefUniqueKeyForImport(tag, dsbPublishObj.getPublishPO().getId(), true, referenceMap.getUid());
                    if (!refTagTemp.equals(refTag) || (schemaObjs = dsbRefObj.getAnalysisSchemaObjects()) == null || schemaObjs.isEmpty()) continue;
                    for (SchemaObject schemaObj : schemaObjs) {
                        SchemaBO schemaBO;
                        SchemaInfo schemaInfo = schemaObj.getSchemaInfo();
                        if (schemaInfo == null || (schemaBO = schemaInfo.getSchemaBO()) == null) continue;
                        boolean flag = false;
                        if (schemaBO.getfId().equals(schemaId)) {
                            flag = true;
                        }
                        if (!flag) continue;
                        SchemaContentVO contentVO = new SchemaContentVO();
                        contentVO.setfId(schemaBO.getfId());
                        contentVO.setSchemaName(schemaBO.getSchemaName());
                        contentVO.setSchemaType(schemaBO.getSchemaType());
                        Map<String, String> tempMap = importedModel.getTempFileMap();
                        String zipFileName = schemaInfo.getSchemaContentFile();
                        String tempFileName = tempMap.get(zipFileName);
                        try {
                            ModelBook modelBook = ModelBookUtil.fromFile((AbstractQingFileType)QingTempFileType.UPLOAD, tempFileName);
                            List<OutsideReference> outSideRefList = schemaObj.getOutSideRefs();
                            if (outSideRefList != null && !outSideRefList.isEmpty()) {
                                modelBook.fixReferences(outSideRefList);
                            }
                            contentVO.setSchemaContent(modelBook);
                            return contentVO;
                        }
                        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
                            throw new ImportException(e);
                        }
                        catch (PersistentModelTooModernException e) {
                            throw new ImportException(e);
                        }
                        catch (IOException e) {
                            throw new ImportException(e);
                        }
                        catch (JDOMException e) {
                            throw new ImportException(e);
                        }
                    }
                }
            }
            return null;
        }
        throw new ImportCacheNotFoundException();
    }
}

