/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.common;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.model.SourceTypeVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.SubjectDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.SchemaInfo;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.subject.DataModelingObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectQsInfo;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.JDOMException;

public class AbstractSubjectModelParser {
    protected void cacheDataSource(SubjectQsInfo subjectQsInfo, DataModelingObject dataModelingObject, String tag, ImportedModel importedModel) throws IOException, JDOMException, ModelParseException, EncryptedLicenseCheckException {
        if (subjectQsInfo != null) {
            ThemeDataSource dataSource = new ThemeDataSource();
            dataSource.setExtractDataTime(subjectQsInfo.getExtractTimestamp());
            dataSource.setOriginalCreatorId(subjectQsInfo.getOriginalCreatorId());
            String boxFileName = dataModelingObject.getBoxFileName();
            Map<String, String> tempMap = importedModel.getTempFileMap();
            String tempFileName = tempMap.get(boxFileName);
            Box box = new Box();
            InputStream boxOrignalStream = BoxUtil.getBoxStreamByFileName(tempFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
            if (boxOrignalStream != null) {
                box = BoxSerializationUtil.toModel(boxOrignalStream, true);
            }
            dataSource.setBox(box);
            BoxUtil.cacheBoxStream(BoxUtil.getBoxStreamByFileName(tempFileName, (AbstractQingFileType)QingTempFileType.UPLOAD));
            HashMap<String, String> dataFiles = new HashMap<String, String>(16);
            Map<String, String> qsMap = subjectQsInfo.getQs();
            for (Map.Entry<String, String> entityEntry : qsMap.entrySet()) {
                dataFiles.put(entityEntry.getKey(), tempMap.get(entityEntry.getValue()));
            }
            dataSource.setDataFiles(dataFiles);
            dataSource.setTag(tag);
            QingSessionUtil.setCache((ISessionCacheable)dataSource);
        }
    }

    protected SubjectDataSourceInfoVO getDataSourceInfoBySubjectObject(SubjectObject subjectObject, ImportedModel importedModel) throws ImportException {
        ThemeVO themeVO = subjectObject.getThemeVO();
        ThemeGroupVO themeGroupVO = subjectObject.getThemeGroupVO();
        SubjectDataSourceInfoVO subjectDataSourceInfoVO = new SubjectDataSourceInfoVO();
        subjectDataSourceInfoVO.setSourceType(SourceTypeVO.SourceTypeEnum.subject.name());
        subjectDataSourceInfoVO.setGroupName(themeGroupVO.getThemeGroupName());
        subjectDataSourceInfoVO.setDescription(themeVO.getDescription());
        subjectDataSourceInfoVO.setName(themeVO.getThemeName());
        SubjectQsInfo subjectQsInfo = subjectObject.getAnalysisObj().getSubjectQsInfo();
        if (subjectQsInfo != null) {
            String extractDataTraceFileName = subjectQsInfo.getExtractDataTraceFile();
            List<TraceSpan> extractDataTraceSpans = ImExportUtil.getTraceSpansByZipFileName(extractDataTraceFileName, importedModel);
            subjectDataSourceInfoVO.setExtractDataTraceSpans(extractDataTraceSpans);
        }
        return subjectDataSourceInfoVO;
    }

    protected List<TraceSpanVO> getTraceSpanInfo(SubjectQsInfo subjectQsInfo, List<SchemaObject> schemaObjects, ImportedModel importedModel) throws ImportException {
        ArrayList<TraceSpanVO> traceSpanVOList = new ArrayList<TraceSpanVO>(10);
        if (subjectQsInfo != null) {
            String extractDataTraceFileName = subjectQsInfo.getExtractDataTraceFile();
            List<TraceSpanVO> extractDataTraceSpanVOs = ImExportUtil.getTraceSpanVOsByZipTraceFileName(extractDataTraceFileName, importedModel, 0, Messages.getMLS((String)"dataExtract", (String)"\u6570\u636e\u62bd\u53d6", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
            traceSpanVOList.addAll(extractDataTraceSpanVOs);
        }
        if (schemaObjects != null && !schemaObjects.isEmpty()) {
            for (SchemaObject schemaObject : schemaObjects) {
                SchemaInfo schemaInfo = schemaObject.getSchemaInfo();
                if (!StringUtils.isNotBlank((CharSequence)schemaInfo.getExecuteTraceFile())) continue;
                String joinTraceFileName = schemaInfo.getJoinTraceFile();
                List<TraceSpanVO> joinTraceSpanVOs = ImExportUtil.getTraceSpanVOsByZipTraceFileName(joinTraceFileName, importedModel, 0, Messages.getMLS((String)"joinTask", (String)"JOIN\u4efb\u52a1", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                traceSpanVOList.addAll(joinTraceSpanVOs);
                String executeTraceFileName = schemaInfo.getExecuteTraceFile();
                List<TraceSpanVO> executeTraceSpanVOs = ImExportUtil.getTraceSpanVOsByZipTraceFileName(executeTraceFileName, importedModel, 0, Messages.getMLS((String)"schemaExecute", (String)"\u65b9\u6848\u6267\u884c", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                traceSpanVOList.addAll(executeTraceSpanVOs);
                break;
            }
        }
        return traceSpanVOList;
    }
}

