/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.imexport.strategy.IQHFStrategy;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class Environment {
    private String sceneType;
    private Account account = new Account();
    private Product product = new Product();
    private Client client = new Client();
    private Server server = new Server();
    private UserContext userContext = new UserContext();

    private Environment() {
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public void setUserContext(UserContext userContext) {
        this.userContext = userContext;
    }

    public String getSceneType() {
        return this.sceneType;
    }

    public void setSceneType(String sceneType) {
        this.sceneType = sceneType;
    }

    private static Environment assignValueEnvironment(QingContext qingContext) {
        IQHFStrategy qhfStrategy = (IQHFStrategy)CustomStrategyRegistrar.getStrategy(IQHFStrategy.class);
        if (qhfStrategy == null) {
            throw new RuntimeException("cannot found the implement of IQHFStrategy.");
        }
        Environment environment = new Environment();
        qhfStrategy.assignEnvironmentValue(environment, qingContext);
        return environment;
    }

    public Element toXml() {
        Element environmentElement = new Element("Environment");
        environmentElement.setAttribute("sceneType", this.sceneType);
        environmentElement.addContent((Content)this.account.toXml());
        environmentElement.addContent((Content)this.product.toXml());
        environmentElement.addContent((Content)this.client.toXml());
        environmentElement.addContent((Content)this.server.toXml());
        environmentElement.addContent((Content)this.userContext.toXml());
        return environmentElement;
    }

    public void fromXml(Element xml, String type, String version) {
        this.sceneType = xml.getAttributeValue("sceneType");
        Element accountElement = xml.getChild("Account");
        this.account.setId(accountElement.getAttributeValue("id"));
        this.account.setName(accountElement.getAttributeValue("name"));
        Element productElement = xml.getChild("Product");
        this.product.setName(productElement.getAttributeValue("name"));
        this.product.setVersion(productElement.getAttributeValue("version"));
        this.product.setSerialNo(productElement.getAttributeValue("serialNo"));
        Element clientElement = xml.getChild("Client");
        this.client.setBrowser(clientElement.getAttributeValue("browser"));
        this.client.setBrowserVersion(clientElement.getAttributeValue("browserVersion"));
        this.client.setClientOS(clientElement.getAttributeValue("clientOS"));
        Element serverElement = xml.getChild("Server");
        this.server.setServerOS(serverElement.getAttributeValue("serverOS"));
        this.server.setServerOSVersion(serverElement.getAttributeValue("serverOSVersion"));
        Element userContextElement = xml.getChild("UserContext");
        this.userContext.setSystemVars((Map)JsonUtil.decodeFromString((String)userContextElement.getChild("systemVars").getTextTrim(), Map.class));
    }

    public static class UserContext {
        private Map<String, String> systemVars;

        public Map<String, String> getSystemVars() {
            return this.systemVars;
        }

        public void setSystemVars(Map<String, String> systemVars) {
            this.systemVars = systemVars;
        }

        public Element toXml() {
            Element userContextElement = new Element("UserContext");
            Element systemVarsElement = new Element("systemVars");
            XmlUtil.addCDATA((Element)systemVarsElement, (String)JsonUtil.encodeToString(this.systemVars));
            userContextElement.addContent((Content)systemVarsElement);
            return userContextElement;
        }
    }

    public static class Server {
        private String serverOS;
        private String serverOSVersion;

        public String getServerOS() {
            return this.serverOS;
        }

        public void setServerOS(String serverOS) {
            this.serverOS = serverOS;
        }

        public String getServerOSVersion() {
            return this.serverOSVersion;
        }

        public void setServerOSVersion(String serverOSVersion) {
            this.serverOSVersion = serverOSVersion;
        }

        public Element toXml() {
            Element serverElement = new Element("Server");
            serverElement.setAttribute("serverOS", this.serverOS);
            serverElement.setAttribute("serverOSVersion", this.serverOSVersion);
            return serverElement;
        }
    }

    public static class Client {
        private String browser;
        private String browserVersion;
        private String clientOS;

        public String getBrowser() {
            return this.browser;
        }

        public void setBrowser(String browser) {
            this.browser = browser;
        }

        public String getBrowserVersion() {
            return this.browserVersion;
        }

        public void setBrowserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
        }

        public String getClientOS() {
            return this.clientOS;
        }

        public void setClientOS(String clientOS) {
            this.clientOS = clientOS;
        }

        public Element toXml() {
            Element clientElement = new Element("Client");
            clientElement.setAttribute("browser", this.browser);
            clientElement.setAttribute("browserVersion", this.browserVersion);
            clientElement.setAttribute("clientOS", this.clientOS);
            return clientElement;
        }
    }

    public static class Product {
        private String serialNo;
        private String name;
        private String version;

        public String getSerialNo() {
            return this.serialNo;
        }

        public void setSerialNo(String serialNo) {
            this.serialNo = serialNo;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Element toXml() {
            Element productElement = new Element("Product");
            if (StringUtils.isNotEmpty((CharSequence)this.name)) {
                productElement.setAttribute("name", this.name);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.version)) {
                productElement.setAttribute("version", this.version);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.serialNo)) {
                productElement.setAttribute("serialNo", this.serialNo);
            }
            return productElement;
        }
    }

    public static class Account {
        private String id;
        private String name;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Element toXml() {
            Element accountElement = new Element("Account");
            accountElement.setAttribute("name", this.name);
            accountElement.setAttribute("id", this.id);
            return accountElement;
        }
    }

    public static class Builder {
        private String sceneType;

        public String getSceneType() {
            return this.sceneType;
        }

        public Builder setSceneType(String sceneType) {
            this.sceneType = sceneType;
            return this;
        }

        private void construct(Environment environment) {
            environment.setSceneType(this.sceneType);
        }

        public Environment createBlank() {
            Environment environment = new Environment();
            this.construct(environment);
            return environment;
        }

        public Environment createHasEnvironment(QingContext qingContext) {
            Environment environment = Environment.assignValueEnvironment(qingContext);
            this.construct(environment);
            return environment;
        }
    }
}

