/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.dashboard;

import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class DsbRefObject {
    private ReferenceMap referenceMap;
    private String refSchemaContentFileName;
    private List<OutsideReference> outerRefs;
    private List<SchemaObject> analysisSchemaObjects;
    protected List<TraceSpan> joinTraceSpans;
    private String joinTraceFile;
    protected List<TraceSpan> executeTraceSpans;
    private String executeTraceFile;

    public ReferenceMap getReferenceMap() {
        return this.referenceMap;
    }

    public void setReferenceMap(ReferenceMap referenceMap) {
        this.referenceMap = referenceMap;
    }

    public String getRefSchemaContentFileName() {
        return this.refSchemaContentFileName;
    }

    public void setRefSchemaContentFileName(String refSchemaContentFileName) {
        this.refSchemaContentFileName = refSchemaContentFileName;
    }

    public List<OutsideReference> getOuterRefs() {
        return this.outerRefs;
    }

    public void setOuterRefs(List<OutsideReference> outerRefs) {
        this.outerRefs = outerRefs;
    }

    public List<SchemaObject> getAnalysisSchemaObjects() {
        return this.analysisSchemaObjects;
    }

    public void setAnalysisSchemaObjects(List<SchemaObject> analysisSchemaObjects) {
        this.analysisSchemaObjects = analysisSchemaObjects;
    }

    public List<TraceSpan> getJoinTraceSpans() {
        return this.joinTraceSpans;
    }

    public void setJoinTraceSpans(List<TraceSpan> joinTraceSpans) {
        this.joinTraceSpans = joinTraceSpans;
    }

    public String getJoinTraceFile() {
        return this.joinTraceFile;
    }

    public void setJoinTraceFile(String joinTraceFile) {
        this.joinTraceFile = joinTraceFile;
    }

    public List<TraceSpan> getExecuteTraceSpans() {
        return this.executeTraceSpans;
    }

    public void setExecuteTraceSpans(List<TraceSpan> executeTraceSpans) {
        this.executeTraceSpans = executeTraceSpans;
    }

    public String getExecuteTraceFile() {
        return this.executeTraceFile;
    }

    public void setExecuteTraceFile(String executeTraceFile) {
        this.executeTraceFile = executeTraceFile;
    }

    public Element toXml() {
        Element refElement = new Element("Ref");
        for (Map.Entry entry : this.referenceMap.entrySet()) {
            if (entry.getKey() == null) continue;
            refElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.joinTraceSpans != null && !this.joinTraceSpans.isEmpty()) {
            this.joinTraceFile = UUID.randomUUID().toString() + ".trace";
            refElement.setAttribute("joinTraceFile", this.joinTraceFile);
        }
        if (this.executeTraceSpans != null && !this.executeTraceSpans.isEmpty()) {
            this.executeTraceFile = UUID.randomUUID().toString() + ".trace";
            refElement.setAttribute("executeTraceFile", this.executeTraceFile);
        }
        if (this.outerRefs != null && !this.outerRefs.isEmpty()) {
            Element outsideRefIdsElement = new Element("OutsideRefIds");
            for (OutsideReference outsideReference : this.outerRefs) {
                Element outsideRefIdElement = new Element("OutsideRefId");
                if (outsideReference.getRefToId() != null) {
                    outsideRefIdElement.setAttribute("refToId", outsideReference.getRefToId());
                }
                if (outsideReference.getRefToFullPath() != null) {
                    outsideRefIdElement.setAttribute("fullPath", outsideReference.getRefToFullPath());
                }
                outsideRefIdElement.setAttribute("uid", outsideReference.getUid());
                outsideRefIdsElement.addContent((Content)outsideRefIdElement);
            }
            refElement.addContent((Content)outsideRefIdsElement);
        }
        if (CollectionUtils.isNotEmpty(this.analysisSchemaObjects)) {
            Element analysisSchemaObjectsElement = new Element("AnalysisSchemas");
            for (SchemaObject schemaObject : this.analysisSchemaObjects) {
                analysisSchemaObjectsElement.addContent((Content)schemaObject.toXml());
            }
            refElement.addContent((Content)analysisSchemaObjectsElement);
        }
        return refElement;
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        String traceFilePath;
        if (StringUtils.isNotBlank((CharSequence)this.refSchemaContentFileName) && RefTypeEnum.valueOf((String)this.referenceMap.getRefType()) != RefTypeEnum.picture) {
            String zipFilePath = "schema" + File.separator + this.getDsbRefSchemaContentFileName();
            ImExportUtil.exportFile(zos, this.refSchemaContentFileName, zipFilePath);
        }
        if (this.analysisSchemaObjects != null) {
            for (SchemaObject schemaObj : this.analysisSchemaObjects) {
                schemaObj.exportFile(zos);
            }
        }
        if (this.joinTraceSpans != null && !this.joinTraceSpans.isEmpty()) {
            traceFilePath = "trace" + File.separator + this.joinTraceFile;
            zos.putNextEntry(new ZipEntry(traceFilePath));
            XmlUtil.save((Element)ImExportUtil.traceSpansToXml(this.joinTraceSpans), (OutputStream)zos);
            zos.flush();
        }
        if (this.executeTraceSpans != null && !this.executeTraceSpans.isEmpty()) {
            traceFilePath = "trace" + File.separator + this.executeTraceFile;
            zos.putNextEntry(new ZipEntry(traceFilePath));
            XmlUtil.save((Element)ImExportUtil.traceSpansToXml(this.executeTraceSpans), (OutputStream)zos);
            zos.flush();
        }
    }

    public void fromXml(Element refElement, String type, String version) {
        Element analysisSchemaObjsElement;
        List outsideRefIdElements;
        this.referenceMap = new ReferenceMap();
        List attributeList = refElement.getAttributes();
        for (Attribute attribute : attributeList) {
            this.referenceMap.put((Object)attribute.getName(), (Object)attribute.getValue());
        }
        this.joinTraceFile = refElement.getAttributeValue("joinTraceFile");
        this.executeTraceFile = refElement.getAttributeValue("executeTraceFile");
        Element outsideRefIdsElement = refElement.getChild("OutsideRefIds");
        if (outsideRefIdsElement != null && (outsideRefIdElements = outsideRefIdsElement.getChildren("OutsideRefId")) != null) {
            this.outerRefs = new ArrayList<OutsideReference>(10);
            for (Element outsideRefIdElement : outsideRefIdElements) {
                OutsideReference outsideReference = new OutsideReference();
                outsideReference.setRefToId(outsideRefIdElement.getAttributeValue("refToId"));
                outsideReference.setUid(outsideRefIdElement.getAttributeValue("uid"));
                outsideReference.setRefToFullPath(outsideRefIdElement.getAttributeValue("fullPath"));
                this.outerRefs.add(outsideReference);
            }
        }
        if ((analysisSchemaObjsElement = refElement.getChild("AnalysisSchemas")) != null) {
            this.analysisSchemaObjects = new ArrayList<SchemaObject>(10);
            List schemaElements = analysisSchemaObjsElement.getChildren("Schema");
            for (Element schemaObjElement : schemaElements) {
                SchemaObject schemaObj = new SchemaObject();
                schemaObj.fromXml(schemaObjElement, type, version);
                this.analysisSchemaObjects.add(schemaObj);
            }
        }
        this.refSchemaContentFileName = this.getDsbRefSchemaContentFileName();
    }

    private String getDsbRefSchemaContentFileName() {
        String fId = (String)this.referenceMap.get((Object)"id");
        return fId + ".schema";
    }

    public void endCleanFiles() {
        ImExportUtil.deleteExportFile(this.refSchemaContentFileName);
        if (this.analysisSchemaObjects != null) {
            for (SchemaObject schemaObj : this.analysisSchemaObjects) {
                schemaObj.endCleanFiles();
            }
        }
    }
}

