/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.embeddeddata;

import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataInfo;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataQsInfo;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class EmbeddedDataObject {
    private EmbeddedDataInfo embeddedDataInfo;
    private EmbeddedDataQsInfo embeddedDataQsInfo;
    private List<SchemaObject> schemaObjs;

    public EmbeddedDataInfo getEmbeddedDataInfo() {
        return this.embeddedDataInfo;
    }

    public void setEmbeddedDataInfo(EmbeddedDataInfo embeddedDataInfo) {
        this.embeddedDataInfo = embeddedDataInfo;
    }

    public EmbeddedDataQsInfo getEmbeddedDataQsInfo() {
        return this.embeddedDataQsInfo;
    }

    public void setEmbeddedDataQsInfo(EmbeddedDataQsInfo embeddedDataQsInfo) {
        this.embeddedDataQsInfo = embeddedDataQsInfo;
    }

    public List<SchemaObject> getSchemaObjs() {
        return this.schemaObjs;
    }

    public void setSchemaObjs(List<SchemaObject> schemaObjs) {
        this.schemaObjs = schemaObjs;
    }

    public Element toXml() {
        Element embedDataElement = this.embeddedDataInfo.toXml();
        embedDataElement.addContent((Content)this.embeddedDataQsInfo.toXml());
        if (this.schemaObjs != null && !this.schemaObjs.isEmpty()) {
            Element schemasElement = new Element("Schemas");
            for (SchemaObject schemaObj : this.schemaObjs) {
                schemasElement.addContent((Content)schemaObj.toXml());
            }
            embedDataElement.addContent((Content)schemasElement);
        }
        return embedDataElement;
    }

    public void exportFile(ZipOutputStream zos, boolean hasSchemaExported) throws IOException {
        if (this.schemaObjs != null && !hasSchemaExported) {
            for (SchemaObject schemaObj : this.schemaObjs) {
                schemaObj.exportFile(zos);
            }
        }
        if (this.embeddedDataQsInfo != null) {
            this.embeddedDataQsInfo.exportFile(zos);
        }
    }

    public void fromXml(Element embeddedDataObjElement, String type, String version) {
        this.embeddedDataInfo = new EmbeddedDataInfo();
        this.embeddedDataInfo.fromXml(embeddedDataObjElement, type, version);
        Element schemasElement = embeddedDataObjElement.getChild("Schemas");
        Element qsInfoElement = embeddedDataObjElement.getChild("QsInfo");
        if (qsInfoElement != null) {
            this.embeddedDataQsInfo = new EmbeddedDataQsInfo();
            this.embeddedDataQsInfo.fromXml(qsInfoElement, type, version);
        }
        if (schemasElement != null) {
            this.schemaObjs = new ArrayList<SchemaObject>(10);
            List schemaObjElements = schemasElement.getChildren("Schema");
            for (Element schemaObjElement : schemaObjElements) {
                SchemaObject schemaObj = new SchemaObject();
                schemaObj.fromXml(schemaObjElement, type, version);
                this.schemaObjs.add(schemaObj);
            }
        }
    }

    public void endCleanFiles() {
        if (CollectionUtils.isNotEmpty(this.schemaObjs)) {
            for (SchemaObject schemaObj : this.schemaObjs) {
                schemaObj.endCleanFiles();
            }
        }
        if (this.embeddedDataQsInfo != null) {
            this.embeddedDataQsInfo.endCleanFiles();
        }
    }
}

