/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.publish.dashboard;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.imexport.model.publish.AbstractCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DashboardQsInfo;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbDataModelObject;
import com.kingdee.bos.qing.publish.model.PublishPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class DsbCarryDataInfo
extends AbstractCarryDataInfo {
    private List<DsbDataModelObject> dsbDataModelObjects;
    private DashboardQsInfo dashboardQsInfo;

    public List<DsbDataModelObject> getDsbDataModelObjects() {
        return this.dsbDataModelObjects;
    }

    public void setDsbDataModelObjects(List<DsbDataModelObject> dsbDataModelObjects) {
        this.dsbDataModelObjects = dsbDataModelObjects;
    }

    public DashboardQsInfo getDashboardQsInfo() {
        return this.dashboardQsInfo;
    }

    public void setDashboardQsInfo(DashboardQsInfo dashboardQsInfo) {
        this.dashboardQsInfo = dashboardQsInfo;
    }

    @Override
    public Element toXml(PublishPO publishPO) {
        Element carryDataInfosElement = new Element("CarryDataInfo");
        Element dashboardElement = new Element("Dashboard");
        if (this.dsbDataModelObjects != null && !this.dsbDataModelObjects.isEmpty()) {
            Element dataModelingElement = new Element("DataModeling");
            for (DsbDataModelObject dsbDataModelObject : this.dsbDataModelObjects) {
                dataModelingElement.addContent((Content)dsbDataModelObject.toXml(publishPO.getId()));
            }
            dashboardElement.addContent((Content)dataModelingElement);
        }
        if (this.dashboardQsInfo != null) {
            dashboardElement.addContent((Content)this.dashboardQsInfo.toXml());
        }
        carryDataInfosElement.addContent((Content)dashboardElement);
        return carryDataInfosElement;
    }

    @Override
    public void fromXml(Element xml, String type, String version) throws ModelParseException, IOException, JDOMException {
        Element carryDataInfoElm = xml.getChild("CarryDataInfo");
        if (carryDataInfoElm != null) {
            Element dashboardQsInfoElement;
            List modelElements;
            Element DashboardObjElement = carryDataInfoElm.getChild("Dashboard");
            Element dataModelingElement = DashboardObjElement.getChild("DataModeling");
            if (dataModelingElement != null && (modelElements = dataModelingElement.getChildren("Model")) != null) {
                this.dsbDataModelObjects = new ArrayList<DsbDataModelObject>(modelElements.size());
                for (Element modelElement : modelElements) {
                    DsbDataModelObject dsbDataModelObject = new DsbDataModelObject();
                    dsbDataModelObject.fromXml(modelElement, type, version);
                    this.dsbDataModelObjects.add(dsbDataModelObject);
                }
            }
            if ((dashboardQsInfoElement = DashboardObjElement.getChild("QsInfo")) != null) {
                this.dashboardQsInfo = new DashboardQsInfo();
                this.dashboardQsInfo.fromXml(dashboardQsInfoElement, type, version);
            }
        }
    }

    @Override
    public void exportFile(String publishId, ZipOutputStream zos) throws IOException {
        if (this.dsbDataModelObjects != null && !this.dsbDataModelObjects.isEmpty()) {
            HashSet<String> dmFileNameSet = new HashSet<String>(16);
            for (DsbDataModelObject dsbDataModelObject : this.dsbDataModelObjects) {
                if (dmFileNameSet.contains(dsbDataModelObject.getBoxFileName())) continue;
                dsbDataModelObject.exportBoxFile(zos);
                dmFileNameSet.add(dsbDataModelObject.getBoxFileName());
            }
        }
        if (this.dashboardQsInfo != null) {
            this.dashboardQsInfo.exportFile(zos);
        }
    }

    @Override
    public void endCleanFiles() {
        if (this.dsbDataModelObjects != null && !this.dsbDataModelObjects.isEmpty()) {
            for (DsbDataModelObject dsbDataModelObject : this.dsbDataModelObjects) {
                dsbDataModelObject.endCleanFiles();
            }
        }
        if (this.dashboardQsInfo != null) {
            this.dashboardQsInfo.endCleanFiles();
        }
    }
}

