/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.publish.dashboard;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class DsbDataModelObject {
    private String boxFileName;
    private String refUid;

    public String getBoxFileName() {
        return this.boxFileName;
    }

    public void setBoxFileName(String boxFileName) {
        this.boxFileName = boxFileName;
    }

    public String getRefUid() {
        return this.refUid;
    }

    public void setRefUid(String refUid) {
        this.refUid = refUid;
    }

    public Element toXml(String themeId) {
        Element modelElement = new Element("Model");
        modelElement.setAttribute("file", this.getDmFileName(this.boxFileName));
        modelElement.setAttribute("refUid", this.refUid);
        return modelElement;
    }

    public void fromXml(Element modelElement, String type, String version) throws JDOMException, IOException, ModelParseException {
        this.boxFileName = modelElement.getAttributeValue("file");
        this.refUid = modelElement.getAttributeValue("refUid");
    }

    private String getDmFileName(String dmFileName) {
        return dmFileName + ".dm";
    }

    public void exportBoxFile(ZipOutputStream zos) throws IOException {
        String boxFilePath = "model" + File.separator + this.getDmFileName(this.boxFileName);
        ImExportUtil.exportFile(zos, this.boxFileName, boxFilePath);
    }

    public void endCleanFiles() {
        ImExportUtil.deleteExportFile(this.boxFileName);
    }
}

