/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.service;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.DmDynamicData;
import com.kingdee.bos.qing.data.model.designtime.ModelDecoder;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.Entites;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.model.vo.Sources;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.QHFSourceDomain;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.dm.QHFSource;
import com.kingdee.bos.qing.imexport.service.QHFDMEntityService;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.subject.AbstractSubjectModelingService;
import java.util.Map;

public class AbstractQHFDMService
extends AbstractSubjectModelingService {
    @Override
    public byte[] loadModel(Map<String, String> params) {
        String tag = params.get("tag");
        try {
            QHFDMEntityService service = new QHFDMEntityService(tag);
            DmDynamicData dmDynamicData = service.loadModel();
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dmDynamicData);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getDesigntimeDataObject(Map<String, String> params) {
        try {
            String tag = params.get("tag");
            String associateName = params.get("associateName");
            QHFSource qhfSource = new QHFSource(tag);
            QHFSourceDomain sourceDomain = new QHFSourceDomain();
            DesigntimeDataObject result = sourceDomain.getDesigntimeDataObject(this.qingContext, qhfSource, associateName);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (UnSupportDataSourceException e) {
            return this.exceptionHandler((AbstractQingException)((Object)e));
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)((Object)e));
        }
        catch (AbstractQingIntegratedException e) {
            return this.exceptionHandler((AbstractQingException)((Object)e));
        }
    }

    public byte[] getDataCount(Map<String, String> params) {
        String tag = params.get("tag");
        String arrjsonEntity = params.get("entities");
        String jsonSources = params.get("sources");
        Entites entities = (Entites)ModelDecoder.decode((String)arrjsonEntity, Entites.class);
        Sources sources = (Sources)ModelDecoder.decode((String)jsonSources, Sources.class);
        QHFDMEntityService service = new QHFDMEntityService(tag);
        try {
            long dataCount = service.getDataCount(this.qingContext, entities, sources, null);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dataCount);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)((Object)e));
        }
        catch (AbstractQingIntegratedException e) {
            return this.exceptionHandler((AbstractQingException)((Object)e));
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] getPreviewData(Map<String, String> params) {
        String tag = params.get("tag");
        String arrjsonEntity = params.get("entities");
        String jsonSources = params.get("sources");
        int jsonRows = Integer.parseInt(params.get("topRows"));
        Entites entities = (Entites)ModelDecoder.decode((String)arrjsonEntity, Entites.class);
        Sources sources = (Sources)ModelDecoder.decode((String)jsonSources, Sources.class);
        QHFDMEntityService service = new QHFDMEntityService(tag);
        try {
            PreviewDataModel result = service.getPreviewData(this.qingContext, jsonRows, entities, sources, null);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)((Object)e));
        }
        catch (AbstractQingIntegratedException e) {
            return this.exceptionHandler((AbstractQingException)((Object)e));
        }
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public byte[] saveModel(Map<String, String> params) {
        Box boxModel = (Box)ModelDecoder.decode((String)params.get("model"), Box.class);
        String tag = params.get("tag");
        try {
            QHFDMEntityService service = new QHFDMEntityService(tag);
            Box box = service.saveModel(boxModel);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)box);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] resetModel(Map<String, String> params) {
        String tag = params.get("tag");
        try {
            QHFDMEntityService service = new QHFDMEntityService(tag);
            DmDynamicData dmDynamicData = service.resetModel();
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dmDynamicData);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

