/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.service;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.ExportQHFDomain;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.ImportQHFDomain;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import java.util.Map;

public class QHFService
implements IDBAccessable,
IQingContextable {
    protected QingContext qingContext;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private ExportQHFDomain exportQHFDomain;
    private ImportQHFDomain importQHFDomain;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private ExportQHFDomain getExportQHFDomain() {
        if (this.exportQHFDomain == null) {
            this.exportQHFDomain = new ExportQHFDomain();
            this.exportQHFDomain.setQingContext(this.qingContext);
            this.exportQHFDomain.setDbExcuter(this.dbExcuter);
            this.exportQHFDomain.setTx(this.tx);
        }
        return this.exportQHFDomain;
    }

    private ImportQHFDomain getImportQHFDomain() {
        if (this.importQHFDomain == null) {
            this.importQHFDomain = new ImportQHFDomain();
        }
        return this.importQHFDomain;
    }

    public byte[] doExport(Map<String, String> params) {
        try {
            String fileName = this.getExportQHFDomain().doExport(params);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)fileName);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] doImport(String fileName) {
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getImportQHFDomain().doImport(fileName));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] schemaManage_loadContent(Map<String, String> params) {
        try {
            String tag = params.get("tag");
            String id = params.get("fId");
            String source = params.get("source");
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getImportQHFDomain().loadSchema(tag, id, source));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] schemaManage_loadAttrs(Map<String, String> params) {
        String tag = params.get("tag");
        String source = params.get("source");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getImportQHFDomain().loadSchemaAttrs(tag, source));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadEnvironmentVO(Map<String, String> params) {
        String tag = params.get("tag");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getImportQHFDomain().loadEnvironmentVO(tag));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadEntranceInfo(Map<String, String> params) {
        String tag = params.get("tag");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getImportQHFDomain().loadEntranceInfo(tag));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadDataSourceInfo(Map<String, String> params) {
        String tag = params.get("tag");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getImportQHFDomain().loadDataSourceInfo(tag));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadFileInfo(Map<String, String> params) {
        String tag = params.get("tag");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getImportQHFDomain().loadFileInfo(tag));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadTraceSpanInfo(Map<String, String> params) {
        String tag = params.get("tag");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getImportQHFDomain().loadTraceSpanInfo(tag));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

