/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.export;

import com.kingdee.bos.qing.imexport.model.resource.DBConnInfo;
import com.kingdee.bos.qing.imexport.model.resource.Macro;
import com.kingdee.bos.qing.imexport.model.resource.Resources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class PackageMeta {
    public static final String VERSION = "20210101";
    private static final String TYPE = "macro";
    private Resources resources = new Resources();
    private List<Macro> macros = new ArrayList<Macro>(10);
    private List<DBConnInfo> dbConns = new ArrayList<DBConnInfo>(10);
    private Map<String, DBConnInfo> mapBetweenDBConnAndHashCode = new HashMap<String, DBConnInfo>();

    public void addMacro(Macro macro) {
        this.macros.add(macro);
    }

    public void addDBConn(DBConnInfo dbConn) {
        String sourceHashCode = dbConn.getDbSource().getSourceHashCode();
        if (this.mapBetweenDBConnAndHashCode.get(sourceHashCode) == null) {
            this.dbConns.add(dbConn);
            this.mapBetweenDBConnAndHashCode.put(sourceHashCode, dbConn);
        }
    }

    public Element toXml() {
        this.resources.setMacros(this.macros);
        this.resources.setDBConnInfos(this.dbConns);
        Element metaElement = new Element("Meta");
        metaElement.setAttribute("type", TYPE);
        metaElement.setAttribute("version", VERSION);
        metaElement.addContent((Content)this.resources.toXml());
        return metaElement;
    }
}

