/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.filesystem.manager.fileresource.domain.CleanFileResourceDomain;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.exception.ThemeGroupDuplicateNameException;
import com.kingdee.bos.qing.manage.exception.ThemeGroupNotEmptyException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.domain.ImExportDomain;
import com.kingdee.bos.qing.manage.model.ThemeGroupPO;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.manage.oplog.ManageOpLog;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.preset.domain.PresetManageDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThemeGroupDomain {
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private QingContext qingContext;
    private IScheduleEngine scheduleEngine;
    private IThemeGroupDao themeGroupDao;
    private IThemeDao iThemeDao;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;

    private IThemeGroupDao getThemeGroupDao() {
        if (this.themeGroupDao == null) {
            this.themeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.themeGroupDao;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private IRefHandler getRefHandler(String sThemeType) {
        IRefHandler refHandler;
        RefTypeEnum refType = sThemeType.equals("2") ? RefTypeEnum.programableCard : RefTypeEnum.subject;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new HashMap<RefTypeEnum, IRefHandler>();
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.qingContext, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    public List<ThemeGroupVO> listThemeGroup(String userID) throws AbstractQingIntegratedException, ThemeManagementException {
        try {
            ImExportDomain imExportDomain = new ImExportDomain();
            imExportDomain.setTx(this.tx);
            imExportDomain.setDbExcuter(this.dbExcuter);
            imExportDomain.setQingContext(this.qingContext);
            imExportDomain.importThemeSysPkg(userID);
        }
        catch (Exception e) {
            LogUtil.error((String)"listThemeGroup importThemeSysPkg error", (Throwable)e);
        }
        try {
            PresetManageDomain presetManageDomain = new PresetManageDomain();
            presetManageDomain.setTx(this.tx);
            presetManageDomain.setDbExcuter(this.dbExcuter);
            presetManageDomain.setQingContext(this.qingContext);
            presetManageDomain.setScheduleEngine(this.scheduleEngine);
            presetManageDomain.importFiles();
        }
        catch (Exception e) {
            LogUtil.error((String)"listThemeGroup presetImportFiles error", (Throwable)e);
        }
        try {
            this.notGroupAddDefaultGroup();
        }
        catch (Exception e) {
            LogUtil.error((String)"listThemeGroup notGroupAddDefaultGroup error", (Throwable)e);
        }
        List<ThemeGroupVO> result = null;
        try {
            result = this.getUserVisibleThemeGroups();
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
        try {
            CleanFileResourceDomain cleanFileResourceDomain = new CleanFileResourceDomain(this.qingContext, this.dbExcuter, this.tx);
            cleanFileResourceDomain.asyncCleanTask();
        }
        catch (Exception e) {
            LogUtil.error((String)"listThemeGroup asyncCleanTask error", (Throwable)e);
        }
        return result;
    }

    public List<ThemeGroupVO> listUnpresetThemeGroup() throws AbstractQingIntegratedException, ThemeManagementException {
        List<ThemeGroupVO> themeGroups;
        try {
            themeGroups = this.getThemeGroupDao().listThemeGroup(this.qingContext.getUserId());
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
        return themeGroups;
    }

    public List<ThemeGroupVO> getUserVisibleThemeGroups() throws AbstractQingIntegratedException, SQLException {
        List<ThemeGroupVO> themeGroups = this.getThemeGroupDao().listThemeGroup(this.qingContext.getUserId());
        if (IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter)) {
            List<ThemeGroupVO> presetThemeGroups = this.getThemeGroupDao().listPresetThemeGroup();
            themeGroups.addAll(0, presetThemeGroups);
        }
        return themeGroups;
    }

    public List<ThemeGroupVO> getThemeGroups() throws AbstractQingIntegratedException, SQLException {
        return this.getThemeGroupDao().listThemeGroup(this.qingContext.getUserId());
    }

    private void notGroupAddDefaultGroup() throws AbstractQingIntegratedException, SQLException, ThemeGroupDuplicateNameException {
        List<ThemeGroupVO> userOwnThemeGroups = this.getThemeGroupDao().listThemeGroup(this.qingContext.getUserId());
        if (userOwnThemeGroups == null || userOwnThemeGroups.isEmpty()) {
            Date createTime = new Date();
            String groupName = Messages.getMLS((QingContext)this.qingContext, (String)"defaultGroupName", (String)"\u9ed8\u8ba4\u5206\u7c7b", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
            ThemeGroupPO newThemeGroup = new ThemeGroupPO();
            newThemeGroup.setThemeGroupName(groupName);
            newThemeGroup.setCreateTime(createTime);
            newThemeGroup.setUpdateTime(createTime);
            newThemeGroup.setUserID(this.qingContext.getUserId());
            try {
                this.tx.beginRequired();
                this.getThemeGroupDao().saveThemeGroup(newThemeGroup);
            }
            catch (AbstractQingIntegratedException e) {
                this.tx.markRollback();
                throw e;
            }
            catch (ThemeGroupDuplicateNameException e) {
                this.tx.markRollback();
                throw e;
            }
            catch (SQLException e) {
                this.tx.markRollback();
                throw e;
            }
            finally {
                this.tx.end();
            }
        }
    }

    public String saveOrUpdateThemeGroup(ThemeGroupPO groupPO) throws ThemeGroupDuplicateNameException, AbstractQingIntegratedException, ThemeManagementException {
        boolean isUpdate;
        String themeGroupId;
        String oldThemeGroupName = null;
        try {
            this.tx.beginRequired();
            themeGroupId = groupPO.getThemeGroupID();
            boolean bl = isUpdate = groupPO.getThemeGroupID() != null;
            if (isUpdate) {
                ThemeGroupVO groupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(groupPO.getUserID(), themeGroupId);
                if (groupVO != null) {
                    oldThemeGroupName = groupVO.getThemeGroupName();
                }
                this.getThemeGroupDao().updateThemeGroup(groupPO);
            } else {
                themeGroupId = this.getThemeGroupDao().saveThemeGroup(groupPO);
            }
            if (isUpdate) {
                this.updateDashboardRef(themeGroupId, groupPO);
            }
        }
        catch (ThemeGroupDuplicateNameException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ThemeManagementException(e);
        }
        finally {
            this.tx.end();
        }
        OpLogActionType opLogActionType = isUpdate ? OpLogActionType.EDIT : OpLogActionType.NEW;
        this.addOpLog(opLogActionType, groupPO.getThemeGroupName(), oldThemeGroupName);
        return themeGroupId;
    }

    private void addOpLog(OpLogActionType opLogActionType, String themeGroupName, String oldThemeGroupName) {
        ArrayList<String> params = new ArrayList<String>(2);
        ManageOpLog emptyDir = ManageOpLog.EMPTY_DIR;
        switch (opLogActionType) {
            case DELETE: 
            case NEW: {
                emptyDir.setParamsDesc("\u201c$param\u201d");
                params.add(themeGroupName);
                break;
            }
            case EDIT: {
                emptyDir.setParamsDesc("\u201c$param\u201d\u540d\u79f0\u4e3a\u201c$param\u201d");
                params.add(oldThemeGroupName);
                params.add(themeGroupName);
                break;
            }
        }
        emptyDir.setLogScene("\u8f7b\u5206\u6790\u5206\u7c7b");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(opLogActionType, (IOpLogConstant)emptyDir, params));
    }

    public Integer saveOrderTheme(List<ThemePO> themePOList) throws ThemeManagementException, AbstractQingIntegratedException {
        ILock transactionLock = LockFactory.createLock((String)("QingTransactionLockSaveThemeOrder" + this.qingContext.getAccountId() + this.qingContext.getUserId()));
        boolean succeed = false;
        try {
            succeed = transactionLock.tryLock(30000L);
            if (!succeed) {
                throw new IntegratedRuntimeException("lock QingTransactionLockSaveThemeOrder time out.");
            }
            this.tx.beginRequired();
            for (ThemePO themePO : themePOList) {
                this.getThemeDao().updateThemeForOrder(themePO);
            }
            Integer n = themePOList.size();
            return n;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ThemeManagementException(e);
        }
        catch (QingLockRequireException e) {
            throw new ThemeManagementException(e);
        }
        catch (InterruptedException e) {
            throw new ThemeManagementException(e);
        }
        finally {
            this.tx.end();
            if (succeed) {
                transactionLock.unlock();
            }
        }
    }

    public Integer saveOrderThemeGroup(List<ThemeGroupPO> groupPOList) throws ThemeManagementException, AbstractQingIntegratedException {
        ILock transactionLock = LockFactory.createLock((String)("QingTransactionLockSaveOrderThemeGroup" + this.qingContext.getAccountId() + this.qingContext.getUserId()));
        boolean succeed = false;
        try {
            succeed = transactionLock.tryLock(30000L);
            if (!succeed) {
                throw new IntegratedRuntimeException("lock QingTransactionLockSaveOrderThemeGroup time out.");
            }
            this.tx.beginRequired();
            for (ThemeGroupPO themeGroupPO : groupPOList) {
                this.getThemeGroupDao().updateThemeGroupForOrder(themeGroupPO);
            }
            Integer n = groupPOList.size();
            return n;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ThemeManagementException(e);
        }
        catch (QingLockRequireException e) {
            throw new ThemeManagementException(e);
        }
        catch (InterruptedException e) {
            throw new ThemeManagementException(e);
        }
        finally {
            this.tx.end();
            if (succeed) {
                transactionLock.unlock();
            }
        }
    }

    public boolean deleteThemeGroup(String userID, String groupID) throws ThemeManagementException, AbstractQingIntegratedException {
        List<ThemeVO> themes;
        String groupName = null;
        try {
            themes = this.getThemeDao().listThemesUnionPreset(userID, groupID);
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
        if (themes.isEmpty()) {
            try {
                this.tx.beginRequired();
                ThemeGroupVO groupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(userID, groupID);
                if (groupVO != null) {
                    groupName = groupVO.getThemeGroupName();
                }
                this.getThemeGroupDao().deleteThemeGroup(userID, groupID);
            }
            catch (AbstractQingIntegratedException e) {
                this.tx.markRollback();
                throw e;
            }
            catch (SQLException e) {
                this.tx.markRollback();
                throw new ThemeManagementException(e);
            }
            finally {
                this.tx.end();
            }
        } else {
            throw new ThemeGroupNotEmptyException();
        }
        this.addOpLog(OpLogActionType.DELETE, groupName, null);
        return true;
    }

    public ThemeGroupVO loadThemeGroupByGroupName(String userId, String themeGroupName) throws AbstractQingIntegratedException, SQLException {
        return this.getThemeGroupDao().loadThemeGroupByGroupName(userId, themeGroupName);
    }

    private void updateDashboardRef(String themeGroupId, ThemeGroupPO groupPO) throws AbstractQingIntegratedException, SQLException {
        String userId = this.qingContext.getUserId();
        List<ThemeVO> themeList = this.getThemeDao().listThemesUnionPreset(userId, themeGroupId);
        for (int i = 0; i < themeList.size(); ++i) {
            ThemeVO themeVO = themeList.get(i);
            String fullPath = groupPO.getThemeGroupName() + "/" + themeVO.getThemeName();
            String themeType = themeVO.getThemeType();
            IRefHandler refHandler = this.getRefHandler(themeType);
            ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
            if (switchPathAndIdHandler == null) continue;
            switchPathAndIdHandler.replacePersistentPathToId(fullPath, themeVO.getThemeID(), userId);
        }
    }
}

