/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.resource.domain.IResInfoManagerDomain;
import com.kingdee.bos.qing.resource.exception.ResourceManagementException;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

public class ThemeResInfoManagerDomain
implements IResInfoManagerDomain {
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private IThemeDao iThemeDao;

    public ThemeResInfoManagerDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.dbExcuter = dbExcuter;
        this.qingContext = qingContext;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    public List<FileResourceVO> findResourceFileListByUserId() throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            return this.getThemeDao().findResourceFileListByUserId(this.qingContext.getUserId());
        }
        catch (SQLException e) {
            throw new ResourceManagementException((Throwable)e);
        }
    }

    public List<ScheduleExecuteVO> findScheduleExecuteListByUserId(Date dateMin, Date dateMax) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            return this.getThemeDao().findScheduleExecuteListByUserId(this.qingContext.getUserId(), dateMin, dateMax);
        }
        catch (SQLException e) {
            throw new ResourceManagementException((Throwable)e);
        }
    }
}

