/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.domain.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.impl.SubjectSwitchPathAndIdHandler;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.ModelPersistenceException;
import com.kingdee.bos.qing.data.exception.SubjectDataModelingException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.BizUnionInnerEntityRelations;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.designtime.UnionEntityType;
import com.kingdee.bos.qing.data.model.designtime.source.AbstractBizMetaSource;
import com.kingdee.bos.qing.data.model.designtime.source.FileSource;
import com.kingdee.bos.qing.data.model.designtime.source.IFileSavable;
import com.kingdee.bos.qing.data.model.vo.RecentUsedSources;
import com.kingdee.bos.qing.data.model.vo.Sources;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageLimitException;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.macro.domain.MacroCommonDomain;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeFileParseException;
import com.kingdee.bos.qing.manage.exception.ImportThemeFileSizeLimitException;
import com.kingdee.bos.qing.manage.exception.ThemeFileSizeLimitException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.handler.SubjectManageHandlesFactory;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.domain.SchemaImExportDomain;
import com.kingdee.bos.qing.manage.imexport.model.po.ExportThemeModel;
import com.kingdee.bos.qing.manage.imexport.model.po.subject.ExportSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.ExportFileInfo;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectSchemaImportModel;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.manage.oplog.ManageOpLog;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetImexportDomainFactory;
import com.kingdee.bos.qing.publish.target.lapp.LappDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.AbstractJobParam;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.subject.exception.SubjectFileSizeLimitException;
import com.kingdee.bos.qing.subject.exception.SubjectNotFoundException;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class SubjectManageDomain
extends AbstractThemeManageDomain {
    private SchemaManageDao schemaManageDao;
    private ISubjectDao iSubjectDao;
    private DashboardDao dashboardDao;
    private DashboardPublishDao dashboardPublishDao;
    private SchemaImExportDomain schemaImExportDomain;
    private CommonPublishDomain commonPublishDomain;
    private ThemeDomain themeDomain;
    private LappDomain lappDomain;
    public static final String SUBJECT_SAVE_IMPORT_LOCK_KEY = "subject_save_import_lock_key_";
    private ISwitchPathAndIdHandler switchPathAndIdHandler;

    public SubjectManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private ISubjectDao getSubjectDao() {
        if (this.iSubjectDao == null) {
            this.iSubjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.iSubjectDao;
    }

    private DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private SchemaImExportDomain getSchemaImExportDomain() {
        if (this.schemaImExportDomain == null) {
            this.schemaImExportDomain = new SchemaImExportDomain();
            this.schemaImExportDomain.setDbExcuter(this.dbExcuter);
            this.schemaImExportDomain.setTx(this.tx);
        }
        return this.schemaImExportDomain;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    private ThemeDomain getThemeDomain() {
        if (this.themeDomain == null) {
            this.themeDomain = new ThemeDomain(this.qingContext, this.dbExcuter);
        }
        return this.themeDomain;
    }

    private LappDomain getLappDomain() {
        if (this.lappDomain == null) {
            this.lappDomain = new LappDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.lappDomain;
    }

    private ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new SubjectSwitchPathAndIdHandler(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    public Box loadModel(String userId, String themeID) throws SubjectDataModelingException, AbstractQingIntegratedException, EncryptedLicenseCheckException {
        try {
            return this.getSubjectDao().loadSubjectModelIncludePreset(userId, themeID);
        }
        catch (SQLException e) {
            throw new SubjectDataModelingException((Throwable)e);
        }
    }

    public RecentUsedSources loadUserRecentUsedSourceList(String userId, Sources needexcludeSources, boolean showMoreFlag) throws SubjectDataModelingException, AbstractQingIntegratedException {
        try {
            return this.getSubjectDao().loadUserRecentUsedSourceList(userId, needexcludeSources, showMoreFlag);
        }
        catch (SQLException e) {
            throw new SubjectDataModelingException((Throwable)e);
        }
    }

    public void checkThemeExist(String themeID) throws SubjectDataModelingException, AbstractQingIntegratedException {
        try {
            if (this.getThemeDao().getThemeByID(themeID) == null) {
                throw new SubjectNotFoundException(Messages.getMLS((II18nContext)this.qingContext.getIi18nContext(), (String)"SubjectNotFound", (String)"\u5bf9\u5e94\u4e3b\u9898\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
            }
        }
        catch (SQLException e) {
            throw new SubjectDataModelingException((Throwable)e);
        }
    }

    public Box saveModel(String themeID, Box boxModel) throws AbstractQingIntegratedException, SubjectDataModelingException {
        Box box;
        ThemePO themePO;
        this.checkBoxIllegalBeforeSave(boxModel);
        ILock saveModelLock = LockFactory.createLock((String)(SUBJECT_SAVE_IMPORT_LOCK_KEY + this.qingContext.getAccountId() + themeID));
        boolean succeed = false;
        String userID = this.qingContext.getUserId();
        try {
            themePO = this.getThemeDomain().checkAndReturnOwnTheme(themeID);
        }
        catch (SQLException e) {
            throw new SubjectDataModelingException((Throwable)e);
        }
        ArrayList<IQingFile> saveQingFiles = new ArrayList<IQingFile>();
        try {
            succeed = saveModelLock.tryLock(30000L);
            if (!succeed) {
                throw new IntegratedRuntimeException("lock QingTransactionLockSaveModel time out.");
            }
            this.tx.beginRequired();
            box = this.doSave(userID, themeID, themePO.getThemeName(), boxModel, saveQingFiles, null);
        }
        catch (SubjectDataModelingException e) {
            FileFactory.clearFile(saveQingFiles);
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            FileFactory.clearFile(saveQingFiles);
            this.tx.markRollback();
            throw e;
        }
        catch (QingFileStorageLimitException e) {
            this.tx.markRollback();
            throw new SubjectFileSizeLimitException(e);
        }
        catch (QingLockRequireException e) {
            FileFactory.clearFile(saveQingFiles);
            this.tx.markRollback();
            throw new SubjectDataModelingException((Throwable)e);
        }
        catch (InterruptedException e) {
            FileFactory.clearFile(saveQingFiles);
            this.tx.markRollback();
            throw new SubjectDataModelingException((Throwable)e);
        }
        catch (Exception e) {
            FileFactory.clearFile(saveQingFiles);
            this.tx.markRollback();
            throw new SubjectDataModelingException((Throwable)e);
        }
        finally {
            this.tx.end();
            if (succeed) {
                saveModelLock.unlock();
            }
        }
        this.addOpLog(userID, themePO.getGroupID(), themePO.getThemeName());
        return box;
    }

    private void addOpLog(String userId, String groupId, String themeName) {
        try {
            ThemeGroupVO groupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(userId, groupId);
            ManageOpLog qingAnalysisGroupDir = ManageOpLog.QING_ANALYSIS_GROUP_DIR;
            qingAnalysisGroupDir.setParamsDesc("\u201c$param\u201d\u6570\u636e\u51c6\u5907");
            qingAnalysisGroupDir.setLogScene("\u4e1a\u52a1\u4e3b\u9898");
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(themeName);
            params.add(groupVO.getThemeGroupName());
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)qingAnalysisGroupDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkBoxIllegalBeforeSave(Box box) throws ModelPersistenceException {
        List entities = box.getEntities();
        ArrayList<UnionEntity> bizUnionEntityList = new ArrayList<UnionEntity>(10);
        HashMap<String, AbstractEntity> entityMap = new HashMap<String, AbstractEntity>(10);
        for (Object entity : entities) {
            UnionEntity unionEntity;
            entityMap.put(entity.getName(), (AbstractEntity)entity);
            if (!entity.isUnion() || (unionEntity = (UnionEntity)entity).getUnionType() != UnionEntityType.BIZ) continue;
            bizUnionEntityList.add(unionEntity);
        }
        HashSet<String> topParentNames = new HashSet<String>(10);
        for (UnionEntity bizUnionEntity : bizUnionEntityList) {
            String parentUnionEntityName = bizUnionEntity.getParentName();
            if (null == parentUnionEntityName) continue;
            String topParentName = parentUnionEntityName;
            while (null != parentUnionEntityName) {
                AbstractEntity parent = (AbstractEntity)entityMap.get(parentUnionEntityName);
                topParentName = parentUnionEntityName;
                parentUnionEntityName = parent.getParentName();
            }
            topParentNames.add(topParentName);
        }
        List unionEntityUnitInnerRelations = box.getBizUnionInnerEntityRelations();
        for (String topUnionName : topParentNames) {
            boolean found = false;
            if (null != unionEntityUnitInnerRelations) {
                for (BizUnionInnerEntityRelations ir : unionEntityUnitInnerRelations) {
                    if (!ir.getRootUnionEntityName().equals(topUnionName) || ir.getRelations().size() <= 0) continue;
                    found = true;
                }
            }
            if (found) continue;
            throw new ModelPersistenceException("illegal box model:biz union entity inner relation can not be found,union entity name:" + topUnionName);
        }
    }

    public Box doSave(String userID, String themeID, String themeName, Box boxModel, List<IQingFile> saveQingFiles, InputStream boxOrignalStream) throws ModelParseException, AbstractQingIntegratedException, SQLException, IOException, ScheduleModelParseException, ScheduleEngineException, ThemeManagementException, ModelPersistenceException {
        this.saveSubjectNewUploadDSFile(themeID, boxModel, saveQingFiles);
        InputStream dbStream = this.getSubjectDao().loadSubjectModelStream(userID, themeID);
        Box originalBoxModel = null;
        if (dbStream != null) {
            originalBoxModel = BoxSerializationUtil.toModel(dbStream, true);
        }
        this.clearOldSubjectDSFile(userID, themeID, boxModel, originalBoxModel);
        this.clearAllScheduleFile(themeID);
        this.saveUserRecentUsedSources(userID, boxModel, themeID, saveQingFiles, originalBoxModel);
        this.getSubjectDao().saveSubjectModel(themeID, boxModel, boxOrignalStream);
        this.getThemeDao().updateModifyDate(themeID, userID);
        this.updateMacroReference(themeID, boxModel);
        Schedule schedule = boxModel.getSchedule();
        this.wakenSchedule(schedule, themeID, themeID, themeName, userID);
        SubjectManageHandlesFactory.createHandlers(this.tx, this.dbExcuter, this.qingContext).handleAfterSaveModel(themeID, boxModel, originalBoxModel);
        return boxModel;
    }

    public void clearOldSubjectData(String userId, String subjectId) throws AbstractQingIntegratedException, SQLException, ModelParseException, ScheduleEngineException, EncryptedLicenseCheckException {
        this.clearAllScheduleFile(subjectId);
        Box originBoxModel = this.getSubjectDao().loadSubjectModelIncludePreset(userId, subjectId);
        this.clearAllSubjectDSFile(userId, subjectId, originBoxModel);
        this.clearScheduleJob(subjectId);
        this.getSubjectDao().deleteSubject(subjectId);
        this.deleteUserRecentUsedSources(userId, subjectId, originBoxModel);
    }

    private void updateMacroReference(String themeID, Box boxModel) throws AbstractQingIntegratedException, SQLException {
        MacroCommonDomain macroDomain = new MacroCommonDomain(this.dbExcuter, this.qingContext);
        if (boxModel != null) {
            List macroUids = boxModel.collectMacroUid();
            macroDomain.saveDataModelingRef(themeID, macroUids);
        }
    }

    private void saveUserRecentUsedSources(String userId, Box boxModel, String themeId, List<IQingFile> saveQingFiles, Box originalBoxModel) throws ModelParseException, AbstractQingIntegratedException, SQLException, ThemeManagementException {
        List paramsSources = boxModel.getSources();
        List<AbstractSource> newSourceList = this.getNewSources(paramsSources, originalBoxModel);
        Set<String> haveDeletedSourceSet = this.getHaveDeletedSources(paramsSources, originalBoxModel);
        if (!haveDeletedSourceSet.isEmpty()) {
            this.getSubjectDao().deleteUserRecentUsedSources(haveDeletedSourceSet, userId, themeId);
        }
        if (!newSourceList.isEmpty()) {
            this.copyFileUploadTypeSource(userId, themeId, newSourceList, saveQingFiles);
            this.getSubjectDao().saveUserRecentUsedSource(userId, newSourceList, themeId);
        }
    }

    private List<AbstractSource> getNewSources(List<AbstractSource> paramsSources, Box originalBoxModel) {
        if (paramsSources.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, AbstractSource> orginSourceMap = new HashMap<String, AbstractSource>();
        if (originalBoxModel != null && !originalBoxModel.getSources().isEmpty()) {
            List oldSources = originalBoxModel.getSources();
            for (AbstractSource oldSource : oldSources) {
                orginSourceMap.put(oldSource.getSourceHashCode(), oldSource);
            }
        }
        ArrayList<AbstractSource> newSourceList = new ArrayList<AbstractSource>();
        for (AbstractSource newSource : paramsSources) {
            String newSourceFileUrl;
            String originSourceFileUrl;
            String paramsSourceHashCode = newSource.getSourceHashCode();
            if (paramsSourceHashCode == null || newSource instanceof AbstractBizMetaSource) continue;
            AbstractSource originSource = (AbstractSource)orginSourceMap.get(paramsSourceHashCode);
            if (originSource == null) {
                newSourceList.add(newSource);
                continue;
            }
            if (!(originSource instanceof FileSource) || !(newSource instanceof FileSource) || (originSourceFileUrl = ((FileSource)originSource).getFileUrl()).equals(newSourceFileUrl = ((FileSource)newSource).getFileUrl())) continue;
            newSourceList.add(newSource);
        }
        return newSourceList;
    }

    private Set<String> getHaveDeletedSources(List<AbstractSource> paramsSources, Box originalBoxModel) {
        HashSet<String> deletedSourceCodes = new HashSet<String>();
        if (originalBoxModel == null || originalBoxModel.getSources().isEmpty()) {
            return deletedSourceCodes;
        }
        List originalSources = originalBoxModel.getSources();
        if (paramsSources.isEmpty()) {
            for (AbstractSource deletedSource : originalSources) {
                deletedSourceCodes.add(deletedSource.getSourceHashCode());
            }
            return deletedSourceCodes;
        }
        HashMap<String, AbstractSource> newSourceMap = new HashMap<String, AbstractSource>(16);
        for (AbstractSource newSource : paramsSources) {
            String newSourceCode = newSource.getSourceHashCode();
            if (newSourceCode == null || newSource instanceof AbstractBizMetaSource) continue;
            newSourceMap.put(newSourceCode, newSource);
        }
        for (AbstractSource originalSource : originalSources) {
            String originalSourceFileUrl;
            String newSourceFileUrl;
            String originalSourceCode = originalSource.getSourceHashCode();
            AbstractSource newSource = (AbstractSource)newSourceMap.get(originalSourceCode);
            if (newSource == null) {
                deletedSourceCodes.add(originalSourceCode);
                continue;
            }
            if (!(newSource instanceof FileSource) || !(originalSource instanceof FileSource) || (newSourceFileUrl = ((FileSource)newSource).getFileUrl()).equals(originalSourceFileUrl = ((FileSource)originalSource).getFileUrl())) continue;
            deletedSourceCodes.add(originalSourceCode);
        }
        return deletedSourceCodes;
    }

    private void copyFileUploadTypeSource(String userId, String themeId, List<AbstractSource> newSources, List<IQingFile> saveQingFile) throws ModelParseException, AbstractQingIntegratedException, SQLException, ThemeManagementException {
        for (AbstractSource newSource : newSources) {
            if (!(newSource instanceof IFileSavable)) continue;
            String newPath = ((IFileSavable)newSource).getFileUrl();
            String hashCode = newSource.getSourceHashCode();
            boolean isFromToUserRecentUsedSourceFlag = this.getSubjectDao().getFromToUserRecentUsedSourceFlag(userId, themeId, hashCode, newPath);
            if (!isFromToUserRecentUsedSourceFlag) continue;
            this.copyFile(newSource, themeId, saveQingFile);
        }
    }

    private void clearOldSubjectDSFile(String userID, String themeID, Box newBoxModel, Box originalBoxModel) throws ModelParseException, AbstractQingIntegratedException, SQLException {
        if (null == originalBoxModel) {
            return;
        }
        List oldSources = originalBoxModel.getSources();
        List newSources = newBoxModel.getSources();
        for (AbstractSource oldSource : oldSources) {
            if (!(oldSource instanceof IFileSavable)) continue;
            boolean isDeleteFlag = true;
            String oldPath = ((IFileSavable)oldSource).getFileUrl();
            for (AbstractSource newSource : newSources) {
                String newPath;
                if (!(newSource instanceof IFileSavable) || (newPath = ((IFileSavable)newSource).getFileUrl()) == null || !newPath.equals(oldPath)) continue;
                isDeleteFlag = false;
                break;
            }
            if (!isDeleteFlag) continue;
            IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)oldPath);
            fileUpdater.delete();
        }
    }

    private void saveSubjectNewUploadDSFile(String themeId, Box boxModel, List<IQingFile> saveQingFile) throws IOException {
        List sourceList = boxModel.getSources();
        if (sourceList != null) {
            for (AbstractSource source : sourceList) {
                String displayName = null;
                if (!(source instanceof IFileSavable)) continue;
                String tempFilePathName = ((IFileSavable)source).getFileUrl();
                displayName = ((IFileSavable)source).getFileName();
                IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)tempFilePathName);
                if (file.exists()) continue;
                QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
                resourceInfo.setDisplayName(displayName);
                resourceInfo.setFromId(themeId);
                resourceInfo.setFromType(ResourceFromType.THEME);
                IQingFile qingFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.DATAMODELING_DS);
                IQingFileVisitor fileTemp = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)tempFilePathName);
                if (!fileTemp.exists()) continue;
                FileFactory.copy((IQingFileVisitor)fileTemp, (IQingFile)qingFile, (boolean)true);
                saveQingFile.add(qingFile);
                ((IFileSavable)source).setFileName(displayName);
                ((IFileSavable)source).setFileUrl(qingFile.getName());
            }
        }
    }

    private void wakenSchedule(Schedule schedule, String pkId, String themeID, String themeName, String userID) throws AbstractQingIntegratedException, ScheduleModelParseException, ScheduleEngineException {
        if (this.scheduleEngine != null) {
            String scheduleName = this.scheduleEngine.getScheduleName();
            this.scheduleEngine.deleteJob(this.qingContext, scheduleName, pkId);
            if (schedule != null && schedule.getPeriod() != null) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("JobType", "extractThemeData");
                params.put("themeId", themeID);
                params.put("userId", userID);
                params.put("name", themeName);
                params.put("pkId", pkId);
                AbstractJobParam jobParam = this.scheduleEngine.createJobParam(params);
                this.scheduleEngine.saveJob(this.qingContext, this.qingContext.getUserId(), this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), scheduleName, schedule, jobParam);
            }
        }
    }

    @Override
    protected void doDelete(String userID, ThemeVO themeVO) throws ThemeManagementException, AbstractQingIntegratedException {
        try {
            String themeID = themeVO.getThemeID();
            this.clearAllScheduleFile(themeID);
            Box originBoxModel = this.getSubjectDao().loadSubjectModelIncludePreset(userID, themeID);
            this.clearAllSubjectDSFile(userID, themeID, originBoxModel);
            this.clearScheduleJob(themeID);
            this.deleteUserRecentUsedSources(userID, themeID, originBoxModel);
            this.getSubjectDao().deleteSubject(themeID);
            this.getSchemaManageDao().deleteSchemaByBizTag(themeID);
            this.getLappDomain().updateAllConfigStateByTagId(themeID);
            this.updateDsbFullPath(themeVO.getThemeGroupID(), themeID, themeVO.getThemeName());
            SubjectManageHandlesFactory.createHandlers(this.tx, this.dbExcuter, this.qingContext).handleAfterDeleteTheme(originBoxModel, themeID);
            this.deleteMacroRef(themeID);
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
        catch (ModelParseException e) {
            throw new ThemeManagementException(e);
        }
        catch (ScheduleEngineException e) {
            throw new ThemeManagementException(e);
        }
    }

    private void deleteMacroRef(String themeID) throws AbstractQingIntegratedException, SQLException {
        MacroCommonDomain macroDomain = new MacroCommonDomain(this.dbExcuter, this.qingContext);
        macroDomain.deleteReference(themeID);
    }

    private void deleteUserRecentUsedSources(String userId, String themeId, Box originBoxModel) throws ModelParseException, AbstractQingIntegratedException, SQLException {
        if (originBoxModel == null || originBoxModel.getSources().isEmpty()) {
            return;
        }
        HashSet<String> originSourceSet = new HashSet<String>(16);
        for (AbstractSource originSource : originBoxModel.getSources()) {
            originSourceSet.add(originSource.getSourceHashCode());
        }
        this.getSubjectDao().deleteUserRecentUsedSources(originSourceSet, userId, themeId);
    }

    @Override
    protected void doOverwrite(String themeID) throws AbstractQingIntegratedException, SQLException {
        this.getSchemaManageDao().deleteSchemaByBizTag(themeID);
    }

    @Override
    public void exportTheme(String themeGroupName, String themeGroupFolderPath, ThemeVO themeVo, boolean needPublish, ZipOutputStream zos) throws ExportThemeException, AbstractQingIntegratedException {
        String userID = this.qingContext.getUserId();
        String themeId = themeVo.getThemeID();
        String themeName = themeVo.getThemeName();
        ExportThemeModel themeProperty = new ExportThemeModel();
        themeProperty.setName(themeName);
        themeProperty.setId(themeId);
        themeProperty.setDescription(themeVo.getDescription());
        themeProperty.setThemeType(themeVo.getThemeType());
        String nameSpace = themeVo.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
        themeProperty.setNameSpace(nameSpace);
        String subjectFolderPath = themeGroupFolderPath + File.separator + themeName;
        String modelFileName = themeName + ".qing-datamodeling";
        if (!this.isFileNameAccept(themeName)) {
            String exportThemeFolderUuid = UUID.randomUUID().toString();
            modelFileName = exportThemeFolderUuid + ".qing-datamodeling";
            subjectFolderPath = themeGroupFolderPath + File.separator + exportThemeFolderUuid;
        }
        try {
            Element themePropertyElement = themeProperty.toXml();
            String subjectPropertyPath = subjectFolderPath + File.separator + "qing-theme.xml";
            zos.putNextEntry(new ZipEntry(subjectPropertyPath));
            XmlUtil.save((Element)themePropertyElement, (OutputStream)zos);
            Box exportBox = this.getSubjectDao().loadSubjectModelIncludePreset(userID, themeId);
            if (exportBox != null) {
                String etBoxPath = subjectFolderPath + File.separator + modelFileName;
                Element etBoxElement = exportBox.toXml();
                zos.putNextEntry(new ZipEntry(etBoxPath));
                XmlUtil.save((Element)etBoxElement, (OutputStream)zos);
                this.writeSubjectDataSourceFiles(exportBox, zos);
            }
            String schemaFolder = subjectFolderPath + File.separator + "qing-schema";
            String queryUserId = themeVo.isPreset() ? IntegratedHelper.getPresetUserId() : userID;
            this.getSchemaImExportDomain().exportSchema(queryUserId, themeId, schemaFolder, zos);
            if (needPublish) {
                List publishInfos = this.getCommonPublishDomain().loadPublishInfos(themeVo.getThemeID(), queryUserId);
                for (int i = 0; i < publishInfos.size(); ++i) {
                    PublishPO publishInfo = (PublishPO)publishInfos.get(i);
                    AbstractPublishTargetImexportDomain publishTargetImexportDomain = PublishTargetImexportDomainFactory.createPublishTargetImexportDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine, publishInfo.getPublishTargetType());
                    if (publishTargetImexportDomain == null) continue;
                    publishTargetImexportDomain.doExportPublishInfo(zos, themeGroupName, publishInfo, themeVo, subjectFolderPath);
                }
            }
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExportThemeException(e);
        }
    }

    private void updateDsbRefToIdOfImport(SubjectImportModel exportSubjectCollectModel) throws AbstractQingIntegratedException, ImportThemeException, SQLException {
        IQingFileVisitor zipFile = exportSubjectCollectModel.getZipFile();
        String themePath = exportSubjectCollectModel.getNameSpace() + "/" + exportSubjectCollectModel.getThemePath();
        String themeId = exportSubjectCollectModel.getThemeID();
        Map cacheDsbId = (Map)JsonUtil.decodeFromString((String)QingSessionUtil.get((String)zipFile.getName()), Map.class);
        if (cacheDsbId != null && cacheDsbId.containsKey(themePath)) {
            List dsbIdAndUids = (List)cacheDsbId.get(themePath);
            for (int i = 0; i < dsbIdAndUids.size(); ++i) {
                String[] ids = ((String)dsbIdAndUids.get(i)).split(",");
                this.updateRef(ids, themeId);
            }
            cacheDsbId.remove(themePath);
        }
        String subjectName = exportSubjectCollectModel.getThemeNewName() == null ? exportSubjectCollectModel.getThemeName() : exportSubjectCollectModel.getThemeNewName();
        this.updateDsbRefToId(exportSubjectCollectModel.getThemeGroupId(), themeId, subjectName);
    }

    private void updateRef(String[] ids, String refToId) throws ImportThemeException, AbstractQingIntegratedException {
        block4: {
            String refFromId = ids[0];
            String uid = ids[1];
            ReferenceMap ref = new ReferenceMap();
            ref.setRefToFullPath(null);
            ref.setRefToId(refToId);
            ref.setUid(uid);
            try {
                if ("dsb".equals(ids[2])) {
                    ref.put((Object)"dsbId", (Object)refFromId);
                    this.getDashboardDao().updateRef(ref);
                    break block4;
                }
                if ("publishDsb".equals(ids[2])) {
                    ref.put((Object)"publishId", (Object)refFromId);
                    this.getDashboardPublishDao().updateRef(ref);
                    break block4;
                }
                throw new RuntimeException("do something.");
            }
            catch (SQLException e) {
                throw new ImportThemeException(e);
            }
        }
    }

    private void importSubjectSchema(SubjectImportModel exportSubjectCollectModel) throws AbstractQingIntegratedException, SQLException, IOException {
        String themeId = exportSubjectCollectModel.getThemeID();
        String userID = this.qingContext.getUserId();
        LinkedHashMap<String, SubjectSchemaImportModel> subjectSchemaImportModel = exportSubjectCollectModel.getSchemaImportModels();
        if (subjectSchemaImportModel != null && !subjectSchemaImportModel.isEmpty()) {
            for (Map.Entry<String, SubjectSchemaImportModel> entry : subjectSchemaImportModel.entrySet()) {
                SubjectSchemaImportModel schemaImportModel = subjectSchemaImportModel.get(entry.getKey());
                byte[] content = schemaImportModel.getSchemaContent();
                SchemaBO bo = schemaImportModel.getSchemaBO();
                ExportSchemaProperty exportSchemaProperty = schemaImportModel.getSchemaProperty();
                List<Map<String, String>> outSideRefList = null;
                if (exportSchemaProperty != null) {
                    outSideRefList = exportSchemaProperty.getReference();
                    Set<String> mapPaths = exportSubjectCollectModel.getMapPath();
                    if (outSideRefList != null && outSideRefList.size() > 0) {
                        for (int i = 0; i < outSideRefList.size(); ++i) {
                            Map<String, String> outSideRef = outSideRefList.get(i);
                            String mapPath = outSideRef.get("fullPath");
                            mapPaths.add(mapPath);
                        }
                    }
                }
                bo.setBizTag(themeId);
                bo.setUserId(userID);
                this.getSchemaImExportDomain().importSchema(bo, outSideRefList, content);
            }
        }
    }

    @Override
    protected void doImport(AbstractThemeImportModel exportThemeCollectModel) throws ImportThemeException, AbstractQingIntegratedException {
        SubjectImportModel exportSubjectCollectModel = (SubjectImportModel)exportThemeCollectModel;
        String userID = this.qingContext.getUserId();
        String themeId = exportThemeCollectModel.getThemeID();
        String themeName = exportThemeCollectModel.getThemeName();
        IQingFileVisitor zipFile = exportSubjectCollectModel.getZipFile();
        Box box = exportSubjectCollectModel.getBox();
        if (box != null) {
            ExportFileInfo exportFileInfo = SubjectManageDomain.getSourceFileName(this.qingContext, themeId, themeName, box);
            ArrayList<IQingFile> successImportFiles = new ArrayList<IQingFile>();
            try {
                this.doSave(userID, themeId, themeName, box, successImportFiles, null);
                this.importSubjectSchema(exportSubjectCollectModel);
                this.doImportPublishInfo(exportSubjectCollectModel, successImportFiles);
                this.updateDsbRefToIdOfImport(exportSubjectCollectModel);
                SubjectManageDomain.importThemeFile(exportFileInfo, zipFile, successImportFiles);
            }
            catch (AbstractQingIntegratedException e) {
                FileFactory.clearFile(successImportFiles);
                throw e;
            }
            catch (ImportThemeException e) {
                FileFactory.clearFile(successImportFiles);
                throw e;
            }
            catch (QingFileStorageLimitException e) {
                FileFactory.clearFile(successImportFiles);
                throw new ImportThemeFileSizeLimitException(e);
            }
            catch (Exception e) {
                FileFactory.clearFile(successImportFiles);
                throw new ImportThemeException(e);
            }
        }
    }

    private static ExportFileInfo getSourceFileName(QingContext qingContext, String themeId, String themeName, Box box) {
        ExportFileInfo exportFileInfo = new ExportFileInfo();
        List sources = box.getSources();
        ArrayList<String> originalFileUrls = new ArrayList<String>();
        ArrayList<IQingFile> newFileUrls = new ArrayList<IQingFile>();
        for (AbstractSource source : sources) {
            if (!(source instanceof IFileSavable)) continue;
            String oldFileUrl = ((IFileSavable)source).getFileUrl();
            originalFileUrls.add(oldFileUrl);
            String originalFileName = ((IFileSavable)source).getFileName();
            QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
            resourceInfo.setDisplayName(originalFileName);
            resourceInfo.setFromId(themeId);
            resourceInfo.setFromType(ResourceFromType.THEME);
            IQingFile qingFile = FileFactory.newPersistentFile((QingContext)qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.DATAMODELING_DS);
            ((IFileSavable)source).setFileUrl(qingFile.getName());
            newFileUrls.add(qingFile);
        }
        exportFileInfo.setThemeId(themeId);
        exportFileInfo.setThemeName(themeName);
        exportFileInfo.setOriginalFileUrls(originalFileUrls);
        exportFileInfo.setNewFileUrls(newFileUrls);
        return exportFileInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void importThemeFile(ExportFileInfo exportFileInfo, IQingFileVisitor zipFile, List<IQingFile> successImportFiles) throws ImportThemeFileParseException, ImportThemeFileSizeLimitException {
        QingInputStream in = null;
        ZipInputStream zis = null;
        try {
            in = zipFile.getInputStream();
            zis = new ZipInputStream((InputStream)in);
            ZipEntry zipEntry = null;
            List<String> originalFileUrls = exportFileInfo.getOriginalFileUrls();
            List<IQingFile> newFileUrls = exportFileInfo.getNewFileUrls();
            block5: while ((zipEntry = zis.getNextEntry()) != null) {
                String fileUrl = zipEntry.getName();
                for (int i = 0; i < originalFileUrls.size(); ++i) {
                    String originalFileUrl = originalFileUrls.get(i);
                    if (!fileUrl.equals(originalFileUrl)) continue;
                    IQingFile themeFile = newFileUrls.get(i);
                    themeFile.write((IWriteCall)new CopyWriteCall((InputStream)zis, false), true);
                    successImportFiles.add(themeFile);
                    continue block5;
                }
            }
        }
        catch (QingFileStorageLimitException e) {
            try {
                throw new ImportThemeFileSizeLimitException(e);
                catch (IOException e2) {
                    throw new ImportThemeFileParseException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{in});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
    }

    public void collectScheduleFileAndRecord(String themeID, List<String> dataModelingQSGarbage) throws AbstractQingIntegratedException, SQLException {
        this.getSubjectDao().deleteSubjectDataByThemeId(themeID);
        List<String> filePaths = this.getSubjectDao().findAllDataPath(themeID);
        dataModelingQSGarbage.addAll(filePaths);
        String boxModelFile = this.getSubjectDao().findScheduleBoxFile(themeID);
        if (null != boxModelFile) {
            dataModelingQSGarbage.add(boxModelFile);
        }
    }

    private void clearAllScheduleFile(String themeID) throws AbstractQingIntegratedException, SQLException {
        List<String> filePaths = this.getSubjectDao().findAllDataPath(themeID);
        for (String filePath : filePaths) {
            IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)filePath);
            fileUpdater.delete();
        }
        String boxModelFile = this.getSubjectDao().findScheduleBoxFile(themeID);
        if (null != boxModelFile) {
            IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)boxModelFile);
            fileUpdater.delete();
        }
    }

    private void clearAllSubjectDSFile(String userID, String themeID, Box boxModel) throws ModelParseException, AbstractQingIntegratedException, SQLException {
        if (null == boxModel) {
            return;
        }
        List sources = boxModel.getSources();
        for (AbstractSource source : sources) {
            if (!(source instanceof IFileSavable)) continue;
            String filePath = ((IFileSavable)source).getFileUrl();
            IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)filePath);
            fileUpdater.delete();
        }
    }

    private void clearScheduleJob(String themeID) throws AbstractQingIntegratedException, ScheduleEngineException {
        if (this.scheduleEngine != null) {
            String scheduleName = this.scheduleEngine.getScheduleName();
            this.scheduleEngine.deleteJob(this.qingContext, scheduleName, themeID);
        }
    }

    @Override
    protected void doCopy(Map<String, String> params, String oldId, String newId, ThemePO themePO, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector) throws ThemeManagementException, AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        boolean needSchema = Boolean.parseBoolean(params.get("analysisCase"));
        Box boxModel = null;
        InputStream dbStream = null;
        try {
            dbStream = this.getSubjectDao().loadSubjectModelStream(userId, oldId);
            if (dbStream != null) {
                boxModel = BoxSerializationUtil.toModel(dbStream, true);
            }
            if (needSchema) {
                this.getSchemaManageDao().copySchema(userId, oldId, newId);
            }
        }
        catch (ModelParseException e) {
            throw new ThemeManagementException(e);
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
        if (null != boxModel) {
            List sources = boxModel.getSources();
            ArrayList<IQingFile> saveQingFile = new ArrayList<IQingFile>();
            for (AbstractSource source : sources) {
                this.copyFile(source, newId, saveQingFile);
            }
            QingFileRollback fileRollback = new QingFileRollback(saveQingFile);
            rollbackCollector.add(fileRollback);
            try {
                this.getSubjectDao().saveSubjectModel(newId, boxModel, this.getSubjectDao().loadSubjectModelStream(userId, oldId));
            }
            catch (SQLException e) {
                throw new ThemeManagementException(e);
            }
            catch (ModelPersistenceException e) {
                throw new ThemeManagementException(e);
            }
            Schedule schedule = boxModel.getSchedule();
            if (this.scheduleEngine != null && schedule != null && schedule.getPeriod() != null) {
                String scheduleName = this.scheduleEngine.getScheduleName();
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("JobType", "extractThemeData");
                param.put("pkId", newId);
                param.put("themeId", newId);
                param.put("userId", userId);
                param.put("name", themePO.getThemeName());
                AbstractJobParam jobParam = this.scheduleEngine.createJobParam(param);
                try {
                    this.scheduleEngine.saveJob(this.qingContext, this.qingContext.getUserId(), this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), scheduleName, boxModel.getSchedule(), jobParam);
                }
                catch (ScheduleEngineException e) {
                    throw new ThemeManagementException(e);
                }
                catch (ScheduleModelParseException e) {
                    throw new ThemeManagementException(e);
                }
            }
        }
        this.updateDsbRefToId(themePO.getGroupID(), newId, themePO.getThemeName());
        try {
            this.updateMacroReference(newId, boxModel);
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
    }

    private void copyFile(AbstractSource source, String themeId, List<IQingFile> saveQingFile) throws ThemeManagementException {
        if (source instanceof IFileSavable) {
            String oldFileUrl = ((IFileSavable)source).getFileUrl();
            String fileName = ((IFileSavable)source).getFileName();
            IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)oldFileUrl);
            if (file.exists()) {
                QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
                resourceInfo.setDisplayName(fileName);
                resourceInfo.setFromId(themeId);
                resourceInfo.setFromType(ResourceFromType.THEME);
                IQingFile themeFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.DATAMODELING_DS);
                saveQingFile.add(themeFile);
                try {
                    themeFile.write((IWriteCall)new CopyWriteCall((InputStream)file.getInputStream(), true), true);
                }
                catch (QingFileStorageLimitException e) {
                    throw new ThemeFileSizeLimitException(e);
                }
                catch (IOException e) {
                    throw new ThemeManagementException(e);
                }
                ((IFileSavable)source).setFileUrl(themeFile.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSubjectDataSourceFiles(Box box, ZipOutputStream zos) throws IOException {
        List sources = box.getSources();
        QingInputStream is = null;
        try {
            for (AbstractSource source : sources) {
                String filePath;
                IQingFileVisitor file;
                if (!(source instanceof IFileSavable) || !(file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)(filePath = ((IFileSavable)source).getFileUrl()))).exists()) continue;
                is = file.getInputStream();
                zos.putNextEntry(new ZipEntry(filePath));
                IOUtil.copy((InputStream)is, (OutputStream)zos);
                CloseUtil.close((Closeable[])new Closeable[]{is});
                is = null;
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{is});
            is = null;
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{is});
        is = null;
    }

    public void updateDsbRefToId(String groupId, String themeId, String themeName) throws AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        try {
            ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(userId, groupId);
            if (themeGroupVO != null) {
                String fullPath = themeGroupVO.getThemeGroupName() + "/" + themeName;
                String fullPathWithNameSpace = NameSpace.user.toPersistance() + "/" + fullPath;
                PathModel pathModel = new PathModel();
                pathModel.setNameSpace(NameSpace.user.toPersistance());
                pathModel.setGroupName(themeGroupVO.getThemeGroupName());
                pathModel.setName(themeName);
                ISwitchPathAndIdHandler switchPathAndIdHandler = this.getSwitchPathAndIdHandler();
                switchPathAndIdHandler.replacePersistentPathToId(fullPath, themeId, userId);
                switchPathAndIdHandler.replacePersistentPathToId(fullPathWithNameSpace, themeId, userId);
                switchPathAndIdHandler.replacePersistentPathToId(JsonUtil.encodeToString((Object)pathModel), themeId, userId);
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"fail to load subject group", (Throwable)e);
        }
    }

    private void updateDsbFullPath(String groupId, String themeId, String themeName) throws AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        try {
            ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(userId, groupId);
            if (themeGroupVO != null) {
                PathModel pathModel = new PathModel();
                pathModel.setNameSpace(NameSpace.user.toPersistance());
                pathModel.setGroupName(themeGroupVO.getThemeGroupName());
                pathModel.setName(themeName);
                ISwitchPathAndIdHandler switchPathAndIdHandler = this.getSwitchPathAndIdHandler();
                switchPathAndIdHandler.replacePersistentIdToPath(JsonUtil.encodeToString((Object)pathModel), themeId, userId);
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"fail to load subject group", (Throwable)e);
        }
    }

    @Override
    protected void doSaveOrUpdate(ThemePO themePO) throws AbstractQingIntegratedException {
        this.updateDsbRefToId(themePO.getGroupID(), themePO.getThemeID(), themePO.getThemeName());
    }

    @Override
    protected void doMove(String groupID, String themeID, String themeName) throws AbstractQingIntegratedException {
        this.updateDsbRefToId(groupID, themeID, themeName);
    }

    @Override
    public void collectExportMapModel(ThemeVO themeVo, List<ExportMapModel> exportMapModels, List<String> mapIdList, boolean withPublish) throws AbstractQingIntegratedException, SQLException {
        int source = 1;
        String userId = this.qingContext.getUserId();
        String queryUserId = themeVo.isPreset() ? IntegratedHelper.getPresetUserId() : userId;
        List<OutsideReference> outSideRefList = this.getSchemaDao().loadSchemaRefByTagId(themeVo.getThemeID(), source);
        for (int k = 0; k < outSideRefList.size(); ++k) {
            OutsideReference outSideRef = outSideRefList.get(k);
            String mapId = outSideRef.getRefToId();
            if (mapIdList.indexOf(mapId) != -1) continue;
            ExportMapModel exportMapModel = this.getMapManageDao().loadMapWithGroupName(mapId);
            if (exportMapModel != null) {
                exportMapModels.add(exportMapModel);
            }
            mapIdList.add(mapId);
        }
        if (withPublish) {
            List publishInfos = this.getPublishInfoDao().loadPublishInfos(themeVo.getThemeID(), 5, queryUserId);
            for (int t = 0; t < publishInfos.size(); ++t) {
                PublishPO publishPO = (PublishPO)publishInfos.get(t);
                String schemaId = publishPO.getSchemaId();
                List<OutsideReference> outSidePublishRefList = this.getSchemaDao().loadSchemaRef(schemaId);
                for (int g = 0; g < outSidePublishRefList.size(); ++g) {
                    OutsideReference outSideRef = outSidePublishRefList.get(g);
                    String mapId = outSideRef.getRefToId();
                    if (mapIdList.indexOf(mapId) != -1) continue;
                    ExportMapModel exportMapModel = this.getMapManageDao().loadMapWithGroupName(mapId);
                    if (exportMapModel != null) {
                        exportMapModels.add(exportMapModel);
                    }
                    mapIdList.add(mapId);
                }
            }
        }
    }

    @Override
    public void updateMapRef(Map<String, String> importMapId, String subjectId) throws AbstractQingIntegratedException, SQLException {
        String refType = "0";
        try {
            this.tx.beginRequired();
            String userId = this.qingContext.getUserId();
            int source = 1;
            ArrayList<SchemaBO> schemaBoList = this.getSchemaManageDao().loadSchemaAttrs(subjectId, userId, source);
            for (int i = 0; i < schemaBoList.size(); ++i) {
                SchemaBO schemaBO = schemaBoList.get(i);
                String schemaId = schemaBO.getfId();
                Map<String, OutsideReference> outSideRefList = this.getSchemaManageDao().loadSchemaRefWithFId(schemaId, refType);
                for (Map.Entry<String, OutsideReference> entry : outSideRefList.entrySet()) {
                    OutsideReference outSideRef = outSideRefList.get(entry.getKey());
                    String mapId = importMapId.get(outSideRef.getRefToFullPath());
                    if (mapId != null) {
                        this.getSchemaManageDao().updateSchemaRef(mapId, entry.getKey());
                        continue;
                    }
                    String fullPath = outSideRef.getRefToFullPath();
                    if (StringUtils.isBlank((CharSequence)fullPath)) continue;
                    String[] path = fullPath.split("/");
                    String nameSpace = ImportUtil.getNameSpaceCode(path[0]);
                    String mapGroupName = path[1];
                    String mapName = path[2];
                    ExportMapModel exportMapModel = this.getMapManageDao().loadMapByNameAndGroupName(mapGroupName, mapName, nameSpace);
                    if (exportMapModel == null) continue;
                    mapId = exportMapModel.getMapId();
                    this.getSchemaManageDao().updateSchemaRef(mapId, entry.getKey());
                }
            }
            List publishPOs = this.getPublishInfoDao().loadPublishInfos(subjectId, 5, userId);
            for (int i = 0; i < publishPOs.size(); ++i) {
                PublishPO publishPO = (PublishPO)publishPOs.get(i);
                String schemaId = publishPO.getSchemaId();
                Map<String, OutsideReference> outSideRefList = this.getSchemaManageDao().loadSchemaRefWithFId(schemaId, refType);
                for (Map.Entry<String, OutsideReference> entry : outSideRefList.entrySet()) {
                    OutsideReference outSideRef = outSideRefList.get(entry.getKey());
                    String mapId = importMapId.get(outSideRef.getRefToFullPath());
                    if (mapId != null) {
                        this.getSchemaManageDao().updateSchemaRef(mapId, entry.getKey());
                        continue;
                    }
                    String fullPath = outSideRef.getRefToFullPath();
                    if (StringUtils.isBlank((CharSequence)fullPath)) continue;
                    String[] path = fullPath.split("/");
                    String nameSpace = ImportUtil.getNameSpaceCode(path[0]);
                    String mapGroupName = path[1];
                    String mapName = path[2];
                    ExportMapModel exportMapModel = this.getMapManageDao().loadMapByNameAndGroupName(mapGroupName, mapName, nameSpace);
                    if (exportMapModel == null) continue;
                    mapId = exportMapModel.getMapId();
                    this.getSchemaManageDao().updateSchemaRef(mapId, entry.getKey());
                }
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public List<ThemePO> getThemeList(Set<String> themeIds) throws AbstractQingIntegratedException, SQLException {
        return this.getThemeDao().getThemeList(themeIds);
    }

    public int getFileSize(String fileUrl) throws IOException {
        try {
            IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileUrl);
            if (!file.exists()) {
                file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)fileUrl);
            }
            if (file.exists()) {
                return (int)file.getLength();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return 0;
    }

    public String downloadFile(String fileUrl) throws IOException {
        String string;
        IQingFileWriter fileWriter = null;
        IQingFile exportFile = null;
        QingOutputStream fos = null;
        Exception exception = null;
        try {
            exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
            fileWriter = exportFile.createWriter();
            fos = fileWriter.getOutputStream();
            this.doDownloadFile(fileUrl, (OutputStream)fos);
            string = exportFile.getName();
        }
        catch (Exception e) {
            try {
                exception = e;
                FileFactory.clearFile((IQingFile)exportFile);
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fos});
                if (fileWriter != null) {
                    fileWriter.close(exception);
                    fileWriter = null;
                }
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fos});
        if (fileWriter != null) {
            fileWriter.close(exception);
            fileWriter = null;
        }
        return string;
    }

    public void doDownloadFile(String fileUrl, OutputStream fos) throws IOException {
        QingInputStream fis = null;
        try {
            IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileUrl);
            if (!file.exists()) {
                file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)fileUrl);
            }
            if (file.exists()) {
                int len;
                fis = file.getInputStream();
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) > -1) {
                    fos.write(buffer, 0, len);
                }
                fos.flush();
            }
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
    }

    private static class QingFileRollback
    implements AbstractThemeManageDomain.IFileRollback {
        private List<IQingFile> saveQingFiles;

        public QingFileRollback(List<IQingFile> saveQingFiles) {
            this.saveQingFiles = saveQingFiles;
        }

        @Override
        public void rollback() {
            FileFactory.clearFile(this.saveQingFiles);
        }
    }
}

