/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.handler.convertQSHandler.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.file.qs.QSFileWriteException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.designtime.source.FileSource;
import com.kingdee.bos.qing.data.model.runtime.ISubjectEntityExtractDataCallBack;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.Sources;
import com.kingdee.bos.qing.data.service.EntityDataServiceFactory;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.manage.dao.IEntityQSFileDao;
import com.kingdee.bos.qing.manage.dao.impl.EntityQSFileDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.model.ConvertQSEntityInfo;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.model.ConvertStateEnum;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.model.EntityFileSourceTypeEnum;
import com.kingdee.bos.qing.manage.model.EntityQSFilePO;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ConvertQSHandleDomain
implements ISubjectEntityExtractDataCallBack {
    private IEntityQSFileDao iEntityQSFileDao;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private QingContext qingContext;
    private ISubjectDao iSubjectDao;

    public ConvertQSHandleDomain(IDBExcuter dbExcuter, ITransactionManagement tx, QingContext qingContext) {
        this.dbExcuter = dbExcuter;
        this.tx = tx;
        this.qingContext = qingContext;
    }

    private IEntityQSFileDao getEntityFileDao() {
        if (this.iEntityQSFileDao == null) {
            this.iEntityQSFileDao = new EntityQSFileDaoImpl(this.dbExcuter);
        }
        return this.iEntityQSFileDao;
    }

    private ISubjectDao getSubjectDao() {
        if (this.iSubjectDao == null) {
            this.iSubjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.iSubjectDao;
    }

    public void deleteQSFile(ConvertQSEntityInfo convertQSEntityInfo) throws QingLockRequireException, InterruptedException, AbstractQingIntegratedException, SQLException {
        this.deleteStateDoubleCheck(convertQSEntityInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteStateDoubleCheck(ConvertQSEntityInfo convertQSEntityInfo) throws QingLockRequireException, InterruptedException, AbstractQingIntegratedException, SQLException {
        block5: {
            String themeId = convertQSEntityInfo.getThemeId();
            String entityUniqueInfoSetCacheKey = this.createEntityUniqueInfoSetCacheKey(themeId);
            ILock lock = LockFactory.createLock((String)entityUniqueInfoSetCacheKey);
            try {
                lock.lock();
                IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
                String s = globalQingSession.get(entityUniqueInfoSetCacheKey);
                if (!StringUtils.isNotBlank((CharSequence)s)) break block5;
                Set convertQSEntityInfoSet = (Set)JsonUtil.decodeFromString((String)s, HashSet.class);
                Iterator iterator = convertQSEntityInfoSet.iterator();
                while (iterator.hasNext()) {
                    String convertQSEntityInfoJson = (String)iterator.next();
                    ConvertQSEntityInfo convertQSEntityInfoFromJson = (ConvertQSEntityInfo)JsonUtil.decodeFromString((String)convertQSEntityInfoJson, ConvertQSEntityInfo.class);
                    if (!convertQSEntityInfoFromJson.getFileUrl().equals(convertQSEntityInfo.getFileUrl()) || !convertQSEntityInfoFromJson.getEntityName().equals(convertQSEntityInfo.getEntityName())) continue;
                    if (convertQSEntityInfoFromJson.getConvertState() == ConvertStateEnum.DELETE) {
                        EntityQSFilePO entityFile = this.getEntityFileDao().getEntityFile(convertQSEntityInfo.getFileUrl(), convertQSEntityInfo.getEntityName());
                        this.deleteDBAndQSFile(entityFile);
                    }
                    iterator.remove();
                    this.addConvertQSEntityInfoSetToCache(globalQingSession, entityUniqueInfoSetCacheKey, convertQSEntityInfoSet);
                    break;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public String createEntityUniqueInfoSetCacheKey(String themeId) {
        return "Qing.Convert.QS.entity_unique_key_set_" + themeId;
    }

    public void createQSFile(ConvertQSEntityInfo convertQSEntityInfo) throws AbstractQingIntegratedException, SQLException, QingLockRequireException, InterruptedException, ModelParseException, EncryptedLicenseCheckException {
        EntityQSFilePO entityFile = this.getEntityFileDao().getEntityFile(convertQSEntityInfo.getFileUrl(), convertQSEntityInfo.getEntityName());
        if (entityFile != null) {
            this.addStateDoubleCheck(convertQSEntityInfo, entityFile);
        } else {
            Map<AbstractSource, Entity> sourceEntityMap = this.getNeedHandleEntity(convertQSEntityInfo);
            if (MapUtils.isNotEmpty(sourceEntityMap) && sourceEntityMap != null) {
                for (Map.Entry<AbstractSource, Entity> entry : sourceEntityMap.entrySet()) {
                    this.doCreateQSFile(entry.getValue(), entry.getKey(), convertQSEntityInfo);
                }
            } else {
                this.removeConvertingQSFlagFromCache(convertQSEntityInfo.getThemeId(), convertQSEntityInfo.getFileUrl(), convertQSEntityInfo.getEntityName());
            }
        }
    }

    private Map<AbstractSource, Entity> getNeedHandleEntity(ConvertQSEntityInfo convertQSEntityInfo) throws AbstractQingIntegratedException, SQLException, ModelParseException, EncryptedLicenseCheckException {
        Map<AbstractSource, List<Entity>> handleEntityMap;
        Box box = this.getSubjectDao().loadSubjectModelIncludePreset(this.qingContext.getUserId(), convertQSEntityInfo.getThemeId());
        if (box != null && MapUtils.isNotEmpty(handleEntityMap = this.getHandleEntityMap(box))) {
            for (Map.Entry<AbstractSource, List<Entity>> entry : handleEntityMap.entrySet()) {
                FileSource fileSource = (FileSource)entry.getKey();
                if (!fileSource.getFileUrl().equals(convertQSEntityInfo.getFileUrl())) continue;
                List<Entity> entityList = entry.getValue();
                for (Entity entity : entityList) {
                    if (!entity.getName().equals(convertQSEntityInfo.getEntityName())) continue;
                    HashMap<AbstractSource, Entity> resultMap = new HashMap<AbstractSource, Entity>();
                    resultMap.put(entry.getKey(), entity);
                    return resultMap;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStateDoubleCheck(ConvertQSEntityInfo convertQSEntityInfo, EntityQSFilePO entityFile) throws QingLockRequireException, InterruptedException, AbstractQingIntegratedException, SQLException {
        block7: {
            String themeId = convertQSEntityInfo.getThemeId();
            String entityUniqueInfoSetCacheKey = this.createEntityUniqueInfoSetCacheKey(themeId);
            ILock lock = LockFactory.createLock((String)entityUniqueInfoSetCacheKey);
            try {
                lock.lock();
                IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
                String cacheValue = globalQingSession.get(entityUniqueInfoSetCacheKey);
                if (!StringUtils.isNotBlank((CharSequence)cacheValue)) break block7;
                Set convertQSEntityInfoSet = (Set)JsonUtil.decodeFromString((String)cacheValue, HashSet.class);
                Iterator iterator = convertQSEntityInfoSet.iterator();
                while (iterator.hasNext()) {
                    String convertQSEntityInfoJson = (String)iterator.next();
                    ConvertQSEntityInfo convertQSEntityInfoFromJson = (ConvertQSEntityInfo)JsonUtil.decodeFromString((String)convertQSEntityInfoJson, ConvertQSEntityInfo.class);
                    if (!convertQSEntityInfoFromJson.getFileUrl().equals(convertQSEntityInfo.getFileUrl()) || !convertQSEntityInfoFromJson.getEntityName().equals(convertQSEntityInfo.getEntityName())) continue;
                    if (convertQSEntityInfoFromJson.getConvertState() == ConvertStateEnum.DELETE) {
                        this.deleteDBAndQSFile(entityFile);
                    } else if (StringUtils.isBlank((CharSequence)entityFile.getId())) {
                        this.doInsertQSFileRecordToDb(entityFile);
                    }
                    iterator.remove();
                    this.addConvertQSEntityInfoSetToCache(globalQingSession, entityUniqueInfoSetCacheKey, convertQSEntityInfoSet);
                    break;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void addConvertQSEntityInfoSetToCache(IGlobalQingSession globalQingSession, String setUniqueKey, Set<String> linkedHashSet) {
        globalQingSession.set(setUniqueKey, JsonUtil.encodeToString(linkedHashSet), 30, TimeUnit.MINUTES);
    }

    private void deleteDBAndQSFile(EntityQSFilePO entityFile) throws AbstractQingIntegratedException, SQLException {
        if (entityFile != null && StringUtils.isNotBlank((CharSequence)entityFile.getId())) {
            this.doDeleteDBAndQSFile(entityFile);
        } else {
            this.doDeleteQSFile(entityFile);
        }
    }

    private void doInsertQSFileRecordToDb(EntityQSFilePO entityFile) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            this.getEntityFileDao().insert(entityFile);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            this.doDeleteQSFile(entityFile);
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            this.doDeleteQSFile(entityFile);
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private void doDeleteDBAndQSFile(EntityQSFilePO entityFile) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            this.getEntityFileDao().deleteById(entityFile.getId());
            this.doDeleteQSFile(entityFile);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private void doDeleteQSFile(EntityQSFilePO entityQSFilePO) {
        if (null != entityQSFilePO) {
            IQingFileUpdater qsFile = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)entityQSFilePO.getQsFileName());
            FileFactory.clearFile((IQingFile)((IQingFile)qsFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateQSFile(Entity sourceEntity, AbstractSource source, ConvertQSEntityInfo convertQSEntityInfo) throws QingLockRequireException, InterruptedException {
        QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
        resourceInfo.setDisplayName(sourceEntity.getAlias());
        resourceInfo.setFromId(convertQSEntityInfo.getThemeId());
        resourceInfo.setFromType(ResourceFromType.THEMESOURCECONVERT);
        IQingFile dataFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.DATAMODELING_QS);
        try {
            this.tx.beginRequired();
            HashMap<String, Entity> entityNamesMap = new HashMap<String, Entity>();
            entityNamesMap.put(sourceEntity.getName(), sourceEntity);
            HashMap<String, AbstractSource> sourcesMap = new HashMap<String, AbstractSource>();
            sourcesMap.put(sourceEntity.getSource(), source);
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain((AbstractSource)source);
            DesigntimeDataObject designtimeDataObject = sourceDomain.getDesigntimeDataObject(this.qingContext, source, sourceEntity.getAssociateName());
            sourceEntity = this.getSourceEntity(designtimeDataObject, sourceEntity);
            EntityExtractContext context = new EntityExtractContext();
            context.setDataFile(dataFile);
            context.setEntityNamesMap(entityNamesMap);
            context.setSourcesMap(sourcesMap);
            context.setRelations(new ArrayList());
            context.setQingContext(this.qingContext);
            context.setCallBackFunction(null);
            context.setOwnerId(this.qingContext.getUserId());
            EntityDataServiceFactory.newDataService((AbstractEntity)sourceEntity).extractEntityData(context);
            FileSource fileSource = (FileSource)sourcesMap.get(sourceEntity.getSource());
            EntityQSFilePO entityQSFilePO = new EntityQSFilePO();
            entityQSFilePO.setOriginalFileName(fileSource.getFileUrl());
            entityQSFilePO.setOriginalFileType(QingPersistentFileType.DATAMODELING_DS.getSubFolder());
            entityQSFilePO.setOriginalEntityName(sourceEntity.getName());
            entityQSFilePO.setSourceId(convertQSEntityInfo.getThemeId());
            entityQSFilePO.setSourceType(EntityFileSourceTypeEnum.THEME.getSourceType());
            entityQSFilePO.setQsFileName(dataFile.getName());
            entityQSFilePO.setQsFileType(QingPersistentFileType.DATAMODELING_QS.getSubFolder());
            this.addStateDoubleCheck(convertQSEntityInfo, entityQSFilePO);
        }
        catch (Exception e) {
            LogUtil.error((String)"create file source qs file error", (Throwable)e);
            FileFactory.clearFile((IQingFile)dataFile);
            this.removeConvertingQSFlagFromCache(convertQSEntityInfo.getThemeId(), convertQSEntityInfo.getFileUrl(), convertQSEntityInfo.getEntityName());
            this.tx.markRollback();
        }
        finally {
            this.tx.end();
        }
    }

    public String getEntityUniqueKey(AbstractSource source, Entity entity) {
        FileSource fileSource = (FileSource)source;
        return this.createEntityUniqueCacheKey(fileSource.getFileUrl(), entity.getName());
    }

    public String createEntityUniqueCacheKey(String fileUrl, String entityName) {
        return "Qing.Convert.QS.lock_writing_qs_file_" + fileUrl + "_" + entityName;
    }

    public Object getQSFileWriterOrVisitor(QingContext qingContext, AbstractSource source, Entity entity, String fromId, EntityExtractContext entityExtractContext) throws AbstractQingIntegratedException, SQLException {
        FileSource fileSource = (FileSource)source;
        EntityQSFilePO entityFile = this.getEntityFileDao().getEntityFile(fileSource.getFileUrl(), entity.getName());
        if (entityFile == null) {
            QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
            resourceInfo.setDisplayName(entity.getAlias());
            resourceInfo.setFromId(fromId);
            resourceInfo.setFromType(ResourceFromType.THEMESOURCECONVERT);
            IQingFile persistenceDataFile = FileFactory.newPersistentFile((QingContext)qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.DATAMODELING_QS);
            QSDataSourceWriter dataSourcePersistentWriter = new QSDataSourceWriter(persistenceDataFile);
            entityExtractContext.putWriteQingFile(entity, persistenceDataFile);
            return dataSourcePersistentWriter;
        }
        return FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)entityFile.getQsFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQSFile(QingContext qingContext, IQingFile writeQingFile, AbstractSource source, Entity entity, String themeId) {
        FileSource fileSource = (FileSource)source;
        String name = writeQingFile.getName();
        if (StringUtils.isNotBlank((CharSequence)name) && source != null) {
            try {
                this.tx.beginRequired();
                EntityQSFilePO entityQSFilePO = new EntityQSFilePO();
                entityQSFilePO.setOriginalFileName(fileSource.getFileUrl());
                entityQSFilePO.setOriginalFileType(QingPersistentFileType.DATAMODELING_DS.getSubFolder());
                entityQSFilePO.setOriginalEntityName(entity.getName());
                entityQSFilePO.setQsFileType(QingPersistentFileType.DATAMODELING_QS.getSubFolder());
                entityQSFilePO.setQsFileName(name);
                entityQSFilePO.setSourceId(themeId);
                entityQSFilePO.setSourceType(EntityFileSourceTypeEnum.THEME.getSourceType());
                ConvertQSEntityInfo convertQSEntityInfo = new ConvertQSEntityInfo();
                convertQSEntityInfo.setEntityName(entity.getName());
                convertQSEntityInfo.setFileUrl(((FileSource)source).getFileUrl());
                convertQSEntityInfo.setThemeId(themeId);
                convertQSEntityInfo.setSubmitHandle(true);
                convertQSEntityInfo.setConvertState(ConvertStateEnum.ADD);
                this.addStateDoubleCheck(convertQSEntityInfo, entityQSFilePO);
            }
            catch (Exception e) {
                LogUtil.error((String)"entityQSFile insert db error", (Throwable)e);
                IQingFileUpdater qsFile = FileFactory.newFileUpdater((QingContext)qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)name);
                FileFactory.clearFile((IQingFile)((IQingFile)qsFile));
                this.tx.markRollback();
            }
            finally {
                this.tx.end();
            }
        }
    }

    public Entity getSourceEntity(DesigntimeDataObject designtimeDataObject, Entity entity) {
        List entities = designtimeDataObject.getEntities();
        Entity entityFromSource = null;
        for (Entity sourceEntity : entities) {
            if (!sourceEntity.getAssociateName().equals(entity.getAssociateName())) continue;
            sourceEntity.setName(entity.getName());
            entityFromSource = sourceEntity;
            break;
        }
        return entityFromSource;
    }

    public void setConvertingQSFlagToCache(String themeId, String fileUrl, String entityName) throws QingLockRequireException, InterruptedException {
        HashMap<String, ConvertQSEntityInfo> convertQSEntityInfoSet = new HashMap<String, ConvertQSEntityInfo>();
        ConvertQSEntityInfo convertQSEntityInfo = new ConvertQSEntityInfo();
        convertQSEntityInfo.setSubmitHandle(true);
        convertQSEntityInfo.setConvertState(ConvertStateEnum.ADD);
        convertQSEntityInfo.setFileUrl(fileUrl);
        convertQSEntityInfo.setEntityName(entityName);
        convertQSEntityInfoSet.put(this.createEntityUniqueCacheKey(fileUrl, entityName), convertQSEntityInfo);
        this.addEntityUniqueKeyToCacheSet(convertQSEntityInfoSet, themeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConvertingQSFlagFromCache(String themeId, String fileUrl, String entityName) throws QingLockRequireException, InterruptedException {
        block4: {
            String entityUniqueInfoSetCacheKey = this.createEntityUniqueInfoSetCacheKey(themeId);
            ILock lock = LockFactory.createLock((String)entityUniqueInfoSetCacheKey);
            try {
                lock.lock();
                IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
                String s = globalQingSession.get(entityUniqueInfoSetCacheKey);
                if (!StringUtils.isNotBlank((CharSequence)s)) break block4;
                Set convertQSEntityInfoSet = (Set)JsonUtil.decodeFromString((String)s, HashSet.class);
                Iterator iterator = convertQSEntityInfoSet.iterator();
                while (iterator.hasNext()) {
                    String convertQSEntityInfoJson = (String)iterator.next();
                    ConvertQSEntityInfo convertQSEntityInfoFromJson = (ConvertQSEntityInfo)JsonUtil.decodeFromString((String)convertQSEntityInfoJson, ConvertQSEntityInfo.class);
                    if (!convertQSEntityInfoFromJson.getFileUrl().equals(fileUrl) || !convertQSEntityInfoFromJson.getEntityName().equals(entityName)) continue;
                    iterator.remove();
                    this.addConvertQSEntityInfoSetToCache(globalQingSession, entityUniqueInfoSetCacheKey, convertQSEntityInfoSet);
                    break;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void initReadQingFileVisitor(AbstractEntity abstractEntity, EntityExtractContext context) throws QSFileWriteException {
        try {
            Map sourcesMap = context.getSourcesMap();
            Sources sources = new Sources();
            ArrayList sourceList = new ArrayList(sourcesMap.size());
            for (Map.Entry entry : sourcesMap.entrySet()) {
                sourceList.add(entry.getValue());
            }
            sources.setSources(sourceList);
            Map<Entity, IQingFileVisitor> qingFileVisitorMap = this.getQingFileVisitorMap(abstractEntity, sources);
            context.setReadQingFileMap(qingFileVisitorMap);
        }
        catch (Exception e) {
            throw new QSFileWriteException((Throwable)e);
        }
    }

    public void addEntityUniqueKeyToCacheSet(Map<String, ConvertQSEntityInfo> convertQSEntityInfoMap, String themeId) throws InterruptedException, QingLockRequireException {
        if (MapUtils.isEmpty(convertQSEntityInfoMap)) {
            return;
        }
        String entityUniqueInfoSetCacheKey = this.createEntityUniqueInfoSetCacheKey(themeId);
        ILock lock = LockFactory.createLock((String)entityUniqueInfoSetCacheKey);
        try {
            lock.lock();
            IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
            String s = globalQingSession.get(entityUniqueInfoSetCacheKey);
            Set convertQSEntityInfoCacheSet = StringUtils.isBlank((CharSequence)s) ? new HashSet() : (Set)JsonUtil.decodeFromString((String)s, HashSet.class);
            Iterator iterator = convertQSEntityInfoCacheSet.iterator();
            HashSet<String> newAddOrUpdateSet = new HashSet<String>(16);
            while (iterator.hasNext()) {
                String convertQSEntityInfoCacheValue = (String)iterator.next();
                ConvertQSEntityInfo convertQSEntityInfoFromJson = (ConvertQSEntityInfo)JsonUtil.decodeFromString((String)convertQSEntityInfoCacheValue, ConvertQSEntityInfo.class);
                String entityUniqueCacheKey = this.createEntityUniqueCacheKey(convertQSEntityInfoFromJson.getFileUrl(), convertQSEntityInfoFromJson.getEntityName());
                ConvertQSEntityInfo convertQSEntityInfo = convertQSEntityInfoMap.get(entityUniqueCacheKey);
                if (convertQSEntityInfo == null) continue;
                if (convertQSEntityInfoFromJson.getFileUrl().equals(convertQSEntityInfo.getFileUrl()) && convertQSEntityInfoFromJson.getEntityName().equals(convertQSEntityInfo.getEntityName()) && convertQSEntityInfoFromJson.getConvertState() != convertQSEntityInfo.getConvertState()) {
                    iterator.remove();
                    convertQSEntityInfoFromJson.setConvertState(convertQSEntityInfo.getConvertState());
                    newAddOrUpdateSet.add(JsonUtil.encodeToString((Object)convertQSEntityInfoFromJson));
                }
                convertQSEntityInfoMap.remove(entityUniqueCacheKey);
            }
            for (Map.Entry<String, ConvertQSEntityInfo> entry : convertQSEntityInfoMap.entrySet()) {
                newAddOrUpdateSet.add(JsonUtil.encodeToString((Object)entry.getValue()));
            }
            convertQSEntityInfoCacheSet.addAll(newAddOrUpdateSet);
            this.addConvertQSEntityInfoSetToCache(globalQingSession, entityUniqueInfoSetCacheKey, convertQSEntityInfoCacheSet);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (QingLockRequireException e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public Map<AbstractSource, List<Entity>> getHandleEntityMap(Box boxModel) {
        List sources;
        List entities;
        HashMap<AbstractSource, List<Entity>> sourceListMap = new HashMap<AbstractSource, List<Entity>>();
        if (boxModel != null && CollectionUtils.isNotEmpty((Collection)(entities = boxModel.getEntities())) && CollectionUtils.isNotEmpty((Collection)(sources = boxModel.getSources()))) {
            HashMap<String, AbstractSource> sourceMap = new HashMap<String, AbstractSource>();
            for (AbstractSource source : sources) {
                if (!(source instanceof FileSource)) continue;
                sourceMap.put(source.getName(), source);
            }
            for (AbstractEntity abstractEntity : entities) {
                List children;
                UnionEntity unionEntity;
                if (abstractEntity instanceof Entity) {
                    Entity entity = (Entity)abstractEntity;
                    this.buildHandleEntityMap(sourceMap, entity, sourceListMap);
                    continue;
                }
                if (!(abstractEntity instanceof UnionEntity) || (unionEntity = (UnionEntity)abstractEntity) == null || !CollectionUtils.isNotEmpty((Collection)(children = unionEntity.getChildren()))) continue;
                for (Entity entity : children) {
                    this.buildHandleEntityMap(sourceMap, entity, sourceListMap);
                }
            }
        }
        return sourceListMap;
    }

    private void buildHandleEntityMap(Map<String, AbstractSource> sourceMap, Entity entity, Map<AbstractSource, List<Entity>> sourceListMap) {
        AbstractSource source = sourceMap.get(entity.getSource());
        if (source instanceof FileSource) {
            List<Entity> entityList = sourceListMap.get(source);
            if (CollectionUtils.isNotEmpty(entityList)) {
                entityList.add(entity);
            } else {
                ArrayList<Entity> newEntityList = new ArrayList<Entity>();
                newEntityList.add(entity);
                sourceListMap.put(source, newEntityList);
            }
        }
    }

    public Map<AbstractSource, List<Entity>> getDeletedEntity(Map<AbstractSource, List<Entity>> handleEntityMap, Box originalBoxModel) {
        if (originalBoxModel == null || CollectionUtils.isEmpty((Collection)originalBoxModel.getEntities())) {
            return null;
        }
        Map<AbstractSource, List<Entity>> oldHandleEntityMap = this.getHandleEntityMap(originalBoxModel);
        Set<AbstractSource> sourcesSet = handleEntityMap.keySet();
        HashMap<AbstractSource, List<Entity>> resultListMap = new HashMap<AbstractSource, List<Entity>>();
        for (Map.Entry<AbstractSource, List<Entity>> entry : oldHandleEntityMap.entrySet()) {
            FileSource oldSource = (FileSource)entry.getKey();
            boolean isFlag = false;
            for (AbstractSource newSource : sourcesSet) {
                FileSource source = (FileSource)newSource;
                if (!source.getName().equals(oldSource.getName()) || !source.getFileUrl().equals(oldSource.getFileUrl())) continue;
                isFlag = true;
                List<Entity> oldEntityList = oldHandleEntityMap.get(oldSource);
                List<Entity> entityList = handleEntityMap.get(source);
                this.buildOldSourceMap((AbstractSource)oldSource, oldEntityList, entityList, resultListMap);
                break;
            }
            if (isFlag) continue;
            resultListMap.put((AbstractSource)oldSource, entry.getValue());
        }
        return resultListMap;
    }

    private void buildOldSourceMap(AbstractSource oldSource, List<Entity> oldEntityList, List<Entity> entityList, Map<AbstractSource, List<Entity>> resultListMap) {
        if (CollectionUtils.isNotEmpty(oldEntityList) && CollectionUtils.isNotEmpty(entityList)) {
            ArrayList<Entity> resultList = new ArrayList<Entity>();
            for (Entity oldEntity : oldEntityList) {
                boolean isFlag = false;
                for (Entity entity : entityList) {
                    if (!oldEntity.getName().equals(entity.getName())) continue;
                    isFlag = true;
                    break;
                }
                if (isFlag) continue;
                resultList.add(oldEntity);
            }
            if (CollectionUtils.isNotEmpty(resultList)) {
                resultListMap.put(oldSource, resultList);
            }
        }
    }

    public Map<Entity, IQingFileVisitor> getQingFileVisitorMap(AbstractEntity abstractEntity, Sources sources) throws AbstractQingIntegratedException, SQLException {
        UnionEntity unionEntity;
        List children;
        HashMap<Entity, IQingFileVisitor> resultMap = new HashMap<Entity, IQingFileVisitor>();
        HashMap<AbstractSource, List<Entity>> sourceListMap = new HashMap<AbstractSource, List<Entity>>();
        Map sourceMap = sources.getSourceMap();
        if (abstractEntity instanceof Entity) {
            Entity entity = (Entity)abstractEntity;
            this.buildHandleEntityMap(sourceMap, entity, sourceListMap);
        } else if (abstractEntity instanceof UnionEntity && CollectionUtils.isNotEmpty((Collection)(children = (unionEntity = (UnionEntity)abstractEntity).getChildren()))) {
            for (Entity entity : children) {
                this.buildHandleEntityMap(sourceMap, entity, sourceListMap);
            }
        }
        if (MapUtils.isNotEmpty(sourceListMap)) {
            this.buildQingFileVisitor(sourceListMap, resultMap);
        }
        return resultMap;
    }

    private void buildQingFileVisitor(Map<AbstractSource, List<Entity>> sourceListMap, Map<Entity, IQingFileVisitor> resultMap) throws AbstractQingIntegratedException, SQLException {
        List<EntityQSFilePO> entityFileList;
        Set<AbstractSource> sourcesList = sourceListMap.keySet();
        HashSet<String> resourceFileNameSet = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(sourcesList)) {
            for (AbstractSource source : sourcesList) {
                if (!(source instanceof FileSource)) continue;
                FileSource fileSource = (FileSource)source;
                resourceFileNameSet.add(fileSource.getFileUrl());
            }
        }
        if (CollectionUtils.isNotEmpty(entityFileList = this.getEntityFileDao().queryByResourceFileNameSet(resourceFileNameSet))) {
            for (Map.Entry<AbstractSource, List<Entity>> entry : sourceListMap.entrySet()) {
                List<Entity> entityList = entry.getValue();
                for (Entity entity : entityList) {
                    this.putQingFileVisitor(entity, entry.getKey(), entityFileList, resultMap);
                }
            }
        }
    }

    private void putQingFileVisitor(Entity entity, AbstractSource source, List<EntityQSFilePO> entityFileList, Map<Entity, IQingFileVisitor> resultMap) {
        FileSource fileSource = (FileSource)source;
        for (EntityQSFilePO entityFile : entityFileList) {
            if (!entityFile.getOriginalFileName().equals(fileSource.getFileUrl()) || !entityFile.getOriginalEntityName().equals(entity.getName())) continue;
            IQingFileVisitor qsFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)entityFile.getQsFileName());
            resultMap.put(entity, qsFile);
        }
    }
}

