/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.handover.dao;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.InSqlConditionBuilder;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.manage.handover.dao.ISQLExcuter;
import com.kingdee.bos.qing.manage.handover.dao.SQLSplitHelper;
import com.kingdee.bos.qing.manage.handover.model.HandOverOpeation;
import com.kingdee.bos.qing.manage.handover.model.HandOverPublish;
import com.kingdee.bos.qing.manage.handover.model.HandOverRecordOperationDataVO;
import com.kingdee.bos.qing.manage.handover.model.HandOverRecordOperationVO;
import com.kingdee.bos.qing.manage.handover.model.HandOverRecordVO;
import com.kingdee.bos.qing.manage.handover.model.HandOverSource;
import com.kingdee.bos.qing.manage.handover.model.HandOverVO;
import com.kingdee.bos.qing.manage.handover.model.PublishTypeEnum;
import com.kingdee.bos.qing.manage.handover.model.SourceTypeEnum;
import com.kingdee.bos.qing.message.model.BizTypeEnum;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetDomainFactory;
import com.kingdee.bos.qing.publish.target.email.dao.EmailConfigDao;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HandOverDao {
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    public static final String HAS_DELETED = "hasDeleted";

    public HandOverDao(QingContext qingContext, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
    }

    public List<HandOverVO> queryIndirectThemePublishDataByUserId(final String userId) throws AbstractQingIntegratedException, SQLException {
        final String userName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId);
        List result = (List)this.dbExcuter.query("SELECT \t\tP.FTAGID AS SOURCEID, \t\tT.FNAME AS SOURCENAME, \t\tG.FNAME AS SOURCEPATHNAME, \t\tG.FID AS SOURCEPATHID, \t\t'3' AS SOURCETYPE, \t\tP.FCREATORID AS SOURCECREATORID, \t\tP.FSOURCE AS PUBSOURCETYPE, \t\tP.FNAME AS PUBNAME, \t\tP.FTYPE AS PUBLISHTOTYPE, \t\t'PUBLISH' AS PUBTYPE, \t\tP.FPATH AS PUBPATH, \t\tP.FID AS FPUBID FROM (\tSELECT \t\tP.FTAGID ,\t\tP.FCREATORID,\t\tP.FSOURCE,\t\tP.FNAME,\t\tP.FTYPE,\t\tP.FPATH,\t\tP.FID\tFROM\t\tT_QING_PUBLISH P \tWhere P.FCREATORID = ? AND \t\tP.FSOURCE IN ('subject', 'dashboard') \t\tAND \t\t(\t\t\tP.FTYPE NOT IN ('6') \t\t)) P LEFT JOIN T_QING_THEME T ON T .FID = P.FTAGID LEFT JOIN T_QING_THEME_GROUP G ON T.FTHEMEGROUPID = G.FID WHERE (P.FCREATORID <> T.FUSERID OR T.FUSERID IS NULL)", new Object[]{userId}, (ResultHandler)new ResultHandler<List<HandOverVO>>(){

            public List<HandOverVO> handle(ResultSet rs) throws SQLException {
                ArrayList<HandOverVO> handOverVOs = new ArrayList<HandOverVO>(10);
                while (rs.next()) {
                    HandOverVO handOverVO = new HandOverVO();
                    handOverVO.setSourceCreatorName(userName);
                    handOverVO.setSourceId(rs.getString("SOURCEID"));
                    handOverVO.setSourceName(rs.getString("SOURCENAME"));
                    handOverVO.setSourcePathName(rs.getString("SOURCEPATHNAME"));
                    handOverVO.setSourcePathId(rs.getString("SOURCEPATHID"));
                    handOverVO.setSourceType(rs.getString("SOURCETYPE"));
                    handOverVO.setSourceCreatorId(StringUtils.isEmpty((CharSequence)rs.getString("SOURCECREATORID")) ? userId : rs.getString("SOURCECREATORID"));
                    handOverVO.setPubSourceType(rs.getString("PUBSOURCETYPE"));
                    handOverVO.setPubName(rs.getString("PUBNAME"));
                    handOverVO.setPubId(rs.getString("FPUBID"));
                    handOverVO.setPubType(rs.getString("PUBTYPE"));
                    handOverVO.setPublishToType(rs.getString("PUBLISHTOTYPE"));
                    handOverVO.setPubPath(rs.getString("PUBPATH"));
                    if (StringUtils.isBlank((CharSequence)handOverVO.getSourceName())) {
                        handOverVO.setSourceName(HandOverDao.HAS_DELETED);
                    } else {
                        handOverVO.setSourceName("");
                        handOverVO.setSourcePathName("");
                    }
                    handOverVOs.add(handOverVO);
                }
                return handOverVOs;
            }
        });
        this.fixHandOverNames(result);
        return result;
    }

    public List<HandOverVO> queryIndirectThemePushDataByUserId(final String userId) throws AbstractQingIntegratedException, SQLException {
        final String userName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId);
        List result = (List)this.dbExcuter.query("SELECT \tC .FTAGID AS SOURCEID, \tP .FNAME AS SOURCENAME, \tNULL AS SOURCEPATHNAME, \tP.FPATH AS SOURCEPATHID, \t'3' AS SOURCETYPE, \tC.FUSERID AS SOURCECREATORID, \tC.FPUBLISHSOURCETYPE AS PUBSOURCETYPE, \tNULL AS PUBNAME, \t'6' AS PUBLISHTOTYPE, \t'PUSH' AS PUBTYPE, \tNULL AS PUBPATH, \tC.FID AS FPUBID FROM \tT_QING_PUB_EMAIL_CONF C LEFT JOIN T_QING_PUBLISH P ON P .FID = C.FTAGID WHERE (C .FUSERID <> P.FCREATORID OR P.FCREATORID IS NULL) AND C .FTAGID LIKE ? AND C.FUSERID = ?  union  SELECT \tC .FTAGID AS SOURCEID, \tP .FNAME AS SOURCENAME, \tNULL AS SOURCEPATHNAME, \tP.FPATH AS SOURCEPATHID, \t'3' AS SOURCETYPE, \tC.FUSERID AS SOURCECREATORID, \tC.FSOURCETYPE AS PUBSOURCETYPE, \tC.FNAME AS PUBNAME, \t'2' AS PUBLISHTOTYPE, \t'PUSH' AS PUBTYPE, \tNULL AS PUBPATH, \tC.FID AS FPUBID FROM \tT_QING_PUSH_CONFIG_INFO C LEFT JOIN T_QING_PUBLISH P ON P .FID = C.FTAGID WHERE (C .FUSERID <> P.FCREATORID OR P.FCREATORID IS NULL) AND C .FTAGID LIKE ? AND C.FUSERID = ?", new Object[]{"QingAnalysis-%", userId, "QingAnalysis-%", userId}, (ResultHandler)new ResultHandler<List<HandOverVO>>(){

            public List<HandOverVO> handle(ResultSet rs) throws SQLException {
                ArrayList<HandOverVO> handOverVOs = new ArrayList<HandOverVO>(10);
                while (rs.next()) {
                    HandOverVO handOverVO = new HandOverVO();
                    handOverVO.setSourceCreatorName(userName);
                    handOverVO.setSourceId(rs.getString("SOURCEID"));
                    handOverVO.setSourceName(rs.getString("SOURCENAME"));
                    handOverVO.setSourcePathName(rs.getString("SOURCEPATHNAME"));
                    handOverVO.setSourcePathId(rs.getString("SOURCEPATHID"));
                    handOverVO.setSourceType(rs.getString("SOURCETYPE"));
                    handOverVO.setSourceCreatorId(StringUtils.isEmpty((CharSequence)rs.getString("SOURCECREATORID")) ? userId : rs.getString("SOURCECREATORID"));
                    handOverVO.setPubSourceType(rs.getString("PUBSOURCETYPE"));
                    handOverVO.setPubName(rs.getString("PUBNAME"));
                    handOverVO.setPubId(rs.getString("FPUBID"));
                    handOverVO.setPubType(rs.getString("PUBTYPE"));
                    handOverVO.setPublishToType(rs.getString("PUBLISHTOTYPE"));
                    handOverVO.setPubPath(rs.getString("PUBPATH"));
                    if (StringUtils.isBlank((CharSequence)handOverVO.getSourceName())) {
                        handOverVO.setSourceName(HandOverDao.HAS_DELETED);
                    } else {
                        handOverVO.setSourceName("");
                        handOverVO.setSourcePathName("");
                    }
                    handOverVOs.add(handOverVO);
                }
                return handOverVOs;
            }
        });
        this.fixHandOverNames(result);
        return result;
    }

    public List<HandOverVO> queryThemeEmailPush(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT \tC .FTAGID AS SOURCEID, \tT .FNAME AS SOURCENAME, \tG .FNAME AS SOURCEPATHNAME, \tG .FID AS SOURCEPATHID, \tT .FTYPE AS SOURCETYPE, \tT .FUSERID AS SOURCECREATORID, \tC.FPUBLISHSOURCETYPE AS PUBSOURCETYPE, \tNULL AS PUBNAME, \t'6' AS PUBLISHTOTYPE, \t'PUSH' AS PUBTYPE, \tNULL AS PUBPATH, \tC.FID AS FPUBID FROM \tT_QING_PUB_EMAIL_CONF C LEFT JOIN T_QING_THEME T ON T .FID = C.FTAGID LEFT JOIN T_QING_THEME_GROUP G ON T .FTHEMEGROUPID = G .FID WHERE (C .FUSERID = T.FUSERID OR T.FUSERID IS NULL) AND C.FPUBLISHSOURCETYPE IN ('subject', 'dashboard') AND C .FTAGID NOT LIKE ? AND C.FUSERID = ? ";
        return this.queryOwnThemePushDataByUserId(sql, userId);
    }

    public List<HandOverVO> queryPublishEmailPush(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT \tC .FTAGID AS SOURCEID, \tP .FNAME AS SOURCENAME, \tNULL AS SOURCEPATHNAME, \tP.FPATH AS SOURCEPATHID, \t'3' AS SOURCETYPE, \tP.FCREATORID AS SOURCECREATORID, \tC.FPUBLISHSOURCETYPE AS PUBSOURCETYPE, \tNULL AS PUBNAME, \t'6' AS PUBLISHTOTYPE, \t'PUSH' AS PUBTYPE, \tNULL AS PUBPATH, \tC.FID AS FPUBID FROM \tT_QING_PUB_EMAIL_CONF C LEFT JOIN T_QING_PUBLISH P ON P .FID = C.FTAGID WHERE C .FUSERID = P.FCREATORID AND C .FTAGID LIKE ? AND C.FUSERID = ? ";
        return this.queryOwnThemePushDataByUserId(sql, userId);
    }

    public List<HandOverVO> queryThemeLappPush(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT \tC .FTAGID AS SOURCEID, \tT .FNAME AS SOURCENAME, \tG .FNAME AS SOURCEPATHNAME, \tG .FID AS SOURCEPATHID, \tT .FTYPE AS SOURCETYPE, \tT .FUSERID AS SOURCECREATORID, \tC.FSOURCETYPE AS PUBSOURCETYPE, \tC.FNAME AS PUBNAME, \t'2' AS PUBLISHTOTYPE, \t'PUSH' AS PUBTYPE, \tNULL AS PUBPATH, \tC.FID AS FPUBID FROM \tT_QING_PUSH_CONFIG_INFO C LEFT JOIN T_QING_THEME T ON T .FID = C.FTAGID LEFT JOIN T_QING_THEME_GROUP G ON T .FTHEMEGROUPID = G .FID WHERE (C .FUSERID = T.FUSERID OR T.FUSERID IS NULL) AND C.FSOURCETYPE IN ('subject', 'dashboard') AND C .FTAGID NOT LIKE ? AND C.FUSERID = ? ";
        return this.queryOwnThemePushDataByUserId(sql, userId);
    }

    public List<HandOverVO> queryPublishLappPush(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT \tC .FTAGID AS SOURCEID, \tP .FNAME AS SOURCENAME, \tNULL AS SOURCEPATHNAME, \tP.FPATH AS SOURCEPATHID, \t'3' AS SOURCETYPE, \tP.FCREATORID AS SOURCECREATORID, \tC.FSOURCETYPE AS PUBSOURCETYPE, \tC.FNAME AS PUBNAME, \t'2' AS PUBLISHTOTYPE, \t'PUSH' AS PUBTYPE, \tNULL AS PUBPATH, \tC.FID AS FPUBID FROM \tT_QING_PUSH_CONFIG_INFO C LEFT JOIN T_QING_PUBLISH P ON P .FID = C.FTAGID WHERE C .FUSERID = P.FCREATORID AND C .FTAGID LIKE ? AND C.FUSERID = ?";
        return this.queryOwnThemePushDataByUserId(sql, userId);
    }

    private List<HandOverVO> queryOwnThemePushDataByUserId(String sql, final String userId) throws AbstractQingIntegratedException, SQLException {
        final String userName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId);
        List result = (List)this.dbExcuter.query(sql, new Object[]{"QingAnalysis-%", userId}, (ResultHandler)new ResultHandler<List<HandOverVO>>(){

            public List<HandOverVO> handle(ResultSet rs) throws SQLException {
                ArrayList<HandOverVO> handOverVOs = new ArrayList<HandOverVO>(10);
                while (rs.next()) {
                    HandOverVO handOverVO = new HandOverVO();
                    handOverVO.setSourceCreatorName(userName);
                    handOverVO.setSourceId(rs.getString("SOURCEID"));
                    handOverVO.setSourceName(rs.getString("SOURCENAME"));
                    handOverVO.setSourcePathName(rs.getString("SOURCEPATHNAME"));
                    handOverVO.setSourcePathId(rs.getString("SOURCEPATHID"));
                    handOverVO.setSourceType(rs.getString("SOURCETYPE"));
                    handOverVO.setSourceCreatorId(StringUtils.isEmpty((CharSequence)rs.getString("SOURCECREATORID")) ? userId : rs.getString("SOURCECREATORID"));
                    handOverVO.setPubSourceType(rs.getString("PUBSOURCETYPE"));
                    handOverVO.setPubName(rs.getString("PUBNAME"));
                    handOverVO.setPubId(rs.getString("FPUBID"));
                    handOverVO.setPubType(rs.getString("PUBTYPE"));
                    handOverVO.setPublishToType(rs.getString("PUBLISHTOTYPE"));
                    handOverVO.setPubPath(rs.getString("PUBPATH"));
                    if (StringUtils.isBlank((CharSequence)handOverVO.getSourceName())) {
                        handOverVO.setSourceName(HandOverDao.HAS_DELETED);
                    }
                    handOverVOs.add(handOverVO);
                }
                return handOverVOs;
            }
        });
        this.fixHandOverNames(result);
        return result;
    }

    public List<HandOverVO> queryOwnThemePublishDataByUserId(final String userId) throws AbstractQingIntegratedException, SQLException {
        final String userName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId);
        List result = (List)this.dbExcuter.query("SELECT \tT.FID AS SOURCEID, \tT.FNAME AS SOURCENAME, \tG.FNAME AS SOURCEPATHNAME, \tG.FID AS SOURCEPATHID, \tT.FTYPE AS SOURCETYPE, \tT.FUSERID AS SOURCECREATORID, \tP.FSOURCE AS PUBSOURCETYPE, \tP.FNAME AS PUBNAME, \tP.FTYPE AS PUBLISHTOTYPE, \t'PUBLISH' AS PUBTYPE, \tP.FPATH AS PUBPATH, \tP.FID AS FPUBID FROM (SELECT FID,FUSERID,FNAME,FTYPE,FTHEMEGROUPID FROM\tT_QING_THEME WHERE FUSERID=?) T LEFT JOIN (SELECT FID,FSOURCE,FTAGID,FTYPE,FNAME,FPATH FROM T_QING_PUBLISH WHERE FCREATORID=? AND  FSOURCE IN ('subject', 'dashboard') AND  FTYPE NOT IN ('6'))  P ON T.FID = P.FTAGID  LEFT JOIN T_QING_THEME_GROUP G ON T.FTHEMEGROUPID = G.FID ", new Object[]{userId, userId}, (ResultHandler)new ResultHandler<List<HandOverVO>>(){

            public List<HandOverVO> handle(ResultSet rs) throws SQLException {
                ArrayList<HandOverVO> handOverVOs = new ArrayList<HandOverVO>(10);
                while (rs.next()) {
                    HandOverVO handOverVO = new HandOverVO();
                    handOverVO.setSourceCreatorName(userName);
                    handOverVO.setSourceId(rs.getString("SOURCEID"));
                    handOverVO.setSourceName(rs.getString("SOURCENAME"));
                    handOverVO.setSourcePathName(rs.getString("SOURCEPATHNAME"));
                    handOverVO.setSourcePathId(rs.getString("SOURCEPATHID"));
                    handOverVO.setSourceType(rs.getString("SOURCETYPE"));
                    handOverVO.setSourceCreatorId(StringUtils.isEmpty((CharSequence)rs.getString("SOURCECREATORID")) ? userId : rs.getString("SOURCECREATORID"));
                    handOverVO.setPubSourceType(rs.getString("PUBSOURCETYPE"));
                    handOverVO.setPubName(rs.getString("PUBNAME"));
                    handOverVO.setPubId(rs.getString("FPUBID"));
                    handOverVO.setPubType(rs.getString("PUBTYPE"));
                    handOverVO.setPublishToType(rs.getString("PUBLISHTOTYPE"));
                    handOverVO.setPubPath(rs.getString("PUBPATH"));
                    handOverVOs.add(handOverVO);
                }
                return handOverVOs;
            }
        });
        this.fixHandOverNames(result);
        return result;
    }

    public List<HandOverVO> queryEmbeddedPublishDataByUserId(final String userId) throws AbstractQingIntegratedException, SQLException {
        final String userName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId);
        List result = (List)this.dbExcuter.query("SELECT \tP.FTAGID AS SOURCEID, \tNULL AS SOURCENAME, \tNULL AS SOURCEPATHNAME, \tNULL AS SOURCEPATHID, \t'2' AS SOURCETYPE, \tP.FCREATORID AS SOURCECREATORID, \tP.FSOURCE AS PUBSOURCETYPE, \tP.FNAME AS PUBNAME, \tP.FTYPE AS PUBLISHTOTYPE, \t'PUBLISH' AS PUBTYPE, \tP.FPATH AS PUBPATH, \tP.FID AS FPUBID FROM \tT_QING_PUBLISH P WHERE P.FCREATORID = ? AND P.FSOURCE NOT IN ('subject', 'dashboard') AND P.FTYPE NOT IN ('6')  ", new Object[]{userId}, (ResultHandler)new ResultHandler<List<HandOverVO>>(){

            public List<HandOverVO> handle(ResultSet rs) throws SQLException {
                ArrayList<HandOverVO> handOverVOs = new ArrayList<HandOverVO>(10);
                while (rs.next()) {
                    HandOverVO handOverVO = new HandOverVO();
                    handOverVO.setSourceCreatorName(userName);
                    handOverVO.setSourceId(rs.getString("SOURCEID"));
                    handOverVO.setSourceName(rs.getString("SOURCENAME"));
                    handOverVO.setSourcePathName(rs.getString("SOURCEPATHNAME"));
                    handOverVO.setSourcePathId(rs.getString("SOURCEPATHID"));
                    handOverVO.setSourceType(rs.getString("SOURCETYPE"));
                    handOverVO.setSourceCreatorId(StringUtils.isEmpty((CharSequence)rs.getString("SOURCECREATORID")) ? userId : rs.getString("SOURCECREATORID"));
                    handOverVO.setPubSourceType(rs.getString("PUBSOURCETYPE"));
                    handOverVO.setPubName(rs.getString("PUBNAME"));
                    handOverVO.setPubId(rs.getString("FPUBID"));
                    handOverVO.setPubType(rs.getString("PUBTYPE"));
                    handOverVO.setPublishToType(rs.getString("PUBLISHTOTYPE"));
                    handOverVO.setPubPath(rs.getString("PUBPATH"));
                    handOverVOs.add(handOverVO);
                }
                return handOverVOs;
            }
        });
        this.fixHandOverNames(result);
        return result;
    }

    public List<HandOverVO> queryEmbeddedPushDataByUserId(final String userId) throws AbstractQingIntegratedException, SQLException {
        final String userName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId);
        List result = (List)this.dbExcuter.query("SELECT \tC.FTAGID AS SOURCEID, \tNULL AS SOURCENAME, \tNULL AS SOURCEPATHNAME, \tNULL AS SOURCEPATHID, \t'2' AS SOURCETYPE, \tC.FUSERID AS SOURCECREATORID, \tC.FPUBLISHSOURCETYPE AS PUBSOURCETYPE, \tNULL AS PUBNAME, \t'6' AS PUBLISHTOTYPE, \t'PUSH' AS PUBTYPE, \tNULL AS PUBPATH, \tC.FID AS FPUBID FROM \tT_QING_PUB_EMAIL_CONF C WHERE  C.FPUBLISHSOURCETYPE NOT IN ('subject', 'dashboard') AND C.FUSERID = ? AND C.FTAGID NOT LIKE ? UNION SELECT \tC.FTAGID AS SOURCEID, \tNULL AS SOURCENAME, \tNULL AS SOURCEPATHNAME, \tNULL AS SOURCEPATHID, \t'2' AS SOURCETYPE, \tC.FUSERID AS SOURCECREATORID, \tC.FSOURCETYPE AS PUBSOURCETYPE, \tC.FNAME AS PUBNAME, \t'2' AS PUBLISHTOTYPE, \t'PUSH' AS PUBTYPE, \tNULL AS PUBPATH, \tC.FID AS FPUBID FROM T_QING_PUSH_CONFIG_INFO C WHERE  C.FSOURCETYPE NOT IN ('subject', 'dashboard') AND C.FUSERID = ? AND C.FTAGID NOT LIKE ? ", new Object[]{userId, "QingAnalysis-%", userId, "QingAnalysis-%"}, (ResultHandler)new ResultHandler<List<HandOverVO>>(){

            public List<HandOverVO> handle(ResultSet rs) throws SQLException {
                ArrayList<HandOverVO> handOverVOs = new ArrayList<HandOverVO>(10);
                while (rs.next()) {
                    HandOverVO handOverVO = new HandOverVO();
                    handOverVO.setSourceCreatorName(userName);
                    handOverVO.setSourceId(rs.getString("SOURCEID"));
                    handOverVO.setSourceName(rs.getString("SOURCENAME"));
                    handOverVO.setSourcePathName(rs.getString("SOURCEPATHNAME"));
                    handOverVO.setSourcePathId(rs.getString("SOURCEPATHID"));
                    handOverVO.setSourceType(rs.getString("SOURCETYPE"));
                    handOverVO.setSourceCreatorId(StringUtils.isEmpty((CharSequence)rs.getString("SOURCECREATORID")) ? userId : rs.getString("SOURCECREATORID"));
                    handOverVO.setPubSourceType(rs.getString("PUBSOURCETYPE"));
                    handOverVO.setPubName(rs.getString("PUBNAME"));
                    handOverVO.setPubId(rs.getString("FPUBID"));
                    handOverVO.setPubType(rs.getString("PUBTYPE"));
                    handOverVO.setPublishToType(rs.getString("PUBLISHTOTYPE"));
                    handOverVO.setPubPath(rs.getString("PUBPATH"));
                    handOverVOs.add(handOverVO);
                }
                return handOverVOs;
            }
        });
        this.fixHandOverNames(result);
        return result;
    }

    private void fixHandOverNames(List<HandOverVO> handOverVOS) throws SQLException {
        for (HandOverVO handOverVO : handOverVOS) {
            this.fixHandOverNames(handOverVO);
        }
    }

    private void fixHandOverNames(HandOverVO handOverVO) throws SQLException {
        if (PublishTypeEnum.PUBLISH.name().equals(handOverVO.getPubType()) && StringUtils.isNotBlank((CharSequence)handOverVO.getPubPath())) {
            AbstractPublishTargetDomain publishTargetDomain = PublishTargetDomainFactory.createPublishTargetDomain((QingContext)this.qingContext, null, (IDBExcuter)this.dbExcuter, null, (Integer)Integer.valueOf(handOverVO.getPublishToType()));
            if (publishTargetDomain != null) {
                try {
                    String pubPathName = publishTargetDomain.loadPathNameByPath(handOverVO.getPubPath(), handOverVO.getPubId());
                    handOverVO.setPubPathName(pubPathName);
                }
                catch (AbstractQingIntegratedException e) {
                    throw new SQLException(e);
                }
            }
        } else if (PublishTypeEnum.PUSH.name().equals(handOverVO.getPubType()) && String.valueOf(6).equals(handOverVO.getPublishToType()) && StringUtils.isNotBlank((CharSequence)handOverVO.getPubId())) {
            EmailConfigDao emailConfigDao = new EmailConfigDao(this.qingContext, this.dbExcuter);
            try {
                EmailConfig emailConfig = emailConfigDao.getEmailConfigById(handOverVO.getPubId());
                if (emailConfig != null) {
                    handOverVO.setPubName(emailConfig.getNameRule().getName());
                }
            }
            catch (AbstractQingIntegratedException e) {
                throw new SQLException(e);
            }
        }
        if (SourceTypeEnum.BILL.getSourceType().equals(handOverVO.getSourceType())) {
            try {
                handOverVO.setSourceName(IntegratedHelper.queryFormDisplayName((String)handOverVO.getSourceId(), (String)handOverVO.getPubSourceType(), (QingContext)this.qingContext, (IDBExcuter)this.dbExcuter));
            }
            catch (IntegratedRuntimeException e) {
                throw new SQLException(e);
            }
        }
        if (String.valueOf(2).equals(handOverVO.getPublishToType()) && PublishTypeEnum.PUBLISH.name().equals(handOverVO.getPubType()) && StringUtils.isNotBlank((CharSequence)handOverVO.getPubName()) && handOverVO.getPubName().length() > 36) {
            handOverVO.setPubName(handOverVO.getPubName().substring(0, handOverVO.getPubName().length() - 36));
        }
    }

    public void updateThemeUserId(String themeId, String themeGroupId, String themeNameNew, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[4];
        int idx = 0;
        params[idx++] = toUserId;
        params[idx++] = themeGroupId;
        params[idx++] = themeNameNew;
        params[idx++] = themeId;
        this.dbExcuter.execute("UPDATE T_QING_THEME SET FUSERID=?, FTHEMEGROUPID=?, FNAME=? WHERE FID=?", params);
    }

    public void updatePublishedUserId(String publishId, String pathId, String publishNewName, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[4];
        int idx = 0;
        params[idx++] = toUserId;
        params[idx++] = pathId;
        params[idx++] = publishNewName;
        params[idx++] = publishId;
        this.dbExcuter.execute("UPDATE T_QING_PUBLISH SET FCREATORID=?, FPATH=?, FNAME=? WHERE FID=?", params);
    }

    public void updateEmailPushedUserId(String id, String toUserId, String senderId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[3];
        int idx = 0;
        params[idx++] = toUserId;
        params[idx++] = senderId;
        params[idx++] = id;
        this.dbExcuter.execute("UPDATE T_QING_PUB_EMAIL_CONF SET FUSERID=?, FSENDERID=? WHERE FID=?", params);
    }

    public void updateLappPushUserId(LappSchedulePushConfigModel lappSchedulePushConfigModel, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[2];
        int idx = 0;
        params[idx++] = toUserId;
        params[idx++] = lappSchedulePushConfigModel.getId();
        this.dbExcuter.execute("UPDATE T_QING_PUSH_CONFIG_INFO SET FUSERID=? WHERE FID=?", params);
    }

    public void updateLappPushRecordUserId(LappSchedulePushConfigModel lappSchedulePushConfigModel, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[2];
        int idx = 0;
        params[idx++] = toUserId;
        params[idx++] = lappSchedulePushConfigModel.getId();
        this.dbExcuter.execute("UPDATE T_QING_PUSH_RECORD SET FUSERID=? WHERE FCONFIGID=?", params);
    }

    public void updateLappPushThumbnailFileResourceUserId(String configId, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{toUserId, configId, ResourceFromType.CARDTHUMBNAIL.toPersistance()};
        this.dbExcuter.execute("UPDATE T_QING_FILE_RESOURCE SET FUSERID=? WHERE FFROMID=? AND FFROMTYPE=?", params);
    }

    public void updateSubjectSchemaUserId(HandOverVO handOverVO, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[2];
        int idx = 0;
        params[idx++] = toUserId;
        params[idx++] = handOverVO.getSourceId();
        this.dbExcuter.execute("UPDATE T_QING_SARELATION SET FUSERID=? WHERE FSCHEMAID IN (SELECT FID FROM T_QING_SASCHEMA WHERE FBIZTAG=?)", params);
    }

    public void updateSubjectFileResourceUserId(String sourceId, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{toUserId, sourceId, ResourceFromType.THEME.toPersistance(), ResourceFromType.THEMESCHEDULE.toPersistance(), ResourceFromType.THEMESOURCECONVERT.toPersistance()};
        this.dbExcuter.execute("UPDATE T_QING_FILE_RESOURCE SET FUSERID=? WHERE FFROMID=? AND FFROMTYPE IN (?, ?, ?)", params);
    }

    public void updateFileResourceUserId(String sourceId, ResourceFromType resourceFromType, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{toUserId, sourceId, resourceFromType.toPersistance()};
        this.dbExcuter.execute("UPDATE T_QING_FILE_RESOURCE SET FUSERID=? WHERE FFROMID=? AND FFROMTYPE=?", params);
    }

    public void updatePublishFileResourceUserId(String sourceId, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{toUserId, sourceId, ResourceFromType.PUBLISHED.toPersistance(), ResourceFromType.TIMINGPUSH.toPersistance(), ResourceFromType.CARDTHUMBNAIL.toPersistance()};
        this.dbExcuter.execute("UPDATE T_QING_FILE_RESOURCE SET FUSERID=? WHERE FFROMID IN (SELECT FID FROM T_QING_PUBLISH WHERE FTAGID=?) AND FFROMTYPE IN (?, ?, ?)", params);
    }

    public Set<String> queryHOSourceId(String pubId, String pubType) throws AbstractQingIntegratedException, SQLException {
        return (Set)this.dbExcuter.query("SELECT FHOSOURCEID FROM T_QING_HO_PUBLISH WHERE FPUBID=? AND FPUBTYPE=?", new Object[]{pubId, pubType}, (ResultHandler)new ResultHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> hoSourceIds = new HashSet<String>(16);
                while (rs.next()) {
                    hoSourceIds.add(rs.getString("FHOSOURCEID"));
                }
                return hoSourceIds;
            }
        });
    }

    public List<HandOverRecordVO> queryHandOverRecordsBySourceId(String sourceId) throws AbstractQingIntegratedException, SQLException {
        return this.queryHandOverRecords("SELECT O.FCREATETIME, O.FCREATORID, O.FTOUSERID, O.FFROMUSERID FROM (SELECT FOPERATIONID FROM T_QING_HO_SOURCE WHERE FSOURCEID =?) S LEFT JOIN T_QING_HO_OPERATION O ON O.FID = S.FOPERATIONID GROUP BY FCREATETIME, FCREATORID, FTOUSERID, FFROMUSERID ORDER BY FCREATETIME DESC", new Object[]{sourceId});
    }

    public List<HandOverRecordVO> queryHandOverRecordsByHOSourceId(String hoSourceId) throws AbstractQingIntegratedException, SQLException {
        return this.queryHandOverRecords("SELECT O.FCREATETIME, O.FCREATORID, O.FTOUSERID, O.FFROMUSERID FROM (SELECT FOPERATIONID FROM T_QING_HO_SOURCE WHERE FID =?) S LEFT JOIN T_QING_HO_OPERATION O ON O.FID = S.FOPERATIONID GROUP BY FCREATETIME, FCREATORID, FTOUSERID, FFROMUSERID ORDER BY FCREATETIME DESC", new Object[]{hoSourceId});
    }

    private List<HandOverRecordVO> queryHandOverRecords(String sql, Object[] params) throws AbstractQingIntegratedException, SQLException {
        final HashSet<String> userIds = new HashSet<String>();
        List result = (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<HandOverRecordVO>>(){

            public List<HandOverRecordVO> handle(ResultSet rs) throws SQLException {
                ArrayList<HandOverRecordVO> handOverRecords = new ArrayList<HandOverRecordVO>(10);
                while (rs.next()) {
                    String toUserId = rs.getString("FTOUSERID");
                    HandOverRecordVO handOverRecord = new HandOverRecordVO();
                    handOverRecord.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                    handOverRecord.setCreatorId(rs.getString("FCREATORID"));
                    handOverRecord.setToUserId(toUserId);
                    handOverRecord.setFromUserId(rs.getString("FFROMUSERID"));
                    userIds.add(handOverRecord.getCreatorId());
                    userIds.add(handOverRecord.getToUserId());
                    userIds.add(handOverRecord.getFromUserId());
                    handOverRecords.add(handOverRecord);
                }
                return handOverRecords;
            }
        });
        try {
            Map<String, String> userNameMap = this.collectUserNameMap(userIds);
            for (HandOverRecordVO handOverRecordVO : result) {
                handOverRecordVO.setCreatorName(userNameMap.get(handOverRecordVO.getCreatorId()));
                handOverRecordVO.setToUserName(userNameMap.get(handOverRecordVO.getToUserId()));
                handOverRecordVO.setFromUserName(userNameMap.get(handOverRecordVO.getFromUserId()));
            }
        }
        catch (IntegratedRuntimeException e) {
            throw new SQLException(e);
        }
        return result;
    }

    private Map<String, String> collectUserNameMap(Set<String> userIds) throws IntegratedRuntimeException {
        HashMap<String, String> userNameMap = new HashMap<String, String>(32);
        for (String userId : userIds) {
            String userName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId);
            userNameMap.put(userId, userName);
        }
        return userNameMap;
    }

    public void updateImageUserId(String refToId, String categoryId, String newImageName, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{categoryId, newImageName, toUserId, refToId};
        this.dbExcuter.execute("UPDATE T_QING_IMGLIB_IMG_INFO SET FCATEGORYID = ?, FIMAGENAME = ?, FUSERID = ? WHERE FIMAGEFILENAME = ?", params);
    }

    public String insertHandOverOpeation(HandOverOpeation handOverOpeation) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[5];
        String id = this.dbExcuter.genStringId("T_QING_HO_OPERATION");
        int idx = 0;
        params[idx++] = id;
        params[idx++] = handOverOpeation.getToUserId();
        params[idx++] = handOverOpeation.getFromUserId();
        params[idx++] = handOverOpeation.getCreatorId();
        params[idx++] = new Date();
        this.dbExcuter.execute("INSERT INTO T_QING_HO_OPERATION (FID, FTOUSERID, FFROMUSERID, FCREATORID, FCREATETIME) VALUES(?, ?, ?, ?, ?)", params);
        return id;
    }

    public String insertHandOverSource(HandOverSource handOverSource) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[8];
        String id = this.dbExcuter.genStringId("T_QING_HO_SOURCE");
        int idx = 0;
        params[idx++] = id;
        params[idx++] = handOverSource.getSourceId();
        params[idx++] = handOverSource.getSourceOldName();
        params[idx++] = handOverSource.getSourceNewName();
        params[idx++] = handOverSource.getSourceType();
        params[idx++] = handOverSource.getSourcePathId();
        params[idx++] = handOverSource.getSourcePathName();
        params[idx++] = handOverSource.getOperationId();
        this.dbExcuter.execute("INSERT INTO T_QING_HO_SOURCE (FID, FSOURCEID, FSOURCEOLDNAME, FSOURCENEWNAME, FSOURCETYPE, FSOURCEPATHID, FSOURCEPATHNAME, FOPERATIONID) VALUES(?, ?, ?, ?, ?, ?, ?, ?)", params);
        return id;
    }

    public void insertHandOverPublish(HandOverPublish handOverPublish) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[9];
        String id = this.dbExcuter.genStringId("T_QING_HO_PUBLISH");
        int idx = 0;
        params[idx++] = id;
        params[idx++] = handOverPublish.getPubId();
        params[idx++] = handOverPublish.getPubOldName();
        params[idx++] = handOverPublish.getPubNewName();
        params[idx++] = handOverPublish.getPubType();
        params[idx++] = handOverPublish.getPubPath();
        params[idx++] = handOverPublish.getPubPathName();
        params[idx++] = handOverPublish.getPublishToType();
        params[idx++] = handOverPublish.getHoSourceId();
        this.dbExcuter.execute("INSERT INTO T_QING_HO_PUBLISH (FID, FPUBID, FPUBOLDNAME, FPUBNEWNAME, FPUBTYPE, FPUBPATH, FPUBPATHNAME, FPUBLISHTOTYPE, FHOSOURCEID) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)", params);
    }

    public List<HandOverRecordOperationDataVO> loadHandOverRecordDataByOperationId(String operationId) throws AbstractQingIntegratedException, SQLException {
        final HashSet<String> userIds = new HashSet<String>();
        List result = (List)this.dbExcuter.query("SELECT s.FSOURCETYPE AS TYPE, s.FSOURCENEWNAME AS NAME, o.FFROMUSERID AS FROMUSERID, s.FSOURCEPATHNAME AS PATHNAME, null as PUBID, null as PUBLISHTOTYPE,null as PUBPATH FROM T_QING_HO_OPERATION o LEFT JOIN T_QING_HO_SOURCE s ON s.FOPERATIONID = o.FID WHERE o.FID = ? AND s.FSOURCETYPE IN ('0', '1')  UNION ALL SELECT '2' AS TYPE, P.FPUBNEWNAME AS NAME, o.FFROMUSERID AS FROMUSERID, p.FPUBPATHNAME AS PATHNAME, p.FPUBID as PUBID, p.FPUBLISHTOTYPE as PUBLISHTOTYPE,P.FPUBPATH AS PUBPATH FROM T_QING_HO_PUBLISH p LEFT JOIN T_QING_HO_SOURCE s ON p.FHOSOURCEID = s.FID  LEFT JOIN T_QING_HO_OPERATION o ON s.FOPERATIONID = o.FID  WHERE P.FPUBTYPE= ? AND o.FID = ?  UNION ALL SELECT '3' AS TYPE, P.FPUBNEWNAME as NAME, o.FFROMUSERID as FROMUSERID, p.FPUBPATHNAME AS PATHNAME, p.FPUBID as PUBID, p.FPUBLISHTOTYPE as PUBLISHTOTYPE,P.FPUBPATH AS PUBPATH FROM T_QING_HO_PUBLISH p LEFT JOIN T_QING_HO_SOURCE s ON p.FHOSOURCEID = s.FID  LEFT JOIN T_QING_HO_OPERATION o ON s.FOPERATIONID = o.FID  WHERE P.FPUBTYPE= ? AND o.FID = ? ORDER BY TYPE", new Object[]{operationId, PublishTypeEnum.PUBLISH.name(), operationId, PublishTypeEnum.PUSH.name(), operationId}, (ResultHandler)new ResultHandler<List<HandOverRecordOperationDataVO>>(){

            public List<HandOverRecordOperationDataVO> handle(ResultSet rs) throws SQLException {
                ArrayList<HandOverRecordOperationDataVO> handOverRecordDatas = new ArrayList<HandOverRecordOperationDataVO>(10);
                while (rs.next()) {
                    HandOverRecordOperationDataVO handOverRecordData = new HandOverRecordOperationDataVO();
                    handOverRecordData.setType(rs.getString("TYPE"));
                    handOverRecordData.setName(rs.getString("NAME"));
                    handOverRecordData.setFromUserId(rs.getString("FROMUSERID"));
                    handOverRecordData.setPathName(rs.getString("PATHNAME"));
                    handOverRecordData.setPubId(rs.getString("PUBID"));
                    handOverRecordData.setPublishToType(rs.getString("PUBLISHTOTYPE"));
                    handOverRecordData.setPubPath(rs.getString("PUBPATH"));
                    userIds.add(handOverRecordData.getFromUserId());
                    handOverRecordDatas.add(handOverRecordData);
                }
                return handOverRecordDatas;
            }
        });
        try {
            Map<String, String> userNameMap = this.collectUserNameMap(userIds);
            for (HandOverRecordOperationDataVO handOverRecordOperationDataVO : result) {
                handOverRecordOperationDataVO.setFromUserName(userNameMap.get(handOverRecordOperationDataVO.getFromUserId()));
            }
        }
        catch (IntegratedRuntimeException e) {
            throw new SQLException(e);
        }
        return result;
    }

    public List<HandOverRecordOperationVO> loadUnReadHandOverOperationRecord(String messageId, String isread) throws AbstractQingIntegratedException, SQLException {
        String bizType = BizTypeEnum.HAND_OVER_NEWS.getBizType();
        final String userId = this.qingContext.getUserId();
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("SELECT o.FID, o.FTOUSERID, o.FFROMUSERID, o.FCREATORID,m.FID as MESSAGEID FROM T_QING_MESSAGE m LEFT JOIN T_QING_HO_OPERATION o ON o.FID = m.FBIZID LEFT JOIN T_QING_MESSAGE_RECEIVER_REL QMR ON M.FID=QMR.FMESSAGEID ");
        if (StringUtils.isNotEmpty((CharSequence)messageId)) {
            params.add(messageId);
            sql.append(" where m.FID=? AND QMR.FRECEVIERID = ? AND m.FBIZTYPE= ? ");
        } else {
            sql.append("where QMR.FRECEVIERID = ? AND m.FBIZTYPE= ? ");
        }
        params.add(userId);
        params.add(bizType);
        if (StringUtils.isNotEmpty((CharSequence)isread)) {
            params.add(isread);
            sql.append(" AND  QMR.FISREAD=? ");
        }
        sql.append(" ORDER BY m.FSENDDATE DESC");
        final HashSet<String> userIds = new HashSet<String>();
        List result = (List)this.dbExcuter.query(sql.toString(), params.toArray(), (ResultHandler)new ResultHandler<List<HandOverRecordOperationVO>>(){

            public List<HandOverRecordOperationVO> handle(ResultSet rs) throws SQLException {
                ArrayList<HandOverRecordOperationVO> handOverRecordOperations = new ArrayList<HandOverRecordOperationVO>(10);
                while (rs.next()) {
                    HandOverRecordOperationVO handOverRecordOperation = new HandOverRecordOperationVO();
                    handOverRecordOperation.setOperationId(rs.getString("FID"));
                    handOverRecordOperation.setCreatorId(rs.getString("FCREATORID"));
                    handOverRecordOperation.setToUserId(rs.getString("FTOUSERID"));
                    handOverRecordOperation.setFromUserId(rs.getString("FFROMUSERID"));
                    handOverRecordOperation.setMessageId(rs.getString("MESSAGEID"));
                    handOverRecordOperation.setType(userId.equals(handOverRecordOperation.getFromUserId()) ? HandOverRecordOperationVO.HandOverRecordOperationTypeEnum.FORM.name() : HandOverRecordOperationVO.HandOverRecordOperationTypeEnum.TO.name());
                    userIds.add(handOverRecordOperation.getCreatorId());
                    userIds.add(handOverRecordOperation.getToUserId());
                    userIds.add(handOverRecordOperation.getFromUserId());
                    handOverRecordOperations.add(handOverRecordOperation);
                }
                return handOverRecordOperations;
            }
        });
        try {
            Map<String, String> userNameMap = this.collectUserNameMap(userIds);
            for (HandOverRecordOperationVO handOverRecordOperationVO : result) {
                handOverRecordOperationVO.setCreatorName(userNameMap.get(handOverRecordOperationVO.getCreatorId()));
                handOverRecordOperationVO.setToUserName(userNameMap.get(handOverRecordOperationVO.getToUserId()));
                handOverRecordOperationVO.setFromUserName(userNameMap.get(handOverRecordOperationVO.getFromUserId()));
            }
        }
        catch (IntegratedRuntimeException e) {
            throw new SQLException(e);
        }
        return result;
    }

    public void updatePublishedSchemaName(String schemaId, String schemaNameNew) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{schemaNameNew, schemaId};
        this.dbExcuter.execute("UPDATE T_QING_SASchema SET FSCHEMANAME = ? WHERE FID = ?", params);
    }

    public void updatePublishedSchemaUser(String schemaId, String toUserId, String owerUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{toUserId, schemaId, owerUserId};
        this.dbExcuter.execute("UPDATE T_QING_SARelation SET FUSERID = ? WHERE FSCHEMAID = ? AND FUSERID = ?", params);
    }

    public List<String> queryPublishIdsFromPushRecored(List<String> publishInfoIds) throws AbstractQingIntegratedException, SQLException {
        final ArrayList<String> result = new ArrayList<String>();
        SQLSplitHelper.split(publishInfoIds, new ISQLExcuter(){

            @Override
            public void excuter(List<?> publishIds) throws AbstractQingIntegratedException, SQLException {
                InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(publishIds.size());
                StringBuilder sql = new StringBuilder("SELECT FPUBLISHID FROM T_QING_PUSH_RECORD WHERE  ");
                sql.append(inSqlConditionBuilder.build("fpublishid"));
                List resPublishIds = (List)HandOverDao.this.dbExcuter.query(sql.toString(), publishIds.toArray(), (ResultHandler)new ResultHandler<List<String>>(){

                    public List<String> handle(ResultSet rs) throws SQLException {
                        ArrayList<String> resultPublishIds = new ArrayList<String>(10);
                        while (rs.next()) {
                            resultPublishIds.add(rs.getString("FPUBLISHID"));
                        }
                        return resultPublishIds;
                    }
                });
                result.addAll(resPublishIds);
            }
        });
        return result;
    }
}

