/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.imexport.collector.dashboard;

import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.imexport.collector.ICollectable;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;

public class DsbPictureCollector
implements ICollectable {
    @Override
    public void collect(ZipInputStream zis, String[] zipEntryPath, AbstractThemeImportModel exportThemeCollectModel) throws ImportThemeException {
        DashboardImportModel dashboardImportModel = (DashboardImportModel)exportThemeCollectModel;
        List<String> pictureFileKeys = dashboardImportModel.getFileKeys(RefTypeEnum.picture);
        if (pictureFileKeys == null) {
            pictureFileKeys = new ArrayList<String>();
            dashboardImportModel.setFileKeys(RefTypeEnum.picture, pictureFileKeys);
        }
        try {
            byte[] imageContent = ImportUtil.getBytesFromZipInputStream(zis);
            IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.UPLOAD);
            String imageFileName = qingFile.getName();
            qingFile.write((IWriteCall)new CopyWriteCall((InputStream)new ByteArrayInputStream(imageContent), false), true);
            pictureFileKeys.add(imageFileName);
        }
        catch (IOException e) {
            throw new ImportThemeException(e);
        }
    }
}

