/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.imexport.collector.util;

import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;

public class ImportUtil {
    private static ThreadLocal<Map<String, Object>> IMPORT_CACHEMAP_THREADLOCAL = new ThreadLocal();

    public static Object getImportCache(String cacheKey, Object defaultVaule) {
        Map<String, Object> cacheMap = IMPORT_CACHEMAP_THREADLOCAL.get();
        if (cacheMap == null) {
            cacheMap = new HashMap<String, Object>();
            IMPORT_CACHEMAP_THREADLOCAL.set(cacheMap);
        }
        if (cacheMap.containsKey(cacheKey)) {
            return cacheMap.get(cacheKey);
        }
        cacheMap.put(cacheKey, defaultVaule);
        return defaultVaule;
    }

    public static void clearImportCache() {
        IMPORT_CACHEMAP_THREADLOCAL.remove();
    }

    public static ByteArrayInputStream getInputStreamFromZipInputStream(ZipInputStream zipInputStream) throws IOException {
        return new ByteArrayInputStream(ImportUtil.getBytesFromZipInputStream(zipInputStream));
    }

    public static byte[] getBytesFromZipInputStream(ZipInputStream zipInputStream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = zipInputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }

    public static List<Map<String, String>> createRefMap(List<OutsideReference> outSideRef) {
        ArrayList<Map<String, String>> refInfo = new ArrayList<Map<String, String>>(outSideRef.size());
        int c = outSideRef.size();
        for (int i = 0; i < c; ++i) {
            OutsideReference refItem = outSideRef.get(i);
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("uid", refItem.getUid());
            item.put("refType", refItem.getRefType());
            item.put("refToId", refItem.getRefToId());
            item.put("fullPath", refItem.getRefToFullPath());
            refInfo.add(item);
        }
        return refInfo;
    }

    public static List<OutsideReference> createOutSideRef(List<Map<String, String>> refInfo, boolean addRefToId) {
        ArrayList<OutsideReference> outSideRefList = new ArrayList<OutsideReference>(refInfo.size());
        int c = refInfo.size();
        for (int i = 0; i < c; ++i) {
            Map<String, String> refItem = refInfo.get(i);
            OutsideReference outSideRef = new OutsideReference();
            outSideRef.setUid(refItem.get("uid"));
            outSideRef.setRefType(refItem.get("refType"));
            if (addRefToId) {
                outSideRef.setRefToId(refItem.get("refToId"));
            }
            outSideRef.setRefToFullPath(refItem.get("fullPath"));
            outSideRefList.add(outSideRef);
        }
        return outSideRefList;
    }

    public static String getFullPathWithNameSpace(String fullPath) {
        if (fullPath.contains(NameSpace.user.toPersistance())) {
            return fullPath;
        }
        if (fullPath.contains(NameSpace.system.toPersistance())) {
            return fullPath;
        }
        return NameSpace.user.toPersistance() + "/" + fullPath;
    }

    public static String getNameSpaceCode(String nameSpace) {
        return NameSpace.valueOf((String)nameSpace.substring(1, nameSpace.length() - 1)).getCode();
    }
}

