/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.imexport.model.po;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ExportThemeModel {
    private String VERSION = "20190525";
    private String id;
    private String name;
    private String description;
    private String themeType;
    private List<String> dsbRelativeTheme;
    private String nameSpace;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getThemeType() {
        return this.themeType;
    }

    public void setThemeType(String themeType) {
        this.themeType = themeType;
    }

    public void setRelativeTheme(List<String> dsbRelativeTheme) {
        this.dsbRelativeTheme = dsbRelativeTheme;
    }

    public List<String> getRelativeTheme() {
        return this.dsbRelativeTheme;
    }

    public Element toXml() {
        Element xml = new Element("Data");
        xml.setAttribute("version", this.VERSION);
        Element node = new Element("Theme");
        if (this.id != null && this.name != null) {
            node.setAttribute("id", this.id);
            node.setAttribute("name", this.name);
        }
        if (this.themeType != null) {
            node.setAttribute("themeType", this.themeType);
        }
        if (this.description != null) {
            XmlUtil.addCDATA((Element)node, (String)this.description);
        }
        if (this.dsbRelativeTheme != null) {
            node.setAttribute("dsbRelativeTheme", JsonUtil.encodeToString(this.dsbRelativeTheme));
        }
        if (this.nameSpace != null) {
            node.setAttribute("nameSpace", this.nameSpace);
        }
        xml.addContent((Content)node);
        return xml;
    }

    public void fromXml(Element xml) {
        Element node = xml.getChild("Theme");
        this.id = node.getAttributeValue("id");
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        this.name = node.getAttributeValue("name");
        this.themeType = node.getAttributeValue("themeType");
        if (this.themeType == null) {
            this.themeType = "0";
        }
        this.description = node.getText();
        String dsbRelativeTheme = node.getAttributeValue("dsbRelativeTheme");
        if (dsbRelativeTheme != null) {
            this.dsbRelativeTheme = (List)JsonUtil.decodeFromString((String)dsbRelativeTheme, List.class);
        }
        this.nameSpace = node.getAttributeValue("nameSpace");
    }

    public static ExportThemeModel parseFromZipFile(ByteArrayInputStream is, String[] zipEntryPath) throws JDOMException, IOException, ModelParseException {
        Element element = XmlUtil.loadRootElement((InputStream)is);
        ExportThemeModel themeProperty = new ExportThemeModel();
        themeProperty.fromXml(element);
        String themeName = zipEntryPath[1];
        if (themeProperty.getName() == null) {
            themeProperty.setName(themeName);
        }
        return themeProperty;
    }

    public ExportThemeVO toExportTheme() {
        ExportThemeVO exportTheme = new ExportThemeVO();
        exportTheme.setThemeType(this.themeType);
        exportTheme.setThemeName(this.name);
        return exportTheme;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }
}

