/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.map.exception.MapGroupDuplicateNameException;
import com.kingdee.bos.qing.map.model.MapModelContent;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MapDesignerDao {
    private IDBExcuter dbExcuter;

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void deleteMapContent(String mapId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Map_Content WHERE FMapId = ?", new Object[]{mapId});
    }

    public String saveMapContent(MapModelContent mapModelContent) throws AbstractQingIntegratedException, SQLException, MapGroupDuplicateNameException {
        Object[] params = new Object[9];
        String id = this.dbExcuter.genStringId("T_QING_Map_Content");
        params[0] = id;
        params[1] = mapModelContent.getMapId();
        params[2] = mapModelContent.getImageFileName();
        params[3] = mapModelContent.getMapModelFileName();
        params[4] = mapModelContent.getMapSvgFileName();
        params[5] = mapModelContent.getMapConfigFileName();
        params[6] = mapModelContent.getMapThumbnailFileName();
        params[7] = mapModelContent.getCreateDate();
        params[8] = mapModelContent.getModifyDate();
        this.dbExcuter.execute("INSERT INTO T_QING_Map_Content (FId, FMapId, FImageFileName, FModelFileName, FSvgFileName, FConfigFileName, FThumbnailFileName, FCreateDate, FModifyDate) VALUES(?,?,?,?,?,?,?,?,?)", params);
        return id;
    }

    public MapModelContent loadMapContent(String mapId) throws AbstractQingIntegratedException, SQLException {
        return (MapModelContent)this.dbExcuter.query("SELECT FId, FMapId, FImageFileName, FModelFileName, FSvgFileName, FConfigFileName, FThumbnailFileName, FCreateDate, FModifyDate FROM T_QING_Map_Content WHERE FMapId = ?", new Object[]{mapId}, (ResultHandler)new ResultHandler<MapModelContent>(){

            public MapModelContent handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    MapModelContent mapModelContent = new MapModelContent();
                    mapModelContent.setfId(rs.getString("FId"));
                    mapModelContent.setMapId(rs.getString("FMapId"));
                    mapModelContent.setImageFileName(rs.getString("FImageFileName"));
                    mapModelContent.setMapModelFileName(rs.getString("FModelFileName"));
                    mapModelContent.setMapSvgFileName(rs.getString("FSvgFileName"));
                    mapModelContent.setMapConfigFileName(rs.getString("FConfigFileName"));
                    mapModelContent.setMapThumbnailFileName(rs.getString("FThumbnailFileName"));
                    mapModelContent.setCreateDate(rs.getDate("FCreateDate"));
                    mapModelContent.setModifyDate(rs.getDate("FModifyDate"));
                    return mapModelContent;
                }
                return null;
            }
        });
    }
}

