/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.map.builder.ConfigBuilder;
import com.kingdee.bos.qing.map.builder.MapBuilder;
import com.kingdee.bos.qing.map.builder.ThumbnailBuilder;
import com.kingdee.bos.qing.map.dao.MapDesignerDao;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.designer.exception.PersistentModelParseException;
import com.kingdee.bos.qing.map.designer.model.DesigntimeMapModel;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.model.MapGroupVO;
import com.kingdee.bos.qing.map.model.MapModelContent;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.map.oplog.MapOpLog;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;
import org.jdom2.Element;

public class MapDesignerDomain {
    private static final int THUMBNAIL_WIDTH = 240;
    private static final int THUMBNAIL_HEIGHT = 180;
    private static final String THUMBNAIL_TYPE = "png";
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private MapDesignerDao mapDesignerDao;
    private MapManageDao mapManageDao;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private MapDesignerDao getMapDesignerDao() {
        if (this.mapDesignerDao == null) {
            this.mapDesignerDao = new MapDesignerDao();
            this.mapDesignerDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapDesignerDao;
    }

    private MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    private String saveImage(String imageFileName) throws MapException {
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)imageFileName);
        if (fileVisitor.exists()) {
            IQingFile file = FileFactory.newPersistentFile((QingContext)this.qingContext, null, (QingPersistentFileType)QingPersistentFileType.MAP);
            try {
                QingInputStream sis = fileVisitor.getInputStream();
                file.write((IWriteCall)new CopyWriteCall((InputStream)sis, false), true);
                return file.getName();
            }
            catch (IOException e) {
                throw new MapException(e);
            }
        }
        return null;
    }

    public String loadImage(String imageFileName) throws MapException {
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.MAP, (String)imageFileName);
        if (fileVisitor.exists()) {
            IQingFile file = FileFactory.newTempFile((QingTempFileType)QingTempFileType.UPLOAD);
            try {
                QingInputStream sis = fileVisitor.getInputStream();
                file.write((IWriteCall)new CopyWriteCall((InputStream)sis, false), true);
                return file.getName();
            }
            catch (IOException e) {
                throw new MapException(e);
            }
        }
        return null;
    }

    public DesigntimeMapModel loadMap(String mapId) throws AbstractQingIntegratedException, MapException, PersistentModelParseException {
        try {
            MapModelContent MapModelContent2 = this.getMapDesignerDao().loadMapContent(mapId);
            if (MapModelContent2 == null) {
                return null;
            }
            IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.MAP, (String)MapModelContent2.getMapModelFileName());
            DesigntimeMapModel designtimeMapModel = null;
            if (fileVisitor.exists()) {
                QingInputStream mapModel = fileVisitor.getInputStream();
                designtimeMapModel = this.byteToModel((InputStream)mapModel);
                String tempImageId = this.loadImage(MapModelContent2.getImageFileName());
                designtimeMapModel.fixBackImageIdentity(tempImageId);
            }
            return designtimeMapModel;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MapException(e);
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    public String saveFile(Element mapFileEle) throws MapException {
        IQingFile file = FileFactory.newPersistentFile((QingContext)this.qingContext, null, (QingPersistentFileType)QingPersistentFileType.MAP);
        byte[] mapFile = XmlUtil.toByteArray((Element)mapFileEle);
        try {
            ByteArrayInputStream sis = new ByteArrayInputStream(mapFile);
            file.write((IWriteCall)new CopyWriteCall((InputStream)sis, false), true);
            return file.getName();
        }
        catch (IOException e) {
            throw new MapException(e);
        }
    }

    public void saveMap(DesigntimeMapModel model, String mapId) throws AbstractQingIntegratedException, MapException {
        MapBuilder mapBuilder = new MapBuilder();
        Element svgElement = mapBuilder.buildSvg(model);
        Element configElm = ConfigBuilder.build((DesigntimeMapModel)model);
        String uploadImage = model.pickBackImageIdentity();
        String imageFileName = this.saveImage(uploadImage);
        String modelFileName = this.saveFile(model.toXml());
        String svgFileName = this.saveFile(svgElement);
        String configFileName = this.saveFile(configElm);
        String thumbnailFileName = this.createThumbnail(model, uploadImage);
        try {
            this.tx.beginRequired();
            MapModelContent oldMapModelContent = this.getMapDesignerDao().loadMapContent(mapId);
            Date createDate = new Date();
            Date modifyDate = new Date();
            if (oldMapModelContent != null) {
                createDate = oldMapModelContent.getCreateDate();
                this.deleteMapContent(mapId);
            }
            MapModelContent mapModelContent = new MapModelContent();
            mapModelContent.setImageFileName(imageFileName);
            mapModelContent.setMapModelFileName(modelFileName);
            mapModelContent.setMapSvgFileName(svgFileName);
            mapModelContent.setMapConfigFileName(configFileName);
            mapModelContent.setMapThumbnailFileName(thumbnailFileName);
            mapModelContent.setMapId(mapId);
            mapModelContent.setCreateDate(createDate);
            mapModelContent.setModifyDate(modifyDate);
            this.getMapDesignerDao().saveMapContent(mapModelContent);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
        try {
            MapVO mapVO = this.getMapManageDao().loadMap(mapId);
            MapGroupVO mapGroupVO = this.getMapManageDao().loadMapGroupById(mapVO.getMapGroupId());
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(mapVO.getMapName());
            params.add(mapGroupVO.getMapGroupName());
            MapOpLog mapDir = MapOpLog.MAP_DIR;
            mapDir.setLogScene("\u5730\u56fe");
            mapDir.setParamsDesc("\u201c$param\u201d");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)mapDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String createThumbnail(DesigntimeMapModel model, String imageFileName) throws MapException {
        ThumbnailBuilder thumbnailBuilder = new ThumbnailBuilder();
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)imageFileName);
        if (fileVisitor.exists()) {
            try {
                QingInputStream sis = fileVisitor.getInputStream();
                BufferedImage bufImg = ImageIO.read((InputStream)sis);
                thumbnailBuilder.setBackImage(bufImg);
            }
            catch (IOException e) {
                throw new MapException(e);
            }
        }
        thumbnailBuilder.setDesignModel(model);
        BufferedImage bufferedImage = thumbnailBuilder.build(240, 180);
        IQingFile file = FileFactory.newPersistentFile((QingContext)this.qingContext, null, (QingPersistentFileType)QingPersistentFileType.MAP);
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, THUMBNAIL_TYPE, bs);
            ByteArrayInputStream sis = new ByteArrayInputStream(bs.toByteArray());
            file.write((IWriteCall)new CopyWriteCall((InputStream)sis, false), true);
            return file.getName();
        }
        catch (IOException e) {
            throw new MapException(e);
        }
    }

    public MapModelContent loadMapContent(String mapId) throws AbstractQingIntegratedException, MapException {
        try {
            return this.getMapDesignerDao().loadMapContent(mapId);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    public void deleteMapContent(String mapId) throws AbstractQingIntegratedException, MapException {
        try {
            MapModelContent mapModelContent = this.getMapDesignerDao().loadMapContent(mapId);
            if (mapModelContent != null) {
                this.getMapDesignerDao().deleteMapContent(mapId);
                this.deleteFile((AbstractQingFileType)QingPersistentFileType.MAP, mapModelContent.getImageFileName());
                this.deleteFile((AbstractQingFileType)QingPersistentFileType.MAP, mapModelContent.getMapModelFileName());
                this.deleteFile((AbstractQingFileType)QingPersistentFileType.MAP, mapModelContent.getMapSvgFileName());
                this.deleteFile((AbstractQingFileType)QingPersistentFileType.MAP, mapModelContent.getMapConfigFileName());
                this.deleteFile((AbstractQingFileType)QingPersistentFileType.MAP, mapModelContent.getMapThumbnailFileName());
            }
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    private DesigntimeMapModel byteToModel(InputStream content) throws PersistentModelParseException {
        DesigntimeMapModel modelBook = new DesigntimeMapModel();
        try {
            Element xmlNode = XmlUtil.loadRootElement((InputStream)content);
            modelBook.fromXml(xmlNode);
            return modelBook;
        }
        catch (Exception e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
    }

    public void copyMapContent(String mapId, String newMapId) throws AbstractQingIntegratedException, MapException {
        try {
            MapModelContent mapModelContent = this.getMapDesignerDao().loadMapContent(mapId);
            if (mapModelContent != null) {
                Date createDate = new Date();
                String modelFileName = mapModelContent.getMapModelFileName();
                String configFileName = mapModelContent.getMapConfigFileName();
                String svgFileName = mapModelContent.getMapSvgFileName();
                String imageFileName = mapModelContent.getImageFileName();
                String thumbnailFileName = mapModelContent.getMapThumbnailFileName();
                mapModelContent.setImageFileName(this.copyFile(imageFileName));
                mapModelContent.setMapConfigFileName(this.copyFile(configFileName));
                mapModelContent.setMapSvgFileName(this.copyFile(svgFileName));
                mapModelContent.setMapModelFileName(this.copyFile(modelFileName));
                mapModelContent.setMapThumbnailFileName(this.copyFile(thumbnailFileName));
                mapModelContent.setMapId(newMapId);
                mapModelContent.setCreateDate(createDate);
                mapModelContent.setModifyDate(createDate);
                this.getMapDesignerDao().saveMapContent(mapModelContent);
            }
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    private String copyFile(String fileName) throws MapException {
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.MAP, (String)fileName);
        IQingFile file = FileFactory.newPersistentFile((QingContext)this.qingContext, null, (QingPersistentFileType)QingPersistentFileType.MAP);
        if (fileVisitor.exists()) {
            try {
                QingInputStream sis = fileVisitor.getInputStream();
                file.write((IWriteCall)new CopyWriteCall((InputStream)sis, false), true);
                return file.getName();
            }
            catch (IOException e) {
                throw new MapException(e);
            }
        }
        return null;
    }

    public String importMapFile(String fileName) throws MapException {
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileName);
        if (fileVisitor.exists()) {
            IQingFile file = FileFactory.newPersistentFile((QingContext)this.qingContext, null, (QingPersistentFileType)QingPersistentFileType.MAP);
            try {
                QingInputStream sis = fileVisitor.getInputStream();
                file.write((IWriteCall)new CopyWriteCall((InputStream)sis, false), true);
                this.deleteFile((AbstractQingFileType)QingTempFileType.UPLOAD, fileName);
                return file.getName();
            }
            catch (IOException e) {
                throw new MapException(e);
            }
        }
        return null;
    }

    private void deleteFile(AbstractQingFileType fileType, String fileName) {
        IQingFileUpdater file = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)fileType, (String)fileName);
        if (file.exists()) {
            file.delete();
        }
    }
}

