/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.map.MapRefUpdater;
import com.kingdee.bos.qing.map.MapRefUpdaterFactory;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.domain.MapDesignerDomain;
import com.kingdee.bos.qing.map.exception.MapDuplicateNameException;
import com.kingdee.bos.qing.map.exception.MapEmptyException;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.exception.MapGroupCanNotNo;
import com.kingdee.bos.qing.map.exception.MapGroupDuplicateNameException;
import com.kingdee.bos.qing.map.exception.MapGroupNotEmptyException;
import com.kingdee.bos.qing.map.exception.MapNotFoundException;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.map.model.MapGroupPO;
import com.kingdee.bos.qing.map.model.MapGroupVO;
import com.kingdee.bos.qing.map.model.MapModelContent;
import com.kingdee.bos.qing.map.model.MapPO;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.map.oplog.MapOpLog;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.preset.domain.PresetManageDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.NameUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class MapManageDomain {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private MapManageDao mapManageDao;
    private MapDesignerDomain mapDesignerDomain;
    private IScheduleEngine scheduleEngine;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    private List<MapRefUpdater> getAllMapRefUpdater() {
        return MapRefUpdaterFactory.getAllMapRefUpdater(this.dbExcuter);
    }

    private MapDesignerDomain getMapDesignerDomain() {
        if (this.mapDesignerDomain == null) {
            this.mapDesignerDomain = new MapDesignerDomain();
            this.mapDesignerDomain.setDbExcuter(this.dbExcuter);
            this.mapDesignerDomain.setTx(this.tx);
            this.mapDesignerDomain.setQingContext(this.qingContext);
        }
        return this.mapDesignerDomain;
    }

    public String saveMapGroupWithoutTx(MapGroupVO mapGroupVO) throws AbstractQingIntegratedException, SQLException, MapGroupDuplicateNameException {
        MapGroupPO mapGroupPO = mapGroupVO.toMapGroupPO();
        mapGroupPO.setCreatorId(this.qingContext.getUserId());
        mapGroupPO.setUpdaterId(this.qingContext.getUserId());
        NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
        mapGroupPO.setNameSpace(nameSpace);
        return this.getMapManageDao().saveMapGroup(mapGroupPO);
    }

    public String saveMapGroup(MapGroupVO mapGroupVO) throws AbstractQingIntegratedException, MapException {
        String id;
        try {
            this.tx.beginRequired();
            id = this.saveMapGroupWithoutTx(mapGroupVO);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (MapGroupDuplicateNameException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(mapGroupVO.getMapGroupName());
        MapOpLog emptyDir = MapOpLog.EMPTY_DIR;
        emptyDir.setLogScene("\u5730\u56fe\u5e93\u5206\u7c7b");
        emptyDir.setParamsDesc("\u201c$param\u201d");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.NEW, (IOpLogConstant)emptyDir, params));
        return id;
    }

    public MapGroupVO loadMapGroupByName(String mapGroupName) throws AbstractQingIntegratedException, MapException {
        try {
            NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
            return this.getMapManageDao().loadMapGroupByName(mapGroupName, nameSpace.getCode());
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    public List<MapGroupVO> loadAllMapGroupList() throws AbstractQingIntegratedException, MapException {
        try {
            PresetManageDomain presetManageDomain = new PresetManageDomain();
            presetManageDomain.setTx(this.tx);
            presetManageDomain.setDbExcuter(this.dbExcuter);
            presetManageDomain.setQingContext(this.qingContext);
            presetManageDomain.setScheduleEngine(this.scheduleEngine);
            presetManageDomain.importFiles();
        }
        catch (Exception e) {
            LogUtil.error((String)"listMapGroup presetImportFiles error", (Throwable)e);
        }
        try {
            List<MapGroupVO> systemMapGroups = this.getMapManageDao().loadMapGroupList(NameSpace.system.getCode());
            List<MapGroupVO> userOwnMapGroups = this.getMapManageDao().loadMapGroupList(NameSpace.user.getCode());
            if (userOwnMapGroups != null && userOwnMapGroups.isEmpty()) {
                MapGroupVO mapGroupVO = this.notGroupAddDefaultGroup();
                userOwnMapGroups.add(mapGroupVO);
            }
            systemMapGroups.addAll(userOwnMapGroups);
            return systemMapGroups;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    public List<MapGroupVO> loadMapGroupList() throws AbstractQingIntegratedException, MapException {
        try {
            List<MapGroupVO> userOwnMapGroups = this.getMapManageDao().loadMapGroupList(NameSpace.user.getCode());
            if (userOwnMapGroups != null && userOwnMapGroups.isEmpty()) {
                MapGroupVO mapGroupVO = this.notGroupAddDefaultGroup();
                userOwnMapGroups.add(mapGroupVO);
            }
            return userOwnMapGroups;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    private MapGroupVO notGroupAddDefaultGroup() throws AbstractQingIntegratedException, MapException {
        String groupName = Messages.getMLS((QingContext)this.qingContext, (String)"defaultGroupName", (String)"\u9ed8\u8ba4\u5206\u7c7b", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
        MapGroupPO newMapGroup = new MapGroupPO();
        newMapGroup.setMapGroupName(groupName);
        newMapGroup.setCreatorId(this.qingContext.getUserId());
        newMapGroup.setUpdaterId(this.qingContext.getUserId());
        try {
            this.tx.beginRequired();
            NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
            newMapGroup.setNameSpace(nameSpace);
            String id = this.getMapManageDao().saveMapGroup(newMapGroup);
            newMapGroup.setMapGroupId(id);
            MapGroupVO mapGroupVO = newMapGroup.toMapGroupVO();
            return mapGroupVO;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (MapGroupDuplicateNameException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public List<MapGroupVO> loadMapGroupListForMoveMap(String mapGroupId) throws AbstractQingIntegratedException, MapException {
        try {
            this.tx.beginRequired();
            List<MapGroupVO> list = this.getMapManageDao().loadMapGroupListForMoveMap(mapGroupId, NameSpace.user.getCode());
            return list;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMapGroup(String mapGroupId, String mapGroupName) throws AbstractQingIntegratedException, MapException {
        String oldName = null;
        try {
            this.tx.beginRequired();
            MapGroupVO mapGroupVO = this.getMapManageDao().loadMapGroupById(mapGroupId);
            if (mapGroupVO != null) {
                oldName = mapGroupVO.getMapGroupName();
            }
            String userId = this.qingContext.getUserId();
            NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
            this.getMapManageDao().updateMapGroup(mapGroupId, mapGroupName, userId, nameSpace.getCode());
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (MapGroupDuplicateNameException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
        try {
            this.tx.beginRequired();
            List<MapVO> mapList = this.loadMapList(mapGroupId);
            for (int i = 0; i < mapList.size(); ++i) {
                MapVO mapVO = mapList.get(i);
                MapGroupVO mapGroupVO = new MapGroupVO();
                mapGroupVO.setMapGroupName(mapGroupName);
                this.updateRefToIdWithoutTx(mapGroupVO, mapVO.toMapPO());
            }
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(oldName);
        params.add(mapGroupName);
        MapOpLog emptyDir = MapOpLog.EMPTY_DIR;
        emptyDir.setLogScene("\u5730\u56fe\u5e93\u5206\u7c7b");
        emptyDir.setParamsDesc("\u201c$param\u201d\u540d\u79f0\u4e3a\u201c$param\u201d");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)emptyDir, params));
    }

    public void deleteMapGroup(String mapGroupId) throws AbstractQingIntegratedException, MapException {
        List<MapVO> mapList = this.loadMapList(mapGroupId);
        List<MapGroupVO> mapGroupList = this.loadMapGroupList();
        if (mapList.size() > 0) {
            throw new MapGroupNotEmptyException();
        }
        if (mapGroupList.size() == 1) {
            throw new MapGroupCanNotNo();
        }
        MapGroupVO mapGroup = null;
        for (MapGroupVO mapGroupVO : mapGroupList) {
            if (!mapGroupId.equals(mapGroupVO.getMapGroupId())) continue;
            mapGroup = mapGroupVO;
            break;
        }
        try {
            this.tx.beginRequired();
            this.getMapManageDao().deleteMapGroup(mapGroupId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
        if (mapGroup != null) {
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(mapGroup.getMapGroupName());
            MapOpLog emptyDir = MapOpLog.EMPTY_DIR;
            emptyDir.setLogScene("\u5730\u56fe\u5e93\u5206\u7c7b");
            emptyDir.setParamsDesc("\u201c$param\u201d");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)emptyDir, params));
        }
    }

    public void saveOrUpdateMap(MapVO mapVO) throws AbstractQingIntegratedException, MapException {
        if (mapVO.getMapId() == null) {
            this.saveMap(mapVO);
        } else {
            this.updateMap(mapVO);
        }
    }

    private void saveMap(MapVO mapVO) throws AbstractQingIntegratedException, MapException {
        MapGroupVO mapGroupVO;
        MapPO mapPO = mapVO.toMapPO();
        try {
            this.tx.beginRequired();
            mapGroupVO = this.getMapManageDao().loadMapGroupById(mapPO.getMapGroupId());
            String userId = this.qingContext.getUserId();
            Date createDate = new Date();
            mapPO.setMapCreateDate(createDate);
            mapPO.setCreatorId(userId);
            mapPO.setUpdaterId(userId);
            NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
            mapPO.setNameSpace(nameSpace);
            String mapId = this.getMapManageDao().saveMap(mapPO);
            mapVO.setMapId(mapId);
            mapVO.setCreateDate(createDate);
            mapVO.setMapModifyDate(createDate);
            mapPO.setMapId(mapId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (MapDuplicateNameException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
        this.updateRefWithMapId(mapPO, mapGroupVO);
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(mapPO.getMapName());
        params.add(mapGroupVO.getMapGroupName());
        MapOpLog mapDir = MapOpLog.MAP_DIR;
        mapDir.setLogScene("\u5730\u56fe");
        mapDir.setParamsDesc("\u201c$param\u201d");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.NEW, (IOpLogConstant)mapDir, params));
    }

    private void updateMap(MapVO mapVO) throws AbstractQingIntegratedException, MapException {
        MapVO oldMapVO;
        MapGroupVO mapGroupVO;
        MapPO mapPO = mapVO.toMapPO();
        try {
            this.tx.beginRequired();
            mapGroupVO = this.getMapManageDao().loadMapGroupById(mapPO.getMapGroupId());
            oldMapVO = this.getMapManageDao().loadMap(mapPO.getMapId());
            String userId = this.qingContext.getUserId();
            Date modifyDate = new Date();
            mapVO.setMapModifyDate(modifyDate);
            mapPO.setUpdaterId(userId);
            mapPO.setMapModifyDate(modifyDate);
            NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
            mapPO.setNameSpace(nameSpace);
            this.getMapManageDao().checkMapNameAndUpdateMap(mapPO);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (MapDuplicateNameException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
        this.updateRefWithMapId(mapPO, mapGroupVO);
        ArrayList<String> params = new ArrayList<String>(3);
        MapOpLog mapDir = MapOpLog.MAP_DIR;
        mapDir.setLogScene("\u5730\u56fe");
        mapDir.setParamsDesc("\u201c$param\u201d");
        if (!mapVO.getMapName().equals(oldMapVO.getMapName())) {
            mapDir.setParamsDesc("\u201c$param\u201d\u540d\u79f0\u4e3a\u201c$param\u201d");
            params.add(oldMapVO.getMapName());
        }
        params.add(mapVO.getMapName());
        params.add(mapGroupVO.getMapGroupName());
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)mapDir, params));
    }

    public void deleteMap(MapVO mapVO) throws AbstractQingIntegratedException, MapException {
        MapGroupVO mapGroupVO;
        MapPO mapPO = mapVO.toMapPO();
        try {
            this.tx.beginRequired();
            mapGroupVO = this.getMapManageDao().loadMapGroupById(mapPO.getMapGroupId());
            this.getMapManageDao().deteteMap(mapPO);
            this.getMapDesignerDomain().deleteMapContent(mapVO.getMapId());
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
        this.updateMapRefFullPath(mapPO, mapGroupVO);
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(mapPO.getMapName());
        if (mapGroupVO != null) {
            params.add(mapGroupVO.getMapGroupName());
        }
        MapOpLog mapDir = MapOpLog.MAP_DIR;
        mapDir.setLogScene("\u5730\u56fe");
        mapDir.setParamsDesc("\u201c$param\u201d");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)mapDir, params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMapRefFullPath(MapPO mapPO, MapGroupVO mapGroupVO) {
        try {
            this.tx.beginRequired();
            if (mapGroupVO != null) {
                PathModel pathModel = new PathModel();
                pathModel.setNameSpace(mapPO.getNameSpace().toPersistance());
                pathModel.setGroupName(mapGroupVO.getMapGroupName());
                pathModel.setName(mapPO.getMapName());
                String mapId = mapPO.getMapId();
                List<MapRefUpdater> mapRefUpdaters = this.getAllMapRefUpdater();
                for (int i = 0; i < mapRefUpdaters.size(); ++i) {
                    MapRefUpdater mapRefUpdater = mapRefUpdaters.get(i);
                    mapRefUpdater.updateMapFullPathOfRefWithoutTx(mapId, JsonUtil.encodeToString((Object)pathModel));
                }
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            LogUtil.error((String)"update map ref fullPath error");
        }
        finally {
            this.tx.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRefWithMapId(MapPO mapPO, MapGroupVO mapGroupVO) {
        try {
            this.tx.beginRequired();
            this.updateRefToIdWithoutTx(mapGroupVO, mapPO);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            LogUtil.error((String)"update refToId error", (Throwable)e);
        }
        finally {
            this.tx.end();
        }
    }

    public void updateRefToIdWithoutTx(MapGroupVO mapGroupVO, MapPO mapPO) {
        if (mapGroupVO != null) {
            String mapPath = mapPO.getNameSpace().toPersistance() + "/" + mapGroupVO.getMapGroupName() + "/" + mapPO.getMapName();
            PathModel pathModel = new PathModel();
            pathModel.setNameSpace(mapPO.getNameSpace().toPersistance());
            pathModel.setGroupName(mapGroupVO.getMapGroupName());
            pathModel.setName(mapPO.getMapName());
            String mapId = mapPO.getMapId();
            List<MapRefUpdater> mapRefUpdaters = this.getAllMapRefUpdater();
            for (int i = 0; i < mapRefUpdaters.size(); ++i) {
                MapRefUpdater mapRefUpdater = mapRefUpdaters.get(i);
                mapRefUpdater.updateMapIdOfRefWithoutTx(mapId, mapPath);
                mapRefUpdater.updateMapIdOfRefWithoutTx(mapId, JsonUtil.encodeToString((Object)pathModel));
            }
        }
    }

    public List<MapVO> loadMapList(String mapGroupId) throws AbstractQingIntegratedException, MapException {
        try {
            return this.getMapManageDao().loadMapList(mapGroupId);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    public void moveMap(MapVO mapVO, String newMapGroupId) throws AbstractQingIntegratedException, MapException {
        try {
            this.tx.beginRequired();
            MapPO mapPO = mapVO.toMapPO();
            NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
            mapPO.setNameSpace(nameSpace);
            this.getMapManageDao().moveMap(mapPO, newMapGroupId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (MapDuplicateNameException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
        try {
            MapGroupVO oldMapGroup = this.getMapManageDao().loadMapGroupById(mapVO.getMapGroupId());
            MapGroupVO newMapGroup = this.getMapManageDao().loadMapGroupById(newMapGroupId);
            if (oldMapGroup != null && newMapGroup != null) {
                ArrayList<String> params = new ArrayList<String>(2);
                params.add(mapVO.getMapName());
                params.add(oldMapGroup.getMapGroupName());
                params.add(newMapGroup.getMapGroupName());
                MapOpLog emptyDir = MapOpLog.EMPTY_DIR;
                emptyDir.setParamsDesc("\u201c$param\u201d\u7531\u201c$param\u201d\u5230\u201c$param\u201d");
                OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.MOVE, (IOpLogConstant)emptyDir, params));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MapVO copyMap(MapVO mapVO, String newMapGroupId, String mapName) throws AbstractQingIntegratedException, MapException {
        MapGroupVO mapGroupVO;
        MapPO mapPO = new MapPO();
        try {
            this.tx.beginRequired();
            mapGroupVO = this.getMapManageDao().loadMapGroupById(newMapGroupId);
            String userId = this.qingContext.getUserId();
            Date createDate = new Date();
            NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
            mapPO.setMapDescription(mapVO.getMapDescription());
            mapPO.setMapName(mapName);
            mapPO.setMapGroupId(newMapGroupId);
            mapPO.setMapCreateDate(createDate);
            mapPO.setMapModifyDate(createDate);
            mapPO.setMapType(mapVO.getMapType());
            mapPO.setCreatorId(userId);
            mapPO.setUpdaterId(userId);
            mapPO.setNameSpace(nameSpace);
            String mapId = this.getMapManageDao().saveMap(mapPO);
            mapPO.setMapId(mapId);
            this.getMapDesignerDomain().copyMapContent(mapVO.getMapId(), mapId);
            mapVO.setMapId(mapId);
            mapVO.setMapName(mapName);
            mapVO.setCreateDate(createDate);
            mapVO.setMapGroupId(newMapGroupId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (MapDuplicateNameException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
        this.updateRefWithMapId(mapPO, mapGroupVO);
        try {
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(mapPO.getMapName());
            params.add(mapGroupVO.getMapGroupName());
            MapOpLog mapDir = MapOpLog.MAP_DIR;
            mapDir.setLogScene("\u5730\u56fe");
            mapDir.setParamsDesc("\u201c$param\u201d");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.NEW, (IOpLogConstant)mapDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mapVO;
    }

    public Map<String, Object> loadMapGroupWithSelectedMap(String refToId) throws MapException, AbstractQingIntegratedException {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            List<MapGroupVO> mapGroupVO = this.loadAllMapGroupList();
            MapVO mapVO = this.getMapManageDao().loadMap(refToId);
            result.put("mapGroup", mapGroupVO);
            result.put("selectedMap", mapVO);
            return result;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    public OutsideReference getOutsideReference(MapVO mapVO, String mapGroupName) throws AbstractQingIntegratedException, MapException {
        try {
            MapVO vo = this.getMapManageDao().loadMap(mapVO.getMapId());
            if (vo.getMapId() == null) {
                throw new MapNotFoundException();
            }
            MapModelContent mapModelContent = this.getMapDesignerDomain().loadMapContent(mapVO.getMapId());
            if (mapModelContent == null) {
                throw new MapEmptyException();
            }
            String fullPath = mapGroupName + "/" + mapVO.getMapName();
            OutsideReference outerRefer = new OutsideReference();
            String uid = UUID.randomUUID().toString();
            outerRefer.setRefToFullPath(fullPath);
            outerRefer.setRefName(mapVO.getMapName());
            outerRefer.setRefToId(mapVO.getMapId());
            outerRefer.setRefType("Map");
            outerRefer.setUid(uid);
            return outerRefer;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    public MapVO loadMapByNameAndGroupId(String mapGroupId, String mapName, String mapType) throws AbstractQingIntegratedException, MapException {
        try {
            return this.getMapManageDao().loadMapByNameAndGroupId(mapGroupId, mapName, mapType);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    public ExportMapModel loadMapWithGroupNameById(String mapId) throws AbstractQingIntegratedException, MapException {
        try {
            return this.getMapManageDao().loadMapWithGroupName(mapId);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new MapException(e);
        }
    }

    public void exportMap(String mapFolderPath, ExportMapModel exportMapVO, ZipOutputStream zos) throws AbstractQingIntegratedException, MapException, IOException {
        String monolayerMapFolderPath = mapFolderPath + File.separator + "map";
        if (!NameUtil.isFileNameAccept((String)exportMapVO.getMapName())) {
            String exportMapFolderUuid = UUID.randomUUID().toString();
            exportMapVO.setMapFloderUuid(exportMapFolderUuid);
            monolayerMapFolderPath = monolayerMapFolderPath + File.separator + exportMapFolderUuid;
        } else {
            monolayerMapFolderPath = monolayerMapFolderPath + File.separator + exportMapVO.getMapName();
        }
        Element mapPropertyElement = exportMapVO.toXml();
        String mapPropertyPath = monolayerMapFolderPath + File.separator + "qing-map.xml";
        zos.putNextEntry(new ZipEntry(mapPropertyPath));
        XmlUtil.save((Element)mapPropertyElement, (OutputStream)zos);
        MapModelContent mapModelContent = this.getMapDesignerDomain().loadMapContent(exportMapVO.getMapId());
        if (mapModelContent != null) {
            String backgroundImageXmlPath = monolayerMapFolderPath + File.separator + "qing-map-background-image";
            String modelXmlPath = monolayerMapFolderPath + File.separator + "qing-map-model.xml";
            String svgXmlPath = monolayerMapFolderPath + File.separator + "qing-map-svg.xml";
            String configXmlPath = monolayerMapFolderPath + File.separator + "qing-map-config.xml";
            String thumbnailPath = monolayerMapFolderPath + File.separator + "qing-map-thumbnail";
            if (mapModelContent.getImageFileName() != null) {
                this.writeMapModelContent(backgroundImageXmlPath, mapModelContent.getImageFileName(), zos);
            }
            this.writeMapModelContent(modelXmlPath, mapModelContent.getMapModelFileName(), zos);
            this.writeMapModelContent(svgXmlPath, mapModelContent.getMapSvgFileName(), zos);
            this.writeMapModelContent(configXmlPath, mapModelContent.getMapConfigFileName(), zos);
            this.writeMapModelContent(thumbnailPath, mapModelContent.getMapThumbnailFileName(), zos);
        }
    }

    private void writeMapModelContent(String path, String fileName, ZipOutputStream zos) throws IOException {
        QingInputStream inputStream = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.MAP, (String)fileName).getInputStream();
        zos.putNextEntry(new ZipEntry(path));
        IOUtil.copy((InputStream)inputStream, (OutputStream)zos);
    }

    public void cleanEmptyGroupByUserId(String presetUserId) throws MapException {
        try {
            this.tx.beginRequired();
            this.getMapManageDao().cleanEmptyGroupByUserId(presetUserId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new MapException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public ExportMapModel loadMapByNameAndGroupName(String mapGroupName, String mapName, String nameSpace) throws AbstractQingIntegratedException, SQLException {
        return this.getMapManageDao().loadMapByNameAndGroupName(mapGroupName, mapName, nameSpace);
    }
}

