/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.cache;

import com.kingdee.bos.qing.util.LogUtil;
import java.util.List;

public class Pager {
    private int pageSize;
    private long currentPageNumber = 0L;
    private boolean hasData = true;
    private List<Object[]> data;

    public Pager() {
        try {
            this.pageSize = Integer.parseInt(System.getProperty("qing.form.pagesize", "1000"));
            LogUtil.info((String)("form.pagesize:" + this.pageSize));
        }
        catch (Exception e) {
            LogUtil.info((String)"Warming qing.form.pagesize config error. form.pagesize:1000");
            this.pageSize = 1000;
        }
    }

    public void setData(List<Object[]> data) {
        this.data = data;
        this.hasData = null != data && data.size() > 0;
    }

    public List<Object[]> getData() {
        return this.data;
    }

    public long getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setCurrentPageNumber(long currentPageNumber) {
        this.currentPageNumber = currentPageNumber;
    }

    public long getNextPageNumber() {
        if (this.currentPageNumber <= 0L) {
            return 1L;
        }
        return this.currentPageNumber + 1L;
    }

    public boolean hasData() {
        return this.hasData;
    }
}

