/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.timingpush;

import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PublishedNotExistPrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.timingpush.TimingPushPrepareDataContext;
import com.kingdee.bos.qing.preparedata.handler.timingpush.source.TimingPushSourcePrepareDataHandlerFactory;
import com.kingdee.bos.qing.preparedata.handler.timingpush.source.impl.AbstractTimingPushSourcePrepareDataHandler;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.exception.PublishNoPermissionException;
import com.kingdee.bos.qing.publish.exception.PublishSourcePublishNotExistException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.TimingPushBillPO;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import java.sql.SQLException;

public abstract class AbstractTimingPushPrepareDataHandler
extends AbstractPrepareDataHandler {
    private CommonPublishDomain commonPublishDomain;

    public AbstractTimingPushPrepareDataHandler(IPrepareDataContext extractContext) {
        super(extractContext);
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.getPrepareContext().getQingContext(), this.getPrepareContext().getTransManagement(), this.getPrepareContext().getDBExecuter());
        }
        return this.commonPublishDomain;
    }

    public abstract TimingPushBillPO getBillPO(String var1) throws SQLException, AbstractQingIntegratedException;

    public abstract void closeSchedule(String var1) throws SQLException, AbstractQingIntegratedException, ScheduleEngineException;

    protected void createCommonDataSource(PublishSourceEnum publishSourceEnum, String tag, String bizTag, String sourceId, int sourceType, String creatorId) throws PrepareDataException {
        try {
            if (PublishUtil.isPublish((String)bizTag)) {
                bizTag = this.checkPublishPermissionAndGetSourceBizTag(sourceId, bizTag);
            }
            TimingPushPrepareDataContext timingPushPrepareDataContext = (TimingPushPrepareDataContext)this.getPrepareContext();
            AbstractTimingPushSourcePrepareDataHandler handler = TimingPushSourcePrepareDataHandlerFactory.createHandler(publishSourceEnum, timingPushPrepareDataContext);
            handler.createTimingPushDataSource(tag, sourceId, sourceType, bizTag, creatorId, this);
        }
        catch (PublishSourcePublishNotExistException e) {
            throw new PublishedNotExistPrepareDataException(e);
        }
        catch (PublishNoPermissionException e) {
            throw new PublishedNotExistPrepareDataException(e);
        }
        catch (PrepareDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrepareDataException(e);
        }
    }

    private String checkPublishPermissionAndGetSourceBizTag(String sourceId, String bizTag) throws AbstractQingIntegratedException, SQLException, ScheduleEngineException, PublishSourcePublishNotExistException, PublishNoPermissionException {
        PublishPO originalPublishInfo = this.getCommonPublishDomain().loadPublishInfo(bizTag);
        if (originalPublishInfo != null) {
            try {
                this.getCommonPublishDomain().checkRightAndReturnIsAnonymous(originalPublishInfo);
            }
            catch (PublishNoPermissionException e) {
                this.closeSchedule(sourceId);
                throw e;
            }
            bizTag = originalPublishInfo.getTagId();
            return bizTag;
        }
        this.closeSchedule(sourceId);
        throw new PublishSourcePublishNotExistException();
    }
}

