/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.timingpush;

import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.timingpush.AbstractTimingPushPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.timingpush.TimingPushPrepareDataContext;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.TimingPushBillPO;
import com.kingdee.bos.qing.publish.target.email.domain.EmailBillManageDomain;
import com.kingdee.bos.qing.publish.target.email.domain.EmailConfigScheduleExecuteDomain;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import java.sql.SQLException;

public class EmailTimingPushPrepareDataHandler
extends AbstractTimingPushPrepareDataHandler {
    private EmailBillManageDomain emailBillManageDomain;
    private EmailConfigScheduleExecuteDomain emailConfigScheduleExecuteDomain;

    public EmailTimingPushPrepareDataHandler(IPrepareDataContext extractContext) {
        super(extractContext);
    }

    private EmailBillManageDomain getEmailBillManageDomain() {
        if (this.emailBillManageDomain == null) {
            this.emailBillManageDomain = new EmailBillManageDomain(this.getPrepareContext().getQingContext(), this.getPrepareContext().getTransManagement(), this.getPrepareContext().getDBExecuter());
        }
        return this.emailBillManageDomain;
    }

    private EmailConfigScheduleExecuteDomain getEmailConfigScheduleExecuteDomain() {
        if (this.emailConfigScheduleExecuteDomain == null) {
            this.emailConfigScheduleExecuteDomain = new EmailConfigScheduleExecuteDomain(this.getPrepareContext().getQingContext(), this.getPrepareContext().getTransManagement(), this.getPrepareContext().getDBExecuter(), this.getPrepareContext().getScheduleEngine());
        }
        return this.emailConfigScheduleExecuteDomain;
    }

    @Override
    public void createDataSource() throws PrepareDataException {
        String tag = this.getPrepareContext().getTag();
        TimingPushPrepareDataContext timingPushPrepareDataContext = (TimingPushPrepareDataContext)this.getPrepareContext();
        String emailConfigId = timingPushPrepareDataContext.getConfigId();
        EmailConfig emailConfig = null;
        try {
            emailConfig = this.getEmailConfigScheduleExecuteDomain().getEmailConfigById(emailConfigId);
        }
        catch (AbstractQingIntegratedException e) {
            throw new PrepareDataException("get config error", e);
        }
        catch (SQLException e) {
            throw new PrepareDataException("get config error", e);
        }
        PublishSourceEnum publishSourceEnum = emailConfig.getPublishSourceType();
        this.createCommonDataSource(publishSourceEnum, tag, emailConfig.getTagId(), emailConfig.getId(), 6, emailConfig.getUserId());
    }

    @Override
    public TimingPushBillPO getBillPO(String configId) throws SQLException, AbstractQingIntegratedException {
        return this.getEmailBillManageDomain().loadBillInfo(configId);
    }

    @Override
    public void closeSchedule(String configId) throws AbstractQingIntegratedException, SQLException, ScheduleEngineException {
        this.getEmailConfigScheduleExecuteDomain().closeSchedule(configId);
    }
}

