/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.timingpush.source.impl;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogCache;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.preparedata.exception.DsbNotFoundPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.TimingPushEncryptedLicenseException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.timingpush.AbstractTimingPushPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.timingpush.TimingPushPrepareDataContext;
import com.kingdee.bos.qing.preparedata.handler.timingpush.source.impl.AbstractTimingPushSourcePrepareDataHandler;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.publish.target.dsbtimingpush.dao.DsbTimingPushDao;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.subject.domain.SubjectRuntimeDomain;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DsbTimingPushSourcePrepareDataHandler
extends AbstractTimingPushSourcePrepareDataHandler {
    private DsbTimingPushDao dsbTimingPushDao;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;
    private SubjectRuntimeDomain subjectDomain;

    public DsbTimingPushSourcePrepareDataHandler(TimingPushPrepareDataContext prepareContext) {
        super(prepareContext);
    }

    private DsbTimingPushDao getDsbTimingPushDao() {
        if (this.dsbTimingPushDao == null) {
            this.dsbTimingPushDao = new DsbTimingPushDao(this.prepareContext.getDBExecuter());
        }
        return this.dsbTimingPushDao;
    }

    private SubjectRuntimeDomain getSubjectDomain() {
        if (this.subjectDomain == null) {
            this.subjectDomain = new SubjectRuntimeDomain(this.prepareContext.getQingContext(), this.prepareContext.getTransManagement(), this.prepareContext.getDBExecuter());
        }
        return this.subjectDomain;
    }

    private IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new HashMap<RefTypeEnum, IRefHandler>();
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.prepareContext.getDBExecuter(), this.prepareContext.getQingContext(), this.prepareContext.getTransManagement());
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    @Override
    public void createTimingPushDataSource(String tag, String sourceId, int sourceType, String bizTag, String creatorId, AbstractTimingPushPrepareDataHandler abstractTimingPushPrepareDataHandler) throws AbstractQingException {
        String refType;
        HashMap<String, ReferenceMap> refPrepareDataTagMap = new HashMap<String, ReferenceMap>();
        try {
            ThemePO themePO = this.getSubjectDomain().getThemeByID(bizTag);
            if (themePO == null) {
                try {
                    abstractTimingPushPrepareDataHandler.closeSchedule(sourceId);
                }
                catch (ScheduleEngineException e) {
                    throw new PrepareDataException(e);
                }
                throw new DsbNotFoundPrepareDataException();
            }
            List<ReferenceMap> referenceMapList = this.getDsbTimingPushDao().getRefList(sourceId, sourceType);
            for (ReferenceMap referenceMap : referenceMapList) {
                String refTag;
                refType = referenceMap.getRefType();
                RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
                IRefHandler refHandler = this.getRefHandler(refTypeEnum);
                if (!(refHandler instanceof IPrepareDataable) || (refTag = ((IPrepareDataable)((Object)refHandler)).getPrepareDataTag(tag, referenceMap.getRefToId())) == null) continue;
                refPrepareDataTagMap.put(refTag, referenceMap);
            }
        }
        catch (SQLException e) {
            throw new PrepareDataException(e);
        }
        for (Map.Entry refTagEntry : refPrepareDataTagMap.entrySet()) {
            ReferenceMap referenceMap;
            Object exception = null;
            referenceMap = (ReferenceMap)refPrepareDataTagMap.get(refTagEntry.getKey());
            refType = referenceMap.getRefType();
            String refToId = referenceMap.getRefToId();
            RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
            IRefHandler refHandler = this.getRefHandler(refTypeEnum);
            if (!(refHandler instanceof IPrepareDataable)) continue;
            IPrepareDataable refPrepareDataHandler = (IPrepareDataable)((Object)refHandler);
            IPrepareDataContext prepareDataContext = refPrepareDataHandler.getDataPrepareContext((String)refTagEntry.getKey(), refToId, true, false, null);
            AbstractPrepareDataHandler prepareDataHandler = refPrepareDataHandler.getDataPrepareHandler(prepareDataContext);
            try {
                prepareDataHandler.createDataSource();
            }
            catch (PrepareDataException e) {
                exception = e;
            }
            if (exception == null) {
                exception = prepareDataContext.getException();
            }
            if (exception == null) continue;
            if (exception instanceof AbstractQingException) {
                AbstractQingException prepareException = (AbstractQingException)((Object)exception);
                EncryptedLicenseCheckException encryptedException = new EncryptedLicenseCheckException("EncryptedLicenseCheckError");
                if (encryptedException.getErrorCode() == prepareException.getErrorCode()) {
                    String errorMsg = Messages.getMLS((QingContext)QingContext.getCurrent(), (String)"timingPushDataError", (String)"\u5b9a\u65f6\u63a8\u9001\u6570\u636e\u5931\u8d25", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
                    TimingPushEncryptedLicenseException timingPushException = new TimingPushEncryptedLicenseException(errorMsg + "," + ((Throwable)exception).getMessage(), 2101017);
                    exception = timingPushException;
                }
            }
            LogUtil.error((String)("dsb ref prepare data error, sourceId:" + sourceId + ", sourceType:" + sourceType + ", refUid:" + referenceMap.getUid()), (Throwable)exception);
            ExceptionLogCache exceptionLogCache = new ExceptionLogCache();
            exceptionLogCache.bindException((Throwable)exception);
            exceptionLogCache.setTag((String)refTagEntry.getKey());
            QingSessionUtil.setCache((ISessionCacheable)exceptionLogCache);
        }
    }
}

