/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preset.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingEncryptedStreamUtil;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imagelibrary.domian.ImageLibraryDomain;
import com.kingdee.bos.qing.imexport.importer.pkg.domain.ImportPKGDomain;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.manage.domain.ThemeGroupDomain;
import com.kingdee.bos.qing.manage.domain.impl.ThemeMangeDomainFactory;
import com.kingdee.bos.qing.manage.exception.ThemeGroupNotEmptyException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.domain.ImExportDomain;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.domain.MapManageDomain;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.imexport.MapImExportDomain;
import com.kingdee.bos.qing.map.imexport.exception.ImExportException;
import com.kingdee.bos.qing.preset.dao.PresetManageDao;
import com.kingdee.bos.qing.preset.strategy.IQingPresetStrategy;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.analysiscenter.domain.AnalysisCenterManageDomain;
import com.kingdee.bos.qing.publish.target.card.domain.AbstractCardManageDomain;
import com.kingdee.bos.qing.publish.target.card.domain.CardRuntimeDomain;
import com.kingdee.bos.qing.publish.target.card.exception.CardException;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.PresetUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class PresetManageDomain {
    public static final String PRESET_IMPORT_LOCK_KEY = "qing_preset_import_lock_";
    public static final String CONFIG_FILE_NAME = "config.xml";
    public static final String EMBEDDED_PKG = "embedded";
    public static final String SUBJECT_PKG = "subject";
    private static Set<String> IS_IMPORTED_ACCOUNTIDS = new HashSet<String>();
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private IScheduleEngine scheduleEngine;
    private ImExportDomain exportDomain;
    private ThemeDomain themeDomain;
    private ThemeGroupDomain themeGroupDomain;
    private ImageLibraryDomain imageLibraryDomain;
    private AnalysisCenterManageDomain analysisCenterDomain;
    private MapImExportDomain mapImExportDomain;
    private ImportPKGDomain importPKGDomain;
    private MapManageDomain mapManageDomain;
    private CardRuntimeDomain cardRuntimeDomain;
    private PresetManageDao presetManageDao;
    private Set<String> deleteGroupNames = new HashSet<String>();
    private AbstractCardManageDomain abstractCardManageDomain;
    private AbstractPublishManageDomain abstractPublishManageDomain;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private static IQingPresetStrategy getPresetResourceStrategyImpl() {
        IQingPresetStrategy presetResourceStrategy = (IQingPresetStrategy)CustomStrategyRegistrar.getStrategy(IQingPresetStrategy.class);
        if (presetResourceStrategy == null) {
            throw new RuntimeException("cannot found the implement of IPresetResourceStrategy.");
        }
        return presetResourceStrategy;
    }

    private ThemeDomain getThemeDomain() {
        if (this.themeDomain == null) {
            this.themeDomain = new ThemeDomain(this.qingContext, this.dbExcuter);
        }
        return this.themeDomain;
    }

    private PresetManageDao getPresetManageDao() {
        if (this.presetManageDao == null) {
            this.presetManageDao = new PresetManageDao(this.dbExcuter);
        }
        return this.presetManageDao;
    }

    private ImageLibraryDomain getImageLibraryDomain() {
        if (this.imageLibraryDomain == null) {
            this.imageLibraryDomain = new ImageLibraryDomain();
            this.imageLibraryDomain.setDbExcuter(this.dbExcuter);
            this.imageLibraryDomain.setQingContext(this.qingContext);
            this.imageLibraryDomain.setTx(this.tx);
        }
        return this.imageLibraryDomain;
    }

    private ThemeGroupDomain getThemeGroupDomain() {
        if (this.themeGroupDomain == null) {
            this.themeGroupDomain = new ThemeGroupDomain();
            this.themeGroupDomain.setDbExcuter(this.dbExcuter);
            this.themeGroupDomain.setQingContext(this.qingContext);
            this.themeGroupDomain.setTx(this.tx);
        }
        return this.themeGroupDomain;
    }

    private ImExportDomain getExportDomain() {
        if (this.exportDomain == null) {
            this.exportDomain = new ImExportDomain();
            this.exportDomain.setTx(this.tx);
            this.exportDomain.setDbExcuter(this.dbExcuter);
            this.exportDomain.setQingContext(this.qingContext);
        }
        return this.exportDomain;
    }

    private MapImExportDomain getMapImExportDomain() {
        if (this.mapImExportDomain == null) {
            this.mapImExportDomain = new MapImExportDomain();
            this.mapImExportDomain.setDbExcuter(this.dbExcuter);
            this.mapImExportDomain.setQingContext(this.qingContext);
            this.mapImExportDomain.setTx(this.tx);
        }
        return this.mapImExportDomain;
    }

    private ImportPKGDomain getImportPKGDomain() {
        if (this.importPKGDomain == null) {
            this.importPKGDomain = new ImportPKGDomain();
            this.importPKGDomain.setDbExcuter(this.dbExcuter);
            this.importPKGDomain.setQingContext(this.qingContext);
            this.importPKGDomain.setScheduleEngine(this.scheduleEngine);
            this.importPKGDomain.setTx(this.tx);
        }
        return this.importPKGDomain;
    }

    private MapManageDomain getMapManageDomin() {
        if (this.mapManageDomain == null) {
            this.mapManageDomain = new MapManageDomain();
            this.mapManageDomain.setDbExcuter(this.dbExcuter);
            this.mapManageDomain.setQingContext(this.qingContext);
            this.mapManageDomain.setTx(this.tx);
        }
        return this.mapManageDomain;
    }

    private CardRuntimeDomain getCardRuntimeDomain() {
        if (this.cardRuntimeDomain == null) {
            this.cardRuntimeDomain = new CardRuntimeDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.cardRuntimeDomain;
    }

    protected AnalysisCenterManageDomain getAnalysisCenterManageDomain() {
        if (this.analysisCenterDomain == null) {
            this.analysisCenterDomain = new AnalysisCenterManageDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.analysisCenterDomain;
    }

    private AbstractCardManageDomain getAbstractCardManageDomain() {
        if (this.abstractCardManageDomain == null) {
            this.abstractCardManageDomain = new AbstractCardManageDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine){

                @Override
                protected String getUserName(String userId) throws CardException, IntegratedRuntimeException {
                    return null;
                }

                @Override
                protected AbstractDomain.IDataSourceCreator getDataSourceCreator(String tag) {
                    return null;
                }
            };
        }
        return this.abstractCardManageDomain;
    }

    private AbstractPublishManageDomain getAbstractPublishManageDomain() {
        if (this.abstractPublishManageDomain == null) {
            this.abstractPublishManageDomain = new AbstractPublishManageDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine){};
        }
        return this.abstractPublishManageDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFiles() throws SQLException, IOException, AbstractQingException, InterruptedException {
        String accountId = this.qingContext.getAccountId();
        if (IS_IMPORTED_ACCOUNTIDS.contains(accountId)) {
            return;
        }
        ILock presetLock = LockFactory.createLock((String)(PRESET_IMPORT_LOCK_KEY + accountId));
        Boolean isLock = presetLock.tryLock();
        boolean hasPublishedMsg = false;
        try {
            while (!isLock.booleanValue()) {
                if (!hasPublishedMsg) {
                    PresetUtil.publishPresettingMsg(this.qingContext.getUserId());
                    hasPublishedMsg = true;
                }
                isLock = presetLock.tryLock(10000L);
            }
        }
        finally {
            PresetUtil.removePresetTag(this.qingContext.getUserId());
        }
        if (IS_IMPORTED_ACCOUNTIDS.contains(accountId)) {
            presetLock.unlock();
            return;
        }
        IQingPresetStrategy presetResourceStrategy = PresetManageDomain.getPresetResourceStrategyImpl();
        String presetUserId = IntegratedHelper.getPresetUserId();
        String originalUserId = this.qingContext.getUserId();
        this.qingContext.setUserId(presetUserId);
        try {
            this.presetMap();
        }
        catch (Exception e) {
            LogUtil.error((String)"import china map error");
        }
        try {
            Set<String> pkgDirectorys = presetResourceStrategy.getPkgDirectorys(presetResourceStrategy.getPath());
            for (String directoryName : pkgDirectorys) {
                try {
                    this.parseConfig(directoryName, SUBJECT_PKG);
                }
                catch (Exception e) {
                    LogUtil.error((String)("preset error parseConfig error, directoryName:" + directoryName), (Throwable)e);
                }
            }
            Set<String> embeddedDirectors = presetResourceStrategy.getPkgDirectorys(presetResourceStrategy.getEmbeddedPath());
            for (String directoryName : embeddedDirectors) {
                try {
                    this.parseConfig(directoryName, EMBEDDED_PKG);
                }
                catch (Exception e) {
                    LogUtil.error((String)("preset error parseConfig error, directoryName:" + directoryName), (Throwable)e);
                }
            }
            this.cleanGroupName(this.deleteGroupNames);
            this.getImageLibraryDomain().deleteNoRefImage(presetUserId);
            this.getAnalysisCenterManageDomain().deleteEmptyCenterGroupByUserId(presetUserId);
            this.getCardRuntimeDomain().cleanEmptyGroupByUserId(presetUserId);
            this.getMapManageDomin().cleanEmptyGroupByUserId(presetUserId);
        }
        finally {
            this.qingContext.setUserId(originalUserId);
            presetLock.unlock();
            Set<String> set = IS_IMPORTED_ACCOUNTIDS;
            synchronized (set) {
                IS_IMPORTED_ACCOUNTIDS.add(accountId);
            }
            PresetUtil.removePresetTag(presetUserId);
        }
    }

    private void parseConfig(String directoryName, String type) throws AbstractQingException, IOException {
        List<Element> configRoots = this.loadConfigXml(directoryName, type);
        if (configRoots.isEmpty()) {
            return;
        }
        for (Element configRoot : configRoots) {
            this.checkConfigXml(configRoot, type);
        }
        this.parseConfigXml(directoryName, configRoots, type);
    }

    private List<Element> loadConfigXml(String directoryName, String type) throws AbstractQingException, IOException {
        ArrayList<Element> configXmlList = new ArrayList<Element>(8);
        IQingPresetStrategy presetResourceStrategy = PresetManageDomain.getPresetResourceStrategyImpl();
        String fileSeparator = presetResourceStrategy.getFileSeparator();
        String filePath = "";
        if (type.equals(SUBJECT_PKG)) {
            filePath = presetResourceStrategy.getPath() + fileSeparator + directoryName + fileSeparator + CONFIG_FILE_NAME;
        } else if (type.equals(EMBEDDED_PKG)) {
            filePath = presetResourceStrategy.getEmbeddedPath() + fileSeparator + directoryName + fileSeparator + CONFIG_FILE_NAME;
        }
        List<URL> urls = presetResourceStrategy.getJarUrls(filePath);
        for (URL url : urls) {
            InputStream in = null;
            try {
                in = url.openStream();
                configXmlList.add(XmlUtil.loadRootElement((InputStream)in));
            }
            catch (Exception e) {
                try {
                    throw new ThemeManagementException(e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
        }
        return configXmlList;
    }

    private void checkConfigXml(Element configRoot, String pkgType) {
        for (Element packageNode : configRoot.getChildren()) {
            String groupName;
            Element revokeItem;
            String fileName = packageNode.getAttributeValue("fileName");
            String versionStr = packageNode.getAttributeValue("version");
            if (fileName == null || "".equals(fileName.trim()) || versionStr == null || "".equals(versionStr.trim())) {
                throw new RuntimeException("fileName,version error");
            }
            try {
                Long.parseLong(versionStr);
            }
            catch (Exception e) {
                throw new RuntimeException("version parse int error", e);
            }
            Element revoke = packageNode.getChild("revoke");
            if (revoke == null) continue;
            List elementList = revoke.getChildren("revokeItem");
            Iterator revokeItemIt = elementList.iterator();
            if (pkgType.equals(SUBJECT_PKG)) {
                while (revokeItemIt.hasNext()) {
                    revokeItem = (Element)revokeItemIt.next();
                    groupName = revokeItem.getAttributeValue("groupName");
                    String name = revokeItem.getAttributeValue("name");
                    String type = revokeItem.getAttributeValue("type");
                    if (groupName != null && !"".equals(groupName.trim()) && name != null && !"".equals(name.trim()) && type != null && !"".equals(type.trim())) continue;
                    throw new RuntimeException("groupName,name,type error");
                }
                continue;
            }
            if (!pkgType.equals(EMBEDDED_PKG)) continue;
            while (revokeItemIt.hasNext()) {
                revokeItem = (Element)revokeItemIt.next();
                groupName = revokeItem.getAttributeValue("groupName");
                String cardName = revokeItem.getAttributeValue("cardName");
                String publishTargetType = revokeItem.getAttributeValue("publishTargetType");
                if (groupName != null && !"".equals(groupName.trim()) && cardName != null && !"".equals(cardName.trim()) && publishTargetType != null && !"".equals(publishTargetType.trim())) continue;
                throw new RuntimeException("groupName,cardName,publishTargetType error");
            }
        }
    }

    private void parseConfigXml(String directoryName, List<Element> configRoots, String type) throws AbstractQingException {
        try {
            Map<String, Long> dbVersionMap = this.getPresetManageDao().getVersions(directoryName);
            for (Element configRoot : configRoots) {
                for (Element childNode : configRoot.getChildren()) {
                    IQingPresetStrategy presetResourceStrategy = PresetManageDomain.getPresetResourceStrategyImpl();
                    boolean isNeedExecutePreset = true;
                    String ignoreProductName = childNode.getAttributeValue("ignoreProduct");
                    if (ignoreProductName != null && presetResourceStrategy.ignoreExecuteInProduct(ignoreProductName)) {
                        isNeedExecutePreset = false;
                    }
                    if (!isNeedExecutePreset) continue;
                    boolean verifyProductNameSuccess = true;
                    String productName = childNode.getAttributeValue("productName");
                    if (StringUtils.isNotBlank((CharSequence)productName)) {
                        verifyProductNameSuccess = presetResourceStrategy.verifyProductName(productName);
                    }
                    if (!verifyProductNameSuccess) continue;
                    this.handlePkgFile(directoryName, dbVersionMap, childNode, type);
                }
            }
        }
        catch (Exception e) {
            throw new ThemeManagementException(e);
        }
    }

    private void handlePkgFile(String directoryName, Map<String, Long> dbVersionMap, Element childNode, String type) throws SQLException, AbstractQingException {
        String fileName = childNode.getAttributeValue("fileName");
        String versionStr = childNode.getAttributeValue("version");
        long version = Long.parseLong(versionStr);
        if (!dbVersionMap.containsKey(fileName) || dbVersionMap.get(fileName) < version) {
            PresetUtil.publishPresettingMsg(QingContext.getCurrent().getUserId());
            this.revokeItems(childNode, type);
            if (this.importPkg(directoryName, fileName, type)) {
                if (dbVersionMap.containsKey(fileName)) {
                    this.updateRecord(directoryName, fileName, version);
                } else {
                    this.insertRecord(directoryName, fileName, version);
                }
                dbVersionMap.put(fileName, version);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importPkg(String directoryName, String fileName, String type) throws AbstractQingException {
        try {
            QingInputStream tempIn;
            InputStream in;
            block12: {
                IQingPresetStrategy presetResourceStrategy = PresetManageDomain.getPresetResourceStrategyImpl();
                String fileSeparator = presetResourceStrategy.getFileSeparator();
                String filePath = "";
                if (type.equals(SUBJECT_PKG)) {
                    filePath = presetResourceStrategy.getPath() + fileSeparator + directoryName + fileSeparator + fileName;
                } else if (type.equals(EMBEDDED_PKG)) {
                    filePath = presetResourceStrategy.getEmbeddedPath() + fileSeparator + directoryName + fileSeparator + fileName;
                }
                List<URL> urls = presetResourceStrategy.getJarUrls(filePath);
                if (urls.size() > 1) {
                    LogUtil.error((String)("duplicate pkg fileName: " + filePath));
                    return false;
                }
                URL url = urls.get(0);
                in = url.openStream();
                tempIn = null;
                try {
                    if (in == null) break block12;
                    IQingFile qingZipFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.UPLOAD);
                    qingZipFile.write((IWriteCall)new CopyWriteCall(in, false), true);
                    tempIn = qingZipFile.getInputStream();
                    ZipInputStream zis = QingEncryptedStreamUtil.createZipInputStream((InputStream)tempIn);
                    ZipEntry zipEntry = zis.getNextEntry();
                    if (zipEntry != null && zipEntry.getName().equals("package-meta.xml")) {
                        CloseUtil.close((Closeable[])new Closeable[]{tempIn});
                        this.importPKGDomain = this.getImportPKGDomain();
                        CardIdCollectAndUpdater publishCollector = PresetCardIdUpdaterFactory.getImpl();
                        this.importPKGDomain.registerPublishInfoCollector(publishCollector);
                        if (type.equals(EMBEDDED_PKG)) {
                            this.importPKGDomain.importBillPublish(qingZipFile.getName(), ExportThemeVO.StrategyType.overwrite.toPersistance());
                        } else {
                            this.importPKGDomain.importSelected(qingZipFile.getName(), null, ExportThemeVO.StrategyType.overwrite.toPersistance(), true, null, null);
                        }
                        publishCollector.update();
                        break block12;
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{tempIn});
                    this.getExportDomain().importSelectedTheme((IQingFileVisitor)qingZipFile, null, ExportThemeVO.StrategyType.overwrite.toPersistance(), true, null);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{in});
                    CloseUtil.close((Closeable[])new Closeable[]{tempIn});
                    throw throwable;
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
            CloseUtil.close((Closeable[])new Closeable[]{tempIn});
        }
        catch (Exception e) {
            throw new ThemeManagementException(e);
        }
        catch (Throwable e) {
            throw new ThemeManagementException(e);
        }
        return true;
    }

    private void revokeItems(Element revokeNode, String itemType) throws AbstractQingIntegratedException, SQLException, ThemeManagementException {
        block5: {
            Iterator revokeItemIt;
            block6: {
                Element revoke = revokeNode.getChild("revoke");
                if (revoke == null) break block5;
                List elementList = revoke.getChildren("revokeItem");
                revokeItemIt = elementList.iterator();
                if (!itemType.equals(SUBJECT_PKG)) break block6;
                while (revokeItemIt.hasNext()) {
                    Element revokeItem = (Element)revokeItemIt.next();
                    String groupName = revokeItem.getAttributeValue("groupName");
                    String name = revokeItem.getAttributeValue("name");
                    String type = revokeItem.getAttributeValue("type");
                    this.deleteItem(groupName, name, type);
                }
                break block5;
            }
            if (!itemType.equals(EMBEDDED_PKG)) break block5;
            while (revokeItemIt.hasNext()) {
                Element revokeItem = (Element)revokeItemIt.next();
                String groupName = revokeItem.getAttributeValue("groupName");
                String cardName = revokeItem.getAttributeValue("cardName");
                int publishTargetType = Integer.parseInt(revokeItem.getAttributeValue("publishTargetType"));
                try {
                    this.deleteEmbeddedItem(groupName, cardName, publishTargetType);
                }
                catch (CardException e) {
                    LogUtil.warn((String)"Failed to get id for this publish information!");
                }
                catch (PublishException e) {
                    LogUtil.warn((String)"Failed to delete the card when presetting!");
                }
            }
        }
    }

    private void deleteEmbeddedItem(String groupName, String cardName, int publishTargetType) throws AbstractQingIntegratedException, SQLException, PublishException {
        String presetUserId = IntegratedHelper.getPresetUserId();
        String publishId = this.getAbstractCardManageDomain().loadPublishId(groupName, presetUserId, cardName, publishTargetType);
        if (publishId != null && !publishId.equals("")) {
            this.getAbstractPublishManageDomain().deletePublishInfo(publishId);
        }
    }

    private void deleteItem(String groupName, String themeName, String themeType) throws AbstractQingIntegratedException, SQLException, ThemeManagementException {
        String presetUserId = IntegratedHelper.getPresetUserId();
        ThemeVO theme = this.getThemeDomain().loadThemeByNameAndGroupNameAndType(presetUserId, groupName, themeName, themeType);
        if (theme != null) {
            AbstractThemeManageDomain themeManageDomain = ThemeMangeDomainFactory.create(themeType, this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
            themeManageDomain.deleteTheme(presetUserId, theme.getThemeID(), true);
            this.deleteGroupNames.add(groupName);
        }
    }

    private void updateRecord(String directoryName, String fileName, long version) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            this.getPresetManageDao().update(directoryName, fileName, version);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private void insertRecord(String directoryName, String fileName, long version) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            this.getPresetManageDao().insert(directoryName, fileName, version);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private void cleanGroupName(Set<String> deleteGroupNames) throws AbstractQingIntegratedException, SQLException, ThemeManagementException {
        String presetUserId = IntegratedHelper.getPresetUserId();
        if (deleteGroupNames != null && !deleteGroupNames.isEmpty()) {
            for (String groupName : deleteGroupNames) {
                ThemeGroupVO themeGroupVO = this.getThemeGroupDomain().loadThemeGroupByGroupName(presetUserId, groupName);
                if (themeGroupVO == null) continue;
                try {
                    this.getThemeGroupDomain().deleteThemeGroup(presetUserId, themeGroupVO.getThemeGroupID());
                }
                catch (ThemeGroupNotEmptyException themeGroupNotEmptyException) {}
            }
        }
    }

    private void presetMap() {
        IQingPresetStrategy presetStrategy = PresetManageDomain.getPresetResourceStrategyImpl();
        Set<Object> pkgDirectorys = new HashSet();
        try {
            pkgDirectorys = presetStrategy.getPkgDirectorys(presetStrategy.getMapPath());
        }
        catch (Exception e) {
            LogUtil.error((String)("get map pkgDirectorys error, pkgDirectorys:" + pkgDirectorys), (Throwable)e);
        }
        for (String string : pkgDirectorys) {
            try {
                this.parseMapConfig(string);
            }
            catch (Exception e) {
                LogUtil.error((String)("parse map config error, directoryName:" + string), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMapConfig(String directoryName) throws JDOMException, IOException, SQLException, AbstractQingException {
        IQingPresetStrategy presetResourceStrategy = PresetManageDomain.getPresetResourceStrategyImpl();
        String fileSeparator = presetResourceStrategy.getFileSeparator();
        String filePath = presetResourceStrategy.getMapPath() + fileSeparator + directoryName + fileSeparator + CONFIG_FILE_NAME;
        List<URL> urls = presetResourceStrategy.getJarUrls(filePath);
        ArrayList<Element> configRoots = new ArrayList<Element>(8);
        for (URL url : urls) {
            InputStream in = null;
            try {
                in = url.openStream();
                configRoots.add(XmlUtil.loadRootElement((InputStream)in));
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
        }
        if (configRoots.isEmpty()) {
            return;
        }
        this.checkMapConfigXml(configRoots);
        this.parseMapConfigXml(directoryName, configRoots);
    }

    private void checkMapConfigXml(List<Element> configRoots) {
        for (Element configRoot : configRoots) {
            for (Element packageNode : configRoot.getChildren()) {
                String fileName = packageNode.getAttributeValue("fileName");
                String versionStr = packageNode.getAttributeValue("version");
                if (fileName != null && !"".equals(fileName.trim()) && versionStr != null && !"".equals(versionStr.trim())) continue;
                LogUtil.error((String)"map config xml info error");
            }
        }
    }

    private void parseMapConfigXml(String directoryName, List<Element> configRoots) throws SQLException, IOException, AbstractQingException, JDOMException {
        Map<String, Long> dbVersionMap = this.getPresetManageDao().getVersions(directoryName);
        for (Element configRoot : configRoots) {
            for (Element childNode : configRoot.getChildren()) {
                this.handleMapPkgFile(directoryName, dbVersionMap, childNode);
            }
        }
    }

    private void handleMapPkgFile(String directoryName, Map<String, Long> dbVersionMap, Element childNode) throws IOException, ImExportException, MapException, AbstractQingIntegratedException, ModelParseException, JDOMException, SQLException {
        String fileName = childNode.getAttributeValue("fileName");
        String versionStr = childNode.getAttributeValue("version");
        long version = Long.parseLong(versionStr);
        if (!dbVersionMap.containsKey(fileName) || dbVersionMap.get(fileName) < version) {
            PresetUtil.publishPresettingMsg(QingContext.getCurrent().getUserId());
            if (this.importMapPkg(directoryName, fileName)) {
                if (dbVersionMap.containsKey(fileName)) {
                    this.updateRecord(directoryName, fileName, version);
                } else {
                    this.insertRecord(directoryName, fileName, version);
                }
                dbVersionMap.put(fileName, version);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importMapPkg(String directoryName, String fileName) throws IOException, ImExportException, MapException, AbstractQingIntegratedException, ModelParseException, JDOMException, SQLException {
        IQingPresetStrategy presetResourceStrategy = PresetManageDomain.getPresetResourceStrategyImpl();
        String fileSeparator = presetResourceStrategy.getFileSeparator();
        String filePath = presetResourceStrategy.getMapPath() + fileSeparator + directoryName + fileSeparator + fileName;
        List<URL> urls = presetResourceStrategy.getJarUrls(filePath);
        if (urls.size() > 1) {
            LogUtil.error((String)("duplicate mapPkg fileName: " + filePath));
            return false;
        }
        URL url = urls.get(0);
        InputStream in = null;
        try {
            in = url.openStream();
            if (in != null) {
                IQingFile qingZipFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.UPLOAD);
                if (!qingZipFile.exists()) {
                    qingZipFile.write((IWriteCall)new CopyWriteCall(in, false), true);
                }
                this.getMapImExportDomain().doImportForPreset((IQingFileVisitor)qingZipFile);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        return true;
    }

    public static class PresetCardIdUpdaterFactory {
        private static CardIdCollectAndUpdater updater;

        public static void register(CardIdCollectAndUpdater cardUpdater) {
            updater = cardUpdater;
        }

        public static CardIdCollectAndUpdater getImpl() {
            return updater;
        }
    }

    public static abstract class CardIdCollectAndUpdater
    implements ImportPKGDomain.IPublishInfoCollector {
        protected Map<String, String> oldAndNewPublishIdMap = new HashMap<String, String>();

        @Override
        public void collectPublishInfo(String oldPublishId, PublishPO newPublishPO) {
            if (newPublishPO.getPublishTargetType() == 5) {
                this.oldAndNewPublishIdMap.put(oldPublishId, newPublishPO.getId());
            }
        }

        @Override
        public void clear() {
            this.oldAndNewPublishIdMap.clear();
        }

        public abstract void update();
    }
}

