/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedBillInfoObject;
import com.kingdee.bos.qing.publish.model.BillModel;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BillManagerDao {
    private IDBExcuter dbExcuter;

    public BillManagerDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void insertBill(BillModel billModel) throws AbstractQingIntegratedException, SQLException {
        String blockSql = "INSERT INTO T_QING_BILL(FID,FPUBLISHID,FQSPATH,FFILTER,FFILTERINDEX,FCTRLKEY,FEXTRACTDATATIME) VALUES (?,?,?,?,?,?,?)";
        byte[] blockData = billModel.getFilterContent();
        Integer length = blockData == null ? 1 : blockData.length;
        int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
        int contentSize = 0;
        int offset = 0;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (blockData == null || blockData.length == 0) {
            Object[] param = new Object[]{UUID.randomUUID().toString(), billModel.getPublishId(), billModel.getQsFileName(), null, 0, billModel.getCtrKey(), billModel.getExtractDataTime()};
            offset += contentSize;
            params.add(param);
        } else {
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[7];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                param[0] = UUID.randomUUID().toString();
                param[1] = billModel.getPublishId();
                param[2] = billModel.getQsFileName();
                param[3] = this.dbExcuter.createSqlParameterBytes(blockData, offset, contentSize);
                param[4] = i;
                param[5] = billModel.getCtrKey();
                param[6] = billModel.getExtractDataTime();
                offset += contentSize;
                params.add(param);
            }
        }
        this.dbExcuter.executeBatch(blockSql, params);
    }

    public BillModel findBillById(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FQSPATH FROM T_QING_BILL WHERE FID = ?";
        Object[] params = new Object[]{id};
        return (BillModel)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<BillModel>(){

            public BillModel handle(ResultSet rs) throws SQLException {
                BillModel billModel = null;
                if (rs.next()) {
                    billModel = new BillModel();
                    billModel.setId(rs.getString("FID"));
                    billModel.setQsFileName(rs.getString("FQSPATH"));
                }
                return billModel;
            }
        });
    }

    public List<BillModel> findBillsByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FQSPATH FROM T_QING_BILL WHERE FPUBLISHID = ?";
        return (List)this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<ArrayList<BillModel>>(){

            public ArrayList<BillModel> handle(ResultSet rs) throws SQLException {
                ArrayList<BillModel> billModelList = new ArrayList<BillModel>();
                while (rs.next()) {
                    BillModel billModel = new BillModel();
                    billModel = new BillModel();
                    billModel.setId(rs.getString("FID"));
                    billModel.setQsFileName(rs.getString("FQSPATH"));
                    billModelList.add(billModel);
                }
                return billModelList;
            }
        });
    }

    public BillModel findBillByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FQSPATH,FCTRLKEY,FEXTRACTDATATIME FROM T_QING_BILL WHERE FPUBLISHID = ?";
        return (BillModel)this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<BillModel>(){

            public BillModel handle(ResultSet rs) throws SQLException {
                BillModel billModel = new BillModel();
                if (rs.next()) {
                    billModel = new BillModel();
                    billModel.setId(rs.getString("FID"));
                    billModel.setQsFileName(rs.getString("FQSPATH"));
                    billModel.setCtrKey(rs.getString("FCTRLKEY"));
                    billModel.setExtractDataTime(rs.getTimestamp("FEXTRACTDATATIME"));
                }
                return billModel;
            }
        });
    }

    public byte[] loadFilterContent(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FFILTER FROM T_QING_BILL WHERE FPUBLISHID = ? ORDER BY FFILTERINDEX ASC";
        return (byte[])this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while (rs.next()) {
                    try {
                        byte[] bytes = rs.getBytes("FFILTER");
                        if (bytes == null) continue;
                        os.write(bytes);
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                return os.toByteArray();
            }
        });
    }

    public String getBillCtrKey(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FCTRLKEY FROM T_QING_BILL WHERE FPUBLISHID = ? ORDER BY FFILTERINDEX ASC";
        return (String)this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String ctrkey = null;
                if (rs.next()) {
                    ctrkey = rs.getString("FCTRLKEY");
                }
                return ctrkey;
            }
        });
    }

    public EmbeddedBillInfoObject getBillCtrlKeyAndFilter(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FCTRLKEY,FFILTER FROM T_QING_BILL WHERE FPUBLISHID = ? ORDER BY FFILTERINDEX ASC";
        return (EmbeddedBillInfoObject)this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<EmbeddedBillInfoObject>(){

            public EmbeddedBillInfoObject handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                EmbeddedBillInfoObject embeddedBillInfoObject = new EmbeddedBillInfoObject();
                String ctrlKey = null;
                while (rs.next()) {
                    ctrlKey = rs.getString("FCTRLKEY");
                    byte[] bytes = rs.getBytes("FFILTER");
                    if (bytes == null) continue;
                    try {
                        os.write(bytes);
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                embeddedBillInfoObject.setCtrlKey(ctrlKey);
                embeddedBillInfoObject.setFilterInfo(os.toByteArray());
                return embeddedBillInfoObject;
            }
        });
    }

    public List<BillModel> findBillsByPath(String path) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FQSPATH FROM T_QING_BILL WHERE FQSPATH = ?";
        return (List)this.dbExcuter.query(sql, new Object[]{path}, (ResultHandler)new ResultHandler<List<BillModel>>(){

            public List<BillModel> handle(ResultSet rs) throws SQLException {
                ArrayList<BillModel> models = new ArrayList<BillModel>(10);
                while (rs.next()) {
                    BillModel billModel = new BillModel();
                    billModel.setId(rs.getString("FID"));
                    billModel.setQsFileName(rs.getString("FQSPATH"));
                    models.add(billModel);
                }
                return models;
            }
        });
    }

    public void deleteBillById(String fId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{fId};
        String sqlDelBill = "DELETE T_QING_BILL WHERE FID = ?";
        this.dbExcuter.execute(sqlDelBill, params);
    }
}

