/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jdom2.Element;

public class DashboardPublishDao {
    private static final int BLOB_SIZE = 32768;
    private IDBExcuter dbExcuter;
    private String refType = "Map";

    public DashboardPublishDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void saveDsbModelContent(String publishId, DashboardModel dsbModel, InputStream dsbModelOrignalStream) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, EncryptedLicenseCheckException {
        byte[] dsbModelBytes;
        InputStream dbStream = null;
        if (PublishUtil.isPublish((String)publishId)) {
            dbStream = this.loadDsbModelContentStream(publishId);
        }
        if ((dsbModelBytes = DashboardSerializationUtil.toBytes(dsbModel, dsbModelOrignalStream, dbStream)) == null) {
            return;
        }
        int length = dsbModelBytes.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[4];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                String fid = this.dbExcuter.genStringId("T_QING_Pub_Dsb_Content");
                param[0] = fid;
                param[1] = publishId;
                param[2] = i;
                param[3] = this.dbExcuter.createSqlParameterBytes(dsbModelBytes, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_Pub_Dsb_Content (FID, FPUBLISHID, FCONTENTINDEX, FCONTENT) VALUES(?, ?, ?, ?)", params);
        }
    }

    public InputStream loadDsbModelContentStream(String publishId) throws AbstractQingIntegratedException, SQLException {
        byte[] dsbBytes = this.readBlock("SELECT FCONTENT FROM T_QING_Pub_Dsb_Content WHERE FPUBLISHID=? ORDER BY FCONTENTINDEX ASC", new Object[]{publishId});
        if (dsbBytes == null) {
            return null;
        }
        return BoxUtil.parseByteToInputStream(dsbBytes);
    }

    public void saveRefInfo(ReferenceMap refItem, String publishId) throws AbstractQingIntegratedException, SQLException {
        Object[] param = new Object[6];
        String fid = this.dbExcuter.genStringId("T_QING_Pub_Dsb_Ref");
        param[0] = fid;
        param[1] = refItem.getUid();
        param[2] = publishId;
        param[3] = StringUtils.isNotBlank((CharSequence)refItem.getRefToId()) ? refItem.getRefToId() : " ";
        param[4] = StringUtils.isNotBlank((CharSequence)refItem.getRefToId()) ? " " : refItem.getRefToFullPath();
        param[5] = refItem.getRefType();
        this.dbExcuter.execute("INSERT INTO T_QING_Pub_Dsb_Ref (FID, FUID, FPUBLISHID, FREFTOID, FFULLPATH, FREFTYPE) VALUES( ?, ?, ?, ?, ?,?)", param);
        refItem.put((Object)"id", (Object)fid);
    }

    public void saveRefInfoOfUser(ReferenceMap refItem, String publishId) throws AbstractQingIntegratedException, SQLException {
        Object[] param = new Object[6];
        String fid = this.dbExcuter.genStringId("T_QING_Pub_Dsb_Ref_u");
        param[0] = fid;
        param[1] = refItem.getUid();
        param[2] = publishId;
        param[3] = StringUtils.isNotBlank((CharSequence)refItem.getRefToId()) ? refItem.getRefToId() : " ";
        param[4] = StringUtils.isNotBlank((CharSequence)refItem.getRefToId()) ? " " : refItem.getRefToFullPath();
        param[5] = refItem.getRefType();
        this.dbExcuter.execute("INSERT INTO T_QING_Pub_Dsb_Ref_u (FID, FUID, FPUBLISHID, FREFTOID, FFULLPATH, FREFTYPE) VALUES( ?, ?, ?, ?, ?,?)", param);
        refItem.put((Object)"id", (Object)fid);
    }

    public void saveRefContent(String publishId, String uid, ModelBook modelBook) throws AbstractQingIntegratedException, SQLException {
        byte[] dsbModelBytes = XmlUtil.toByteArray((Element)modelBook.toXml());
        int length = dsbModelBytes.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[5];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                String fId = this.dbExcuter.genStringId("T_QING_Pub_Dsb_Ref_Cont");
                param[0] = fId;
                param[1] = publishId;
                param[2] = uid;
                param[3] = i;
                param[4] = this.dbExcuter.createSqlParameterBytes(dsbModelBytes, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_Pub_Dsb_Ref_Cont (FID, FPUBLISHID, FREFUID, FCONTENTINDEX, FCONTENT) VALUES(?, ?, ?, ?, ?)", params);
        }
    }

    public List<ReferenceMap> getRefList(String publishId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID, FUID, FREFTOID, FFULLPATH, FREFTYPE FROM T_QING_Pub_Dsb_Ref WHERE FPUBLISHID=?", new Object[]{publishId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.setUid(rs.getString("FUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    RefTypeEnum refEnum = RefTypeEnum.valueOf((String)rs.getString("FRefType").toLowerCase());
                    if (RefTypeEnum.picture == refEnum) {
                        String widgetSourcePath = DashboardModelUtil.parseFullPath(rs.getString("FFullPath"), refEnum);
                        refItem.put((Object)"widgetSourcePath", (Object)widgetSourcePath);
                    }
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.put((Object)"FID", (Object)rs.getString("FID"));
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public List<ReferenceMap> getRefListForEditDsb(String publishId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID, FUID, FREFTOID, FFULLPATH, FREFTYPE FROM T_QING_Pub_Dsb_Ref WHERE FPUBLISHID=?", new Object[]{publishId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.put((Object)"outerRefKey", (Object)UUID.randomUUID().toString());
                    refItem.setUid(rs.getString("FUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    RefTypeEnum refEnum = RefTypeEnum.valueOf((String)rs.getString("FRefType").toLowerCase());
                    if (RefTypeEnum.picture == refEnum) {
                        String widgetSourcePath = DashboardModelUtil.parseFullPath(rs.getString("FFullPath"), refEnum);
                        refItem.put((Object)"widgetSourcePath", (Object)widgetSourcePath);
                    }
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.put((Object)"FID", (Object)rs.getString("FID"));
                    refItem.setFileKey(UUID.randomUUID().toString());
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public byte[] loadRefContent(String publishId, String uid) throws AbstractQingIntegratedException, SQLException {
        return this.readBlock("SELECT FCONTENT FROM T_QING_Pub_Dsb_Ref_Cont WHERE FPUBLISHID=? AND FREFUID=? ORDER BY FCONTENTINDEX ASC", new Object[]{publishId, uid});
    }

    public byte[] selectRefContentUser(String userId, String publishId, String uid) throws AbstractQingIntegratedException, SQLException {
        return this.readBlock("SELECT FCONTENT FROM T_QING_Pub_Dsb_Ref_Cont_u WHERE FPUBLISHID=? AND FREFUID=? AND FUSERID=? ORDER BY FCONTENTINDEX ASC", new Object[]{publishId, uid, userId});
    }

    private byte[] readBlock(String sql, Object[] params) throws AbstractQingIntegratedException, SQLException {
        return (byte[])this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    do {
                        try {
                            os.write(rs.getBytes("FCONTENT"));
                        }
                        catch (IOException e) {
                            LogUtil.error((String)e.getMessage(), (Throwable)e);
                        }
                    } while (rs.next());
                    return os.toByteArray();
                }
                return null;
            }
        });
    }

    public void deleteRefAndContent(String publishId, String uid) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Ref WHERE FPUBLISHID=? AND FUID=?", new Object[]{publishId, uid});
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Ref_Cont WHERE FPUBLISHID=? AND FREFUID=?", new Object[]{publishId, uid});
    }

    public void deleteRefContentUser(String userId, String publishId, String uid) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Ref_Cont_u WHERE FPUBLISHID=? AND FREFUID=? AND FUSERID=?", new Object[]{publishId, uid, userId});
    }

    public void saveRefContentUser(String userId, String publishId, ReferenceMap refItem, byte[] refContentBytes) throws AbstractQingIntegratedException, SQLException {
        int length = refContentBytes.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[6];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                String fId = this.dbExcuter.genStringId("T_QING_Pub_Dsb_Ref_Cont_u");
                param[0] = fId;
                param[1] = userId;
                param[2] = publishId;
                param[3] = refItem.getUid();
                param[4] = i;
                param[5] = this.dbExcuter.createSqlParameterBytes(refContentBytes, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_Pub_Dsb_Ref_Cont_u (FID, FUSERID, FPUBLISHID, FREFUID, FCONTENTINDEX, FCONTENT) VALUES(?, ?, ?, ?, ?, ?)", params);
        }
    }

    public void updatePublishedDsbContent(String publishId, DashboardModel model) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, EncryptedLicenseCheckException {
        InputStream dsbStream = this.loadDsbModelContentStream(publishId);
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Content WHERE FPUBLISHID=?", new Object[]{publishId});
        this.saveDsbModelContent(publishId, model, dsbStream);
    }

    public void deletePublishedByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Content WHERE FPUBLISHID=?", new Object[]{publishId});
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Ref WHERE FPUBLISHID=?", new Object[]{publishId});
    }

    public void deletePublishedSchemaContent(String publishId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Ref_Cont WHERE FPUBLISHID=?", new Object[]{publishId});
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Ref_Cont_u WHERE FPUBLISHID=?", new Object[]{publishId});
    }

    public void overwriteDeletePublishedContentByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Content WHERE FPUBLISHID=?", new Object[]{publishId});
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Ref_Cont WHERE FPUBLISHID=?", new Object[]{publishId});
    }

    public String getRefPK(String publishId, String refUid) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT FID, FUID, FREFTOID, FFULLPATH, FREFTYPE FROM T_QING_Pub_Dsb_Ref WHERE FPUBLISHID=? AND FUID=?", new Object[]{publishId, refUid}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        });
    }

    public List<String> getRefPKList(String publishId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID, FUID, FREFTOID, FFULLPATH, FREFTYPE FROM T_QING_Pub_Dsb_Ref WHERE FPUBLISHID=?", new Object[]{publishId}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> refPKs = new ArrayList<String>(10);
                while (rs.next()) {
                    refPKs.add(rs.getString("FID"));
                }
                return refPKs;
            }
        });
    }

    public void updateRef(ReferenceMap ref) throws SQLException, AbstractQingIntegratedException {
        Object[] param = new Object[]{StringUtils.isNotBlank((CharSequence)ref.getRefToId()) ? ref.getRefToId() : " ", StringUtils.isNotBlank((CharSequence)ref.getRefToId()) ? " " : ref.getRefToFullPath(), ref.getUid(), ref.get((Object)"publishId")};
        this.dbExcuter.execute("UPDATE T_QING_Pub_Dsb_REF SET FREFTOID = ?, FFULLPATH = ? WHERE FUID = ? AND FPUBLISHID = ?", param);
    }

    public void updateOutSideRef(String mapId, String fId) throws SQLException, AbstractQingIntegratedException {
        Object[] param = new Object[]{mapId, null, fId};
        this.dbExcuter.execute("UPDATE T_QING_Pub_Dsb_REF SET FRefToId = ?, FFullPath = ? WHERE FId = ?", param);
    }

    public List<ReferenceMap> loadRefList(String userId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT DSBREF.FID, FPUBLISHID, FUID, FREFTOID, FFULLPATH, FREFTYPE FROM T_QING_PUB_DSB_REF DSBREF LEFT JOIN T_QING_PUBLISH PUB ON DSBREF.FPUBLISHID=PUB.FID WHERE FCREATORID=? AND DSBREF.FFULLPATH IS NOT NULL AND DSBREF.FFULLPATH !=' ' AND DSBREF.FREFTYPE != ?", new Object[]{userId, this.refType}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    refItem.setUid(rs.getString("FUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.put((Object)"publishId", (Object)rs.getString("FPUBLISHID"));
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public List<String> getDsbRelativeIdForExport(String dsbId) throws SQLException, AbstractQingIntegratedException {
        String refType = RefTypeEnum.subject.name();
        String sql = "SELECT DISTINCT DSBREF.FREFTOID FROM T_QING_PUB_DSB_REF DSBREF LEFT JOIN T_QING_PUBLISH PUB ON DSBREF.FPUBLISHID = PUB.FID WHERE PUB.FTAGID = ? AND DSBREF.FREFTYPE = ?";
        Object[] param = new Object[]{dsbId, refType};
        return (List)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> refToId = new ArrayList<String>(10);
                while (rs.next()) {
                    refToId.add(rs.getString("FREFTOID"));
                }
                return refToId;
            }
        });
    }

    public int getRefTimeOfImage(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (Integer)this.dbExcuter.query("SELECT FID FROM T_QING_PUB_DSB_REF WHERE FRefToId = ?", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                int refTimes = 0;
                while (rs.next()) {
                    ++refTimes;
                }
                return refTimes;
            }
        });
    }

    public List<ReferenceMap> loadRefListByRefToId(String refToId, String refType, String userId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT R.FID, FUID,FRefToId,FFullPath,FRefType,FPublishId FROM T_QING_PUB_DSB_REF R left join T_QING_PUBLISH B ON R.FPUBLISHID = B.FID WHERE R.FREFTOID = ? AND R.FREFTYPE LIKE ? AND B.FCREATORID = ?", new Object[]{refToId, refType, userId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    String fileKey = UUID.randomUUID().toString();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.setUid(rs.getString("FUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.put((Object)"publishId", (Object)rs.getString("FPublishId"));
                    refItem.setFileKey(fileKey);
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public List<ReferenceMap> loadRefListByFullPath(String fullPath, String refType, String userId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FUID,FRefToId,FFullPath,FRefType,FPublishId FROM T_QING_PUB_DSB_REF R left join T_QING_PUBLISH B ON R.FPUBLISHID = B.FID WHERE R.FFULLPATH = ? AND R.FREFTYPE LIKE ? AND B.FCREATORID = ?", new Object[]{fullPath, refType, userId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    String fileKey = UUID.randomUUID().toString();
                    refItem.setUid(rs.getString("FUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.put((Object)"publishId", (Object)rs.getString("FPublishId"));
                    refItem.setFileKey(fileKey);
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public void deleteRefById(String id) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Ref WHERE FID=?", new Object[]{id});
    }

    public boolean isExistRefInfo(String refUid, String publishId) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> params = new ArrayList<String>();
        params.add(refUid);
        params.add(publishId);
        return (Boolean)this.dbExcuter.query("SELECT 1 FROM T_QING_Pub_Dsb_Ref WHERE FUID = ? AND FPUBLISHID = ?", params.toArray(), (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public List<OutsideReference> loadSchemaRef(String fId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FUID,FRefToId,FFullPath,FRefType FROM T_QING_PUB_DSB_REF WHERE FPublishId = ?", new Object[]{fId}, (ResultHandler)new ResultHandler<List<OutsideReference>>(){

            public List<OutsideReference> handle(ResultSet rs) throws SQLException {
                ArrayList<OutsideReference> list = new ArrayList<OutsideReference>(10);
                while (rs.next()) {
                    OutsideReference outsideRef = new OutsideReference();
                    outsideRef.setRefToId(rs.getString("FRefToId"));
                    outsideRef.setRefToFullPath(rs.getString("FFullPath"));
                    outsideRef.setRefType(rs.getString("FRefType"));
                    outsideRef.setUid(rs.getString("FUID"));
                    list.add(outsideRef);
                }
                return list;
            }
        });
    }

    public List<OutsideReference> loadSchemaRefOfUser(String fId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FUID,FREFTOID,FFULLPATH,FREFTYPE FROM T_QING_Pub_Dsb_Ref_u WHERE FPUBLISHID = ?", new Object[]{fId}, (ResultHandler)new ResultHandler<List<OutsideReference>>(){

            public List<OutsideReference> handle(ResultSet rs) throws SQLException {
                ArrayList<OutsideReference> list = new ArrayList<OutsideReference>(10);
                while (rs.next()) {
                    OutsideReference outsideRef = new OutsideReference();
                    outsideRef.setRefToId(rs.getString("FREFTOID"));
                    outsideRef.setRefToFullPath(rs.getString("FFULLPATH"));
                    outsideRef.setRefType(rs.getString("FREFTYPE"));
                    outsideRef.setUid(rs.getString("FUID"));
                    list.add(outsideRef);
                }
                return list;
            }
        });
    }

    public void deleteOuterRef(String fId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_PUB_DSB_REF WHERE FPublishId = ?", new Object[]{fId});
    }

    public void deleteOuterRefOfUser(String fId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Ref_u WHERE FPUBLISHID = ?", new Object[]{fId});
    }

    public void deleteOuterRefOfUser(String publishId, String uid) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Pub_Dsb_Ref_u WHERE FPUBLISHID=? AND FUID=?", new Object[]{publishId, uid});
    }

    public List<String> loadRefListByFullPathWidthoutUserId(String fullPath, String refType) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FId,FUID,FRefToId,FFullPath,FRefType FROM T_QING_PUB_DSB_REF WHERE FFullPath = ? AND FRefToId =' ' AND FRefType = ?", new Object[]{fullPath, refType}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> refIds = new ArrayList<String>(10);
                while (rs.next()) {
                    refIds.add(rs.getString("FId"));
                }
                return refIds;
            }
        });
    }

    public void updateRefToIdByRefId(String fId, String mapId) throws SQLException, AbstractQingIntegratedException {
        Object[] param = new Object[]{mapId, null, fId};
        this.dbExcuter.execute("UPDATE T_QING_PUB_DSB_REF SET FRefToId = ?, FFullPath = ? WHERE FId = ?", param);
    }

    public List<String> loadRefListByRefToIdAndRefType(String refToId, String refType) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FId, FUID,FRefToId,FFullPath,FRefType FROM T_QING_PUB_DSB_REF WHERE FRefToId = ? AND FRefType = ?", new Object[]{refToId, refType}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> refIds = new ArrayList<String>(10);
                while (rs.next()) {
                    refIds.add(rs.getString("FId"));
                }
                return refIds;
            }
        });
    }

    public void updateRefFullPathByRefId(String fId, String mapPath) throws SQLException, AbstractQingIntegratedException {
        Object[] param = new Object[]{" ", mapPath, fId};
        this.dbExcuter.execute("UPDATE T_QING_PUB_DSB_REF SET FRefToId = ?, FFullPath = ? WHERE FId = ?", param);
    }
}

