/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.model.PubDsbRefExtractDataExceptionLog;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class PubDsbRefExtractDataExceptionLogDao {
    private IDBExcuter dbExcuter;

    public PubDsbRefExtractDataExceptionLogDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void insert(PubDsbRefExtractDataExceptionLog exceptionLog) throws AbstractQingIntegratedException, SQLException {
        this.insertExceptionLog(exceptionLog);
        this.insertExceptionLogStackTrace(exceptionLog.getPublishId(), exceptionLog.getRefUid(), exceptionLog.getErrorStackTrace());
    }

    private void insertExceptionLog(PubDsbRefExtractDataExceptionLog exceptionLog) throws AbstractQingIntegratedException, SQLException {
        String errorMessage;
        String fId = this.dbExcuter.genStringId("T_QING_PUB_DSB_REF_ERR");
        Object[] params = new Object[5];
        params[0] = fId;
        params[1] = exceptionLog.getPublishId();
        params[2] = exceptionLog.getRefUid();
        params[3] = exceptionLog.getErrorCode();
        String string = errorMessage = StringUtils.isNotEmpty((CharSequence)exceptionLog.getErrorMessage()) ? exceptionLog.getErrorMessage() : " ";
        if (errorMessage.length() > 33) {
            errorMessage = errorMessage.substring(0, 33);
        }
        params[4] = errorMessage;
        this.dbExcuter.execute("INSERT INTO T_QING_PUB_DSB_REF_ERR (FID, FPUBLISHID, FREFUID, FERRORCODE, FERRORMESSAGE) VALUES (?, ?, ?, ?, ?)", params);
    }

    private void insertExceptionLogStackTrace(String publishId, String refUid, String errorStackTrace) throws AbstractQingIntegratedException, SQLException {
        if (StringUtils.isNotBlank((CharSequence)errorStackTrace)) {
            int length;
            byte[] errorStackTraceBytes = null;
            try {
                errorStackTraceBytes = errorStackTrace.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            int n = length = errorStackTraceBytes == null ? 0 : errorStackTraceBytes.length;
            if (length > 0) {
                int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
                int contentSize = 0;
                int offset = 0;
                ArrayList<Object[]> paramsContentList = new ArrayList<Object[]>(count);
                for (int i = 0; i < count; ++i) {
                    Object[] paramsContents = new Object[5];
                    contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                    String fId = this.dbExcuter.genStringId("T_QING_PUB_DSB_REF_ERR_ST");
                    paramsContents[0] = fId;
                    paramsContents[1] = publishId;
                    paramsContents[2] = refUid;
                    paramsContents[3] = i;
                    paramsContents[4] = this.dbExcuter.createSqlParameterBytes(errorStackTraceBytes, offset, contentSize);
                    offset += contentSize;
                    paramsContentList.add(paramsContents);
                }
                this.dbExcuter.executeBatch("INSERT INTO T_QING_PUB_DSB_REF_ERR_ST (FID, FPUBLISHID, FREFUID, FINDEX, FERRORSTACKTRACE) VALUES (?, ?, ?, ?, ?)", paramsContentList);
            }
        }
    }

    public PubDsbRefExtractDataExceptionLog selectExceptionLog(String publishId, String refUid) throws AbstractQingIntegratedException, SQLException {
        byte[] contentBytes;
        PubDsbRefExtractDataExceptionLog exceptionLog = this.selectExceptionLogInfo(publishId, refUid);
        if (exceptionLog != null && (contentBytes = this.selectExceptionLogStackTrace(publishId, refUid)) != null) {
            try {
                exceptionLog.setErrorStackTrace(new String(contentBytes, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        return exceptionLog;
    }

    private PubDsbRefExtractDataExceptionLog selectExceptionLogInfo(String publishId, String refUid) throws AbstractQingIntegratedException, SQLException {
        return (PubDsbRefExtractDataExceptionLog)((Object)this.dbExcuter.query("SELECT FERRORCODE, FERRORMESSAGE FROM T_QING_PUB_DSB_REF_ERR WHERE FPUBLISHID=? AND FREFUID=?", new Object[]{publishId, refUid}, (ResultHandler)new ResultHandler<PubDsbRefExtractDataExceptionLog>(){

            public PubDsbRefExtractDataExceptionLog handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    PubDsbRefExtractDataExceptionLog exceptionLog = new PubDsbRefExtractDataExceptionLog();
                    exceptionLog.setErrorCode(rs.getInt("FERRORCODE"));
                    exceptionLog.setErrorMessage(rs.getString("FERRORMESSAGE"));
                    return exceptionLog;
                }
                return null;
            }
        }));
    }

    private byte[] selectExceptionLogStackTrace(String publishId, String refUid) throws AbstractQingIntegratedException, SQLException {
        return (byte[])this.dbExcuter.query("SELECT FERRORSTACKTRACE FROM T_QING_PUB_DSB_REF_ERR_ST WHERE FPUBLISHID=? AND FREFUID=? ORDER BY FINDEX ASC", new Object[]{publishId, refUid}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    do {
                        try {
                            os.write(rs.getBytes("FERRORSTACKTRACE"));
                        }
                        catch (IOException e) {
                            LogUtil.error((String)"IOException", (Throwable)e);
                        }
                    } while (rs.next());
                    return os.toByteArray();
                }
                return null;
            }
        });
    }

    public void delete(String publishId, String refUid) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_PUB_DSB_REF_ERR WHERE FPUBLISHID=? AND FREFUID=?", new Object[]{publishId, refUid});
        this.dbExcuter.execute("DELETE FROM T_QING_PUB_DSB_REF_ERR_ST WHERE FPUBLISHID=? AND FREFUID=?", new Object[]{publishId, refUid});
    }
}

