/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.domain;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.map.MapRefUpdater;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.List;

public class DashboardPublishedMapRefUpdater
implements MapRefUpdater {
    private static final String UPDATE_PUBLISH_DSB_MAP_REFTOID_ERROR = "update publish dsb map RefToId error";
    private IDBExcuter dbExcuter;
    private DashboardPublishDao dashboardPublishDao;

    @Override
    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    @Override
    public void updateMapIdOfRefWithoutTx(String mapId, String fullPath) {
        try {
            List<String> dsbPublishOutSideRefList = this.getDashboardPublishDao().loadRefListByFullPathWidthoutUserId(fullPath, "Map");
            for (int i = 0; i < dsbPublishOutSideRefList.size(); ++i) {
                String fId = dsbPublishOutSideRefList.get(i);
                this.getDashboardPublishDao().updateRefToIdByRefId(fId, mapId);
            }
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)UPDATE_PUBLISH_DSB_MAP_REFTOID_ERROR, (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)UPDATE_PUBLISH_DSB_MAP_REFTOID_ERROR, (Throwable)e);
        }
    }

    @Override
    public void updateMapFullPathOfRefWithoutTx(String mapId, String fullPath) {
        try {
            List<String> dsbPublishOutSideRefList = this.getDashboardPublishDao().loadRefListByRefToIdAndRefType(mapId, "Map");
            for (int i = 0; i < dsbPublishOutSideRefList.size(); ++i) {
                String fId = dsbPublishOutSideRefList.get(i);
                this.getDashboardPublishDao().updateRefFullPathByRefId(fId, fullPath);
            }
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)UPDATE_PUBLISH_DSB_MAP_REFTOID_ERROR, (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)UPDATE_PUBLISH_DSB_MAP_REFTOID_ERROR, (Throwable)e);
        }
    }
}

