/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.publishmenu.IPublishMenuStrategy;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.target.email.dao.EmailConfigDao;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.resource.domain.IResInfoManagerDomain;
import com.kingdee.bos.qing.resource.exception.ResourceManagementException;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PublishResInfoManagerDomain
implements IResInfoManagerDomain {
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private ITransactionManagement tx;
    private EmailConfigDao emailConfigDao;
    private LappDao lappDao;
    private PublishInfoDao publishInfoDao;

    public PublishResInfoManagerDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.dbExcuter = dbExcuter;
        this.qingContext = qingContext;
        this.tx = tx;
    }

    protected EmailConfigDao getEmailConfigDao() {
        if (this.emailConfigDao == null) {
            this.emailConfigDao = new EmailConfigDao(this.qingContext, this.dbExcuter);
        }
        return this.emailConfigDao;
    }

    private LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    public List<FileResourceVO> findResourceFileListByUserId() throws ResourceManagementException {
        try {
            List publishedAndCardThumbnail = this.getPublishInfoDao().findResourceFilePublishedAndCardThumbnail(this.qingContext.getUserId());
            if (publishedAndCardThumbnail != null) {
                IPublishMenuStrategy publishMenuStrategy = (IPublishMenuStrategy)CustomStrategyRegistrar.getStrategy(IPublishMenuStrategy.class);
                if (null != publishMenuStrategy) {
                    publishMenuStrategy.buildMenuPath(publishedAndCardThumbnail, null, this.qingContext, this.tx, this.dbExcuter);
                }
                this.buildLappPushCustomThumbnailPath(publishedAndCardThumbnail);
            }
            List timingPush = this.getPublishInfoDao().findResourceFileTimingPush(this.qingContext.getUserId());
            ArrayList<FileResourceVO> list = new ArrayList<FileResourceVO>();
            if (publishedAndCardThumbnail != null) {
                list.addAll(publishedAndCardThumbnail);
            }
            if (timingPush != null) {
                list.addAll(timingPush);
            }
            return list;
        }
        catch (Exception e) {
            throw new ResourceManagementException((Throwable)e);
        }
    }

    private void buildLappPushCustomThumbnailPath(List<FileResourceVO> list) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> configIds = new ArrayList<String>();
        for (FileResourceVO fileResourceVO : list) {
            if (!ResourceFromType.CARDTHUMBNAIL.toPersistance().equals(fileResourceVO.getFromType()) || PublishUtil.isPublish((String)fileResourceVO.getFromId())) continue;
            configIds.add(fileResourceVO.getFromId());
        }
        if (configIds.isEmpty()) {
            return;
        }
        Map<String, LappSchedulePushConfigModel> pushConfigMap = this.getLappDao().loadPushConfigByIds(this.qingContext.getUserId(), configIds);
        if (pushConfigMap.isEmpty()) {
            return;
        }
        for (FileResourceVO fileResourceVO : list) {
            LappSchedulePushConfigModel pushConfigModel = pushConfigMap.get(fileResourceVO.getFromId());
            if (pushConfigModel == null) continue;
            fileResourceVO.setFromTargetType(String.valueOf(pushConfigModel.getPushTargetType()));
            fileResourceVO.setFromPath(pushConfigModel.getId());
            fileResourceVO.setSourceExist(true);
        }
    }

    public List<ScheduleExecuteVO> findScheduleExecuteListByUserId(Date dateMin, Date dateMax) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            IGetLappScheduleInfo lappScheduleInfoGetter = LappScheduleInfoGetterFactory.getImpl();
            List<ScheduleExecuteVO> updateLappThumbnailList = lappScheduleInfoGetter.getThumbnailScheduleInfo(this.dbExcuter, this.qingContext.getUserId(), dateMin, dateMax);
            List<ScheduleExecuteVO> emailPublishExecuteList = this.getEmailConfigDao().findScheduleExecuteListByUserId(this.qingContext.getUserId(), dateMin, dateMax);
            List<ScheduleExecuteVO> pushExecuteList = this.getLappDao().findScheduleExecuteListByUserId(this.qingContext.getUserId(), dateMin, dateMax);
            ArrayList<ScheduleExecuteVO> list = new ArrayList<ScheduleExecuteVO>();
            if (updateLappThumbnailList != null) {
                list.addAll(updateLappThumbnailList);
            }
            if (emailPublishExecuteList != null) {
                list.addAll(emailPublishExecuteList);
            }
            if (pushExecuteList != null) {
                list.addAll(pushExecuteList);
            }
            return list;
        }
        catch (SQLException e) {
            throw new ResourceManagementException((Throwable)e);
        }
    }

    public static interface IGetLappScheduleInfo {
        public List<ScheduleExecuteVO> getThumbnailScheduleInfo(IDBExcuter var1, String var2, Date var3, Date var4) throws AbstractQingIntegratedException, SQLException;
    }

    static class LappScheduleInfoGetter
    implements IGetLappScheduleInfo {
        LappScheduleInfoGetter() {
        }

        @Override
        public List<ScheduleExecuteVO> getThumbnailScheduleInfo(IDBExcuter dbExecuter, String userId, Date dateMin, Date dateMax) throws AbstractQingIntegratedException, SQLException {
            return new PublishInfoDao(dbExecuter).findScheduleExecuteListByUserId(userId, dateMin, dateMax);
        }
    }

    public static class LappScheduleInfoGetterFactory {
        private static IGetLappScheduleInfo _impl = new LappScheduleInfoGetter();

        public static IGetLappScheduleInfo getImpl() {
            return _impl;
        }

        public static void registImpl(IGetLappScheduleInfo impl) {
            _impl = impl;
        }
    }
}

