/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.domain;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.ModelPersistenceException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageLimitException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingAppLocalTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.po.ISubjectExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.po.subject.ExportPublishQsFileProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.subject.ExportPublishSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectPublishImportModel;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.dao.PublishSubjectFileDao;
import com.kingdee.bos.qing.publish.dao.PublishSubjectModelDao;
import com.kingdee.bos.qing.publish.domain.IPublishSourceDomain;
import com.kingdee.bos.qing.publish.exception.MapNotFoundException;
import com.kingdee.bos.qing.publish.exception.PublishEncryptedLicenseException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishFileLimitException;
import com.kingdee.bos.qing.publish.exception.PublishSourceSubjectNotExistException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSchemaModel;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishSubjectFilePO;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaModel;
import com.kingdee.bos.qing.schema.model.SchemaVO;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SubjectPublishSourceDomain
implements IPublishSourceDomain {
    private IDBExcuter dbExcuter;
    private QingContext context;
    private ITransactionManagement tx;
    private SchemaManageDao schemaManageDao;
    private PublishSubjectModelDao publishSubjectModelDao;
    private PublishSubjectFileDao publishSubjectFileDao;
    private IThemeDao themeDao;
    private MapManageDao mapManageDao;
    private ISubjectDao subjectDao;
    private PublishInfoDao publishInfoDao;
    private SchemaDomain schemaDomain;

    public SubjectPublishSourceDomain(QingContext context, IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.context = context;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private PublishSubjectModelDao getPublishSubjectModelDao() {
        if (this.publishSubjectModelDao == null) {
            this.publishSubjectModelDao = new PublishSubjectModelDao(this.dbExcuter);
        }
        return this.publishSubjectModelDao;
    }

    private PublishSubjectFileDao getPublishSubjectFileDao() {
        if (this.publishSubjectFileDao == null) {
            this.publishSubjectFileDao = new PublishSubjectFileDao(this.dbExcuter);
        }
        return this.publishSubjectFileDao;
    }

    private IThemeDao getThemeDao() {
        if (this.themeDao == null) {
            this.themeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.themeDao;
    }

    private MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    private ISubjectDao getSubjectDao() {
        if (this.subjectDao == null) {
            this.subjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.subjectDao;
    }

    protected PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    public AbstractPublishSourceModel parsePublishSourceModel(String modelJsonString) {
        SchemaVO schemaVO = (SchemaVO)ModelJsonDecoder.decode((String)modelJsonString, SchemaVO.class);
        PublishSchemaModel publishSubjectModel = new PublishSchemaModel();
        publishSubjectModel.setSchemaAttr(schemaVO.getSchemaAttr());
        publishSubjectModel.setSchemaContent(schemaVO.getSchemaContent());
        return publishSubjectModel;
    }

    public PublishPO savePublish(String tag, String bizTag, PublishPO publishInfo, List<AbstractPublishSourceModel> importSubjectSourceList, List<IQingFile> savedQingFiles) throws PublishException, AbstractQingIntegratedException {
        try {
            this.checkSourceIsExist(bizTag);
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey(tag), AbstractDataSource.class);
            this.savePersistentFileAndData(dataSource, publishInfo, savedQingFiles);
            List<SchemaModel> schemaModelList = this.packageInfoToSchemaModel(importSubjectSourceList, publishInfo, false);
            this.getSchemaManageDao().insertSchemaList(schemaModelList);
            publishInfo.setTagId(bizTag);
            return publishInfo;
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (IOException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public List<SchemaModel> packageInfoToSchemaModel(List<AbstractPublishSourceModel> importSubjectSourceList, PublishPO publishInfo, boolean isEditPublishInfo) throws SQLException, AbstractQingIntegratedException, PublishException {
        ArrayList<SchemaModel> schemaModelList = new ArrayList<SchemaModel>(importSubjectSourceList.size());
        byte[] modelBookContent = null;
        List<OutsideReference> outerRefList = null;
        ArrayList<String> schemaIdList = new ArrayList<String>(importSubjectSourceList.size());
        int schemaSeq = importSubjectSourceList.size() - 1;
        for (int i = 0; i < importSubjectSourceList.size(); ++i) {
            SchemaAttrVO schemaAttrVO;
            PublishSchemaModel publishSchemaModel = (PublishSchemaModel)importSubjectSourceList.get(i);
            if (publishSchemaModel.getSchemaContent() != null || schemaIdList.contains((schemaAttrVO = publishSchemaModel.getSchemaAttr()).getfId())) continue;
            schemaIdList.add(schemaAttrVO.getfId());
        }
        Map<Object, Object> existSchemaContentMap = new HashMap(schemaIdList.size());
        if (schemaIdList.size() != 0) {
            existSchemaContentMap = this.getSchemaManageDao().loadSchemaContentList(schemaIdList);
        }
        for (int i = 0; i < importSubjectSourceList.size(); ++i) {
            SchemaBO schemaBO = new SchemaBO();
            PublishSchemaModel publishSourceModel = (PublishSchemaModel)importSubjectSourceList.get(i);
            SchemaAttrVO schemaAttrVO = null;
            if (publishSourceModel.getSchemaContent() == null) {
                schemaAttrVO = publishSourceModel.getSchemaAttr();
                modelBookContent = (byte[])existSchemaContentMap.get(schemaAttrVO.getfId());
                schemaIdList.add(schemaAttrVO.getfId());
                outerRefList = this.getSchemaManageDao().loadSchemaRef(publishInfo.getSchemaId());
            } else {
                schemaAttrVO = publishSourceModel.getSchemaAttr();
                ModelBook schemaContent = publishSourceModel.getSchemaContent();
                outerRefList = schemaContent.pickReferences();
                modelBookContent = XmlUtil.toByteArray((Element)schemaContent.toXml());
            }
            this.checkMapExist(outerRefList, publishInfo);
            String newSchemaFid = this.getSchemaManageDao().genSchemaId();
            this.updateSchemaRef(outerRefList, newSchemaFid);
            schemaBO.setfId(newSchemaFid);
            schemaBO.setSchemaName(schemaAttrVO.getSchemaName() == null ? Messages.getMLS((QingContext)this.context, (String)"systemDefaultSchema", (String)"\u7cfb\u7edf\u9ed8\u8ba4\u65b9\u6848", (Messages.ProjectName)Messages.ProjectName.QING_THEME) : schemaAttrVO.getSchemaName());
            schemaBO.setSource(schemaAttrVO.getSource());
            schemaBO.setBizTag(publishInfo.getId());
            schemaBO.setUserId(schemaAttrVO.IsDefault() != false && schemaAttrVO.getSchemaType() == 2 ? "SystemUser" : this.context.getUserId());
            schemaBO.setIsDefault(schemaAttrVO.IsDefault());
            schemaBO.setSchemaType(schemaAttrVO.getSchemaType());
            schemaBO.setSeq(isEditPublishInfo ? schemaAttrVO.getSeq() : schemaSeq--);
            if ((schemaBO.IsDefault().booleanValue() || schemaBO.getSchemaType() == 1) && modelBookContent != null) {
                if (schemaBO.IsDefault().booleanValue()) {
                    publishInfo.setSchemaId(newSchemaFid);
                }
                this.getSchemaManageDao().insertSchemaRelation(schemaBO);
            }
            SchemaModel schemaModel = new SchemaModel();
            schemaModel.setSchemaBO(schemaBO);
            schemaModel.setSchemaContent(modelBookContent);
            if (modelBookContent == null) continue;
            schemaModelList.add(schemaModel);
        }
        if (publishInfo.getSchemaId() == null || Objects.equals(publishInfo.getSchemaId(), "currentAnalysisState")) {
            publishInfo.setSchemaId(((SchemaModel)schemaModelList.get(0)).getSchemaBO().getfId());
        }
        return schemaModelList;
    }

    private void checkMapExist(List<OutsideReference> outerRefList, PublishPO publishInfo) throws MapNotFoundException {
        if (!publishInfo.isImport()) {
            for (int i = 0; i < outerRefList.size(); ++i) {
                String refToId = outerRefList.get(i).getRefToId();
                if (refToId == null) {
                    throw new MapNotFoundException();
                }
                outerRefList.get(i).setRefToFullPath(null);
            }
        }
    }

    private void updateSchemaRef(List<OutsideReference> outerRefList, String schemaId) throws PublishException {
        try {
            this.getSchemaManageDao().deleteSchemaRef(schemaId);
            for (int i = 0; i < outerRefList.size(); ++i) {
                OutsideReference outerRef = outerRefList.get(i);
                this.getSchemaManageDao().saveSchemaRef(outerRef, schemaId);
            }
        }
        catch (Exception e) {
            throw new PublishException((Throwable)e);
        }
    }

    public void deletePublish(PublishPO info) throws AbstractQingIntegratedException, PublishException {
        try {
            this.deletePersistentFileAndData(info.isCarryData(), info.getId());
            this.getSchemaManageDao().deleteSchemaByBizTag(info.getId());
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public void updatePublish(int updateType, PublishPO publishInfoNew, PublishPO publishInfoOld, List<AbstractPublishSourceModel> importSubjectSourceList) throws AbstractQingIntegratedException, PublishException {
        try {
            switch (updateType) {
                case 4: 
                case 6: {
                    this.updateSchema(publishInfoNew, publishInfoOld, importSubjectSourceList, false);
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    private void savePersistentFileAndData(AbstractDataSource dataSource, PublishPO publishInfo, List<IQingFile> savedQingFile) throws PublishException, IOException, AbstractQingIntegratedException, SQLException {
        if (publishInfo.isCarryData() && null != dataSource) {
            ThemeDataSource themeDataSource = (ThemeDataSource)dataSource;
            Map<String, String> dataFiles = themeDataSource.getDataFiles();
            for (Map.Entry<String, String> entity : dataFiles.entrySet()) {
                String filePath = dataFiles.get(entity.getKey());
                IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)filePath);
                if (!qingFileVisitor.exists()) {
                    qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)filePath);
                }
                QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
                resourceInfo.setDisplayName(entity.getKey());
                resourceInfo.setFromId(publishInfo.getId());
                if (publishInfo.isTimingPush()) {
                    resourceInfo.setFromType(ResourceFromType.TIMINGPUSH);
                } else {
                    resourceInfo.setFromType(ResourceFromType.PUBLISHED);
                }
                try {
                    IQingFile qingFile = FileFactory.newPersistentFile((QingContext)this.context, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.DATAMODELING_QS);
                    FileFactory.copy((IQingFileVisitor)qingFileVisitor, (IQingFile)qingFile, (boolean)true);
                    savedQingFile.add(qingFile);
                    PublishSubjectFilePO publishSubjectFilePO = new PublishSubjectFilePO();
                    publishSubjectFilePO.setFilePath(qingFile.getName());
                    publishSubjectFilePO.setPublishId(publishInfo.getId());
                    publishSubjectFilePO.setEntityName(entity.getKey());
                    publishSubjectFilePO.setExtractDataTime(new Date(themeDataSource.getExtractDataTime()));
                    this.getPublishSubjectFileDao().insert(publishSubjectFilePO);
                }
                catch (QingFileStorageLimitException e) {
                    throw new PublishFileLimitException(e);
                }
            }
            InputStream boxStream = null;
            try {
                boxStream = BoxUtil.getCacheBoxStream();
                if (boxStream == null) {
                    String tagId = publishInfo.getTagId();
                    if (tagId != null && PublishUtil.isPublish((String)tagId)) {
                        boxStream = this.getPublishSubjectModelDao().loadBoxStreamByPublishId(tagId);
                        if (boxStream == null) {
                            PublishPO notCarryDataPublishInfo = this.getPublishInfoDao().getPublishInfoByInfoId(tagId);
                            boxStream = this.getSubjectDao().loadSubjectModelStreamByThemeID(notCarryDataPublishInfo.getTagId());
                        }
                    } else {
                        boxStream = this.getSubjectDao().loadSubjectModelStreamByThemeID(publishInfo.getTagId());
                    }
                }
                this.getPublishSubjectModelDao().insert(publishInfo.getId(), themeDataSource.getBoxModel(), boxStream);
            }
            catch (ModelParseException e) {
                LogUtil.error((String)e.getMessage());
            }
            catch (ModelPersistenceException e) {
                LogUtil.error((String)e.getMessage());
            }
            catch (EncryptedLicenseCheckException e) {
                throw new PublishEncryptedLicenseException(e.getMessage(), e.getErrorCode());
            }
        }
    }

    public void doExport(ZipOutputStream zos, PublishPO publishPo, String publishPrefixPath, ISubjectExportFilePathGetter subjectExportFilePathGetter) throws ThemeManagementException, AbstractQingIntegratedException {
        try {
            String schemaId = publishPo.getSchemaId();
            SchemaBO schemaBO = this.getSchemaManageDao().findSchemaById(schemaId);
            byte[] schemaContent = this.getSchemaManageDao().loadSchemaContent(schemaId);
            List<OutsideReference> outSideRefList = this.getSchemaManageDao().loadSchemaRef(schemaId);
            ExportPublishSchemaProperty publishSchemaProperty = new ExportPublishSchemaProperty();
            publishSchemaProperty.setBizTag(schemaBO.getBizTag());
            publishSchemaProperty.setSchemaName(schemaBO.getSchemaName());
            publishSchemaProperty.setSource(schemaBO.getSource());
            if (outSideRefList.size() > 0) {
                this.setFullPath(outSideRefList);
                List<Map<String, String>> outSideRefMapList = ImportUtil.createRefMap(outSideRefList);
                publishSchemaProperty.setReference(outSideRefMapList);
            }
            zos.putNextEntry(new ZipEntry(subjectExportFilePathGetter.getSchemaPropertyFilePathInZip(publishPrefixPath)));
            Element schemaPropertyElement = publishSchemaProperty.toXml();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XmlUtil.save((Element)schemaPropertyElement, (OutputStream)baos);
            zos.write(baos.toByteArray());
            zos.putNextEntry(new ZipEntry(subjectExportFilePathGetter.getSchemaFilePathInZip(publishPrefixPath)));
            zos.write(schemaContent);
            if (publishPo.isCarryData()) {
                this.exportSubjectQsAndBoxModel(zos, publishPo.getId(), publishPrefixPath, subjectExportFilePathGetter.getQsFilePropertyFileNameInZip(), subjectExportFilePathGetter.getQsFileNameInZip(), subjectExportFilePathGetter.getBoxModelFileNameInZip());
            }
        }
        catch (SQLException e) {
            throw new ExportThemeException(e);
        }
        catch (IOException e) {
            throw new ExportThemeException(e);
        }
        catch (ModelParseException e) {
            throw new ExportThemeException(e);
        }
    }

    public String cachePublishCarrayData(SubjectPublishImportModel subjectPublishImportModel) throws ThemeManagementException {
        String tag = UUID.randomUUID().toString();
        try {
            List<ExportPublishQsFileProperty> qsPropertyList = subjectPublishImportModel.getPublishQsFileProperties();
            List<String> qsFileKeyList = subjectPublishImportModel.getPublishQsFiles();
            String modelFileKey = subjectPublishImportModel.getBoxFile();
            if (qsPropertyList != null && qsFileKeyList != null && modelFileKey != null) {
                HashMap<String, String> dataFiles = new HashMap<String, String>(qsFileKeyList.size());
                for (int i = 0; i < qsFileKeyList.size(); ++i) {
                    String qsFileKey = qsFileKeyList.get(i);
                    ExportPublishQsFileProperty carryDataProperty = qsPropertyList.get(i);
                    String entityName = carryDataProperty.getEntityName();
                    IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingAppLocalTempFileType.LOCAL_TEMP, (String)qsFileKey);
                    IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
                    FileFactory.copy((IQingFileVisitor)qingFileVisitor, (IQingFile)qingFile, (boolean)true);
                    dataFiles.put(entityName, qingFile.getName());
                }
                Box box = new Box();
                String boxFileName = modelFileKey;
                InputStream boxOrignalStream = BoxUtil.getBoxStreamByFileName(boxFileName, (AbstractQingFileType)QingAppLocalTempFileType.LOCAL_TEMP);
                if (boxOrignalStream != null) {
                    box = BoxSerializationUtil.toModel(boxOrignalStream, true);
                }
                ThemeDataSource themeDataSource = new ThemeDataSource();
                themeDataSource.setOriginalCreatorId(this.context.getUserId());
                themeDataSource.setDataFiles(dataFiles);
                themeDataSource.setBox(box);
                themeDataSource.setTag(tag);
                QingSessionUtil.setCache((ISessionCacheable)themeDataSource);
            }
        }
        catch (ModelParseException e) {
            throw new ImportThemeException(e);
        }
        catch (IOException e) {
            throw new ImportThemeException(e);
        }
        return tag;
    }

    public PublishSchemaModel getImportSubjectSource(SubjectPublishImportModel subjectPublishImportModel) throws ImportThemeException {
        try {
            byte[] schemaContent = subjectPublishImportModel.getSchemaContent();
            ExportPublishSchemaProperty publishSchemaProperty = subjectPublishImportModel.getPublishSchemaProperty();
            int source = publishSchemaProperty.getSource();
            PublishSchemaModel importSubjectSource = new PublishSchemaModel();
            SchemaAttrVO schemaAttrVO = new SchemaAttrVO();
            schemaAttrVO.setSource(source);
            schemaAttrVO.setSchemaType(2);
            importSubjectSource.setSchemaAttr(schemaAttrVO);
            Element element = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(schemaContent));
            ModelBook modelBook = new ModelBook();
            modelBook.fromXml(element);
            List<Map<String, String>> outSideRefMapList = publishSchemaProperty.getReference();
            if (outSideRefMapList != null && outSideRefMapList.size() > 0) {
                List<OutsideReference> outSideRefList = ImportUtil.createOutSideRef(outSideRefMapList, false);
                modelBook.fixReferences(outSideRefList);
            }
            importSubjectSource.setSchemaContent(modelBook);
            return importSubjectSource;
        }
        catch (IOException e) {
            throw new ImportThemeException(e);
        }
        catch (JDOMException e) {
            throw new ImportThemeException(e);
        }
        catch (PersistentModelParseException e) {
            throw new ImportThemeException(e);
        }
        catch (PersistentModelTooModernException e) {
            throw new ImportThemeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSubjectQsAndBoxModel(ZipOutputStream zos, String publishId, String publishPrefixPath, String qsFilePropertyFileNameInZip, String qsFileNameInZip, String boxModelFileNameInZip) throws AbstractQingIntegratedException, SQLException, IOException, ModelParseException, EncryptedLicenseCheckException {
        List<PublishSubjectFilePO> publishSubjectFilePOs = this.getPublishSubjectFileDao().loadPublishSubjectFile(publishId);
        QingInputStream qsFileInputStream = null;
        try {
            for (int i = 0; i < publishSubjectFilePOs.size(); ++i) {
                PublishSubjectFilePO publishSubjectFilePO = publishSubjectFilePOs.get(i);
                String qsFileName = publishSubjectFilePO.getFilePath();
                String entityName = publishSubjectFilePO.getEntityName();
                String qsFileFloder = UUID.randomUUID().toString();
                ExportPublishQsFileProperty carryDataProperty = new ExportPublishQsFileProperty();
                carryDataProperty.setEntityName(entityName);
                zos.putNextEntry(new ZipEntry(publishPrefixPath + File.separator + qsFileFloder + File.separator + qsFilePropertyFileNameInZip));
                XmlUtil.save((Element)carryDataProperty.toXml(), (OutputStream)zos);
                IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)qsFileName);
                qsFileInputStream = qingFileVisitor.getInputStream();
                zos.putNextEntry(new ZipEntry(publishPrefixPath + File.separator + qsFileFloder + File.separator + qsFileNameInZip));
                IOUtil.copy((InputStream)qsFileInputStream, (OutputStream)zos);
                zos.flush();
                CloseUtil.close((Closeable[])new Closeable[]{qsFileInputStream});
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{qsFileInputStream});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{qsFileInputStream});
        Box box = this.getPublishSubjectModelDao().loadBoxByPublishId(publishId);
        byte[] byteContent = XmlUtil.toByteArray((Element)box.toXml());
        zos.putNextEntry(new ZipEntry(publishPrefixPath + File.separator + boxModelFileNameInZip));
        zos.write(byteContent);
    }

    private void checkSourceIsExist(String bizTag) throws AbstractQingIntegratedException, SQLException, PublishSourceSubjectNotExistException {
        ThemePO theme = this.getThemeDao().getThemeByID(bizTag);
        if (theme == null) {
            throw new PublishSourceSubjectNotExistException();
        }
    }

    public void overwritePublish(String tag, PublishPO publishInfoNew, PublishPO publishInfoOld, List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<IQingFile> savedQingFiles) throws AbstractQingIntegratedException, PublishException {
        try {
            this.updateSchema(publishInfoNew, publishInfoOld, abstractPublishSourceModelList, true);
            this.deletePersistentFileAndData(publishInfoOld.isCarryData(), publishInfoNew.getId());
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey(tag), AbstractDataSource.class);
            if (publishInfoNew.isCarryData() && null != dataSource) {
                dataSource.setExtractDataTime(publishInfoNew.getCreateTime().getTime());
            }
            this.savePersistentFileAndData(dataSource, publishInfoNew, savedQingFiles);
            this.getPublishInfoDao().updatePublishInfo(10, publishInfoNew);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (IOException e) {
            throw new PublishException((Throwable)e);
        }
    }

    private void deletePersistentFileAndData(boolean isCarryDataOld, String publishId) throws AbstractQingIntegratedException, SQLException {
        if (isCarryDataOld) {
            List<PublishSubjectFilePO> publishSubjectFilePOs = this.getPublishSubjectFileDao().loadPublishSubjectFile(publishId);
            for (int i = 0; i < publishSubjectFilePOs.size(); ++i) {
                PublishSubjectFilePO publishSubjectFilePO = publishSubjectFilePOs.get(i);
                String qsFileName = publishSubjectFilePO.getFilePath();
                if (qsFileName == null || "".equals(qsFileName)) continue;
                IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.context, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)qsFileName);
                fileUpdater.delete();
            }
            this.getPublishSubjectFileDao().deleteSubjectFileByPublishId(publishId);
            this.getPublishSubjectModelDao().deleteSubjectModelByPublishId(publishId);
        }
    }

    private void updateSchema(PublishPO publishInfoNew, PublishPO publishInfoOld, List<AbstractPublishSourceModel> importSubjectSourceList, boolean isOverride) throws AbstractQingIntegratedException, SQLException, PublishException {
        if (isOverride) {
            List<SchemaModel> schemaModelList = this.packageInfoToSchemaModel(importSubjectSourceList, publishInfoNew, false);
            this.getSchemaManageDao().updateSchemaBoList(publishInfoOld.getId(), schemaModelList);
        } else {
            List<SchemaModel> schemaModelList;
            List<AbstractPublishSourceModel> newPublishSchemaList;
            List<SchemaAttrVO> samePublishSchemaList;
            List<SchemaAttrVO> updatePublishSchemaList;
            ArrayList<SchemaAttrVO> existPublishSchema = new ArrayList<SchemaAttrVO>(importSubjectSourceList.size());
            List<SchemaBO> existPublishSchemaList = this.getSchemaManageDao().findSchemaByBiztag(publishInfoOld.getId(), "SystemUser", 0);
            this.adjustPublishSchemaSeq(importSubjectSourceList, existPublishSchemaList);
            List<String> deletePublishSchemaIdList = SubjectPublishSourceDomain.obtainDeletePublishSchema(importSubjectSourceList, existPublishSchemaList);
            if (deletePublishSchemaIdList.size() > 0) {
                this.getSchemaManageDao().deletePublishSchemaInfoById(deletePublishSchemaIdList);
            }
            if ((updatePublishSchemaList = SubjectPublishSourceDomain.obtainUpdatePublishSchema(importSubjectSourceList, existPublishSchemaList)).size() > 0) {
                existPublishSchema.addAll(updatePublishSchemaList);
                this.getSchemaManageDao().updateSchemaAttrList(updatePublishSchemaList);
            }
            if ((samePublishSchemaList = this.obtainSamePublishSchema(importSubjectSourceList, existPublishSchemaList)).size() > 0) {
                existPublishSchema.addAll(updatePublishSchemaList.size(), samePublishSchemaList);
            }
            if ((newPublishSchemaList = SubjectPublishSourceDomain.obtainNewPublishSchema(importSubjectSourceList, existPublishSchemaList)).size() > 0 && (schemaModelList = this.packageInfoToSchemaModel(newPublishSchemaList, publishInfoNew, true)).size() > 0) {
                List<SchemaAttrVO> schemaAttrVOList = this.packageInfoToSchemaAttrVO(schemaModelList);
                existPublishSchema.addAll(updatePublishSchemaList.size() + samePublishSchemaList.size(), schemaAttrVOList);
                this.getSchemaManageDao().insertSchemaList(schemaModelList);
            }
            this.updateSchemaIdForPublishInfo(existPublishSchema, publishInfoNew, publishInfoOld);
        }
    }

    private void updateSchemaIdForPublishInfo(List<SchemaAttrVO> schemaAttrVOList, PublishPO publishInfoNew, PublishPO publishInfoOld) throws AbstractQingIntegratedException, SQLException {
        if (schemaAttrVOList.size() > 0) {
            String defaultPublishSchema = SubjectPublishSourceDomain.findSetDefaultPublishSchema(schemaAttrVOList);
            publishInfoNew.setSchemaId(defaultPublishSchema != null ? defaultPublishSchema : schemaAttrVOList.get(0).getfId());
            if (!Objects.equals(defaultPublishSchema, publishInfoOld.getSchemaId())) {
                this.getSchemaManageDao().updateSchemaRelation(publishInfoOld.getSchemaId(), "0", "SystemUser");
                if (defaultPublishSchema != null) {
                    this.updateCustomSetDefaultSchema(defaultPublishSchema, publishInfoNew);
                }
            }
        }
    }

    private List<SchemaAttrVO> packageInfoToSchemaAttrVO(List<SchemaModel> schemaModelList) {
        ArrayList<SchemaAttrVO> schemaAttrVOList = new ArrayList<SchemaAttrVO>(schemaModelList.size());
        for (SchemaModel schemaModel : schemaModelList) {
            SchemaAttrVO schemaAttrVO = new SchemaAttrVO();
            schemaAttrVO.setfId(schemaModel.getSchemaBO().getfId());
            schemaAttrVO.setIsDefault(schemaModel.getSchemaBO().IsDefault());
            schemaAttrVOList.add(schemaAttrVO);
        }
        return schemaAttrVOList;
    }

    private void adjustPublishSchemaSeq(List<AbstractPublishSourceModel> importSubjectSourceList, List<SchemaBO> existPublishSchemaList) throws AbstractQingIntegratedException, SQLException {
        int schemaSeq = importSubjectSourceList.size() - 1;
        for (AbstractPublishSourceModel abstractPublishSourceModel : importSubjectSourceList) {
            PublishSchemaModel publishSourceModel = (PublishSchemaModel)abstractPublishSourceModel;
            publishSourceModel.getSchemaAttr().setSeq(schemaSeq--);
        }
        List<SchemaAttrVO> updateSchemaSeq = this.obtainSamePublishSchema(importSubjectSourceList, existPublishSchemaList);
        if (updateSchemaSeq.size() > 0) {
            this.getSchemaManageDao().updatePublishSchemaSeq(updateSchemaSeq);
        }
    }

    private List<SchemaAttrVO> obtainSamePublishSchema(List<AbstractPublishSourceModel> importSubjectSourceList, List<SchemaBO> existPublishSchemaList) {
        ArrayList<SchemaAttrVO> samePublishSchema = new ArrayList<SchemaAttrVO>(existPublishSchemaList.size());
        block0: for (SchemaBO schemaBO : existPublishSchemaList) {
            for (AbstractPublishSourceModel abstractPublishSourceModel : importSubjectSourceList) {
                PublishSchemaModel publishSchemaModel = (PublishSchemaModel)abstractPublishSourceModel;
                if (!Objects.equals(schemaBO.getfId(), publishSchemaModel.getSchemaAttr().getfId())) continue;
                samePublishSchema.add(publishSchemaModel.getSchemaAttr());
                continue block0;
            }
        }
        return samePublishSchema;
    }

    private void updateCustomSetDefaultSchema(String updateDefaultSchemaId, PublishPO publishPO) throws AbstractQingIntegratedException, SQLException {
        List<String> defaultPlanUserId = this.getSchemaManageDao().findSetDefaultPlanUserId(publishPO);
        if (defaultPlanUserId.size() == 0) {
            SchemaBO schemaBO = new SchemaBO();
            schemaBO.setfId(updateDefaultSchemaId);
            schemaBO.setUserId("SystemUser");
            schemaBO.setIsDefault(true);
            this.getSchemaManageDao().insertSchemaRelation(schemaBO);
        } else {
            this.getSchemaManageDao().updateSchemaRelation(updateDefaultSchemaId, "1", "SystemUser");
        }
    }

    private static List<String> obtainDeletePublishSchema(List<AbstractPublishSourceModel> importSubjectSourceList, List<?> existPublishSchemaList) {
        int i;
        ArrayList<String> deleteSchemaIdList = new ArrayList<String>(existPublishSchemaList.size());
        HashMap<String, Integer> existSchemaId = new HashMap<String, Integer>(existPublishSchemaList.size());
        for (i = 0; i < existPublishSchemaList.size(); ++i) {
            if (existPublishSchemaList.get(i) instanceof SchemaBO) {
                SchemaBO schemaBO = (SchemaBO)existPublishSchemaList.get(i);
                existSchemaId.put(schemaBO.getfId(), 1);
            }
            if (!(existPublishSchemaList.get(i) instanceof SchemaModel)) continue;
            SchemaModel schemaModel = (SchemaModel)existPublishSchemaList.get(i);
            existSchemaId.put(schemaModel.getSchemaBO().getfId(), 1);
        }
        for (i = 0; i < importSubjectSourceList.size(); ++i) {
            PublishSchemaModel publishSourceModel = (PublishSchemaModel)importSubjectSourceList.get(i);
            String editPublishSchemaId = publishSourceModel.getSchemaAttr().getfId();
            if (!existSchemaId.containsKey(editPublishSchemaId)) continue;
            existSchemaId.put(editPublishSchemaId, 2);
        }
        for (Map.Entry entry : existSchemaId.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            deleteSchemaIdList.add((String)entry.getKey());
        }
        return deleteSchemaIdList;
    }

    private static List<SchemaAttrVO> obtainUpdatePublishSchema(List<AbstractPublishSourceModel> importSubjectSourceList, List<SchemaBO> existPublishSchemaList) {
        ArrayList<SchemaAttrVO> updateSchemaAttrList = new ArrayList<SchemaAttrVO>(existPublishSchemaList.size());
        for (int i = 0; i < existPublishSchemaList.size(); ++i) {
            SchemaBO schemaBO = existPublishSchemaList.get(i);
            for (int j = 0; j < importSubjectSourceList.size(); ++j) {
                PublishSchemaModel publishSchemaModel = (PublishSchemaModel)importSubjectSourceList.get(j);
                SchemaAttrVO updatePublishSchemaAttr = publishSchemaModel.getSchemaAttr();
                if (!Objects.equals(schemaBO.getfId(), updatePublishSchemaAttr.getfId()) || Objects.equals(schemaBO.getSchemaName(), updatePublishSchemaAttr.getSchemaName()) && schemaBO.IsDefault() == updatePublishSchemaAttr.IsDefault()) continue;
                updateSchemaAttrList.add(updatePublishSchemaAttr);
            }
        }
        return updateSchemaAttrList;
    }

    private static String findSetDefaultPublishSchema(List<?> schemaList) {
        for (int i = 0; i < schemaList.size(); ++i) {
            SchemaModel schemaModel;
            SchemaAttrVO schemaAttrVO;
            PublishSchemaModel publishSchemaModel;
            SchemaBO schemaBO;
            if (schemaList.get(i) instanceof SchemaBO && (schemaBO = (SchemaBO)schemaList.get(i)).IsDefault().booleanValue()) {
                return schemaBO.getfId();
            }
            if (schemaList.get(i) instanceof AbstractPublishSourceModel && (publishSchemaModel = (PublishSchemaModel)((Object)schemaList.get(i))).getSchemaAttr().IsDefault().booleanValue()) {
                return publishSchemaModel.getSchemaAttr().getfId();
            }
            if (schemaList.get(i) instanceof SchemaAttrVO && (schemaAttrVO = (SchemaAttrVO)schemaList.get(i)).IsDefault().booleanValue()) {
                return schemaAttrVO.getfId();
            }
            if (!(schemaList.get(i) instanceof SchemaModel) || !(schemaModel = (SchemaModel)schemaList.get(i)).getSchemaBO().IsDefault().booleanValue()) continue;
            return schemaModel.getSchemaBO().getfId();
        }
        return null;
    }

    private static List<AbstractPublishSourceModel> obtainNewPublishSchema(List<AbstractPublishSourceModel> importSubjectSourceList, List<SchemaBO> existPublishSchemaList) {
        ArrayList<AbstractPublishSourceModel> NewSchemaList = new ArrayList<AbstractPublishSourceModel>(importSubjectSourceList.size());
        for (int i = 0; i < importSubjectSourceList.size(); ++i) {
            boolean bNewDefaultSchema = false;
            PublishSchemaModel publishSchemaModel = (PublishSchemaModel)importSubjectSourceList.get(i);
            SchemaAttrVO updatePublishSchemaAttr = publishSchemaModel.getSchemaAttr();
            for (int j = 0; j < existPublishSchemaList.size(); ++j) {
                SchemaBO schemaBO = existPublishSchemaList.get(j);
                if (!Objects.equals(schemaBO.getfId(), updatePublishSchemaAttr.getfId())) continue;
                bNewDefaultSchema = true;
                break;
            }
            if (bNewDefaultSchema) continue;
            NewSchemaList.add(publishSchemaModel);
        }
        return NewSchemaList;
    }

    private void setFullPath(List<OutsideReference> outSideRefList) throws AbstractQingIntegratedException, SQLException {
        for (int j = 0; j < outSideRefList.size(); ++j) {
            OutsideReference outSideRef = outSideRefList.get(j);
            if (outSideRef.getRefToFullPath() != null) continue;
            String mapId = outSideRef.getRefToId();
            MapVO mapVO = this.getMapManageDao().getMapPath(mapId);
            String mapNameSpace = NameSpace.getNameSpace((String)mapVO.getNameSpace()).toPersistance();
            String mapPath = mapNameSpace + "/" + mapVO.getMapGroupName() + "/" + mapVO.getMapName();
            outSideRef.setRefToFullPath(mapPath);
        }
    }

    public void addPublicSchemaInfo(Map<String, String> result) throws AbstractQingIntegratedException, SQLException {
        String schemaId = result.get("schemaId");
        SchemaManageDao schemaDao = this.getSchemaManageDao();
        int schemaSource = schemaDao.findSchemaById(schemaId).getSource();
        String schemaType = schemaSource == 0 ? "longer" : "square";
        result.put("schemaType", schemaType);
    }

    public String getPublishSourceName(String bizTag, String publishSourceType) throws SQLException, AbstractQingIntegratedException {
        ThemePO themePO = this.getThemeDao().getThemeByID(bizTag);
        if (themePO != null) {
            return themePO.getThemeName();
        }
        return null;
    }

    public String getPublishSourceGroupName(String bizTag, String publishSourceType) throws SQLException, AbstractQingIntegratedException {
        ThemePO themePO = this.getThemeDao().getThemeByID(bizTag);
        if (themePO != null) {
            return themePO.getThemeGroupName();
        }
        return null;
    }

    public PublishSourceEnum confirmSourceTypeByPublishInfo(PublishPO publishInfo) throws AbstractQingIntegratedException, SQLException {
        String tagId = publishInfo.getTagId();
        ThemePO themePO = this.getThemeDao().getThemeByID(tagId);
        if (themePO != null) {
            if ("1".equals(themePO.getThemeType())) {
                return PublishSourceEnum.dashboard;
            }
            if ("0".equals(themePO.getThemeType())) {
                return PublishSourceEnum.subject;
            }
            throw new SQLException("can't confirm SourceType");
        }
        return null;
    }

    private SchemaDomain getSchemaDomain() {
        if (this.schemaDomain == null) {
            this.schemaDomain = new SchemaDomain();
            this.schemaDomain.setTx(this.tx);
            this.schemaDomain.setDbExcuter(this.dbExcuter);
        }
        return this.schemaDomain;
    }

    public byte[] getAllSchemaAttrs(String bizTag, int source, String userId, boolean isEditPublishInfo) {
        try {
            String publishSourceId = bizTag;
            if (PublishUtil.isPublish((String)bizTag) && isEditPublishInfo) {
                publishSourceId = this.getSchemaDomain().getLastBizTagByFId(bizTag);
            }
            ArrayList<SchemaAttrVO> schemaAttrVOS = this.getSchemaDomain().loadSchemaAttrs(publishSourceId, userId, source);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(schemaAttrVOS);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] setPublicPlanDefaultAttr(String bizTag, String modelJsonString, String userId) {
        SchemaAttrVO vo = (SchemaAttrVO)JsonUtil.decodeFromString((String)modelJsonString, SchemaAttrVO.class);
        int source = vo.getSource();
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getSchemaDomain().setSchemaDefaultAttr(bizTag, userId, source, vo));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getSchemaAttrByPublishId(String fid, String userId, int source) {
        try {
            List<SchemaAttrVO> schemaAttrVOList = this.getSchemaDomain().getSchemaAttrByPublishId(fid, userId, source);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(schemaAttrVOList);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public List<String> getPublishedRecordNameByInputText(String userId, String inputText, String publishSourceType, String publishTargetType) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDomain().getPublishedRecordNameByInputText(userId, inputText, publishSourceType, publishTargetType);
    }

    public boolean checkBeforeEditAndPublishInfo(PublishPO publishPO, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws PublishException, SQLException, AbstractQingIntegratedException {
        return this.checkBeforeEditPublishInfo(publishPO, abstractPublishSourceModelList);
    }

    public boolean checkBeforeMovingRight(PublishPO publishPO, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, SQLException, PublishException {
        return false;
    }

    public boolean checkBeforeEditPublishInfo(PublishPO publishInfoNew, List<AbstractPublishSourceModel> importSubjectSourceList) throws SQLException, PublishException, AbstractQingIntegratedException {
        List<SchemaBO> existPublishSchemaList = this.getSchemaManageDao().findSchemaByBiztag(publishInfoNew.getId(), "SystemUser", 0);
        List<String> deletePublishSchemaIdList = SubjectPublishSourceDomain.obtainDeletePublishSchema(importSubjectSourceList, existPublishSchemaList);
        List<AbstractPublishSourceModel> newPublishSchemaList = SubjectPublishSourceDomain.obtainNewPublishSchema(importSubjectSourceList, existPublishSchemaList);
        List<SchemaModel> schemaModelList = this.packageInfoToSchemaModel(newPublishSchemaList, publishInfoNew, true);
        return deletePublishSchemaIdList.size() == existPublishSchemaList.size() && schemaModelList.size() == 0;
    }
}

