/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.analysiscenter.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.imexport.model.po.AbstractPublishModel;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.collector.ICollectable;
import com.kingdee.bos.qing.manage.imexport.collector.PublishDsbCollectorGetter;
import com.kingdee.bos.qing.manage.imexport.collector.common.PublishInfoCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbModelCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbPictuerCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbPicturePropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbRefCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbWidgetSchemaCollector;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.publish.PublishDsbWidgetSchemaPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishBoxCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishQsFileCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishQsPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishSchemaCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishShcemaPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.po.QingCenterPublishModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportPublishConflictVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.publish.exception.PublishNameDuplicateException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.target.analysiscenter.dao.AnalysisCenterDAO;
import com.kingdee.bos.qing.publish.target.analysiscenter.exception.ACFolderNameDuplicateException;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterGroupVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterPathModel;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class AnalysisCenterPublishTargetImexportDomain
extends AbstractPublishTargetImexportDomain {
    private AnalysisCenterDAO analysisCenterDAO;

    public AnalysisCenterPublishTargetImexportDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private AnalysisCenterDAO getAnalysisCenterDAO() {
        if (this.analysisCenterDAO == null) {
            this.analysisCenterDAO = new AnalysisCenterDAO(this.qingContext, this.dbExcuter);
        }
        return this.analysisCenterDAO;
    }

    @Override
    public AbstractPublishModel createNewPublishModel() {
        return new QingCenterPublishModel();
    }

    @Override
    public final void doExportPublishInfo(ZipOutputStream zos, String themeGroupName, PublishPO publishPo, ThemeVO themeVO, String themeFolderPath) throws ThemeManagementException, AbstractQingIntegratedException {
        try {
            String publishFloder = UUID.randomUUID().toString();
            PublishSourceEnum publishSourceType = publishPo.getPublishSourceType();
            String path = publishPo.getPath();
            QingCenterGroupVO qingCenterGroupVO = this.getAnalysisCenterDAO().getQingCerterCatalog(path);
            if (qingCenterGroupVO != null) {
                QingCenterPublishModel publishToQingCenter = (QingCenterPublishModel)this.initPublishModel(publishPo, themeGroupName, themeVO);
                String publishPrefixPath = themeFolderPath + File.separator + "qingcenter" + File.separator + publishFloder;
                String publishFloderPath = null;
                if (publishSourceType == PublishSourceEnum.subject) {
                    publishFloderPath = publishPrefixPath + File.separator + "subject-pub-qingcenter.xml";
                    this.getSubjectPublishSourceDomain().doExport(zos, publishPo, publishPrefixPath, publishToQingCenter);
                } else if (publishSourceType == PublishSourceEnum.dashboard) {
                    publishFloderPath = publishPrefixPath + File.separator + "dsb-pub-qingcenter.xml";
                    this.getDashboardPublishSourceDomain().doExport(zos, publishPo.getId(), publishPrefixPath, publishToQingCenter);
                }
                publishToQingCenter.setCatalog(qingCenterGroupVO.getName());
                Element propertyElement = publishToQingCenter.toXml();
                if (publishFloderPath != null) {
                    zos.putNextEntry(new ZipEntry(publishFloderPath));
                }
                XmlUtil.save((Element)propertyElement, (OutputStream)zos);
            }
        }
        catch (SQLException e) {
            throw new ExportThemeException(e);
        }
        catch (IOException e) {
            throw new ExportThemeException(e);
        }
    }

    @Override
    public final void collectPublishInfo(ZipInputStream zis, String[] zipEntry, AbstractThemeImportModel exportThemeCollectModel) throws ImportThemeException, AbstractQingIntegratedException {
        if (zipEntry != null && zipEntry.length >= 3 && "qingcenter".equals(zipEntry[2])) {
            String entryName = zipEntry[zipEntry.length - 1];
            ICollectable collector = null;
            collector = "subject-pub-qingcenter.xml".equals(entryName) ? new PublishInfoCollector(new QingCenterPublishModel(), new SubjectPublishImportModel()) : ("dsb-pub-qingcenter.xml".equals(entryName) ? new PublishInfoCollector(new QingCenterPublishModel(), new DashboardPublishImportModel()) : PublishDsbCollectorGetter.getCollector(entryName));
            if (collector != null) {
                collector.collect(zis, zipEntry, exportThemeCollectModel);
            }
        }
    }

    @Override
    public void doImportPublishInfo(AbstractThemeImportModel themeImportModel, AbstractPublishImportModel publishImportModel, List<IQingFile> saveSuccessFiles) throws AbstractQingIntegratedException, ThemeManagementException {
        String themeId = themeImportModel.getThemeID();
        AbstractPublishModel publishModel = publishImportModel.getPublishModel();
        String publishId = PublishUtil.getPublishId((String)UUID.randomUUID().toString());
        QingCenterPublishModel qingCenterPublishModel = (QingCenterPublishModel)publishModel;
        publishModel.setPublishId(publishId);
        publishModel.setTagId(themeId);
        this.saveQingCenterGroupInfo(qingCenterPublishModel);
        try {
            PublishPO publishPo = new PublishPO();
            this.savePublishImportInfo(themeImportModel, publishImportModel, publishPo, saveSuccessFiles);
            if ("0".equals(themeImportModel.getThemeType())) {
                String qingcenterPath = themeImportModel.getNameSpace() + "/" + qingCenterPublishModel.getCatalog() + "/" + qingCenterPublishModel.getName();
                themeImportModel.getImportQingCenterPathAndId().put(qingcenterPath, publishId);
            }
        }
        catch (PublishNameDuplicateException e) {
            this.doPublishNameDuplicate(themeImportModel, qingCenterPublishModel);
        }
        catch (PublishSameSourceNameDuplicateException e) {
            this.doPublishNameDuplicate(themeImportModel, qingCenterPublishModel);
        }
    }

    private void doPublishNameDuplicate(AbstractThemeImportModel themeImportModel, QingCenterPublishModel qingCenterPublishModel) throws ImportThemeException, AbstractQingIntegratedException {
        try {
            String userId = this.qingContext.getUserId();
            ThemeVO themeVO = this.getThemeDao().loadThemeIncludePreset(userId, qingCenterPublishModel.getTagId());
            String themeName = themeVO.getThemeName();
            ExportPublishConflictVO exportPublicConflict = new ExportPublishConflictVO();
            String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"qingAnalysisCenter", (String)"\u8f7b\u5206\u6790\u4e2d\u5fc3", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + qingCenterPublishModel.getCatalog() + "/" + qingCenterPublishModel.getName();
            exportPublicConflict.setThemeName(themeName);
            exportPublicConflict.setThemeType(themeVO.getThemeType());
            exportPublicConflict.setPublishPath(publishPath);
            themeImportModel.getConfilctPublishList().add(exportPublicConflict);
        }
        catch (SQLException e) {
            throw new ImportThemeException(e);
        }
    }

    private void saveQingCenterGroupInfo(QingCenterPublishModel publishModel) throws AbstractQingIntegratedException, ImportThemeException {
        Map catalogs = (Map)ImportUtil.getImportCache("qingCenterCatalogMap", new HashMap());
        String catalogName = publishModel.getCatalog();
        String userId = this.qingContext.getUserId();
        String path = null;
        QingCenterGroupVO centerInfo = new QingCenterGroupVO();
        centerInfo.setName(catalogName);
        try {
            if (catalogs.get(catalogName) == null) {
                path = this.getAnalysisCenterDAO().findPublishPathByNames(catalogName, null, null, null, userId);
                if (path == null) {
                    try {
                        QingCenterGroupVO analysisCenterVO = this.getAnalysisCenterDAO().saveCenterGroup(centerInfo, "ADD_CURRENT", userId);
                        path = analysisCenterVO.getRelationId();
                    }
                    catch (ACFolderNameDuplicateException e) {
                        path = this.getAnalysisCenterDAO().findPublishPathByNames(catalogName, null, null, null, userId);
                    }
                }
                catalogs.put(catalogName, path);
            } else {
                path = (String)catalogs.get(catalogName);
            }
            publishModel.setPath(path);
        }
        catch (SQLException e) {
            throw new ImportThemeException(e);
        }
    }

    @Override
    public PublishPO loadNewPublishPO(PublishTarget publishTarget, Map<String, String> tempFile) throws AbstractQingIntegratedException, SQLException {
        String userId = this.qingContext.getUserId();
        QingCenterPathModel qingCenterPathModel = (QingCenterPathModel)JsonUtil.decodeFromString((String)publishTarget.getPath(), QingCenterPathModel.class);
        String centerName1 = qingCenterPathModel.getCenterName1();
        String centerName2 = qingCenterPathModel.getCenterName2();
        String centerName3 = qingCenterPathModel.getCenterName3();
        String centerName4 = qingCenterPathModel.getCenterName4();
        String relationId = this.getAnalysisCenterDAO().findPublishPathByNames(centerName1, centerName2, centerName3, centerName4, userId);
        if (relationId == null) {
            QingCenterGroupVO centerInfo = new QingCenterGroupVO();
            centerInfo.setName(centerName1);
            String centerId1 = null;
            String centerId2 = null;
            String centerId3 = null;
            String centerId4 = null;
            centerId1 = this.getAnalysisCenterDAO().saveCenterName1(centerInfo, userId);
            if (centerName2 != null) {
                centerInfo.setLevelId1(centerId1);
                centerInfo.setName(centerName2);
                centerId2 = this.getAnalysisCenterDAO().saveCenterName2(centerInfo, userId);
                if (centerName3 != null) {
                    centerInfo.setLevelId2(centerId2);
                    centerInfo.setName(centerName3);
                    centerId3 = this.getAnalysisCenterDAO().saveCenterName3(centerInfo, userId);
                    if (centerName4 != null) {
                        centerInfo.setLevelId3(centerId3);
                        centerInfo.setName(centerName4);
                        centerId4 = this.getAnalysisCenterDAO().saveCenterName4(centerInfo, userId);
                    }
                }
            }
            relationId = centerInfo.getRelationId();
        }
        PublishPO publishPO = new PublishPO();
        publishPO.setPath(relationId);
        return publishPO;
    }

    @Override
    public void doPublishNameDuplicate(List<ExportPublishConflictVO> confilctPublishList, ThemeVO themeVO, String importPath, String publishName) throws AbstractQingIntegratedException, ImportThemeException {
        ExportPublishConflictVO exportPublicConflict = new ExportPublishConflictVO();
        QingCenterPathModel qingCenterPathModel = (QingCenterPathModel)JsonUtil.decodeFromString((String)importPath, QingCenterPathModel.class);
        String path = "";
        if (qingCenterPathModel.getCenterName1() != null) {
            path = path + qingCenterPathModel.getCenterName1() + "/";
        }
        if (qingCenterPathModel.getCenterName2() != null) {
            path = path + qingCenterPathModel.getCenterName2() + "/";
        }
        if (qingCenterPathModel.getCenterName3() != null) {
            path = path + qingCenterPathModel.getCenterName3() + "/";
        }
        if (qingCenterPathModel.getCenterName4() != null) {
            path = path + qingCenterPathModel.getCenterName4() + "/";
        }
        String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"qingAnalysisCenter", (String)"\u8f7b\u5206\u6790\u4e2d\u5fc3", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + path + publishName;
        exportPublicConflict.setThemeName(themeVO.getThemeName());
        exportPublicConflict.setThemeType(themeVO.getThemeType());
        exportPublicConflict.setPublishPath(publishPath);
        confilctPublishList.add(exportPublicConflict);
    }

    static {
        PublishDsbCollectorGetter.registerCollector("dsb-pub-qingcenter-ref.xml", new PublishDsbRefCollector());
        PublishDsbCollectorGetter.registerCollector("dsb-pub-qingcenter.model", new PublishDsbModelCollector());
        PublishDsbCollectorGetter.registerCollector("dsb-pub-qingcenter-schema.xml", new PublishDsbWidgetSchemaPropertyCollector());
        PublishDsbCollectorGetter.registerCollector("dsb-pub-qingcenter.schema", new PublishDsbWidgetSchemaCollector());
        PublishDsbCollectorGetter.registerCollector("dsb-pub-qingcenter-picture.xml", new PublishDsbPicturePropertyCollector());
        PublishDsbCollectorGetter.registerCollector("dsb-pub-qingcenter-picture", new PublishDsbPictuerCollector());
        PublishDsbCollectorGetter.registerCollector("subject-pub-qingcenter-schema.xml", new PublishShcemaPropertyCollector());
        PublishDsbCollectorGetter.registerCollector("subject-pub-qingcenter.schema", new PublishSchemaCollector());
        PublishDsbCollectorGetter.registerCollector("qingcenter_qs.xml", new PublishQsPropertyCollector());
        PublishDsbCollectorGetter.registerCollector("qingcenter.qs", new PublishQsFileCollector());
        PublishDsbCollectorGetter.registerCollector("qingcenter.model", new PublishBoxCollector());
    }
}

