/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.card.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.IPreferences;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.reference.impl.CardSwitchPathAndIdHandler;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.ExportDomain;
import com.kingdee.bos.qing.domain.SquareExecuteDomain;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageLimitException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishFileLimitException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSchemaModel;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetDomain;
import com.kingdee.bos.qing.publish.target.card.dao.PublishCardDao;
import com.kingdee.bos.qing.publish.target.card.exception.CardImageNotFoundException;
import com.kingdee.bos.qing.publish.target.card.model.CardGroupPO;
import com.kingdee.bos.qing.publish.target.card.model.CardPO;
import com.kingdee.bos.qing.publish.target.card.model.CardVO;
import com.kingdee.bos.qing.publish.thumbnail.ThumbnailHelper;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailUrlModel;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public abstract class AbstractCardPublishTargetDomain
extends AbstractPublishTargetDomain {
    public static final String PATH_SUFFIX = "_card";
    private PublishCardDao cardDao;
    private DashboardDao dashboardDao;
    private SchemaManageDao schemaManageDao;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;

    public AbstractCardPublishTargetDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    protected PublishCardDao getPublishCardDao() {
        if (this.cardDao == null) {
            this.cardDao = new PublishCardDao(this.qingContext, this.dbExcuter);
        }
        return this.cardDao;
    }

    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new CardSwitchPathAndIdHandler(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    protected DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    protected SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    protected abstract AbstractDomain.IDataSourceCreator getDataSourceCreator(String var1);

    public PublishPO savePublish(String tag, PublishSourceEnum source, PublishPO publishInfo, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, PublishException {
        if (PublishSourceEnum.dashboard == source) {
            return this.saveDashboardPublish(publishInfo);
        }
        return this.saveSquarePublish(tag, publishInfo, abstractPublishSourceModelList.get(0));
    }

    private PublishPO saveDashboardPublish(PublishPO publishInfo) throws AbstractQingIntegratedException, PublishException {
        CardPO cardPO = (CardPO)publishInfo;
        IQingFile imageFile = null;
        try {
            if (publishInfo.isImport()) {
                IQingFileVisitor iQingFileVisitor;
                String tempCardImageKey = cardPO.getTempImageFileKey();
                if (tempCardImageKey != null && (iQingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)tempCardImageKey)) != null) {
                    QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
                    resourceInfo.setFromId(publishInfo.getId());
                    resourceInfo.setDisplayName(publishInfo.getName());
                    resourceInfo.setFromType(ResourceFromType.CARDTHUMBNAIL);
                    imageFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.CARD_THUMBNAIL);
                    FileFactory.copy((IQingFileVisitor)iQingFileVisitor, (IQingFile)imageFile, (boolean)true);
                    cardPO.setImagePath(imageFile.getName());
                }
            } else {
                String thumbnailPath = cardPO.getImagePath();
                if (StringUtils.isNotEmpty((CharSequence)thumbnailPath) && (imageFile = this.generateCardThumbnail(cardPO)) != null) {
                    cardPO.setImagePath(imageFile.getName());
                }
            }
            this.getPublishCardDao().saveCardPublishInfo(cardPO);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (IOException e) {
            FileFactory.clearFile(imageFile);
            throw new PublishException((Throwable)e);
        }
        return publishInfo;
    }

    private IQingFile generateCardThumbnail(CardPO cardPO) throws PublishException {
        IQingFile imageFile = null;
        try {
            QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
            resourceInfo.setFromId(cardPO.getId());
            resourceInfo.setDisplayName(cardPO.getName());
            resourceInfo.setFromType(ResourceFromType.CARDTHUMBNAIL);
            String thumbnailPath = cardPO.getImagePath();
            ThumbnailUrlModel thumbnailUrlModel = ThumbnailUrlModel.fromJsonObject(thumbnailPath);
            IQingFile localImagePath = (IQingFile)thumbnailUrlModel.getImageIQingFile();
            imageFile = ThumbnailHelper.generateCompressImage((IQingFileVisitor)localImagePath, 800, 400, (AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, this.qingContext, resourceInfo);
        }
        catch (IOException e) {
            FileFactory.clearFile(imageFile);
            throw new PublishException((Throwable)e);
        }
        return imageFile;
    }

    private PublishPO saveSquarePublish(String tag, PublishPO publishInfo, AbstractPublishSourceModel abstractPublishSourceModel) throws AbstractQingIntegratedException, PublishException {
        CardPO cardPO = (CardPO)publishInfo;
        IQingFile imageFile = null;
        try {
            IQingFile uploadCardImageFile = null;
            if (publishInfo.isImport()) {
                String tempCardImageKey = cardPO.getTempImageFileKey();
                if (tempCardImageKey != null) {
                    uploadCardImageFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)tempCardImageKey);
                }
            } else {
                uploadCardImageFile = this.generaImg(tag, publishInfo, abstractPublishSourceModel);
            }
            if (uploadCardImageFile != null) {
                QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
                resourceInfo.setFromId(publishInfo.getId());
                resourceInfo.setDisplayName(publishInfo.getName());
                resourceInfo.setFromType(ResourceFromType.CARDTHUMBNAIL);
                imageFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.CARD_THUMBNAIL);
                FileFactory.copy((IQingFileVisitor)uploadCardImageFile, (IQingFile)imageFile, (boolean)true);
                cardPO.setImagePath(imageFile.getName());
            }
            this.updateRefToId(cardPO);
            this.getPublishCardDao().saveCardPublishInfo(cardPO);
        }
        catch (AnalysisException e) {
            throw new PublishException((Throwable)e);
        }
        catch (AbstractQingIntegratedException e) {
            FileFactory.clearFile(imageFile);
            throw e;
        }
        catch (SQLException e) {
            FileFactory.clearFile(imageFile);
            throw new PublishException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            FileFactory.clearFile(imageFile);
            throw new CardImageNotFoundException(e);
        }
        catch (QingFileStorageLimitException e) {
            FileFactory.clearFile(imageFile);
            throw new PublishFileLimitException(e);
        }
        catch (IOException e) {
            FileFactory.clearFile(imageFile);
            throw new PublishException((Throwable)e);
        }
        return publishInfo;
    }

    public void deletePublish(PublishPO info) throws AbstractQingIntegratedException, PublishException {
        String publishId = info.getId();
        try {
            CardVO vo = this.getPublishCardDao().loadPublishCardBaseInfo(publishId);
            if (vo != null) {
                this.updateRefFullPath(info);
                this.getPublishCardDao().deletePublishInfo(publishId);
                String imageFileName = vo.getImagePath();
                IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, (String)imageFileName);
                fileUpdater.delete();
                List<String> bizTags = this.getSchemaManageDao().getFullBizTagByPrefix(publishId);
                for (String bizTag : bizTags) {
                    this.getSchemaManageDao().deleteSchemaByBizTag(bizTag);
                }
            }
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public void updatePublish(int updateType, PublishPO publishInfoNew) throws AbstractQingIntegratedException, PublishException {
        CardPO newPo = (CardPO)publishInfoNew;
        try {
            if (publishInfoNew.getPublishSourceType() == PublishSourceEnum.dashboard) {
                this.updateDsbPublishInfo(publishInfoNew);
            } else {
                this.getPublishCardDao().updateCardDesc(newPo.getCardDesc(), newPo.getId());
                this.updateRefToId(newPo);
            }
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    private void updateDsbPublishInfo(PublishPO publishInfoNew) throws SQLException, AbstractQingIntegratedException, PublishException {
        IQingFile imageFile;
        CardPO newPo = (CardPO)publishInfoNew;
        CardVO oldVo = this.getPublishCardDao().loadPublishCardBaseInfo(newPo.getId());
        if (newPo.getImagePath() != null && oldVo.getImagePath() != null && newPo.getImagePath().equals(oldVo.getImagePath())) {
            this.getPublishCardDao().updateCardDesc(newPo.getCardDesc(), newPo.getId());
            this.updateRefToId(newPo);
            return;
        }
        String thumbnailPath = newPo.getImagePath();
        if (StringUtils.isNotEmpty((CharSequence)thumbnailPath) && (imageFile = this.generateCardThumbnail(newPo)) != null) {
            newPo.setImagePath(imageFile.getName());
        }
        this.getPublishCardDao().updateCardInfo(newPo);
        this.updateRefToId(newPo);
        if (oldVo.getImagePath() != null) {
            FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, (String)oldVo.getImagePath()).delete();
        }
    }

    private void updateRefToId(CardPO cardPO) throws AbstractQingIntegratedException {
        try {
            String cardName = cardPO.getName();
            String cardGroupId = cardPO.getPath();
            CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByIdForExport(cardGroupId);
            if (cardGroupPO != null) {
                ISwitchPathAndIdHandler switchPathAndIdHandler = this.getSwitchPathAndIdHandler();
                String cardPath = cardGroupPO.getName() + "/" + cardName;
                String publishId = cardPO.getId();
                String fullPathWithNameSpace = NameSpace.user.toPersistance() + "/" + cardPath;
                PathModel pathModel = new PathModel();
                pathModel.setNameSpace(NameSpace.user.toPersistance());
                pathModel.setGroupName(cardGroupPO.getName());
                pathModel.setName(cardName);
                switchPathAndIdHandler.replacePersistentPathToId(cardPath, publishId, this.qingContext.getUserId());
                switchPathAndIdHandler.replacePersistentPathToId(fullPathWithNameSpace, publishId, this.qingContext.getUserId());
                switchPathAndIdHandler.replacePersistentPathToId(JsonUtil.encodeToString((Object)pathModel), publishId, this.qingContext.getUserId());
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"update ref error");
        }
    }

    private void updateRefFullPath(PublishPO publishInfo) throws AbstractQingIntegratedException {
        try {
            String publishId = publishInfo.getId();
            String cardName = publishInfo.getName();
            String cardGroupId = publishInfo.getPath();
            CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByIdForExport(cardGroupId);
            PathModel pathModel = new PathModel();
            pathModel.setNameSpace(NameSpace.user.toPersistance());
            pathModel.setGroupName(cardGroupPO.getName());
            pathModel.setName(cardName);
            ISwitchPathAndIdHandler switchPathAndIdHandler = this.getSwitchPathAndIdHandler();
            switchPathAndIdHandler.replacePersistentIdToPath(JsonUtil.encodeToString((Object)pathModel), publishId, this.qingContext.getUserId());
        }
        catch (SQLException e) {
            LogUtil.error((String)"update ref error");
        }
    }

    public void overwritePublish(String tag, int updateType, PublishPO publishInfoNew, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, PublishException {
        try {
            CardPO newPo = (CardPO)publishInfoNew;
            CardVO vo = this.getPublishCardDao().loadPublishCardBaseInfo(publishInfoNew.getId());
            String oldCardImageFilePath = vo.getImagePath();
            newPo = PublishSourceEnum.dashboard == newPo.getPublishSourceType() ? this.overwriteDsb(newPo) : this.overwriteSquare(tag, newPo, abstractPublishSourceModelList.get(0));
            this.getPublishCardDao().updateCardInfo(newPo);
            String cardName = newPo.getName();
            String cardGroupId = newPo.getPath();
            String publishId = newPo.getId();
            CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByIdForExport(cardGroupId);
            if (cardGroupPO != null) {
                String fullPath = cardGroupPO.getName() + "/" + cardName;
                ISwitchPathAndIdHandler switchPathAndIdHandler = this.getSwitchPathAndIdHandler();
                switchPathAndIdHandler.replacePersistentPathToId(fullPath, publishId, this.qingContext.getUserId());
            }
            if (oldCardImageFilePath != null) {
                IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, (String)oldCardImageFilePath);
                fileUpdater.delete();
            }
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (IOException e) {
            throw new PublishException((Throwable)e);
        }
        catch (AnalysisException e) {
            throw new PublishException((Throwable)e);
        }
    }

    private CardPO overwriteDsb(CardPO cardPO) throws PublishException, IOException {
        IQingFile imageFile = null;
        if (cardPO.isImport()) {
            IQingFileVisitor iQingFileVisitor;
            String tempCardImageKey = cardPO.getTempImageFileKey();
            if (tempCardImageKey != null && (iQingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)tempCardImageKey)) != null) {
                QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
                resourceInfo.setFromId(cardPO.getId());
                resourceInfo.setDisplayName(cardPO.getName());
                resourceInfo.setFromType(ResourceFromType.CARDTHUMBNAIL);
                imageFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.CARD_THUMBNAIL);
                FileFactory.copy((IQingFileVisitor)iQingFileVisitor, (IQingFile)imageFile, (boolean)true);
                cardPO.setImagePath(imageFile.getName());
            }
        } else {
            String thumbnailPath = cardPO.getImagePath();
            if (StringUtils.isNotEmpty((CharSequence)thumbnailPath) && (imageFile = this.generateCardThumbnail(cardPO)) != null) {
                cardPO.setImagePath(imageFile.getName());
            }
        }
        return cardPO;
    }

    private CardPO overwriteSquare(String tag, CardPO cardPO, AbstractPublishSourceModel abstractPublishSourceModel) throws IOException, AnalysisException, AbstractQingIntegratedException, SQLException {
        IQingFile uploadCardImageFile = null;
        if (cardPO.isImport()) {
            String tempCardImageKey = cardPO.getTempImageFileKey();
            if (StringUtils.isNotEmpty((CharSequence)tempCardImageKey)) {
                uploadCardImageFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)tempCardImageKey);
            }
        } else {
            uploadCardImageFile = this.generaImg(tag, (PublishPO)cardPO, abstractPublishSourceModel);
        }
        if (uploadCardImageFile != null) {
            QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
            resourceInfo.setFromId(cardPO.getId());
            resourceInfo.setDisplayName(cardPO.getName());
            resourceInfo.setFromType(ResourceFromType.CARDTHUMBNAIL);
            IQingFile imageFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.CARD_THUMBNAIL);
            FileFactory.copy((IQingFileVisitor)uploadCardImageFile, (IQingFile)imageFile, (boolean)true);
            cardPO.setImagePath(imageFile.getName());
        }
        return cardPO;
    }

    private IQingFile generaImg(String tag, PublishPO publishInfo, AbstractPublishSourceModel abstractPublishSourceModel) throws AbstractQingIntegratedException, SQLException, AnalysisException {
        String selectedSchemaId = publishInfo.getSchemaId();
        ModelBook modelBook = null;
        int schemaSourceType = 0;
        if ("currentAnalysisState".equals(selectedSchemaId)) {
            modelBook = ((PublishSchemaModel)abstractPublishSourceModel).getSchemaContent();
            schemaSourceType = ((PublishSchemaModel)abstractPublishSourceModel).getSchemaAttr().getSource();
        } else {
            SchemaBO schemaBO = this.getSchemaManageDao().findSchemaById(selectedSchemaId);
            schemaSourceType = schemaBO.getSource();
            byte[] modelBookContent = this.getSchemaManageDao().loadSchemaContent(selectedSchemaId);
            List<OutsideReference> outSideRefList = this.getSchemaManageDao().loadSchemaRef(selectedSchemaId);
            modelBook = SchemaDomain.byteToModel(modelBookContent);
            modelBook.fixReferences(outSideRefList);
        }
        Meta meta = modelBook.getMeta();
        ModelBook.ModelPage modelPage = (ModelBook.ModelPage)modelBook.getPages().get(0);
        SquareModel squareModel = (SquareModel)modelPage.getModel();
        ModelBook.ModelPage.prepareForExecuting((Meta)meta, (IQingModel)squareModel, (IPreferences)modelPage.getPreferences());
        if (schemaSourceType != 1) {
            return null;
        }
        int width = 230;
        int height = 115;
        IQingFile exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        SquareExecuteDomain executeDomain = new SquareExecuteDomain(this.getDataSourceCreator(tag));
        executeDomain.setI18nContext(this.qingContext.getIi18nContext());
        ExportDomain exportDomain = new ExportDomain();
        exportDomain.doExportSquareImage(width, height, exportFile, squareModel, executeDomain, "png");
        return exportFile;
    }

    public String loadOrCreatePath(String userId, String pathId, String pathName) throws AbstractQingIntegratedException, SQLException {
        String id = UUID.randomUUID().toString();
        CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByName(userId, pathName);
        if (cardGroupPO == null) {
            cardGroupPO = new CardGroupPO();
            cardGroupPO.setCreateTime(new Date());
            cardGroupPO.setName(pathName);
            cardGroupPO.setUpdateTime(new Date());
            cardGroupPO.setUserId(userId);
            cardGroupPO.setfId(id);
            this.getPublishCardDao().saveGroup(cardGroupPO);
        } else {
            id = cardGroupPO.getfId();
        }
        return id;
    }

    public String loadPathNameByPath(String path, String publishId) throws AbstractQingIntegratedException, SQLException {
        CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByIdForExport(path);
        return Messages.getMLS((QingContext)this.qingContext, (String)"card", (String)"\u5361\u7247\u5e93", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + cardGroupPO.getName();
    }

    public String loadPathNamePOByPathId(String pathId) throws AbstractQingIntegratedException, SQLException {
        CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByIdForExport(pathId);
        return cardGroupPO.getName();
    }
}

