/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.card.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageLimitException;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imexport.model.po.AbstractPublishModel;
import com.kingdee.bos.qing.imexport.model.publish.target.PublishToCard;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeFileSizeLimitException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.collector.ICollectable;
import com.kingdee.bos.qing.manage.imexport.collector.common.PublishInfoCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.CardPngCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishBoxCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishQsFileCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishQsPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishSchemaCollector;
import com.kingdee.bos.qing.manage.imexport.collector.subject.publish.PublishShcemaPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.po.CardPublishModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportPublishConflictVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.publish.exception.PublishNameDuplicateException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.target.card.model.CardGroupPO;
import com.kingdee.bos.qing.publish.target.card.model.CardPO;
import com.kingdee.bos.qing.publish.target.card.model.CardVO;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class CardPublishTargetImexportDomain
extends AbstractPublishTargetImexportDomain {
    private static Map<String, ICollectable> collectorSet = new HashMap<String, ICollectable>();
    private MapManageDao mapManageDao;

    public CardPublishTargetImexportDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    @Override
    public void collectPublishInfo(ZipInputStream zis, String[] zipEntry, AbstractThemeImportModel themeImportModel) throws ImportThemeException, AbstractQingIntegratedException {
        if (zipEntry != null && zipEntry.length >= 3 && "cardrepository".equals(zipEntry[2])) {
            String entryName = zipEntry[zipEntry.length - 1];
            ICollectable collector = null;
            collector = "cardrepositorypublish.xml".equals(entryName) ? new PublishInfoCollector(new CardPublishModel(), new SubjectPublishImportModel()) : collectorSet.get(entryName);
            if (collector != null) {
                collector.collect(zis, zipEntry, themeImportModel);
            }
        }
    }

    @Override
    public AbstractPublishModel createNewPublishModel() {
        return new CardPublishModel();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExportPublishInfo(ZipOutputStream zos, String themeGroupName, PublishPO publishPo, ThemeVO themeVO, String themeFolderPath) throws ThemeManagementException, AbstractQingIntegratedException {
        QingInputStream sis = null;
        try {
            String publishFloder = UUID.randomUUID().toString();
            CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByIdForExport(publishPo.getPath());
            CardVO cardInfo = this.getPublishCardDao().loadPublishCardBaseInfo(publishPo.getId());
            CardPublishModel cardPublishModel = (CardPublishModel)this.initPublishModel(publishPo, themeGroupName, themeVO);
            cardPublishModel.setCardGroup(cardGroupPO.getName());
            cardPublishModel.setImagePath(cardInfo.getImagePath());
            cardPublishModel.setCardDesc(cardInfo.getCardDesc());
            List<OutsideReference> outSideRefList = this.getSchemaManageDao().loadSchemaRef(publishPo.getSchemaId());
            if (outSideRefList != null && !outSideRefList.isEmpty()) {
                this.setMapFullPath(outSideRefList);
                cardPublishModel.setReference(ImportUtil.createRefMap(outSideRefList));
            }
            String publishPrefixPath = themeFolderPath + File.separator + "cardrepository" + File.separator + publishFloder;
            Element propertyElement = cardPublishModel.toXml();
            zos.putNextEntry(new ZipEntry(publishPrefixPath + File.separator + "cardrepositorypublish.xml"));
            XmlUtil.save((Element)propertyElement, (OutputStream)zos);
            IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, (String)cardInfo.getImagePath());
            if (file.exists()) {
                zos.putNextEntry(new ZipEntry(publishPrefixPath + File.separator + "subject-pub-card.png"));
                sis = file.getInputStream();
                IOUtil.copy((InputStream)sis, (OutputStream)zos);
            }
            this.getSubjectPublishSourceDomain().doExport(zos, publishPo, publishPrefixPath, cardPublishModel);
        }
        catch (SQLException e) {
            try {
                throw new ExportThemeException(e);
                catch (IOException e2) {
                    throw new ExportThemeException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{sis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{sis});
    }

    @Override
    public void doImportPublishInfo(AbstractThemeImportModel themeImportModel, AbstractPublishImportModel publishImportModel, List<IQingFile> saveSuccessFiles) throws ThemeManagementException, AbstractQingIntegratedException {
        String themeId = themeImportModel.getThemeID();
        AbstractPublishModel publishModel = publishImportModel.getPublishModel();
        String publishId = PublishUtil.getPublishId((String)UUID.randomUUID().toString());
        CardPublishModel cardPublishModel = (CardPublishModel)publishModel;
        this.saveCardGroupInfo(cardPublishModel);
        try {
            publishModel.setPublishId(publishId);
            publishModel.setTagId(themeId);
            String tempCardImageFileName = this.uploadTempCardImage(cardPublishModel);
            CardPO cardPO = new CardPO();
            cardPO.setImagePath(cardPublishModel.getImagePath());
            cardPO.setCardDesc(cardPublishModel.getCardDesc());
            cardPO.setId(cardPublishModel.getPublishId());
            cardPO.setTempImageFileKey(tempCardImageFileName);
            List<Map<String, String>> outSideRefMapList = cardPublishModel.getReference();
            if (outSideRefMapList != null && !outSideRefMapList.isEmpty()) {
                Set<String> mapPaths = themeImportModel.getMapPath();
                for (int i = 0; i < outSideRefMapList.size(); ++i) {
                    Map<String, String> outSideRef = outSideRefMapList.get(i);
                    String mapPath = outSideRef.get("fullPath");
                    mapPaths.add(mapPath);
                }
            }
            this.savePublishImportInfo(themeImportModel, publishImportModel, (PublishPO)cardPO, saveSuccessFiles);
            if ("0".equals(themeImportModel.getThemeType())) {
                String cardPath = themeImportModel.getNameSpace() + "/" + cardPublishModel.getCardGroup() + "/" + cardPublishModel.getName();
                themeImportModel.getImportCardPathAndId().put(cardPath, publishId);
            }
        }
        catch (PublishNameDuplicateException e) {
            this.doPublishNameDuplicate(themeImportModel, cardPublishModel);
        }
        catch (PublishSameSourceNameDuplicateException e) {
            this.doPublishNameDuplicate(themeImportModel, cardPublishModel);
        }
    }

    private void doPublishNameDuplicate(AbstractThemeImportModel themeImportModel, CardPublishModel cardPublishModel) throws AbstractQingIntegratedException, ImportThemeException {
        try {
            String userId = this.qingContext.getUserId();
            ThemeVO themeVO = this.getThemeDao().loadThemeIncludePreset(userId, cardPublishModel.getTagId());
            String themeName = themeVO.getThemeName();
            ExportPublishConflictVO exportPublicConflict = new ExportPublishConflictVO();
            String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"card", (String)"\u5361\u7247\u5e93", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + cardPublishModel.getCardGroup() + "/" + cardPublishModel.getName();
            exportPublicConflict.setThemeName(themeName);
            exportPublicConflict.setThemeType(themeVO.getThemeType());
            exportPublicConflict.setPublishPath(publishPath);
            themeImportModel.getConfilctPublishList().add(exportPublicConflict);
        }
        catch (SQLException e) {
            throw new ImportThemeException(e);
        }
    }

    private void saveCardGroupInfo(CardPublishModel cardPublishModel) throws AbstractQingIntegratedException, ImportThemeException {
        Map cardGroups = (Map)ImportUtil.getImportCache("cardGroupsMap", new HashMap());
        String userId = this.qingContext.getUserId();
        String path = UUID.randomUUID().toString();
        String groupName = cardPublishModel.getCardGroup();
        try {
            if (cardGroups.get(groupName) == null) {
                CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByName(userId, groupName);
                if (cardGroupPO == null) {
                    cardGroupPO = new CardGroupPO();
                    cardGroupPO.setCreateTime(new Date());
                    cardGroupPO.setName(groupName);
                    cardGroupPO.setUpdateTime(new Date());
                    cardGroupPO.setUserId(userId);
                    cardGroupPO.setfId(path);
                    this.getPublishCardDao().saveGroup(cardGroupPO);
                } else {
                    path = cardGroupPO.getfId();
                }
                cardGroups.put(groupName, path);
            } else {
                path = (String)cardGroups.get(groupName);
            }
            cardPublishModel.setPath(path);
        }
        catch (SQLException e) {
            throw new ImportThemeException(e);
        }
    }

    private String uploadTempCardImage(CardPublishModel cardPublishModel) throws ImportThemeException {
        IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.UPLOAD);
        byte[] cardPngContent = cardPublishModel.getCardPngContent();
        try {
            if (cardPngContent != null) {
                qingFile.write((IWriteCall)new CopyWriteCall((InputStream)new ByteArrayInputStream(cardPngContent), false), true);
                return qingFile.getName();
            }
        }
        catch (QingFileStorageLimitException e) {
            throw new ImportThemeFileSizeLimitException(e);
        }
        catch (IOException e) {
            throw new ImportThemeException(e);
        }
        return null;
    }

    private void setMapFullPath(List<OutsideReference> outSideRefList) throws AbstractQingIntegratedException, SQLException {
        for (int j = 0; j < outSideRefList.size(); ++j) {
            OutsideReference outSideRef = outSideRefList.get(j);
            if (outSideRef.getRefToFullPath() != null) continue;
            String mapId = outSideRef.getRefToId();
            MapVO mapVO = this.getMapManageDao().getMapPath(mapId);
            String mapNameSpace = NameSpace.getNameSpace((String)mapVO.getNameSpace()).toPersistance();
            String mapPath = mapNameSpace + "/" + mapVO.getMapGroupName() + "/" + mapVO.getMapName();
            outSideRef.setRefToFullPath(mapPath);
        }
    }

    @Override
    public PublishPO loadNewPublishPO(PublishTarget publishTarget, Map<String, String> tempFile) throws AbstractQingIntegratedException, SQLException {
        String userId = this.qingContext.getUserId();
        String path = UUID.randomUUID().toString();
        CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByName(userId, publishTarget.getPath());
        if (cardGroupPO == null) {
            cardGroupPO = new CardGroupPO();
            cardGroupPO.setCreateTime(new Date());
            cardGroupPO.setName(publishTarget.getPath());
            cardGroupPO.setUpdateTime(new Date());
            cardGroupPO.setUserId(userId);
            cardGroupPO.setfId(path);
            this.getPublishCardDao().saveGroup(cardGroupPO);
        } else {
            path = cardGroupPO.getfId();
        }
        String tempThumbnailFile = tempFile.get(((PublishToCard)publishTarget).getThumbnail());
        String desc = ((PublishToCard)publishTarget).getDesc();
        CardPO cardPO = new CardPO();
        cardPO.setPath(path);
        cardPO.setTempImageFileKey(tempThumbnailFile);
        cardPO.setCardDesc(desc);
        return cardPO;
    }

    @Override
    public void doPublishNameDuplicate(List<ExportPublishConflictVO> confilctPublishList, ThemeVO themeVO, String importPath, String publishName) throws AbstractQingIntegratedException, ImportThemeException {
        ExportPublishConflictVO exportPublicConflict = new ExportPublishConflictVO();
        String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"card", (String)"\u5361\u7247\u5e93", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + importPath + "/" + publishName;
        exportPublicConflict.setThemeName(themeVO.getThemeName());
        exportPublicConflict.setThemeType(themeVO.getThemeType());
        exportPublicConflict.setPublishPath(publishPath);
        confilctPublishList.add(exportPublicConflict);
    }

    static {
        collectorSet.put("subject-pub-card-schema.xml", new PublishShcemaPropertyCollector());
        collectorSet.put("subject-pub-card.schema", new PublishSchemaCollector());
        collectorSet.put("subject-pub-card.png", new CardPngCollector());
        collectorSet.put("card_qs.xml", new PublishQsPropertyCollector());
        collectorSet.put("card.qs", new PublishQsFileCollector());
        collectorSet.put("card.model", new PublishBoxCollector());
    }
}

