/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.dsbtimingpush.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jdom2.Element;

public class DsbTimingPushDao {
    private IDBExcuter dbExcuter;

    public DsbTimingPushDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void updateDsbModelContent(String sourceId, int sourceType, DashboardModel dsbModel) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, EncryptedLicenseCheckException {
        InputStream dbStream = this.loadDsbModelContentStream(sourceId, sourceType);
        this.dbExcuter.execute("DELETE FROM T_QING_TP_DSB_CONTENT WHERE FSOURCEID=? AND FSOURCETYPE=?", new Object[]{sourceId, sourceType});
        this.saveDsbModelContent(sourceId, sourceType, dsbModel, dbStream);
    }

    public InputStream loadDsbModelContentStream(String sourceId, int sourceType) throws AbstractQingIntegratedException, SQLException {
        byte[] content = this.readBlock("SELECT FCONTENT FROM T_QING_TP_DSB_CONTENT WHERE FSOURCEID=? AND FSOURCETYPE=? ORDER BY FCONTENTINDEX ASC", new Object[]{sourceId, sourceType});
        return BoxUtil.parseByteToInputStream(content);
    }

    public DashboardModel loadDsbModel(String sourceId, int sourceType) throws EncryptedLicenseCheckException, PersistentModelParseException, AbstractQingIntegratedException, SQLException {
        InputStream dsbModelStream = this.loadDsbModelContentStream(sourceId, sourceType);
        if (dsbModelStream == null) {
            return null;
        }
        return DashboardSerializationUtil.toModel(dsbModelStream);
    }

    public void saveDsbModelContent(String sourceId, int sourceType, DashboardModel dsbModel, InputStream dsbModelStream) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, EncryptedLicenseCheckException {
        InputStream dbModelStream = this.loadDsbModelContentStream(sourceId, sourceType);
        byte[] dsbModelBytes = DashboardSerializationUtil.toBytes(dsbModel, dsbModelStream, dbModelStream);
        if (dsbModelBytes == null) {
            return;
        }
        int length = dsbModelBytes.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[5];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                String fid = this.dbExcuter.genStringId("T_QING_TP_DSB_CONTENT");
                param[0] = fid;
                param[1] = sourceId;
                param[2] = sourceType;
                param[3] = i;
                param[4] = this.dbExcuter.createSqlParameterBytes(dsbModelBytes, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_TP_DSB_CONTENT (FID, FSOURCEID, FSOURCETYPE, FCONTENTINDEX, FCONTENT) VALUES(?, ?, ?, ?, ?)", params);
        }
    }

    public String saveRefInfo(String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException {
        Object[] param = new Object[7];
        String fid = this.dbExcuter.genStringId("T_QING_TP_DSB_REF");
        param[0] = fid;
        param[1] = sourceId;
        param[2] = sourceType;
        param[3] = refItem.getUid();
        param[4] = StringUtils.isNotBlank((CharSequence)refItem.getRefToId()) ? refItem.getRefToId() : " ";
        param[5] = StringUtils.isNotBlank((CharSequence)refItem.getRefToId()) ? null : refItem.getRefToFullPath();
        param[6] = refItem.getRefType();
        this.dbExcuter.execute("INSERT INTO T_QING_TP_DSB_REF (FID, FSOURCEID, FSOURCETYPE, FREFUID, FREFTOID, FFULLPATH, FREFTYPE) VALUES(?, ?, ?, ?, ?, ?,?)", param);
        return fid;
    }

    public String loadRefPkId(String sourceId, String uid, int sourceType) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[3];
        int i = 0;
        params[i++] = sourceId;
        params[i++] = uid;
        params[i++] = sourceType;
        String sql = "SELECT FID FROM T_QING_TP_DSB_REF WHERE FSOURCEID=? AND FREFUID=? AND FSOURCETYPE=?";
        return (String)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String fid = null;
                if (rs.next()) {
                    fid = rs.getString("FID");
                }
                return fid;
            }
        });
    }

    public List<OutsideReference> loadSchemaRef(String fId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FREFTOID, FFULLPATH, FREFTYPE, FREFUID FROM T_QING_TP_DSB_REF WHERE FID=?", new Object[]{fId}, (ResultHandler)new ResultHandler<List<OutsideReference>>(){

            public List<OutsideReference> handle(ResultSet rs) throws SQLException {
                ArrayList<OutsideReference> list = new ArrayList<OutsideReference>(10);
                while (rs.next()) {
                    OutsideReference outsideRef = new OutsideReference();
                    outsideRef.setRefToId(rs.getString("FREFTOID"));
                    outsideRef.setRefToFullPath(rs.getString("FFULLPATH"));
                    outsideRef.setRefType(rs.getString("FREFTYPE"));
                    outsideRef.setUid(rs.getString("FREFUID"));
                    list.add(outsideRef);
                }
                return list;
            }
        });
    }

    public void saveRefContent(String sourceId, int sourceType, ReferenceMap refItem, ModelBook modelBook) throws AbstractQingIntegratedException, SQLException {
        byte[] dsbModelBytes = XmlUtil.toByteArray((Element)modelBook.toXml());
        int length = dsbModelBytes.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[6];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                String fId = this.dbExcuter.genStringId("T_QING_TP_DSB_REF_CONT");
                param[0] = fId;
                param[1] = sourceId;
                param[2] = sourceType;
                param[3] = refItem.getUid();
                param[4] = i;
                param[5] = this.dbExcuter.createSqlParameterBytes(dsbModelBytes, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_TP_DSB_REF_CONT (FID, FSOURCEID, FSOURCETYPE, FREFUID, FCONTENTINDEX, FCONTENT) VALUES(?, ?, ?, ?, ?, ?)", params);
        }
    }

    public List<ReferenceMap> getRefList(String sourceId, int sourceType) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID, FREFUID, FREFTOID, FFULLPATH, FREFTYPE FROM T_QING_TP_DSB_REF WHERE FSOURCEID=? AND FSOURCETYPE=?", new Object[]{sourceId, sourceType}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    refItem.setUid(rs.getString("FREFUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.put((Object)"FID", (Object)rs.getString("FID"));
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public List<ReferenceMap> getRefListForEditDsb(String sourceId, int sourceType) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID, FREFUID, FREFTOID, FFULLPATH, FREFTYPE FROM T_QING_TP_DSB_REF WHERE FSOURCEID=? AND FSOURCETYPE=?", new Object[]{sourceId, sourceType}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.put((Object)"outerRefKey", (Object)UUID.randomUUID().toString());
                    refItem.setUid(rs.getString("FREFUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    RefTypeEnum refEnum = RefTypeEnum.valueOf((String)rs.getString("FRefType").toLowerCase());
                    if (RefTypeEnum.picture == refEnum) {
                        String widgetSourcePath = DashboardModelUtil.parseFullPath(rs.getString("FFullPath"), refEnum);
                        refItem.put((Object)"widgetSourcePath", (Object)widgetSourcePath);
                    }
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.put((Object)"FID", (Object)rs.getString("FID"));
                    refItem.setFileKey(UUID.randomUUID().toString());
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public byte[] loadRefContent(String sourceId, int sourceType, String uid) throws AbstractQingIntegratedException, SQLException {
        return this.readBlock("SELECT FCONTENT FROM T_QING_TP_DSB_REF_CONT WHERE FSOURCEID=? AND FSOURCETYPE=? AND FREFUID=? ORDER BY FCONTENTINDEX ASC", new Object[]{sourceId, sourceType, uid});
    }

    private byte[] readBlock(String sql, Object[] params) throws AbstractQingIntegratedException, SQLException {
        return (byte[])this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    do {
                        try {
                            os.write(rs.getBytes("FCONTENT"));
                        }
                        catch (IOException e) {
                            LogUtil.error((String)e.getMessage(), (Throwable)e);
                        }
                    } while (rs.next());
                    return os.toByteArray();
                }
                return null;
            }
        });
    }

    public void delete(String sourceId, int sourceType) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_TP_DSB_CONTENT WHERE FSOURCEID=? AND FSOURCETYPE=?", new Object[]{sourceId, sourceType});
        this.dbExcuter.execute("DELETE FROM T_QING_TP_DSB_REF WHERE FSOURCEID=? AND FSOURCETYPE=?", new Object[]{sourceId, sourceType});
        this.dbExcuter.execute("DELETE FROM T_QING_TP_DSB_REF_CONT WHERE FSOURCEID=? AND FSOURCETYPE=?", new Object[]{sourceId, sourceType});
    }

    public void deleteRefAndContent(String sourceId, String refUid, int sourceType) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_TP_DSB_REF WHERE FSOURCEID=? AND FREFUID=? AND FSOURCETYPE=?", new Object[]{sourceId, refUid, sourceType});
        this.dbExcuter.execute("DELETE FROM T_QING_TP_DSB_REF_CONT WHERE FSOURCEID=? AND FREFUID=? AND FSOURCETYPE=?", new Object[]{sourceId, refUid, sourceType});
    }

    public List<ReferenceMap> loadRefListByRefToId(String refToId, String refType, String userId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT R.FID, R.FREFUID, R.FREFTOID, R.FFULLPATH, R.FREFTYPE FROM T_QING_TP_DSB_REF R LEFT JOIN T_QING_PUB_EMAIL_CONF EC ON R.FSOURCEID = EC.FID WHERE R.FREFTOID = ? AND R.FREFTYPE LIKE ? AND EC.FUSERID = ? AND R.FSOURCETYPE = 6", new Object[]{refToId, refType, userId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.setUid(rs.getString("FREFUID"));
                    refItem.setRefToFullPath(rs.getString("FFULLPATH"));
                    refItem.setRefType(rs.getString("FREFTYPE"));
                    refItem.setRefToId(rs.getString("FREFTOID"));
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public List<ReferenceMap> loadRobotPushRefListByRefToId(String refToId, String refType, String userId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT R.FID, R.FREFUID, R.FREFTOID, R.FFULLPATH, R.FREFTYPE FROM T_QING_TP_DSB_REF R LEFT JOIN T_QING_PUSH_CONFIG_INFO EC ON R.FSOURCEID = EC.FID WHERE R.FREFTOID = ? AND R.FREFTYPE = ? AND EC.FUSERID = ? AND R.FSOURCETYPE = 2", new Object[]{refToId, refType, userId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.setUid(rs.getString("FREFUID"));
                    refItem.setRefToFullPath(rs.getString("FFULLPATH"));
                    refItem.setRefType(rs.getString("FREFTYPE"));
                    refItem.setRefToId(rs.getString("FREFTOID"));
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public void updateRef(ReferenceMap ref) throws AbstractQingIntegratedException, SQLException {
        Object[] param = new Object[]{ref.getRefToId(), ref.getRefToFullPath(), ref.get((Object)"id")};
        this.dbExcuter.execute("UPDATE T_QING_TP_DSB_REF SET FREFTOID = ?, FFULLPATH = ? WHERE FID = ?", param);
    }

    public void updateRefToIdByRefId(String fId, String refToId) throws SQLException, AbstractQingIntegratedException {
        Object[] param = new Object[]{refToId, null, fId};
        this.dbExcuter.execute("UPDATE T_QING_TP_DSB_REF SET FREFTOID = ?, FFULLPATH = ? WHERE FID = ?", param);
    }

    public List<ReferenceMap> loadRefListByFullPath(String fullPath, String refType, String userId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT R.FID, R.FREFUID, R.FREFTOID, R.FFULLPATH, R.FREFTYPE FROM T_QING_TP_DSB_REF R LEFT JOIN T_QING_PUB_EMAIL_CONF EC ON R.FSOURCEID = EC.FID WHERE R.FFULLPATH = ? AND R.FREFTYPE LIKE ? AND EC.FUSERID = ? AND R.FSOURCETYPE = 6", new Object[]{fullPath, refType, userId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.setUid(rs.getString("FREFUID"));
                    refItem.setRefToFullPath(rs.getString("FFULLPATH"));
                    refItem.setRefType(rs.getString("FREFTYPE"));
                    refItem.setRefToId(rs.getString("FREFTOID"));
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public List<ReferenceMap> loadRobotPushRefListByFullPath(String fullPath, String refType, String userId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT R.FID, R.FREFUID, R.FREFTOID, R.FFULLPATH, R.FREFTYPE FROM T_QING_TP_DSB_REF R LEFT JOIN T_QING_PUSH_CONFIG_INFO EC ON R.FSOURCEID = EC.FID WHERE R.FFULLPATH = ? AND R.FREFTYPE = ? AND EC.FUSERID = ? AND R.FSOURCETYPE = 2", new Object[]{fullPath, refType, userId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.setUid(rs.getString("FREFUID"));
                    refItem.setRefToFullPath(rs.getString("FFULLPATH"));
                    refItem.setRefType(rs.getString("FREFTYPE"));
                    refItem.setRefToId(rs.getString("FREFTOID"));
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public List<OutsideReference> loadSchemaRef(String sourceId, int sourceType) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID, FREFUID, FREFTOID, FFULLPATH, FREFTYPE FROM T_QING_TP_DSB_REF WHERE FSOURCEID=? AND FSOURCETYPE=?", new Object[]{sourceId, sourceType}, (ResultHandler)new ResultHandler<List<OutsideReference>>(){

            public List<OutsideReference> handle(ResultSet rs) throws SQLException {
                ArrayList<OutsideReference> refItems = new ArrayList<OutsideReference>(10);
                while (rs.next()) {
                    OutsideReference refItem = new OutsideReference();
                    refItem.setUid(rs.getString("FREFUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }
}

