/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.dsbtimingpush.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ModelJsonDecoder;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.ITimingPushable;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.publish.exception.PublishEncryptedLicenseException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishSourceDsbNotExistException;
import com.kingdee.bos.qing.publish.model.PublishDashboardModel;
import com.kingdee.bos.qing.publish.target.dsbtimingpush.dao.DsbTimingPushDao;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DsbTimingPushDomain {
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private ITransactionManagement tx;
    private DsbTimingPushDao dsbTimingPushDao;
    private IThemeDao iThemeDao;
    private DashboardDao dashboardDao;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;

    public DsbTimingPushDomain(IDBExcuter dbExcuter, QingContext qingContext, ITransactionManagement tx) {
        this.dbExcuter = dbExcuter;
        this.qingContext = qingContext;
        this.tx = tx;
    }

    private DsbTimingPushDao getDsbTimingPushDao() {
        if (this.dsbTimingPushDao == null) {
            this.dsbTimingPushDao = new DsbTimingPushDao(this.dbExcuter);
        }
        return this.dsbTimingPushDao;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    protected DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new HashMap<RefTypeEnum, IRefHandler>();
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.qingContext, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    public void insert(String dashboardUniqueId, String sourceId, int sourceType, String sceneModelJson) throws PublishException, AbstractQingIntegratedException {
        try {
            this.checkSourceIsExist(dashboardUniqueId);
            DashboardModel dsbModel = ModelJsonDecoder.decode((String)sceneModelJson);
            InputStream dbStream = this.getDashboardDao().loadDashboardStream(dashboardUniqueId);
            this.getDsbTimingPushDao().saveDsbModelContent(sourceId, sourceType, dsbModel, dbStream);
            List refItems = new ArrayList();
            refItems = dsbModel.pickReferences();
            for (int i = 0; i < refItems.size(); ++i) {
                ReferenceMap refItem = (ReferenceMap)refItems.get(i);
                RefTypeEnum refTypeEnum = RefTypeEnum.fromPersistance((String)refItem.getRefType());
                IRefHandler refHandler = this.getRefHandler(refTypeEnum);
                ((ITimingPushable)((Object)refHandler)).saveTimingPushReference(dashboardUniqueId, sourceId, sourceType, refItem);
            }
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw new PublishException((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw new PublishException((Throwable)e);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (PersistentModelParseException e) {
            throw new PublishException((Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new PublishEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
    }

    public void delete(String sourceId, int sourceType) throws AbstractQingIntegratedException, SQLException {
        this.getDsbTimingPushDao().delete(sourceId, sourceType);
    }

    private void checkSourceIsExist(String dashboardUniqueId) throws AbstractQingIntegratedException, SQLException, PublishSourceDsbNotExistException {
        ThemePO theme = this.getThemeDao().getThemeByID(dashboardUniqueId);
        if (theme == null) {
            throw new PublishSourceDsbNotExistException();
        }
    }

    public PublishDashboardModel loadPublishDashboardModel(String sourceId, int sourceType) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, EncryptedLicenseCheckException {
        InputStream dbStream = this.getDsbTimingPushDao().loadDsbModelContentStream(sourceId, sourceType);
        if (dbStream != null) {
            DashboardModel dashboardModel = DashboardSerializationUtil.toModel(dbStream);
            List<ReferenceMap> refItems = this.getDsbTimingPushDao().getRefList(sourceId, sourceType);
            dashboardModel.fixReferences(refItems);
            PublishDashboardModel publishDashboardModel = new PublishDashboardModel();
            publishDashboardModel.setDsbModel(dashboardModel);
            InputStream dsbModelStream = this.getDsbTimingPushDao().loadDsbModelContentStream(sourceId, sourceType);
            publishDashboardModel.setDashboardStream(dsbModelStream);
            Map<String, ModelBook> allRefContents = this.loadAllRefContents(sourceId, sourceType, refItems);
            publishDashboardModel.setAllRefContents(allRefContents);
            return publishDashboardModel;
        }
        return null;
    }

    public Map<String, ModelBook> loadAllRefContents(String sourceId, int sourceType, List<ReferenceMap> refItems) throws AbstractQingIntegratedException, SQLException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException {
        HashMap<String, ModelBook> allRefContentsMap = new HashMap<String, ModelBook>();
        for (int i = 0; i < refItems.size(); ++i) {
            ReferenceMap refItem = refItems.get(i);
            String uid = refItem.getUid();
            byte[] refContentByte = this.getDsbTimingPushDao().loadRefContent(sourceId, sourceType, uid);
            List<OutsideReference> outSideRef = this.getDsbTimingPushDao().loadSchemaRef((String)refItem.get((Object)"FID"), sourceType);
            if (refContentByte == null) continue;
            ModelBook modelBook = DashboardModelUtil.byteToSchemaModel(refContentByte);
            modelBook.fixReferences(outSideRef);
            allRefContentsMap.put(uid, modelBook);
        }
        return allRefContentsMap;
    }

    public byte[] loadRefContent(String configId, String uid, int sourceType) throws AbstractQingIntegratedException, SQLException {
        return this.getDsbTimingPushDao().loadRefContent(configId, sourceType, uid);
    }

    public String loadRefInfoPkId(String sourceId, String uid, int sourceType) throws AbstractQingIntegratedException, SQLException {
        return this.getDsbTimingPushDao().loadRefPkId(sourceId, uid, sourceType);
    }

    public List<OutsideReference> loadSchemaRef(String sourceId, int sourceType) throws AbstractQingIntegratedException, SQLException {
        return this.getDsbTimingPushDao().loadSchemaRef(sourceId, sourceType);
    }

    public List<ReferenceMap> getRefList(String sourceId, int sourceType) throws AbstractQingIntegratedException, SQLException {
        return this.getDsbTimingPushDao().getRefList(sourceId, sourceType);
    }

    public void updateDsbModelContent(String sourceId, int sourceType, DashboardModel dsbModel) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, EncryptedLicenseCheckException {
        this.getDsbTimingPushDao().updateDsbModelContent(sourceId, sourceType, dsbModel);
    }
}

