/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.source.db.util.AESUtil;
import com.kingdee.bos.qing.publish.target.email.model.EmailSenderVO;
import com.kingdee.bos.qing.publish.target.email.util.RSAUtils;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class EmailSenderDao {
    private IDBExcuter dbExcuter;

    public EmailSenderDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public String genStringId() {
        return this.dbExcuter.genStringId("T_QING_PUB_EMAIL_SENDER");
    }

    public EmailSenderVO getUserEmailSender(String userId, final boolean decryptPWD) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID,FNAME,FACCOUNT,FPWD,FSMTPHOST,FISSSL,FPORT,FPASSWORD FROM T_QING_PUB_EMAIL_SENDER WHERE FUSERID=?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        return (EmailSenderVO)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<EmailSenderVO>(){

            public EmailSenderVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    EmailSenderVO emailSender = new EmailSenderVO();
                    emailSender.setId(rs.getString("FID"));
                    emailSender.setName(rs.getString("FNAME"));
                    emailSender.setAccount(rs.getString("FACCOUNT"));
                    String pwd = rs.getString("FPWD");
                    String fpassword = EmailSenderDao.this.getStringFromBlob("FPASSWORD", rs);
                    if (fpassword != null && !fpassword.isEmpty()) {
                        pwd = fpassword;
                    }
                    pwd = AESUtil.aesByString((String)pwd, (int)2);
                    if (decryptPWD) {
                        pwd = RSAUtils.decryptByPrivateKey(pwd, EmailSenderVO.RSAPRIVATEKEY);
                    }
                    emailSender.setPwd(pwd);
                    emailSender.setSmtpHost(rs.getString("FSMTPHOST"));
                    emailSender.setSSL(rs.getInt("FISSSL") != 0);
                    emailSender.setPort(rs.getInt("FPORT"));
                    return emailSender;
                }
                return null;
            }
        });
    }

    public EmailSenderVO getEmailSenderById(String senderId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FNAME,FACCOUNT,FPWD,FSMTPHOST,FISSSL,FPORT,FPASSWORD FROM T_QING_PUB_EMAIL_SENDER WHERE FID=? AND FUSERID=?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(senderId);
        queryValue.add(userId);
        return (EmailSenderVO)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<EmailSenderVO>(){

            public EmailSenderVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    EmailSenderVO emailSender = new EmailSenderVO();
                    emailSender.setId(rs.getString("FID"));
                    emailSender.setName(rs.getString("FNAME"));
                    emailSender.setAccount(rs.getString("FACCOUNT"));
                    String pwd = rs.getString("FPWD");
                    String fpassword = EmailSenderDao.this.getStringFromBlob("FPASSWORD", rs);
                    if (fpassword != null && !fpassword.isEmpty()) {
                        pwd = fpassword;
                    }
                    String password = AESUtil.aesByString((String)pwd, (int)2);
                    emailSender.setPwd(RSAUtils.decryptByPrivateKey(password, EmailSenderVO.RSAPRIVATEKEY));
                    emailSender.setSmtpHost(rs.getString("FSMTPHOST"));
                    emailSender.setSSL(rs.getBoolean("FISSSL"));
                    emailSender.setPort(rs.getInt("FPORT"));
                    return emailSender;
                }
                return null;
            }
        });
    }

    public String insert(EmailSenderVO emailSender) throws AbstractQingIntegratedException, SQLException {
        String id = this.genStringId();
        Object[] params = new Object[]{id, emailSender.getUserId(), emailSender.getName(), emailSender.getAccount(), AESUtil.aesByString((String)emailSender.getPwd(), (int)1).getBytes(), emailSender.getSmtpHost(), emailSender.isSSL() ? 1 : 0, emailSender.getPort(), " "};
        String sql = "INSERT INTO T_QING_PUB_EMAIL_SENDER(FID, FUSERID, FNAME, FACCOUNT, FPASSWORD, FSMTPHOST, FISSSL, FPORT, FPWD) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.dbExcuter.execute(sql, params);
        return id;
    }

    public void update(EmailSenderVO emailSender) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{emailSender.getName(), emailSender.getAccount(), AESUtil.aesByString((String)emailSender.getPwd(), (int)1).getBytes(), emailSender.getSmtpHost(), emailSender.isSSL() ? 1 : 0, emailSender.getPort(), emailSender.getId()};
        String sql = "UPDATE T_QING_PUB_EMAIL_SENDER SET FNAME=?, FACCOUNT=?, FPASSWORD=?, FSMTPHOST=?, FISSSL=?, FPORT=? WHERE FID=?";
        this.dbExcuter.execute(sql, params);
    }

    public void delete(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUB_EMAIL_SENDER WHERE FID=?";
        this.dbExcuter.execute(sql, new Object[]{id});
    }

    private String getStringFromBlob(String colName, ResultSet rs) throws SQLException {
        try {
            byte[] bytes = rs.getBytes(colName);
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            return new String(bytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return rs.getString(colName);
        }
    }
}

