/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.publish.exception.PublishEncryptedLicenseException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PushRecordConfig;
import com.kingdee.bos.qing.publish.model.PushTargetType;
import com.kingdee.bos.qing.publish.target.email.domain.AbstractEmailConfigDomain;
import com.kingdee.bos.qing.publish.target.email.domain.EmailConfigManageDomain;
import com.kingdee.bos.qing.publish.target.email.exception.EmailException;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.publish.target.email.model.EmailNameRule;
import com.kingdee.bos.qing.publish.target.email.source.IEmailConfigSourceDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.DateUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jdom2.JDOMException;

public class EmailConfigScheduleExecuteDomain
extends AbstractEmailConfigDomain {
    private EmailConfigManageDomain emailConfigManageDomain;

    protected EmailConfigManageDomain getPublishManageDomain() {
        if (this.emailConfigManageDomain == null) {
            this.emailConfigManageDomain = new EmailConfigManageDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.emailConfigManageDomain;
    }

    public EmailConfigScheduleExecuteDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    public void savePublishInfo(String publishId, EmailConfig emailConfig, String tag, String emailSubjectName) throws PublishException, AbstractQingIntegratedException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, PersistentModelParseException {
        try {
            PublishPO publishInfo = emailConfig.toPublishPO(publishId, emailSubjectName);
            List<PermissionInfo> permissionInfos = this.getPermissionInfos(emailConfig.isAnonymousView(), publishInfo.getId());
            IEmailConfigSourceDomain emailConfigSourceDomain = this.getSourceDomain(emailConfig.getPublishSourceType());
            AbstractPublishSourceModel publishSourceModel = emailConfigSourceDomain.loadPublishModel(emailConfig);
            ArrayList<AbstractPublishSourceModel> publishSourceModelList = new ArrayList<AbstractPublishSourceModel>(1);
            publishSourceModelList.add(publishSourceModel);
            this.savePublishInfo(tag, publishInfo, permissionInfos, publishSourceModelList);
        }
        catch (SQLException e) {
            throw new EmailException(e);
        }
        catch (JDOMException e) {
            throw new EmailException(e);
        }
        catch (IOException e) {
            throw new EmailException(e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new PublishEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
    }

    public void savePublishInfo(String tag, PublishPO publishInfo, List<PermissionInfo> permInfos, List<AbstractPublishSourceModel> publishSourceModelList) throws AbstractQingIntegratedException, PublishException {
        ArrayList savedQingFiles = new ArrayList();
        try {
            this.tx.beginRequired();
            this.savePublishByModel(tag, publishInfo, permInfos, publishSourceModelList, savedQingFiles);
        }
        catch (AbstractQingIntegratedException e) {
            FileFactory.clearFile(savedQingFiles);
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            FileFactory.clearFile(savedQingFiles);
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            FileFactory.clearFile(savedQingFiles);
            this.tx.markRollback();
            throw new PublishException((Throwable)e);
        }
        finally {
            this.tx.end();
        }
    }

    private List<PermissionInfo> getPermissionInfos(boolean isAnonymousView, String publishId) {
        ArrayList<PermissionInfo> permissionInfos = new ArrayList<PermissionInfo>();
        PermissionInfo permissionInfo = new PermissionInfo();
        permissionInfo.setId(UUID.randomUUID().toString());
        permissionInfo.setPublishId(publishId);
        permissionInfo.setViewerId(" ");
        permissionInfo.setCreateTime(new Date());
        permissionInfo.setType(isAnonymousView ? 2 : 3);
        permissionInfos.add(permissionInfo);
        return permissionInfos;
    }

    public String getSubjectName(EmailNameRule nameRule, String configId, Long serialNum) throws AbstractQingIntegratedException, SQLException {
        String subjectName = "";
        EmailNameRule.NameRuleType nameRuleType = nameRule.getType();
        switch (nameRuleType) {
            case fixed: {
                subjectName = nameRule.getName();
                break;
            }
            case date: {
                Locale locale = this.qingContext.getIi18nContext().getLanManager().getLocale();
                subjectName = nameRule.getName() + "-" + DateUtils.date2StrByLang((Locale)locale, (String)nameRule.getDateFormat(), (Date)new Date());
                break;
            }
            case serialNum: {
                Long serialNumNew = this.getSerialNum(configId, nameRule.getSerialStartValue(), nameRule.getSerialStepSize(), serialNum);
                subjectName = nameRule.getName() + "-" + serialNumNew;
                break;
            }
        }
        return subjectName;
    }

    public Long getSerialNum(String configId, Long startValue, Long stepSize, Long serialNum) throws AbstractQingIntegratedException, SQLException {
        serialNum = serialNum != null ? Long.valueOf(serialNum + stepSize) : startValue;
        try {
            this.tx.beginRequired();
            this.getEmailConfigDao().updateSerialNum(configId, serialNum);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
        return serialNum;
    }

    public EmailConfig getEmailConfigById(String id) throws AbstractQingIntegratedException, SQLException {
        return this.getEmailConfigDao().getEmailConfigById(id);
    }

    public String insertSendEmailsLog(String configId, String publishId, String name, int sendEmailsStatus) throws AbstractQingIntegratedException, SQLException, PublishException {
        try {
            this.tx.beginRequired();
            String insertSendEmailsLog = this.getEmailConfigDao().insertSendEmailsLog(configId, publishId, name, sendEmailsStatus);
            PushRecordConfig pushRecordConfig = this.getPublishManageDomain().loadPushRecordConfigInfo(this.qingContext.getUserId(), PushTargetType.EMAIL.toPersistance());
            if (pushRecordConfig != null) {
                this.getPublishManageDomain().deletePushRecordByConfigInfo(pushRecordConfig, configId);
            }
            String string = insertSendEmailsLog;
            return string;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }
}

