/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.IPreferences;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.common.brief.WarningRuleDefinition;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.domain.CommonTimedPushDsbDesignDomain;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.ModelBookTemporaryStorageException;
import com.kingdee.bos.qing.dashboard.exception.NotSelectMapException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.oplog.DashboardOpLog;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.ITimingPushable;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.ExportDomain;
import com.kingdee.bos.qing.domain.SquareExecuteDomain;
import com.kingdee.bos.qing.exceptionlog.dao.ExceptionLogDao;
import com.kingdee.bos.qing.exceptionlog.domain.ExceptionLogDomain;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLog;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageLimitException;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imagelibrary.exception.ImageFileSizeLimitException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageTypeException;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.imagelibrary.util.ImageTypeUtil;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.dao.BillManagerDao;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.domain.PublishSourceDomainFactory;
import com.kingdee.bos.qing.publish.exception.MapNotFoundException;
import com.kingdee.bos.qing.publish.exception.MismatchSourceTypeException;
import com.kingdee.bos.qing.publish.exception.PublishEncryptedLicenseException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNoPermissionException;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.exception.PublishScheduleModelException;
import com.kingdee.bos.qing.publish.exception.PublishSourcePublishNotExistException;
import com.kingdee.bos.qing.publish.exception.PublishSourceSubjectNotExistException;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PushRecordConfig;
import com.kingdee.bos.qing.publish.model.PushRecordSavingStrategy;
import com.kingdee.bos.qing.publish.model.PushTargetType;
import com.kingdee.bos.qing.publish.model.TimeUnit;
import com.kingdee.bos.qing.publish.model.TimingPushBillPO;
import com.kingdee.bos.qing.publish.target.dsbtimingpush.dao.DsbTimingPushDao;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.publish.target.lapp.env.LappApiEnum;
import com.kingdee.bos.qing.publish.target.lapp.exception.ExecuteSqlException;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappException;
import com.kingdee.bos.qing.publish.target.lapp.exception.ScheduleException;
import com.kingdee.bos.qing.publish.target.lapp.exception.TimedPushNotFound;
import com.kingdee.bos.qing.publish.target.lapp.model.HttpRequestErrorResult;
import com.kingdee.bos.qing.publish.target.lapp.model.HttpRequestSuccessResult;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.LappPublishVO;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishInfo;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishLappConfig;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishedDataSourceInfoVO;
import com.kingdee.bos.qing.publish.target.lapp.model.PushRecord;
import com.kingdee.bos.qing.publish.target.lapp.model.PushThumbnailInfoModel;
import com.kingdee.bos.qing.publish.target.lapp.model.ThirdPartyConfig;
import com.kingdee.bos.qing.publish.target.lapp.oplog.LappPushOpLog;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractLappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractLappSchedulePushDomain;
import com.kingdee.bos.qing.publish.target.lapp.push.LappSchedulePushDomainFactory;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.publish.thumbnail.ThumbnailHelper;
import com.kingdee.bos.qing.publish.thumbnail.domain.ThumbnailDomain;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailUrlModel;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.AbstractJobParam;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.schema.dao.ExtReportSchemaManageDao;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaContentVO;
import com.kingdee.bos.qing.schema.model.SchemaVO;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.DateUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class LappDomain
extends AbstractPublishManageDomain {
    private static final String PARAM_PATH_PREFIX = "paramPathPrefix";
    private static final String SOURCE_ID = "sourceId";
    private static final String SOURCE_NAME = "sourceName";
    private LappDao lappDao;
    private DashboardDao dashboardDao;
    private ExceptionLogDomain exceptionLogDomain;
    private ExceptionLogDao exceptionLogDao;
    private SchemaDomain schemaDomain;
    private ThumbnailDomain thumbnailDomain;
    private DsbTimingPushDao dsbTimingPushDao;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;
    private CommonTimedPushDsbDesignDomain commonDsbDesignDomain;
    private SchemaManageDao schemaManageDao;
    private ExtReportSchemaManageDao extRptSchemaManageDao;
    private ThemeDaoImpl themeDao;
    private BillManagerDao billManagerDao;
    private static ScheduledFuture<?> scheduleWithFixedDelay = null;
    private static final int DELAY_SUBMIT_TIME = 1;

    public LappDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    private ExceptionLogDomain getExceptionLogDomain() {
        if (this.exceptionLogDomain == null) {
            this.exceptionLogDomain = new ExceptionLogDomain(this.tx, this.dbExcuter);
        }
        return this.exceptionLogDomain;
    }

    private ExceptionLogDao getExceptionLogDao() {
        if (this.exceptionLogDao == null) {
            this.exceptionLogDao = new ExceptionLogDao(this.dbExcuter);
        }
        return this.exceptionLogDao;
    }

    private SchemaDomain getSchemaDomain() {
        if (this.schemaDomain == null) {
            this.schemaDomain = new SchemaDomain();
            this.schemaDomain.setDbExcuter(this.dbExcuter);
            this.schemaDomain.setTx(this.tx);
        }
        return this.schemaDomain;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private ExtReportSchemaManageDao getExtRptSchemaManageDao() {
        if (this.extRptSchemaManageDao == null) {
            this.extRptSchemaManageDao = new ExtReportSchemaManageDao(this.dbExcuter);
        }
        return this.extRptSchemaManageDao;
    }

    private ThumbnailDomain getThumbnailDomain() {
        if (this.thumbnailDomain == null) {
            this.thumbnailDomain = new ThumbnailDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.thumbnailDomain;
    }

    private DsbTimingPushDao getDsbTimingPushDao() {
        if (this.dsbTimingPushDao == null) {
            this.dsbTimingPushDao = new DsbTimingPushDao(this.dbExcuter);
        }
        return this.dsbTimingPushDao;
    }

    private CommonTimedPushDsbDesignDomain getCommonDsbDesignDomain() {
        if (this.commonDsbDesignDomain == null) {
            this.commonDsbDesignDomain = new CommonTimedPushDsbDesignDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.commonDsbDesignDomain;
    }

    protected DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    protected IThemeDao getThemeDao() {
        if (this.themeDao == null) {
            this.themeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.themeDao;
    }

    protected BillManagerDao getBillManagerDao() {
        if (this.billManagerDao == null) {
            this.billManagerDao = new BillManagerDao(this.dbExcuter);
        }
        return this.billManagerDao;
    }

    public SchemaContentVO loadSchema(String publishId) throws PublishException, AbstractQingIntegratedException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException {
        try {
            PublishPO publishInfo = this.loadPublishInfo(publishId);
            if (publishInfo == null) {
                throw new PublishNotFoundException();
            }
            String schemaId = publishInfo.getSchemaId();
            byte[] schemaContent = this.getSchemaManageDao().loadSchemaContent(schemaId);
            List<OutsideReference> outsideRef = this.getSchemaManageDao().loadSchemaRef(schemaId);
            this.getSchemaDomain().setOutSideRefName(outsideRef);
            ModelBook modelBook = SchemaDomain.byteToModel(schemaContent);
            modelBook.fixReferences(outsideRef);
            SchemaContentVO contentVO = new SchemaContentVO();
            SchemaBO bo = this.getSchemaManageDao().findSchemaById(schemaId);
            contentVO.setSchemaName(bo.getSchemaName());
            contentVO.setSchemaType(bo.getSchemaType());
            contentVO.setfId(schemaId);
            contentVO.setSchemaContent(modelBook);
            return contentVO;
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public String saveLappSchedulePushConfigInfo(String tag, LappSchedulePushConfigModel pushConfigModel, String modelBookStr, ModelBook thumbnailModelBook, String paramPathPrefix) throws AbstractQingIntegratedException, PublishException {
        String configId = null;
        String userId = this.qingContext.getUserId();
        try {
            configId = this.dbExcuter.genStringId("T_QING_PUSH_CONFIG_INFO");
            pushConfigModel.setId(configId);
            PublishSourceEnum publishSourceEnum = PublishSourceEnum.valueOf((String)pushConfigModel.getSourceType());
            String bizTag = pushConfigModel.getTagId();
            switch (publishSourceEnum) {
                case bill: {
                    this.insertPushFromBill(tag, pushConfigModel);
                    this.handlerLappSchema(pushConfigModel, modelBookStr, thumbnailModelBook, configId, userId);
                    break;
                }
                case subject: {
                    this.checkSourceIsExist(bizTag);
                    this.handlerLappSchema(pushConfigModel, modelBookStr, thumbnailModelBook, configId, userId);
                    break;
                }
                case report: {
                    this.insertPushFromBill(tag, pushConfigModel);
                    this.handlerLappSchema(pushConfigModel, modelBookStr, thumbnailModelBook, configId, userId);
                    break;
                }
                case dashboard: {
                    this.checkSourceIsExist(bizTag);
                    this.handleLappDsbModel(bizTag, pushConfigModel, modelBookStr, userId);
                    break;
                }
            }
            Schedule schedule = pushConfigModel.getSchedule();
            if (pushConfigModel.isOpenSchedule() && schedule != null && schedule.getPeriod() != null) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("JobType", "pushExecute");
                params.put("pkId", configId);
                params.put(SOURCE_NAME, pushConfigModel.getName());
                params.put(SOURCE_ID, configId);
                params.put(PARAM_PATH_PREFIX, paramPathPrefix);
                AbstractJobParam jobParams = this.scheduleEngine.createJobParam(params);
                this.scheduleEngine.saveJob(this.qingContext, this.qingContext.getUserId(), this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), pushConfigModel.getName(), schedule, jobParams);
            }
            return configId;
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to save push config model", e);
        }
        catch (IOException e) {
            throw new ScheduleException("fail to change schedule to byte[]", e);
        }
        catch (ScheduleEngineException e) {
            throw new ScheduleException("fail to save schedule", e);
        }
        catch (ScheduleModelParseException e) {
            throw new ScheduleException("fail to parse schedule model", e);
        }
    }

    public DashboardModel loadDashboardModelForEdit(String configId, int sourceType) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, EncryptedLicenseCheckException {
        return this.getCommonDsbDesignDomain().loadDashboardModelForEdit(configId, 2);
    }

    public void saveTimedPushDsbModel(String configId, DashboardModel dsbModel) throws TimedPushNotFound, DashboardException, AbstractQingIntegratedException, SQLException {
        LappSchedulePushConfigModel config;
        try {
            this.tx.beginRequired();
            config = this.getLappDao().loadPushConfigById(configId, this.qingContext.getUserId());
            if (config == null || config.getId() == null) {
                throw new TimedPushNotFound();
            }
            this.getCommonDsbDesignDomain().saveTimedPushDsbModel(configId, dsbModel, 2);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
        try {
            PublishSourceEnum publishSourceEnum = PublishSourceEnum.valueOf((String)config.getSourceType());
            String sourceName = PublishSourceDomainFactory.getPublishSourceName((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (String)config.getTagId(), (PublishSourceEnum)publishSourceEnum);
            String sourceGroupName = PublishSourceDomainFactory.getPublishSourceGroupName((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (String)config.getTagId(), (PublishSourceEnum)publishSourceEnum);
            if (sourceName != null && sourceGroupName != null) {
                DashboardOpLog dashboardOpLog;
                PushTargetType pushTargetType = PushTargetType.fromPersistance((int)config.getPushTargetType());
                switch (pushTargetType) {
                    case WXQYH_ROBOT: {
                        dashboardOpLog = DashboardOpLog.QING_ANALYSIS_QYWX_GROUP_DIR;
                        break;
                    }
                    case DINGDING_ROBOT: {
                        dashboardOpLog = DashboardOpLog.QING_ANALYSIS_DD_GROUP_DIR;
                        break;
                    }
                    default: {
                        dashboardOpLog = DashboardOpLog.QING_ANALYSIS_YZJ_GROUP_DIR;
                    }
                }
                dashboardOpLog.setParamsDesc("\u201c$param\u201d");
                ArrayList<String> params = new ArrayList<String>(3);
                params.add(sourceName);
                params.add(sourceGroupName);
                params.add(config.getName());
                dashboardOpLog.setLogScene("\u201c$param\u201d");
                dashboardOpLog.setLogScene("\u4eea\u8868\u677f");
                OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)dashboardOpLog, params));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ModelBook loadDsbRefSchema(String configId, ReferenceMap referenceMap, String editSchema) throws AbstractQingIntegratedException, DashboardException {
        return this.getCommonDsbDesignDomain().loadSchema(configId, referenceMap, editSchema, 2);
    }

    public void saveSchema(ReferenceMap referenceMap, ModelBook modelBook) throws ModelBookTemporaryStorageException, NotSelectMapException {
        this.getCommonDsbDesignDomain().cacheSquareSchema(referenceMap, modelBook);
    }

    public void longerSaveSchema(ReferenceMap referenceMap, ModelBook modelBook) throws ModelBookTemporaryStorageException {
        this.getCommonDsbDesignDomain().cacheLongerSchema(referenceMap, modelBook);
    }

    private IQingFile generateLappDsbThumbnail(LappSchedulePushConfigModel pushConfigModel) throws PublishException {
        IQingFile imageFile = null;
        try {
            QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
            resourceInfo.setFromId(pushConfigModel.getId());
            resourceInfo.setDisplayName(pushConfigModel.getName());
            resourceInfo.setFromType(ResourceFromType.CARDTHUMBNAIL);
            String thumbnailPath = pushConfigModel.getThumbnailPath();
            ThumbnailUrlModel thumbnailUrlModel = ThumbnailUrlModel.fromJsonObject(thumbnailPath);
            IQingFile localImagePath = (IQingFile)thumbnailUrlModel.getImageIQingFile();
            imageFile = ThumbnailHelper.generateCompressImage((IQingFileVisitor)localImagePath, 800, 400, (AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, this.qingContext, resourceInfo);
        }
        catch (IOException e) {
            FileFactory.clearFile(imageFile);
            throw new PublishException((Throwable)e);
        }
        return imageFile;
    }

    private void handleLappDsbModel(String bizTag, LappSchedulePushConfigModel pushConfigModel, String modelBookStr, String userId) throws AbstractQingIntegratedException, PublishException {
        DashboardModel dsbModel = com.kingdee.bos.qing.dashboard.model.ModelJsonDecoder.decode((String)modelBookStr);
        try {
            IQingFile imageFile;
            String thumbnailPath = pushConfigModel.getThumbnailPath();
            if (StringUtils.isNotEmpty((CharSequence)thumbnailPath) && (imageFile = this.generateLappDsbThumbnail(pushConfigModel)) != null) {
                pushConfigModel.setThumbnailPath(imageFile.getName());
            }
            this.getLappDao().saveConfigInfo(pushConfigModel, 2, userId);
            InputStream dbStream = this.getDashboardDao().loadDashboardStream(pushConfigModel.getTagId());
            this.getDsbTimingPushDao().saveDsbModelContent(pushConfigModel.getId(), 2, dsbModel, dbStream);
            List refItems = dsbModel.pickReferences();
            for (int i = 0; i < refItems.size(); ++i) {
                ReferenceMap refItem = (ReferenceMap)refItems.get(i);
                RefTypeEnum refTypeEnum = RefTypeEnum.fromPersistance((String)refItem.getRefType());
                IRefHandler refHandler = this.getRefHandler(refTypeEnum);
                ((ITimingPushable)((Object)refHandler)).saveTimingPushReference(bizTag, pushConfigModel.getId(), 2, refItem);
            }
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw new PublishException((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw new PublishException((Throwable)e);
        }
        catch (IOException e) {
            throw new PublishException((Throwable)e);
        }
        catch (PersistentModelParseException e) {
            throw new PublishException((Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new PublishEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
    }

    private IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new HashMap<RefTypeEnum, IRefHandler>();
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.qingContext, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    private void handlerLappSchema(LappSchedulePushConfigModel pushConfigModel, String modelBookStr, ModelBook thumbnailModelBook, String configId, String userId) throws AbstractQingIntegratedException, SQLException, IOException, MapNotFoundException {
        SchemaVO schemaVO = (SchemaVO)ModelJsonDecoder.decode((String)modelBookStr, SchemaVO.class);
        int source = schemaVO.getSchemaAttr().getSource();
        this.getLappDao().saveConfigInfo(pushConfigModel, source, userId);
        String thumbnailId = this.getLappDao().saveThumbnailInfo(pushConfigModel);
        ModelBook modelBook = schemaVO.getSchemaContent();
        List schemaOutSideRef = modelBook.pickReferences();
        List thumbnailSchemaOutSideRef = modelBook.pickReferences();
        byte[] modelBytes = XmlUtil.toByteArray((Element)modelBook.toXml());
        byte[] thumbnailModelBytes = XmlUtil.toByteArray((Element)thumbnailModelBook.toXml());
        this.getLappDao().saveSchema(configId, modelBytes);
        this.getLappDao().saveSchema(thumbnailId, thumbnailModelBytes);
        this.saveSchemaRef(schemaOutSideRef, configId);
        this.saveSchemaRef(thumbnailSchemaOutSideRef, thumbnailId);
    }

    private void saveSchemaRef(List<OutsideReference> outsideRefList, String schemaId) throws AbstractQingIntegratedException, SQLException, MapNotFoundException {
        for (int i = 0; i < outsideRefList.size(); ++i) {
            OutsideReference outerRef = outsideRefList.get(i);
            if (outerRef.getUid() == null) {
                throw new MapNotFoundException();
            }
            this.getLappDao().saveSchemaRef(outerRef, schemaId);
        }
    }

    public String updateConfigInfo(LappSchedulePushConfigModel pushConfigModel, String paramPathPrefix) throws AbstractQingIntegratedException, PublishException, JDOMException, PersistentModelTooModernException, com.kingdee.bos.qing.core.exception.PersistentModelParseException {
        try {
            String userId = this.qingContext.getUserId();
            LappSchedulePushConfigModel oldPushConfigModel = this.getLappDao().loadPushConfigById(pushConfigModel.getId(), userId);
            String thumbnailPath = pushConfigModel.getThumbnailPath();
            String oldThumbnailPath = null;
            if (StringUtils.isNotEmpty((CharSequence)thumbnailPath)) {
                IQingFile imageFile;
                if (!thumbnailPath.equals(oldPushConfigModel.getThumbnailPath()) && (imageFile = this.generateLappDsbThumbnail(pushConfigModel)) != null) {
                    pushConfigModel.setThumbnailPath(imageFile.getName());
                    oldThumbnailPath = oldPushConfigModel.getThumbnailPath();
                }
            } else {
                oldThumbnailPath = oldPushConfigModel.getThumbnailPath();
            }
            if (PublishSourceEnum.subject.name().equals(pushConfigModel.getSourceType())) {
                byte[] schemaContentBytes = this.getLappDao().getSchemaContent(pushConfigModel.getId());
                ModelBook modelBook = ModelBookUtil.fromByte(schemaContentBytes);
                boolean warningRuleStatus = LappDomain.checkWarningRuleStatus(pushConfigModel, modelBook);
                pushConfigModel.setWarningRuleStatus(warningRuleStatus);
            }
            this.getLappDao().updateConfigInfo(pushConfigModel, userId);
            Schedule schedule = pushConfigModel.getSchedule();
            String configId = pushConfigModel.getId();
            if (pushConfigModel.isOpenSchedule() && schedule != null && schedule.getPeriod() != null) {
                this.scheduleEngine.deleteJob(this.qingContext, null, pushConfigModel.getId());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("JobType", "pushExecute");
                params.put("pkId", configId);
                params.put(SOURCE_NAME, pushConfigModel.getName());
                params.put(SOURCE_ID, configId);
                params.put(PARAM_PATH_PREFIX, paramPathPrefix);
                AbstractJobParam jobParams = this.scheduleEngine.createJobParam(params);
                this.scheduleEngine.saveJob(this.qingContext, this.qingContext.getUserId(), this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), pushConfigModel.getName(), schedule, jobParams);
            }
            return oldThumbnailPath;
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to update push config model", e);
        }
        catch (IOException e) {
            throw new ScheduleException("fail to change schdelu to byte[]", e);
        }
        catch (ScheduleEngineException e) {
            throw new ScheduleException("fail to change schdelu to byte[]", e);
        }
        catch (ScheduleModelParseException e) {
            throw new ScheduleException("fail to change schdelu to byte[]", e);
        }
        catch (PublishException e) {
            throw new PublishException((Throwable)e);
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw e;
        }
        catch (PersistentModelTooModernException e) {
            throw e;
        }
        catch (JDOMException e) {
            throw e;
        }
    }

    public static boolean checkWarningRuleStatus(LappSchedulePushConfigModel pushConfigModel, ModelBook currentModelBook) {
        boolean warningRuleStatus = true;
        try {
            if (null == pushConfigModel || StringUtils.isEmpty((CharSequence)pushConfigModel.getWarningRuleName())) {
                return warningRuleStatus;
            }
            ModelBook modelBook = currentModelBook;
            if (null == modelBook) {
                return warningRuleStatus;
            }
            IQingModel model = ((ModelBook.ModelPage)modelBook.getPages().get(0)).getModel();
            List warningRuleDefinitions = model.getWarningRuleDefinitions();
            ArrayList<String> warningRuleNames = new ArrayList<String>(10);
            if (CollectionUtils.isNotEmpty((Collection)warningRuleDefinitions)) {
                for (int i = 0; i < warningRuleDefinitions.size(); ++i) {
                    warningRuleNames.add(((WarningRuleDefinition)warningRuleDefinitions.get(i)).getName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)pushConfigModel.getWarningRuleName()) && !warningRuleNames.contains(pushConfigModel.getWarningRuleName())) {
                warningRuleStatus = false;
            }
            return warningRuleStatus;
        }
        catch (Exception e) {
            LogUtil.error((String)"execute failed when checkWarningRuleInvalid", (Throwable)e);
            return warningRuleStatus;
        }
    }

    public void fillPublishSource(LappSchedulePushConfigModel pushConfigModel) throws AbstractQingIntegratedException, SQLException, ExecuteSqlException, MismatchSourceTypeException {
        String bizTag = pushConfigModel.getTagId();
        if (PublishUtil.isPublish((String)bizTag)) {
            PublishPO publishPO = this.loadPublishInfo(bizTag);
            if (publishPO != null) {
                try {
                    bizTag = publishPO.getTagId();
                    this.checkRightAndReturnIsAnonymous(publishPO);
                }
                catch (PublishNoPermissionException e) {
                    this.updateScheduleState(false, pushConfigModel.getId(), null);
                    pushConfigModel.setHasPermission(false);
                    pushConfigModel.setOpenSchedule(false);
                }
            } else {
                this.updateScheduleState(false, pushConfigModel.getId(), null);
                pushConfigModel.setHasPermission(false);
                pushConfigModel.setOpenSchedule(false);
                return;
            }
        }
        PublishSourceEnum publishSourceEnum = PublishSourceEnum.valueOf((String)pushConfigModel.getSourceType());
        String sourceName = PublishSourceDomainFactory.getPublishSourceName((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (String)bizTag, (PublishSourceEnum)publishSourceEnum);
        pushConfigModel.setSourceName(sourceName);
        String sourceGroupName = PublishSourceDomainFactory.getPublishSourceGroupName((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (String)bizTag, (PublishSourceEnum)publishSourceEnum);
        pushConfigModel.setSourceGroupName(sourceGroupName);
    }

    public LappSchedulePushConfigModel loadConfigInfoById(String configId) throws AbstractQingIntegratedException, ExecuteSqlException {
        try {
            String userId = this.qingContext.getUserId();
            return this.getLappDao().loadPushConfigById(configId, userId);
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to load push config model", e);
        }
    }

    public LappSchedulePushConfigModel checkLappConfigExist(String configID) throws AbstractQingIntegratedException, SQLException, TimedPushNotFound {
        String userId = this.qingContext.getUserId();
        LappSchedulePushConfigModel lappSchedulePushConfigModel = this.getLappDao().loadPushConfigById(configID, userId);
        if (null == lappSchedulePushConfigModel || null == lappSchedulePushConfigModel.getId()) {
            throw new TimedPushNotFound();
        }
        return lappSchedulePushConfigModel;
    }

    public String deleteConfigInfo(String configId) throws AbstractQingIntegratedException, LappException {
        String userId = this.qingContext.getUserId();
        try {
            LappSchedulePushConfigModel pushConfigModel = this.getLappDao().loadPushConfigById(configId, userId);
            String oldThumbnailPath = pushConfigModel.getThumbnailPath();
            this.getLappDao().deleteConfigInfo(configId, userId);
            List<ReferenceMap> refList = this.getDsbTimingPushDao().getRefList(configId, 2);
            for (ReferenceMap refItem : refList) {
                if (!this.getExtRptSchemaManageDao().isFromExtReport(refItem.getRefToId())) continue;
                String extReportSchemeId = configId + "/" + refItem.getUid();
                this.getExtRptSchemaManageDao().clearExtRptSchemaInfos(extReportSchemeId);
            }
            this.getDsbTimingPushDao().delete(pushConfigModel.getId(), 2);
            List<PushRecord> yzjPushRecordModels = this.getLappDao().loadAllPushRecord(configId, userId);
            ArrayList<String> analysisIds = new ArrayList<String>();
            for (int i = 0; i < yzjPushRecordModels.size(); ++i) {
                PushRecord yzjPushRecord = yzjPushRecordModels.get(i);
                if (StringUtils.isNotBlank((CharSequence)yzjPushRecord.getAnalysisId())) {
                    analysisIds.add(yzjPushRecord.getAnalysisId());
                }
                this.deletePushRecord(yzjPushRecord);
            }
            this.deleteAnalysisList(configId, analysisIds);
            this.getLappDao().deleteSchemaByConfigId(configId);
            this.getLappDao().deleteSchemaRef(configId);
            this.getLappDao().deleteBillConfig(configId);
            PushThumbnailInfoModel pushThumbnailInfoModel = this.getLappDao().loadThumbnailInfo(configId);
            if (pushThumbnailInfoModel != null) {
                this.getLappDao().deleteSchemaByConfigId(pushThumbnailInfoModel.getId());
                this.getLappDao().deleteThumbnailInfo(configId);
                this.getLappDao().deleteSchemaRef(pushThumbnailInfoModel.getId());
            }
            this.scheduleEngine.deleteJob(this.qingContext, null, configId);
            return oldThumbnailPath;
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to delete push config info", e);
        }
        catch (ScheduleEngineException e) {
            throw new ExecuteSqlException("fail to delete schedule", e);
        }
    }

    public void deleteAllConfig(String tagId) throws AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        try {
            List<LappSchedulePushConfigModel> allConfigInfo = this.getLappDao().loadConfigInfoByTagId(userId, tagId);
            for (int i = 0; i < allConfigInfo.size(); ++i) {
                LappSchedulePushConfigModel configInfo = allConfigInfo.get(i);
                this.deleteConfigInfo(configInfo.getId());
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"delete config state error", (Throwable)e);
        }
        catch (LappException e) {
            LogUtil.error((String)"delete config state error", (Throwable)((Object)e));
        }
    }

    public List<PushRecord> loadAllPushRecord(String configId) throws AbstractQingIntegratedException, ExecuteSqlException {
        String userId = this.qingContext.getUserId();
        List<PushRecord> yzjPushRecordModels = null;
        try {
            this.tx.beginRequired();
            yzjPushRecordModels = this.loadPushRecordByStorageSetInfo(configId, userId);
            ArrayList<PushRecord> yzjPushSuccessRecordModel = new ArrayList<PushRecord>(yzjPushRecordModels.size());
            for (int i = 0; i < yzjPushRecordModels.size(); ++i) {
                PushRecord pushRecord = yzjPushRecordModels.get(i);
                ExceptionLog exceptionLog = this.getExceptionLogDomain().selectByBizIdAndBizType(pushRecord.getId(), ExceptionLogBizTypeEnum.ROBOT_PUSH);
                if (exceptionLog != null) {
                    pushRecord.setErrorCode(exceptionLog.getErrorCode());
                    pushRecord.setErrorMessage(exceptionLog.getErrorMessage());
                    pushRecord.setErrorStack(exceptionLog.getErrorStackTrace());
                }
                if (pushRecord.getPublishId().isEmpty()) {
                    pushRecord.setFileSize("0KB");
                    continue;
                }
                yzjPushSuccessRecordModel.add(pushRecord);
            }
            if (yzjPushSuccessRecordModel.size() > 0) {
                Map<String, Long> fileSizeMap = this.getLappDao().loadQingFileSizeByPublishId(yzjPushSuccessRecordModel);
                for (int i = 0; i < yzjPushSuccessRecordModel.size(); ++i) {
                    BigDecimal bigDecimal;
                    PushRecord pushRecord = (PushRecord)yzjPushSuccessRecordModel.get(i);
                    Long fileSize = fileSizeMap.get(pushRecord.getPublishId());
                    if (fileSize == null) continue;
                    if (fileSize <= 0x100000L) {
                        bigDecimal = new BigDecimal(fileSize).divide(new BigDecimal(1024), 2, 4);
                        pushRecord.setFileSize((bigDecimal == null ? Integer.valueOf(0) : bigDecimal) + "KB");
                        continue;
                    }
                    bigDecimal = new BigDecimal(fileSize).divide(new BigDecimal(0x100000), 2, 4);
                    pushRecord.setFileSize((bigDecimal == null ? Integer.valueOf(0) : bigDecimal) + "MB");
                }
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ExecuteSqlException("fail to load push record", e);
        }
        finally {
            this.tx.end();
        }
        return yzjPushRecordModels;
    }

    public void deletePushRecord(PushRecord yzjPushRecord) throws AbstractQingIntegratedException, LappException {
        String userId = this.qingContext.getUserId();
        try {
            this.tx.beginRequired();
            if (yzjPushRecord.getPublishId() != null) {
                AbstractPublishManageDomain abstractPublishManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)2, (QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (IScheduleEngine)this.scheduleEngine);
                abstractPublishManageDomain.deletePublishInfoNoTx(yzjPushRecord.getPublishId());
            }
            this.getExceptionLogDao().delete(yzjPushRecord.getId(), ExceptionLogBizTypeEnum.ROBOT_PUSH);
            this.getLappDao().deletePushRecord(yzjPushRecord.getId(), userId);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ExecuteSqlException("fail to delete push record", e);
        }
        catch (LappException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw new LappException("fail to delete push record", e, e.getErrorCode());
        }
        finally {
            this.tx.end();
        }
        try {
            LappSchedulePushConfigModel pushConfigModel = this.getLappDao().loadConfigInfoByFid(yzjPushRecord.getConfigId());
            if (pushConfigModel != null) {
                LappPushOpLog lappPushOpLog;
                ArrayList<String> params = new ArrayList<String>(2);
                params.add(yzjPushRecord.getName());
                params.add(pushConfigModel.getName());
                PushTargetType pushTargetType = PushTargetType.fromPersistance((int)pushConfigModel.getPushTargetType());
                switch (pushTargetType) {
                    case WXQYH_ROBOT: {
                        lappPushOpLog = LappPushOpLog.QYWX_PUSH_LOG_DIR;
                        lappPushOpLog.setLogScene("\u4f01\u4e1a\u5fae\u4fe1\u63a8\u9001\u660e\u7ec6");
                        break;
                    }
                    case DINGDING_ROBOT: {
                        lappPushOpLog = LappPushOpLog.DINGDING_PUSH_LOG_DIR;
                        lappPushOpLog.setLogScene("\u9489\u9489\u63a8\u9001\u660e\u7ec6");
                        break;
                    }
                    default: {
                        lappPushOpLog = LappPushOpLog.YZJ_PUSH_LOG_DIR;
                        lappPushOpLog.setLogScene("\u4e91\u4e4b\u5bb6\u63a8\u9001\u660e\u7ec6");
                    }
                }
                lappPushOpLog.setParamsDesc("\u201c$param\u201d");
                OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)lappPushOpLog, params));
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"add opLog error when delete lapp push log", (Throwable)e);
        }
    }

    public void deletePushRecordAndAnalysis(List<PushRecord> yzjPushRecordList) throws AbstractQingIntegratedException, LappException {
        for (PushRecord yzjPushRecord : yzjPushRecordList) {
            this.deletePushRecord(yzjPushRecord);
            this.deleteAnalysis(yzjPushRecord);
        }
    }

    public PublishedDataSourceInfoVO getPublishedDataSourceInfo(String publishId, String tag) throws AbstractQingIntegratedException, SQLException {
        PublishInfo publishInfo = this.getLappDao().getPushRecordByPublishId(publishId);
        PublishedDataSourceInfoVO publishedDataSourceInfoVO = new PublishedDataSourceInfoVO();
        publishedDataSourceInfoVO.setPublishId(publishId);
        String publisher = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)publishInfo.getCreatorId());
        publishedDataSourceInfoVO.setPublisher(publisher);
        String publishTime = DateUtils.DateToString((Date)publishInfo.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
        publishedDataSourceInfoVO.setPublishTime(publishTime);
        publishedDataSourceInfoVO.setExtractDataTime(this.getExtractDataTime(tag));
        String orgName = null;
        orgName = this.qingContext.getSystemVarStringValue(SystemVarType.ORG_NAME);
        if (StringUtils.isBlank((CharSequence)orgName)) {
            orgName = Messages.getMLS((QingContext)this.qingContext, (String)"emptyData", (String)"\u6682\u65e0\u6570\u636e", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        }
        publishedDataSourceInfoVO.setLoginOrgName(orgName);
        return publishedDataSourceInfoVO;
    }

    public String getExtractDataTime(String tag) {
        String extractDataTimeStr = "";
        try {
            long extractDataTime;
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey(tag), AbstractDataSource.class);
            if (dataSource != null && (extractDataTime = dataSource.getExtractDataTime()) != 0L) {
                extractDataTimeStr = DateUtils.DateToString((Date)new Date(extractDataTime), (String)"yyyy-MM-dd HH:mm:ss");
            }
            return extractDataTimeStr;
        }
        catch (Exception e) {
            return extractDataTimeStr;
        }
    }

    public void updateScheduleState(boolean openSchedule, String configId, String paramPathPrefix) throws AbstractQingIntegratedException, ExecuteSqlException {
        String userId = this.qingContext.getUserId();
        try {
            this.tx.beginRequired();
            this.getLappDao().updateScheduleState(openSchedule, configId, userId);
            if (openSchedule) {
                LappSchedulePushConfigModel pushConfigModel = this.getLappDao().loadPushConfigById(configId, userId);
                Schedule schedule = pushConfigModel.getSchedule();
                if (schedule != null && schedule.getPeriod() != null) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("JobType", "pushExecute");
                    params.put("pkId", configId);
                    params.put(SOURCE_NAME, pushConfigModel.getName());
                    params.put(SOURCE_ID, configId);
                    params.put(PARAM_PATH_PREFIX, paramPathPrefix);
                    AbstractJobParam jobParams = this.scheduleEngine.createJobParam(params);
                    this.scheduleEngine.saveJob(this.qingContext, this.qingContext.getUserId(), this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), pushConfigModel.getName(), schedule, jobParams);
                }
            } else {
                this.scheduleEngine.deleteJob(this.qingContext, null, configId);
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ExecuteSqlException("fail to update push schdule", e);
        }
        catch (ScheduleEngineException e) {
            this.tx.markRollback();
            throw new ExecuteSqlException("fail to update push schdule", e);
        }
        catch (ScheduleModelParseException e) {
            this.tx.markRollback();
            throw new ExecuteSqlException("fail to update push schdule", e);
        }
        finally {
            this.tx.end();
        }
    }

    public void deleteAnalysis(PushRecord yzjPushRecord) throws LappException {
        String analysisId = yzjPushRecord.getAnalysisId();
        boolean isConnAvailable = LappHelper.isConnAvailable();
        if (!isConnAvailable && StringUtils.isNotBlank((CharSequence)analysisId)) {
            throw new LappException(Messages.getMLS((QingContext)this.qingContext, (String)"networkError", (String)"\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc", (Messages.ProjectName)Messages.ProjectName.QING_THEME), 4300106);
        }
        if (StringUtils.isNotBlank((CharSequence)analysisId)) {
            String configId = yzjPushRecord.getConfigId();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("id", analysisId);
            paramMap.put("lappUserId", configId);
            paramMap.put("lappUserType", LappContext.UserType.ROBOT_PUSH.toPersistance());
            String result = LappHelper.post(LappApiEnum.QING_SCHEDULE_PUSH_DELETE_ANALYSIS_URL, null, null, paramMap);
            if (result == null) {
                throw new LappException(Messages.getMLS((QingContext)this.qingContext, (String)"failToSendRequest", (String)"\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", (Messages.ProjectName)Messages.ProjectName.QING_THEME), 4300104);
            }
            HttpRequestSuccessResult successResult = (HttpRequestSuccessResult)JsonUtil.decodeFromString((String)result, HttpRequestSuccessResult.class);
            if (successResult.getData() == null) {
                HttpRequestErrorResult errorResult = (HttpRequestErrorResult)JsonUtil.decodeFromString((String)result, HttpRequestErrorResult.class);
                throw new LappException(errorResult.getErrorMessage(), errorResult.getErrorCode());
            }
        }
    }

    public void deleteAnalysisList(String configId, List<String> analysisIds) throws LappException {
        boolean isConnAvailable = LappHelper.isConnAvailable();
        if (!isConnAvailable && analysisIds.size() > 0) {
            throw new LappException(Messages.getMLS((QingContext)this.qingContext, (String)"networkError", (String)"\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc", (Messages.ProjectName)Messages.ProjectName.QING_THEME), 4300106);
        }
        if (analysisIds.size() > 0) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("lappUserId", configId);
            paramMap.put("lappUserType", LappContext.UserType.ROBOT_PUSH.toPersistance());
            String result = LappHelper.post(LappApiEnum.QING_SCHEDULE_PUSH_DELETE_ANALYSISLIST_URL, null, JsonUtil.encodeToString(analysisIds), paramMap);
            if (result == null) {
                throw new LappException(Messages.getMLS((QingContext)this.qingContext, (String)"failToSendRequest", (String)"\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", (Messages.ProjectName)Messages.ProjectName.QING_THEME), 4300104);
            }
            HttpRequestSuccessResult successResult = (HttpRequestSuccessResult)JsonUtil.decodeFromString((String)result, HttpRequestSuccessResult.class);
            if (successResult.getData() == null) {
                HttpRequestErrorResult errorResult = (HttpRequestErrorResult)JsonUtil.decodeFromString((String)result, HttpRequestErrorResult.class);
                throw new LappException(errorResult.getErrorMessage(), errorResult.getErrorCode());
            }
        }
    }

    private void checkSourceIsExist(String bizTag) throws AbstractQingIntegratedException, SQLException, PublishSourcePublishNotExistException, PublishSourceSubjectNotExistException {
        ThemePO theme;
        if (PublishUtil.isPublish((String)bizTag)) {
            PublishPO oldInfo = this.getPublishInfoDao().getPublishInfoByInfoId(bizTag);
            if (oldInfo == null) {
                throw new PublishSourcePublishNotExistException();
            }
            bizTag = oldInfo.getTagId();
        }
        if ((theme = this.getThemeDao().getThemeByID(bizTag)) == null) {
            throw new PublishSourceSubjectNotExistException();
        }
    }

    private void insertPushFromBill(String tag, LappSchedulePushConfigModel pushConfigModel) throws AbstractQingIntegratedException, SQLException {
        String bizTag = pushConfigModel.getTagId();
        byte[] fFilter = null;
        String ctrKey = null;
        if (PublishUtil.isPublish((String)bizTag)) {
            PublishPO oldInfo = this.getPublishInfoDao().getPublishInfoByInfoId(bizTag);
            bizTag = oldInfo.getTagId();
            fFilter = this.getBillManagerDao().loadFilterContent(oldInfo.getId());
            ctrKey = this.getBillManagerDao().getBillCtrKey(oldInfo.getId());
        } else {
            String filterStr = QingSessionUtil.get((String)("qing_filter_" + tag));
            if (filterStr != null) {
                try {
                    fFilter = filterStr.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
            }
            ctrKey = QingSessionUtil.get((String)("qing_ctrl_tag_" + tag));
        }
        TimingPushBillPO bill = new TimingPushBillPO();
        bill.setCtrKey(ctrKey);
        bill.setConfigId(pushConfigModel.getId());
        bill.setFilterContent(fFilter);
        this.getLappDao().insertBill(bill);
    }

    public TimingPushBillPO loadBillInfo(String configId) throws AbstractQingIntegratedException, SQLException {
        TimingPushBillPO bill = this.getLappDao().loadBillInfo(configId);
        byte[] filterContentBytes = this.getLappDao().loadFilterContent(configId);
        bill.setFilterContent(filterContentBytes);
        return bill;
    }

    public String updateLappThumbnail(SquareExecuteDomain exeDomain, String lappId, String schemaId, LappContext lappContext, AbstractDomain.IDataSourceCreator dataSourceCreator) throws LappException {
        ModelBook modelBook;
        try {
            modelBook = this.getSchemaManageDao().loadSchemaModelBook(schemaId);
        }
        catch (Exception e) {
            throw new LappException(e);
        }
        Meta meta = modelBook.getMeta();
        IQingFile exportFile = null;
        try {
            ModelBook.ModelPage modelPage;
            IQingModel qingModel;
            this.tx.beginRequired();
            ThumbnailInfo thumbnail = this.getThumbnailDomain().loadThumbnailInfoByAnalysisId(lappId);
            if (thumbnail != null) {
                String oldThumbnailSchemaId = thumbnail.getSchemaId();
                this.getSchemaManageDao().deleteSchemaContentAndRef(oldThumbnailSchemaId);
                String newThumbnailSchemaId = this.dbExcuter.genStringId("T_QING_SASchema");
                this.getSchemaManageDao().insertSchemaContentAndRef(newThumbnailSchemaId, modelBook);
                this.getThumbnailDomain().updateThumbnailSchema(lappId, newThumbnailSchemaId);
            }
            if ((qingModel = (modelPage = (ModelBook.ModelPage)modelBook.getPages().get(0)).getModel()) instanceof SquareModel) {
                SquareModel squareModel = (SquareModel)modelPage.getModel();
                ModelBook.ModelPage.prepareForExecuting((Meta)meta, (IQingModel)squareModel, (IPreferences)modelPage.getPreferences());
                exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
                ExportDomain exportDomain = new ExportDomain();
                exportDomain.doExportSquareImage(300, 150, exportFile, squareModel, exeDomain, "png");
            } else if (qingModel instanceof AnalyticalModel) {
                ThumbnailInfo thumbnailInfo = this.getThumbnailDomain().loadThumbnailInfoByAnalysisId(lappId);
                exportFile = ThumbnailHelper.generateMobileImage(modelBook, dataSourceCreator, this.qingContext.getIi18nContext(), thumbnailInfo);
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        catch (AnalysisException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        catch (PublishScheduleModelException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        catch (IOException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        catch (JDOMException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        finally {
            this.tx.end();
        }
        if (exportFile != null) {
            try {
                return ThumbnailHelper.uploadImage(exportFile, lappId, lappContext);
            }
            catch (IOException e) {
                throw new LappException(e);
            }
        }
        return null;
    }

    public void updateAllConfigStateByTagId(String tagId) throws AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        try {
            List<LappSchedulePushConfigModel> allConfigInfo = this.getLappDao().loadConfigInfoByTagId(userId, tagId);
            for (int i = 0; i < allConfigInfo.size(); ++i) {
                LappSchedulePushConfigModel configInfo = allConfigInfo.get(i);
                this.updateScheduleState(false, configInfo.getId(), null);
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"update config state error", (Throwable)e);
        }
        catch (ExecuteSqlException e) {
            LogUtil.error((String)"update config state error", (Throwable)((Object)e));
        }
    }

    public boolean checkIsRobotPublih(String publishId) throws LappException, AbstractQingIntegratedException {
        try {
            return this.getLappDao().checkPushRecordByPublishId(publishId, this.qingContext.getUserId());
        }
        catch (SQLException e) {
            throw new LappException(e);
        }
    }

    public PublishPO checkSameSource(String publishId) throws AbstractQingIntegratedException, SQLException {
        return this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
    }

    public List<PermissionInfo> loadPublishPermissionInfo(String publishId) throws AbstractQingIntegratedException, SQLException {
        return this.getPublishPermissionDao().loadPublishPermissionInfo(publishId);
    }

    public List<LappPublishVO> loadPublishInfoByPublishIdArr(String[] publishIdArr) throws PublishException, AbstractQingIntegratedException {
        if (publishIdArr == null || publishIdArr.length == 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            List<LappPublishVO> lappPublishVOs = this.getLappDao().loadPublishInfos(publishIdArr, this.qingContext);
            this.setPublishPermissionInfo(lappPublishVOs);
            return lappPublishVOs;
        }
        catch (SQLException e) {
            throw new LappException(e);
        }
    }

    public void collectPermissionUserInfos(Map<String, Set<String>> permissionUserMap, Set<String> allUserIds, Set<String> roleNames, List<String> publishIds) throws AbstractQingIntegratedException, LappException {
        try {
            HashSet<String> roleIds = new HashSet<String>();
            publishIds = this.getLappDao().getAllMobilePublishInfos(this.qingContext.getUserId(), publishIds);
            Map permissionInfoMap = this.getPublishPermissionDao().loadPublishPermissionInfo(publishIds);
            for (Map.Entry entry : permissionInfoMap.entrySet()) {
                List permissionInfos = (List)entry.getValue();
                for (PermissionInfo permissionInfo : permissionInfos) {
                    if (permissionInfo.getType() != 1) continue;
                    roleIds.add(permissionInfo.getViewerId());
                }
            }
            HashMap<String, List> roleUserMap = new HashMap<String, List>(16);
            List validRoleIds = IntegratedHelper.getValidRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, new ArrayList(roleIds));
            for (String string : validRoleIds) {
                List roleUserIds = IntegratedHelper.getUserIdsByRoleId((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)string);
                roleUserMap.put(string, roleUserIds);
                String roleName = IntegratedHelper.getRoleName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)string);
                if (roleName == null) continue;
                roleNames.add(roleName);
            }
            for (Map.Entry entry : permissionInfoMap.entrySet()) {
                List permissionInfos = (List)entry.getValue();
                HashSet<String> userIds = new HashSet<String>();
                boolean hasPermissionRole = false;
                for (PermissionInfo permissionInfo : permissionInfos) {
                    List roleUserIds;
                    int permType = permissionInfo.getType();
                    if (permType == 0) {
                        userIds.add(permissionInfo.getViewerId());
                        continue;
                    }
                    if (permType != 1 || (roleUserIds = (List)roleUserMap.get(permissionInfo.getViewerId())) == null) continue;
                    userIds.addAll(roleUserIds);
                    hasPermissionRole = true;
                }
                if (!hasPermissionRole) continue;
                permissionUserMap.put((String)entry.getKey(), (Set<String>)userIds);
                allUserIds.addAll(userIds);
            }
        }
        catch (SQLException e) {
            throw new LappException(e);
        }
    }

    public ThirdPartyConfig loadThirdPartyConfig() throws LappException, AbstractQingIntegratedException {
        try {
            return this.getLappDao().getThirdPartyConfig();
        }
        catch (SQLException e) {
            throw new LappException(e);
        }
    }

    public void deleteThirdPartyConfig() throws AbstractQingIntegratedException, LappException {
        try {
            this.tx.beginRequired();
            ThirdPartyConfig oldThirdPartyConfig = this.getLappDao().getThirdPartyConfig();
            this.deleteImageFile(oldThirdPartyConfig.getAppImageFile());
            if (StringUtils.isNotBlank((CharSequence)oldThirdPartyConfig.getId())) {
                this.getLappDao().deleteThirdPartyConfig(oldThirdPartyConfig.getId());
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public ThirdPartyConfig saveOrUpdateThirdPartyConfig(ThirdPartyConfig thirdPartyConfig) throws AbstractQingIntegratedException, LappException, QingImglibException {
        try {
            this.tx.beginRequired();
            ThirdPartyConfig oldThirdPartyConfig = this.getLappDao().getThirdPartyConfig();
            if (oldThirdPartyConfig.getAppImageFile() == null || !oldThirdPartyConfig.getAppImageFile().equals(thirdPartyConfig.getAppImageFile())) {
                String tempFile = thirdPartyConfig.getAppImageFile();
                String appImageFile = this.convertTempToPersistentImageFile(tempFile);
                thirdPartyConfig.setAppImageFile(appImageFile);
                this.deleteImageFile(oldThirdPartyConfig.getAppImageFile());
            }
            if (StringUtils.isBlank((CharSequence)oldThirdPartyConfig.getId())) {
                this.getLappDao().saveThirdPartyConfig(thirdPartyConfig);
            } else {
                this.getLappDao().updateThirdPartyConfig(thirdPartyConfig);
            }
            ThirdPartyConfig thirdPartyConfig2 = thirdPartyConfig;
            return thirdPartyConfig2;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        finally {
            this.tx.end();
        }
    }

    private void deleteImageFile(String imageFileName) {
        if (imageFileName == null) {
            return;
        }
        IQingFileUpdater file = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)imageFileName);
        file.delete();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String convertTempToPersistentImageFile(String tempImageFile) throws QingImglibException {
        if (tempImageFile == null) {
            return null;
        }
        IQingFile persistentFile = FileFactory.newPersistentFile((QingContext)this.qingContext, null, (QingPersistentFileType)QingPersistentFileType.IMAGE_LIBRARY);
        IQingFileVisitor tempFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)tempImageFile);
        QingInputStream sis = null;
        try {
            sis = tempFileVisitor.getInputStream();
            if (ImageTypeUtil.getPicType((InputStream)sis) == null) {
                throw new ImageTypeException();
            }
            CloseUtil.close((Closeable[])new Closeable[]{sis});
            sis = tempFileVisitor.getInputStream();
            persistentFile.write((IWriteCall)new CopyWriteCall((InputStream)sis, false), true);
        }
        catch (QingFileStorageLimitException e) {
            try {
                persistentFile.delete();
                throw new ImageFileSizeLimitException(e);
                catch (IOException e2) {
                    persistentFile.delete();
                    throw new QingImglibException((Throwable)e2, "fail to persistent image file.");
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{sis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{sis});
        return persistentFile.getName();
    }

    public void updatePublishLappConfigs(List<PublishLappConfig> publishLappConfigs) throws LappException, AbstractQingIntegratedException {
        try {
            this.tx.beginRequired();
            for (PublishLappConfig publishLappConfig : publishLappConfigs) {
                this.getLappDao().updatePublishLappConfig(publishLappConfig);
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        finally {
            this.tx.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PublishLappConfig> loadPublishLappConfigs(List<LappContext.AppType> configedAppTypes) {
        try {
            this.tx.beginRequired();
            List<PublishLappConfig> publishLappConfigs = this.getLappDao().loadPublishLappConfigs();
            ArrayList<LappContext.AppType> existedAppTypes = new ArrayList<LappContext.AppType>(publishLappConfigs.size());
            HashMap<LappContext.AppType, PublishLappConfig> publishLappConfigMap = new HashMap<LappContext.AppType, PublishLappConfig>(16);
            for (PublishLappConfig publishLappConfig : publishLappConfigs) {
                existedAppTypes.add(publishLappConfig.getAppType());
                publishLappConfigMap.put(publishLappConfig.getAppType(), publishLappConfig);
            }
            for (LappContext.AppType existedAppType : existedAppTypes) {
                if (configedAppTypes.contains((Object)existedAppType)) continue;
                this.getLappDao().deletePublishLappConfig(existedAppType);
                publishLappConfigs.remove(publishLappConfigMap.get((Object)existedAppType));
            }
            int orderId = existedAppTypes.isEmpty() ? configedAppTypes.size() : 0;
            for (LappContext.AppType configedAppType : configedAppTypes) {
                if (existedAppTypes.contains((Object)configedAppType)) continue;
                PublishLappConfig publishLappConfig = new PublishLappConfig();
                publishLappConfig.setAppType(configedAppType);
                publishLappConfig.setOrderId(orderId);
                String id = this.getLappDao().savePublishLappConfig(publishLappConfig);
                publishLappConfig.setId(id);
                publishLappConfigs.add(publishLappConfig);
                if (orderId <= 0) continue;
                --orderId;
            }
            List<PublishLappConfig> list = publishLappConfigs;
            return list;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            LogUtil.error((String)"\u52a0\u8f7d\u8f7b\u5e94\u7528\u53d1\u5e03\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            LogUtil.error((String)"\u52a0\u8f7d\u8f7b\u5e94\u7528\u53d1\u5e03\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            this.tx.end();
        }
        return new ArrayList<PublishLappConfig>();
    }

    public PushRecordConfig loadPushRecordConfigInfo(String userId, int pushTargetType) throws AbstractQingIntegratedException, SQLException {
        return this.getLappDao().loadPushRecordConfigInfo(userId, pushTargetType);
    }

    public void saveLappPushRecordConfig(PushRecordConfig lappPushRecordConfig) throws SQLException, AbstractQingIntegratedException, PublishException, ParseException, com.kingdee.bos.qing.core.exception.PersistentModelParseException {
        try {
            this.tx.beginRequired();
            PushRecordConfig existLappStorageSetVO = this.getLappDao().loadPushRecordConfigInfo(lappPushRecordConfig.getUserId(), lappPushRecordConfig.getPushTargetType());
            if (existLappStorageSetVO != null) {
                if (PushRecordSavingStrategy.all.toString().equals(lappPushRecordConfig.getStrategy())) {
                    this.getLappDao().deleteLappPushRecordConfig(lappPushRecordConfig);
                } else {
                    this.getLappDao().updateLappPushRecordConfig(lappPushRecordConfig);
                }
            } else {
                lappPushRecordConfig.setId(this.getLappDao().createLappPushRecordPKId());
                this.getLappDao().saveLappPushRecordConfig(lappPushRecordConfig);
            }
            this.deletePushRecordByConfigInfo(lappPushRecordConfig, null);
            if (PushRecordSavingStrategy.time.toString().equals(lappPushRecordConfig.getStrategy())) {
                scheduleWithFixedDelay = ThreadPoolManage.scheduleAtFixRate((Runnable)new TimedClearUpTaskRunner(lappPushRecordConfig), (long)1L, (long)1L, (java.util.concurrent.TimeUnit)java.util.concurrent.TimeUnit.DAYS);
            } else if (scheduleWithFixedDelay != null) {
                scheduleWithFixedDelay.cancel(true);
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (ParseException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void deletePushRecordByConfigInfo(PushRecordConfig lappPushRecordConfig, String configId) throws AbstractQingIntegratedException, SQLException, PublishException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, ParseException {
        PushTargetType pushTargetType = PushTargetType.fromPersistance((int)lappPushRecordConfig.getPushTargetType());
        AbstractLappSchedulePushDomain domain = LappSchedulePushDomainFactory.createDomain(pushTargetType, this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        List<? extends AbstractLappSchedulePushConfigModel> lappSchedulePushConfigModels = domain.loadConfigInfo(pushTargetType, configId);
        ArrayList<PushRecord> delPushRecordList = new ArrayList<PushRecord>(20);
        if (PushRecordSavingStrategy.time.toString().equals(lappPushRecordConfig.getStrategy())) {
            String setValue = lappPushRecordConfig.getValue();
            String[] stringArray = setValue.split(",");
            int value = Integer.parseInt(stringArray[0]);
            int timeUnitIndex = Integer.parseInt(stringArray[1]);
            Calendar calendar = Calendar.getInstance();
            TimeUnit timeUnit = TimeUnit.findTimeUnitByIndex(timeUnitIndex);
            calendar.add(timeUnit.getCalendarIndex(), -value);
            for (AbstractLappSchedulePushConfigModel abstractLappSchedulePushConfigModel : lappSchedulePushConfigModels) {
                List<PushRecord> delPushRecordByTimeList = this.getLappDao().loadPushRecordNotInSpecifiedTime(abstractLappSchedulePushConfigModel.getLappSchedulePushConfigModel().getId(), lappPushRecordConfig.getUserId(), calendar.getTime());
                delPushRecordList.addAll(delPushRecordByTimeList);
            }
        } else if (PushRecordSavingStrategy.number.toString().equals(lappPushRecordConfig.getStrategy())) {
            for (AbstractLappSchedulePushConfigModel abstractLappSchedulePushConfigModel : lappSchedulePushConfigModels) {
                String boundaryDate = this.findBoundaryDateByPushRecordInfo(lappPushRecordConfig, abstractLappSchedulePushConfigModel);
                if (boundaryDate == null) continue;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = simpleDateFormat.parse(boundaryDate);
                List<PushRecord> delPushRecordByNum = this.getLappDao().loadPublishInfoByMonthLimit(abstractLappSchedulePushConfigModel.getLappSchedulePushConfigModel().getId(), lappPushRecordConfig.getUserId(), date);
                delPushRecordList.addAll(delPushRecordByNum);
            }
        }
        if (delPushRecordList.size() > 0) {
            for (PushRecord pushRecord : delPushRecordList) {
                this.deletePushRecord(pushRecord);
            }
        }
    }

    public String findBoundaryDateByPushRecordInfo(PushRecordConfig lappStorageSetVO, AbstractLappSchedulePushConfigModel lappSchedulePushConfigModel) throws AbstractQingIntegratedException, SQLException {
        ArrayList<PushRecord> pushRecordList = new ArrayList<PushRecord>(20);
        Integer pushRecordCount = this.getLappDao().loadPublishInfoCount(lappSchedulePushConfigModel.getLappSchedulePushConfigModel().getId(), lappStorageSetVO.getUserId());
        int setValue = Integer.parseInt(lappStorageSetVO.getValue());
        if (setValue < pushRecordCount) {
            ArrayList<Date> subTime = new ArrayList<Date>(2);
            Calendar calendar = Calendar.getInstance();
            subTime.add(calendar.getTime());
            while (setValue > 0) {
                calendar.add(2, -1);
                subTime.add(calendar.getTime());
                List<PushRecord> pushRecords = this.getLappDao().selectPublishInfoByMonthLimit(lappSchedulePushConfigModel.getLappSchedulePushConfigModel().getId(), lappStorageSetVO.getUserId(), subTime, setValue);
                pushRecordList.addAll(pushRecords);
                setValue -= pushRecords.size();
                subTime.remove(0);
            }
        }
        if (pushRecordList.size() > 0) {
            return ((PushRecord)pushRecordList.get(pushRecordList.size() - 1)).getPushTime();
        }
        return null;
    }

    public List<PushRecord> loadPushRecordByStorageSetInfo(String configId, String userId) throws AbstractQingIntegratedException, SQLException {
        List<PushRecord> pushRecordList = this.getLappDao().loadAllPushRecord(configId, userId);
        if (pushRecordList != null && pushRecordList.size() > 0) {
            Map<String, Long> fileSizeMap = this.getLappDao().loadQingFileSizeByPublishId(pushRecordList);
            for (int i = 0; i < pushRecordList.size(); ++i) {
                PushRecord pushRecord = pushRecordList.get(i);
                if (StringUtils.isNotEmpty((CharSequence)pushRecord.getPublishId())) {
                    BigDecimal bigDecimal;
                    Long fileSize;
                    Long l = fileSize = fileSizeMap.get(pushRecord.getPublishId()) == null ? Long.valueOf(0L) : fileSizeMap.get(pushRecord.getPublishId());
                    if (fileSize <= 0x100000L) {
                        bigDecimal = new BigDecimal(fileSize).divide(new BigDecimal(1024), 2, 4);
                        pushRecord.setFileSize((bigDecimal == null ? Integer.valueOf(0) : bigDecimal) + "KB");
                        continue;
                    }
                    bigDecimal = new BigDecimal(fileSize).divide(new BigDecimal(0x100000), 2, 4);
                    pushRecord.setFileSize((bigDecimal == null ? Integer.valueOf(0) : bigDecimal) + "MB");
                    continue;
                }
                pushRecord.setFileSize("0KB");
            }
        }
        return pushRecordList;
    }

    private class TimedClearUpTaskRunner
    implements Runnable {
        private PushRecordConfig lappPushRecordConfig;

        public TimedClearUpTaskRunner(PushRecordConfig lappPushRecordConfig) {
            this.lappPushRecordConfig = lappPushRecordConfig;
        }

        @Override
        public void run() {
            try {
                LappDomain.this.tx.beginRequired();
                LappDomain.this.deletePushRecordByConfigInfo(this.lappPushRecordConfig, null);
            }
            catch (PublishException e) {
                LappDomain.this.tx.markRollback();
            }
            catch (ParseException e) {
                LappDomain.this.tx.markRollback();
            }
            catch (SQLException e) {
                LappDomain.this.tx.markRollback();
            }
            catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
                LappDomain.this.tx.markRollback();
            }
            catch (AbstractQingIntegratedException e) {
                LappDomain.this.tx.markRollback();
            }
            finally {
                LappDomain.this.tx.end();
            }
        }
    }
}

