/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.exceptionlog.domain.ExceptionLogDomain;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLog;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.PublishEncryptedLicenseException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSchemaModel;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PushTargetType;
import com.kingdee.bos.qing.publish.target.dsbtimingpush.domain.DsbTimingPushDomain;
import com.kingdee.bos.qing.publish.target.lapp.LappDomain;
import com.kingdee.bos.qing.publish.target.lapp.LappSyncDomain;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.publish.target.lapp.env.LappApiEnum;
import com.kingdee.bos.qing.publish.target.lapp.exception.ExecuteSqlException;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappException;
import com.kingdee.bos.qing.publish.target.lapp.exception.ScheduleException;
import com.kingdee.bos.qing.publish.target.lapp.model.HttpRequestErrorResult;
import com.kingdee.bos.qing.publish.target.lapp.model.HttpRequestSuccessResult;
import com.kingdee.bos.qing.publish.target.lapp.model.LappAnalysisInfo;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.model.PushRecord;
import com.kingdee.bos.qing.publish.target.lapp.model.PushSharePersonInfo;
import com.kingdee.bos.qing.publish.target.lapp.model.ViewTypeEnum;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractPushMessageResult;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractPushMessageService;
import com.kingdee.bos.qing.publish.target.lapp.push.PushMessageServiceFactory;
import com.kingdee.bos.qing.publish.target.lapp.strategy.ILappStrategy;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.util.DateUtils;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import com.kingdee.bos.qing.util.URLUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jdom2.JDOMException;

public class PushScheduleExecuteDomian {
    private static final String ACCOUNT_ID = "accountId";
    private static String LAPP_ENTRANCE = "/qing/lappEntrance.do";
    private QingContext qingContext;
    private LappDao lappDao;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private PublishInfoDao publishInfoDao;
    private LappDomain lappDomain;
    private IScheduleEngine scheduleEngine;
    private ExceptionLogDomain exceptionLogDomain;
    private DsbTimingPushDomain dsbTimingPushDomain;
    private LappSyncDomain lappSyncDomain;
    private ILappStrategy lappStrategy;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    private LappDomain getLappDomain() {
        if (this.lappDomain == null) {
            this.lappDomain = new LappDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.lappDomain;
    }

    protected PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private ExceptionLogDomain getExceptionLogDomain() {
        if (this.exceptionLogDomain == null) {
            this.exceptionLogDomain = new ExceptionLogDomain(this.tx, this.dbExcuter);
        }
        return this.exceptionLogDomain;
    }

    private DsbTimingPushDomain getDsbTimingPushDomain() {
        if (this.dsbTimingPushDomain == null) {
            this.dsbTimingPushDomain = new DsbTimingPushDomain(this.dbExcuter, this.qingContext, this.tx);
        }
        return this.dsbTimingPushDomain;
    }

    private LappSyncDomain getLappSyncDomain() {
        if (this.lappSyncDomain == null) {
            this.lappSyncDomain = new LappSyncDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.lappSyncDomain;
    }

    private ILappStrategy getLappStrategyImpl() {
        this.lappStrategy = (ILappStrategy)CustomStrategyRegistrar.getStrategy(ILappStrategy.class);
        if (this.lappStrategy == null) {
            throw new RuntimeException("cannot found the implement of ILappStrategy.");
        }
        return this.lappStrategy;
    }

    public PublishPO savePublish(String tag, String configId, Map<String, String> lappContext, List<IQingFile> savedQingFiles) throws AbstractQingIntegratedException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, PublishException, SQLException, JDOMException, IOException {
        LappSchedulePushConfigModel pushConfigModel = this.getPushConfigById(configId);
        this.addSystemTime(pushConfigModel);
        PublishPO publishPO = this.getPublishPO(pushConfigModel);
        this.savePublishInfo(tag, pushConfigModel, publishPO, savedQingFiles);
        return publishPO;
    }

    public String saveLappContent(String thumbnailFileName, String sParamPathPrefix, LappSchedulePushConfigModel pushConfigModel, PublishPO publishPO, Map<String, String> yzjInfo, Map<String, String> lappContext) throws AbstractQingException, InterruptedException {
        HttpRequestSuccessResult sharePersonInfo;
        String analysisId = null;
        String sView = null;
        String viewType = null;
        if (pushConfigModel.getSchemaType() == 1) {
            sView = "10";
            viewType = ViewTypeEnum.SQUARE.toPersistance();
        } else {
            viewType = pushConfigModel.getSchemaType() == 0 ? ViewTypeEnum.LONGER.toPersistance() : ViewTypeEnum.DASHBOARD.toPersistance();
        }
        String lappEntranceUrlPrefix = sParamPathPrefix + LAPP_ENTRANCE;
        String saveLappAnalysisStr = this.saveLappAnalysis(thumbnailFileName, pushConfigModel, lappContext, publishPO, lappEntranceUrlPrefix, sView, viewType);
        if (saveLappAnalysisStr == null) {
            throw new ScheduleException(Messages.getMLS((QingContext)this.qingContext, (String)"failToSendRequest", (String)"\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", (Messages.ProjectName)Messages.ProjectName.QING_THEME), 4300104);
        }
        HttpRequestSuccessResult saveLappAnalysis = (HttpRequestSuccessResult)JsonUtil.decodeFromString((String)saveLappAnalysisStr, HttpRequestSuccessResult.class);
        if (saveLappAnalysis.getData() != null) {
            analysisId = saveLappAnalysis.getData();
            String sharePersonInfoStr = this.addSharePersonInfo(pushConfigModel, yzjInfo, lappContext, analysisId);
            if (sharePersonInfoStr == null) {
                throw new ScheduleException(Messages.getMLS((QingContext)this.qingContext, (String)"failToSendRequest", (String)"\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", (Messages.ProjectName)Messages.ProjectName.QING_THEME), 4300104);
            }
            sharePersonInfo = (HttpRequestSuccessResult)JsonUtil.decodeFromString((String)sharePersonInfoStr, HttpRequestSuccessResult.class);
            if (sharePersonInfo.getData() == null) {
                HttpRequestErrorResult httpRequestErrorResult = (HttpRequestErrorResult)JsonUtil.decodeFromString((String)sharePersonInfoStr, HttpRequestErrorResult.class);
                throw new ScheduleException(httpRequestErrorResult.getErrorMessage(), httpRequestErrorResult.getErrorCode());
            }
        } else {
            HttpRequestErrorResult httpRequestErrorResult = (HttpRequestErrorResult)JsonUtil.decodeFromString((String)saveLappAnalysisStr, HttpRequestErrorResult.class);
            throw new ScheduleException(httpRequestErrorResult.getErrorMessage(), httpRequestErrorResult.getErrorCode());
        }
        String sharingTargetId = URLUtil.getUrlParam((String)sharePersonInfo.getData(), (String)"sharingTargetId");
        lappEntranceUrlPrefix = URLUtil.appendParamToUrl((String)lappEntranceUrlPrefix, (String)ACCOUNT_ID, (String)lappContext.get(ACCOUNT_ID));
        lappEntranceUrlPrefix = URLUtil.appendParamToUrl((String)lappEntranceUrlPrefix, (String)"publishId", (String)publishPO.getId());
        lappEntranceUrlPrefix = URLUtil.appendParamToUrl((String)lappEntranceUrlPrefix, (String)"analysisId", (String)analysisId);
        lappEntranceUrlPrefix = URLUtil.appendParamToUrl((String)lappEntranceUrlPrefix, (String)"sharingTargetId", (String)sharingTargetId);
        lappEntranceUrlPrefix = URLUtil.appendParamToUrl((String)lappEntranceUrlPrefix, (String)"view", (String)sView);
        lappEntranceUrlPrefix = this.getLappStrategyImpl().addExtraParamsToUrl(lappEntranceUrlPrefix);
        PushTargetType pushTargetType = PushTargetType.fromPersistance((int)pushConfigModel.getPushTargetType());
        AbstractPushMessageService pushMessageService = PushMessageServiceFactory.createPushMessageServcie(pushTargetType, this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        ServerRequestInvokeContext.staticCheckInterrupt();
        AbstractPushMessageResult pushMessageResult = pushMessageService.doPush(lappEntranceUrlPrefix, pushConfigModel, thumbnailFileName, analysisId, publishPO.getId());
        this.savePushInfo(pushConfigModel, pushMessageResult, publishPO, analysisId);
        return analysisId;
    }

    public void deleteAnalysis(String configId, String analysisId) throws AbstractQingIntegratedException, LappException {
        if (analysisId != null) {
            PushRecord yzjPushRecord = new PushRecord();
            yzjPushRecord.setAnalysisId(analysisId);
            yzjPushRecord.setConfigId(configId);
            this.getLappDomain().deleteAnalysis(yzjPushRecord);
        }
    }

    public void savePublishInfo(String tag, LappSchedulePushConfigModel pushConfigModel, PublishPO publishPO, List<IQingFile> savedQingFiles) throws AbstractQingIntegratedException, PublishException, SQLException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, JDOMException, IOException {
        String configId = pushConfigModel.getId();
        int schemaSourceType = pushConfigModel.getSchemaType();
        PublishSourceEnum publishSourceEnum = PublishSourceEnum.valueOf((String)pushConfigModel.getSourceType());
        AbstractPublishSourceModel abstractPublishSourceModel = null;
        if (publishSourceEnum == PublishSourceEnum.dashboard) {
            try {
                abstractPublishSourceModel = this.getDsbTimingPushDomain().loadPublishDashboardModel(pushConfigModel.getId(), 2);
            }
            catch (PersistentModelParseException e) {
                throw new com.kingdee.bos.qing.core.exception.PersistentModelParseException((Throwable)e);
            }
            catch (EncryptedLicenseCheckException e) {
                throw new PublishEncryptedLicenseException(e.getMessage(), e.getErrorCode());
            }
        } else {
            byte[] schemaContentBytes = this.getLappDao().getSchemaContent(configId);
            List<OutsideReference> outsideRef = this.getLappDao().loadSchemaRef(configId);
            ModelBook modelBook = ModelBookUtil.fromByte(schemaContentBytes);
            modelBook.fixReferences(outsideRef);
            abstractPublishSourceModel = new PublishSchemaModel();
            SchemaAttrVO schemaAttr = new SchemaAttrVO();
            schemaAttr.setSource(schemaSourceType);
            schemaAttr.setIsDefault(true);
            ((PublishSchemaModel)abstractPublishSourceModel).setSchemaAttr(schemaAttr);
            ((PublishSchemaModel)abstractPublishSourceModel).setSchemaContent(modelBook);
        }
        AbstractPublishManageDomain publishManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)2, (QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null);
        ArrayList<AbstractPublishSourceModel> abstractPublishSourceModelList = new ArrayList<AbstractPublishSourceModel>(1);
        abstractPublishSourceModelList.add(abstractPublishSourceModel);
        publishManageDomain.savePublishByModel(tag, publishPO, null, abstractPublishSourceModelList, savedQingFiles);
    }

    public String saveLappAnalysis(String thumbnailFileName, LappSchedulePushConfigModel pushConfigModel, Map<String, String> lappContext, PublishPO publishPO, String lappEntranceUrl, String sView, String viewType) throws AbstractQingException {
        LappAnalysisInfo lappAnalysisInfo = new LappAnalysisInfo();
        lappAnalysisInfo.setAuthorizedUsers(null);
        lappAnalysisInfo.setDescription(pushConfigModel.getDescText());
        lappAnalysisInfo.setLayoutType(pushConfigModel.getLayoutType());
        lappAnalysisInfo.setName(pushConfigModel.getName());
        lappAnalysisInfo.setParentId(LappHelper.getLappAnalysisParentId());
        lappAnalysisInfo.setScene(lappContext.get("scene"));
        lappAnalysisInfo.setLargeThumb(thumbnailFileName);
        lappAnalysisInfo.setViewType(viewType);
        String url = URLUtil.appendParamToUrl((String)lappEntranceUrl, (String)"tag", (String)pushConfigModel.getTagId());
        url = URLUtil.appendParamToUrl((String)url, (String)ACCOUNT_ID, (String)lappContext.get(ACCOUNT_ID));
        url = URLUtil.appendParamToUrl((String)url, (String)"publishId", (String)publishPO.getId());
        url = URLUtil.appendParamToUrl((String)url, (String)"view", (String)sView);
        url = this.getLappStrategyImpl().addExtraParamsToUrl(url);
        lappAnalysisInfo.setUrl(url);
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("model", JsonUtil.encodeToString((Object)lappAnalysisInfo));
        paramMap.put("lappUserId", pushConfigModel.getId());
        paramMap.put("lappUserType", LappContext.UserType.ROBOT_PUSH.toPersistance());
        paramMap.put("datacenterUUID", this.getLappSyncDomain().getSyncedDatacenterUUID());
        paramMap.put("webShare", "true");
        return LappHelper.post(LappApiEnum.QING_SCHEDULE_PUSH_SAVE_ANALYSIS_URL, null, null, paramMap);
    }

    public String addSharePersonInfo(LappSchedulePushConfigModel pushConfigModel, Map<String, String> yzjInfo, Map<String, String> lappContext, String analysisId) throws LappException {
        PushSharePersonInfo pushSharePersonInfo = new PushSharePersonInfo();
        pushSharePersonInfo.setAnalysisId(analysisId);
        pushSharePersonInfo.setAvatar(yzjInfo.get("userPictureFiled"));
        pushSharePersonInfo.setCreatorName(yzjInfo.get("userName"));
        pushSharePersonInfo.setCreatorId(pushConfigModel.getId());
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("model", JsonUtil.encodeToString((Object)pushSharePersonInfo));
        paramMap.put("webShare", "true");
        paramMap.put("lappUserId", pushConfigModel.getId());
        paramMap.put("lappUserType", LappContext.UserType.ROBOT_PUSH.toPersistance());
        return LappHelper.post(LappApiEnum.QING_SCHEDULE_PUSH_ADD_SHARE_URL, null, null, paramMap);
    }

    public void savePushInfo(LappSchedulePushConfigModel pushConfigModel, AbstractPushMessageResult pushMessageResult, PublishPO publishPO, String analysisId) throws AbstractQingIntegratedException, LappException, InterruptedException {
        String userId = this.qingContext.getUserId();
        try {
            if (pushMessageResult != null && pushMessageResult.getErrorCode() != 0) {
                throw new LappException(pushMessageResult.getErrorMessage(), pushMessageResult.getErrorCode());
            }
            PushRecord pushRecord = new PushRecord();
            pushRecord.setConfigId(pushConfigModel.getId());
            pushRecord.setName(pushConfigModel.getName());
            pushRecord.setAnalysisId(analysisId);
            pushRecord.setPublishId(publishPO.getId());
            this.getLappDao().savePushRecord(pushRecord, userId);
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to save pushrecord", e);
        }
    }

    public void saveErrorInfo(String recordId, ExceptionLog exceptionLog) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            exceptionLog.setBizId(recordId);
            exceptionLog.setBizTypeEnum(ExceptionLogBizTypeEnum.ROBOT_PUSH);
            this.getExceptionLogDomain().insert(exceptionLog);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private void addSystemTime(LappSchedulePushConfigModel yzjPushConfigModel) {
        if (yzjPushConfigModel.getNameRule() != null) {
            Locale locale = this.qingContext.getIi18nContext().getLanManager().getLocale();
            String dateStr = DateUtils.date2StrByLang((Locale)locale, (String)yzjPushConfigModel.getNameRule(), (Date)new Date());
            yzjPushConfigModel.setName(yzjPushConfigModel.getName() + "-" + dateStr);
        }
    }

    public void deleteGarbage(LappSchedulePushConfigModel yzjPushConfigModel, String analysisId, String publishId) {
        try {
            this.deleteAnalysis(yzjPushConfigModel.getId(), analysisId);
            if (publishId != null) {
                AbstractPublishManageDomain abstractPublishManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)2, (QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (IScheduleEngine)this.scheduleEngine);
                abstractPublishManageDomain.deletePublishInfoNoTx(publishId);
            }
        }
        catch (LappException e) {
            LogUtil.error((String)"delete publish info error", (Throwable)((Object)e));
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)"delete publish info error", (Throwable)e);
        }
        catch (PublishException e) {
            LogUtil.error((String)"delete publish info error", (Throwable)e);
        }
    }

    public LappSchedulePushConfigModel getPushConfigById(String configId) throws AbstractQingIntegratedException, ExecuteSqlException {
        String userId = this.qingContext.getUserId();
        LappSchedulePushConfigModel pushConfigModel = null;
        try {
            pushConfigModel = this.getLappDao().loadPushConfigById(configId, userId);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to get yzjpush config model", e);
        }
        return pushConfigModel;
    }

    public PublishPO getPublishPO(LappSchedulePushConfigModel pushConfigModel) {
        String publishId = PublishUtil.getPublishId((String)UUID.randomUUID().toString());
        PublishPO publishPO = new PublishPO();
        publishPO.setCarryData(true);
        publishPO.setCanAnalysis(false);
        publishPO.setId(publishId);
        publishPO.setCreateTime(new Date());
        publishPO.setUpdateTime(new Date());
        publishPO.setImport(false);
        publishPO.setCreatorId(this.qingContext.getUserId());
        publishPO.setName(pushConfigModel.getName());
        publishPO.setPath(pushConfigModel.getId());
        publishPO.setTagId(pushConfigModel.getTagId());
        publishPO.setPublishTargetType(2);
        publishPO.setPublishSourceType(PublishSourceEnum.valueOf((String)pushConfigModel.getSourceType()));
        publishPO.setSchemaId("currentAnalysisState");
        publishPO.setTimingPush(true);
        return publishPO;
    }

    public boolean isMyOwnConfig(String configId) throws ExecuteSqlException, AbstractQingIntegratedException {
        boolean myOwnConfig = false;
        String userId = this.qingContext.getUserId();
        LappSchedulePushConfigModel pushModel = this.getPushConfigById(configId);
        if (pushModel != null && userId.equals(pushModel.getUserId())) {
            myOwnConfig = true;
        }
        return myOwnConfig;
    }

    public int loadPushTargetTypeByConfigId(String configId) throws AbstractQingIntegratedException, SQLException {
        return this.getLappDao().loadPushTargetTypeByConfigId(configId);
    }
}

